/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.ghprb;

import hudson.Extension;
import hudson.model.AbstractProject;
import hudson.model.UnprotectedRootAction;
import hudson.security.ACL;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.acegisecurity.context.SecurityContextHolder;
import org.jenkinsci.plugins.ghprb.GhprbGitHub;
import org.jenkinsci.plugins.ghprb.GhprbRepository;
import org.jenkinsci.plugins.ghprb.GhprbTrigger;
import org.kohsuke.github.GHEventPayload;
import org.kohsuke.github.GHRepository;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Extension
public class GhprbRootAction
implements UnprotectedRootAction {
    private static final Logger logger = Logger.getLogger(GhprbRootAction.class.getName());
    static final String URL = "ghprbhook";

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return null;
    }

    public String getUrlName() {
        return URL;
    }

    public void doIndex(StaplerRequest req, StaplerResponse resp) {
        String event = req.getHeader("X-GitHub-Event");
        String payload = req.getParameter("payload");
        if (payload == null) {
            logger.log(Level.SEVERE, "Request doesn't contain payload.");
            return;
        }
        GhprbGitHub gh = GhprbTrigger.getDscp().getGitHub();
        logger.log(Level.INFO, "Got payload event: {0}", event);
        try {
            if ("issue_comment".equals(event)) {
                GHEventPayload.IssueComment issueComment = (GHEventPayload.IssueComment)gh.get().parseEventPayload((Reader)new StringReader(payload), GHEventPayload.IssueComment.class);
                for (GhprbRepository repo : this.getRepos(issueComment.getRepository())) {
                    repo.onIssueCommentHook(issueComment);
                }
            } else if ("pull_request".equals(event)) {
                GHEventPayload.PullRequest pr = (GHEventPayload.PullRequest)gh.get().parseEventPayload((Reader)new StringReader(payload), GHEventPayload.PullRequest.class);
                for (GhprbRepository repo : this.getRepos(pr.getPullRequest().getRepository())) {
                    repo.onPullRequestHook(pr);
                }
            } else {
                logger.log(Level.WARNING, "Request not known");
            }
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, "Failed to parse github hook payload.", ex);
        }
    }

    private Set<GhprbRepository> getRepos(GHRepository repo) throws IOException {
        return this.getRepos(repo.getOwner().getLogin() + "/" + repo.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<GhprbRepository> getRepos(String repo) {
        HashSet<GhprbRepository> ret = new HashSet<GhprbRepository>();
        Authentication old = SecurityContextHolder.getContext().getAuthentication();
        SecurityContextHolder.getContext().setAuthentication(ACL.SYSTEM);
        try {
            for (AbstractProject job : Jenkins.getInstance().getAllItems(AbstractProject.class)) {
                GhprbRepository r;
                GhprbTrigger trigger = (GhprbTrigger)job.getTrigger(GhprbTrigger.class);
                if (trigger == null || trigger.getGhprb() == null || !repo.equals((r = trigger.getGhprb().getRepository()).getName())) continue;
                ret.add(r);
            }
        }
        finally {
            SecurityContextHolder.getContext().setAuthentication(old);
        }
        return ret;
    }
}

