/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.ghprb;

import hudson.model.AbstractBuild;
import java.io.IOException;
import java.net.URL;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.ghprb.Ghprb;
import org.jenkinsci.plugins.ghprb.GhprbCause;
import org.jenkinsci.plugins.ghprb.GhprbPullRequest;
import org.jenkinsci.plugins.ghprb.GhprbTrigger;
import org.kohsuke.github.GHCommitState;
import org.kohsuke.github.GHEvent;
import org.kohsuke.github.GHEventPayload;
import org.kohsuke.github.GHHook;
import org.kohsuke.github.GHIssueState;
import org.kohsuke.github.GHPullRequest;
import org.kohsuke.github.GHRepository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GhprbRepository {
    private static final Logger logger = Logger.getLogger(GhprbRepository.class.getName());
    private final String reponame;
    private Map<Integer, GhprbPullRequest> pulls;
    private GHRepository repo;
    private Ghprb ml;
    private static final EnumSet<GHEvent> EVENTS = EnumSet.of(GHEvent.ISSUE_COMMENT, GHEvent.PULL_REQUEST);

    public GhprbRepository(String user, String repository, Ghprb helper, Map<Integer, GhprbPullRequest> pulls) {
        this.reponame = user + "/" + repository;
        this.ml = helper;
        this.pulls = pulls;
    }

    public void init() {
        this.checkState();
        for (GhprbPullRequest pull : this.pulls.values()) {
            pull.init(this.ml, this);
        }
    }

    private boolean checkState() {
        if (this.repo == null) {
            try {
                this.repo = this.ml.getGitHub().get().getRepository(this.reponame);
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, "Could not retrieve repo named " + this.reponame + " (Do you have properly set 'GitHub project' field in job configuration?)", ex);
                return false;
            }
        }
        return true;
    }

    public void check() {
        List prs;
        if (!this.checkState()) {
            return;
        }
        try {
            prs = this.repo.getPullRequests(GHIssueState.OPEN);
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, "Could not retrieve pull requests.", ex);
            return;
        }
        HashSet<Integer> closedPulls = new HashSet<Integer>(this.pulls.keySet());
        for (GHPullRequest pr : prs) {
            if (pr.getHead() == null) {
                try {
                    pr = this.repo.getPullRequest(pr.getNumber());
                }
                catch (IOException ex) {
                    Logger.getLogger(GhprbRepository.class.getName()).log(Level.SEVERE, "Could not retrieve pr " + pr.getNumber(), ex);
                    return;
                }
            }
            this.check(pr);
            closedPulls.remove(pr.getNumber());
        }
        this.removeClosed(closedPulls, this.pulls);
    }

    private void check(GHPullRequest pr) {
        GhprbPullRequest pull;
        Integer id = pr.getNumber();
        if (this.pulls.containsKey(id)) {
            pull = this.pulls.get(id);
        } else {
            pull = new GhprbPullRequest(pr, this.ml, this);
            this.pulls.put(id, pull);
        }
        pull.check(pr);
    }

    private void removeClosed(Set<Integer> closedPulls, Map<Integer, GhprbPullRequest> pulls) {
        if (closedPulls.isEmpty()) {
            return;
        }
        for (Integer id : closedPulls) {
            pulls.remove(id);
        }
    }

    public void createCommitStatus(AbstractBuild<?, ?> build, GHCommitState state, String message, int id) {
        String sha1 = ((GhprbCause)build.getCause(GhprbCause.class)).getCommit();
        this.createCommitStatus(sha1, state, Jenkins.getInstance().getRootUrl() + build.getUrl(), message, id);
    }

    public void createCommitStatus(String sha1, GHCommitState state, String url, String message, int id) {
        logger.log(Level.INFO, "Setting status of {0} to {1} with url {2} and message: {3}", new Object[]{sha1, state, url, message});
        try {
            this.repo.createCommitStatus(sha1, state, url, message);
        }
        catch (IOException ex) {
            if (GhprbTrigger.getDscp().getUseComments().booleanValue()) {
                logger.log(Level.INFO, "Could not update commit status of the Pull Request on GitHub. Trying to send comment.", ex);
                this.addComment(id, message);
            }
            logger.log(Level.SEVERE, "Could not update commit status of the Pull Request on GitHub.", ex);
        }
    }

    public String getName() {
        return this.reponame;
    }

    public void addComment(int id, String comment) {
        try {
            this.repo.getPullRequest(id).comment(comment);
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, "Couldn't add comment to pull request #" + id + ": '" + comment + "'", ex);
        }
    }

    public void closePullRequest(int id) {
        try {
            this.repo.getPullRequest(id).close();
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, "Couldn't close the pull request #" + id + ": '", ex);
        }
    }

    public String getRepoUrl() {
        return this.ml.getGitHubServer() + "/" + this.reponame;
    }

    private boolean hookExist() throws IOException {
        for (GHHook h : this.repo.getHooks()) {
            if (!"web".equals(h.getName()) || !this.ml.getHookUrl().equals(h.getConfig().get("url"))) continue;
            return true;
        }
        return false;
    }

    public boolean createHook() {
        if (this.repo == null) {
            logger.log(Level.INFO, "Repository not available, cannot set pull request hook for repository " + this.reponame);
            return false;
        }
        try {
            if (this.hookExist()) {
                return true;
            }
            HashMap<String, String> config = new HashMap<String, String>();
            config.put("url", new URL(this.ml.getHookUrl()).toExternalForm());
            config.put("insecure_ssl", "1");
            this.repo.createHook("web", config, EVENTS, true);
            return true;
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, "Couldn't create web hook for repository " + this.reponame + ". Does the user (from global configuration) have admin rights to the repository?", ex);
            return false;
        }
    }

    public GHPullRequest getPullRequest(int id) throws IOException {
        return this.repo.getPullRequest(id);
    }

    void onIssueCommentHook(GHEventPayload.IssueComment issueComment) {
        int id = issueComment.getIssue().getNumber();
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "Comment on issue #{0}: '{1}'", new Object[]{id, issueComment.getComment().getBody()});
        }
        if (!"created".equals(issueComment.getAction())) {
            return;
        }
        GhprbPullRequest pull = this.pulls.get(id);
        if (pull == null) {
            if (logger.isLoggable(Level.FINER)) {
                logger.log(Level.FINER, "Pull request #{0} desn't exist", id);
            }
            return;
        }
        pull.check(issueComment.getComment());
        GhprbTrigger.getDscp().save();
    }

    void onPullRequestHook(GHEventPayload.PullRequest pr) {
        if ("opened".equals(pr.getAction()) || "reopened".equals(pr.getAction())) {
            GhprbPullRequest pull = this.pulls.get(pr.getNumber());
            if (pull == null) {
                pull = new GhprbPullRequest(pr.getPullRequest(), this.ml, this);
                this.pulls.put(pr.getNumber(), pull);
            }
            pull.check(pr.getPullRequest());
        } else if ("synchronize".equals(pr.getAction())) {
            GhprbPullRequest pull = this.pulls.get(pr.getNumber());
            if (pull == null) {
                logger.log(Level.SEVERE, "Pull Request #{0} doesn't exist", pr.getNumber());
                return;
            }
            pull.check(pr.getPullRequest());
        } else if ("closed".equals(pr.getAction())) {
            this.pulls.remove(pr.getNumber());
        } else {
            logger.log(Level.WARNING, "Unknown Pull Request hook action: {0}", pr.getAction());
        }
        GhprbTrigger.getDscp().save();
    }
}

