/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.ghprb;

import java.io.IOException;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jenkinsci.plugins.ghprb.Ghprb;
import org.jenkinsci.plugins.ghprb.GhprbRepository;
import org.jenkinsci.plugins.ghprb.GhprbTrigger;
import org.kohsuke.github.GHCommitState;
import org.kohsuke.github.GHIssueComment;
import org.kohsuke.github.GHPullRequest;

public class GhprbPullRequest {
    private static final Logger logger = Logger.getLogger(GhprbPullRequest.class.getName());
    private final int id;
    private final String author;
    private String title;
    private Date updated;
    private String head;
    private boolean mergeable;
    private String reponame;
    private String target;
    private String authorEmail;
    private boolean shouldRun = false;
    private boolean accepted = false;
    private boolean triggered = false;
    @Deprecated
    private transient boolean askedForApproval;
    private transient Ghprb ml;
    private transient GhprbRepository repo;

    GhprbPullRequest(GHPullRequest pr, Ghprb helper, GhprbRepository repo) {
        this.id = pr.getNumber();
        this.updated = pr.getUpdatedAt();
        this.head = pr.getHead().getSha();
        this.author = pr.getUser().getLogin();
        this.title = pr.getTitle();
        this.reponame = repo.getName();
        this.target = pr.getBase().getRef();
        this.obtainAuthorEmail(pr);
        this.ml = helper;
        this.repo = repo;
        if (helper.isWhitelisted(this.author)) {
            this.accepted = true;
            this.shouldRun = true;
        } else {
            logger.log(Level.INFO, "Author of #{0} {1} on {2} not in whitelist!", new Object[]{this.id, this.author, this.reponame});
            repo.addComment(this.id, GhprbTrigger.getDscp().getRequestForTestingPhrase());
        }
        logger.log(Level.INFO, "Created pull request #{0} on {1} by {2} ({3}) updated at: {4} SHA: {5}", new Object[]{this.id, this.reponame, this.author, this.authorEmail, this.updated, this.head});
    }

    public void init(Ghprb helper, GhprbRepository repo) {
        this.ml = helper;
        this.repo = repo;
        if (this.reponame == null) {
            this.reponame = repo.getName();
        }
    }

    public void check(GHPullRequest pr) {
        if (this.target == null) {
            this.target = pr.getBase().getRef();
        }
        if (this.authorEmail == null) {
            this.obtainAuthorEmail(pr);
        }
        if (this.isUpdated(pr)) {
            logger.log(Level.INFO, "Pull request builder: pr #{0} was updated on {1} at {2} by {3} ({4})", new Object[]{this.id, this.reponame, this.updated, this.author, this.authorEmail});
            this.title = pr.getTitle();
            int commentsChecked = this.checkComments(pr);
            boolean newCommit = this.checkCommit(pr.getHead().getSha());
            if (!newCommit && commentsChecked == 0) {
                logger.log(Level.INFO, "Pull request was updated on repo {0} but there aren't any new comments nor commits - that may mean that commit status was updated.", this.reponame);
            }
            this.updated = pr.getUpdatedAt();
        }
        this.checkMergeable(pr);
        this.tryBuild();
    }

    public void check(GHIssueComment comment) {
        try {
            this.checkComment(comment);
            this.updated = comment.getUpdatedAt();
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, "Couldn't check comment #" + comment.getId(), ex);
            return;
        }
        this.tryBuild();
    }

    private boolean isUpdated(GHPullRequest pr) {
        boolean ret = false;
        ret = ret || this.updated.compareTo(pr.getUpdatedAt()) < 0;
        ret = ret || !pr.getHead().getSha().equals(this.head);
        return ret;
    }

    private void tryBuild() {
        if (this.ml.ifOnlyTriggerPhrase() && !this.triggered) {
            this.shouldRun = false;
        }
        if (this.shouldRun) {
            this.build();
            this.shouldRun = false;
            this.triggered = false;
        }
    }

    private void build() {
        String message = this.ml.getBuilds().build(this);
        this.repo.createCommitStatus(this.head, GHCommitState.PENDING, null, message, this.id);
        logger.log(Level.INFO, message);
    }

    private boolean checkCommit(String sha) {
        if (this.head.equals(sha)) {
            return false;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "New commit. Sha: {0} => {1}", new Object[]{this.head, sha});
        }
        this.head = sha;
        if (this.accepted) {
            this.shouldRun = true;
        }
        return true;
    }

    private void checkComment(GHIssueComment comment) throws IOException {
        String sender = comment.getUser().getLogin();
        String body = comment.getBody();
        if (this.ml.isWhitelistPhrase(body) && this.ml.isAdmin(sender)) {
            if (!this.ml.isWhitelisted(this.author)) {
                this.ml.addWhitelist(this.author);
            }
            this.accepted = true;
            this.shouldRun = true;
        }
        if (this.ml.isOktotestPhrase(body) && this.ml.isAdmin(sender)) {
            this.accepted = true;
            this.shouldRun = true;
        }
        if (this.ml.isRetestPhrase(body)) {
            if (this.ml.isAdmin(sender)) {
                this.shouldRun = true;
            } else if (this.accepted && this.ml.isWhitelisted(sender)) {
                this.shouldRun = true;
            }
        }
        if (this.ml.isTriggerPhrase(body)) {
            if (this.ml.isAdmin(sender)) {
                this.shouldRun = true;
                this.triggered = true;
            } else if (this.accepted && this.ml.isWhitelisted(sender)) {
                this.shouldRun = true;
                this.triggered = true;
            }
        }
    }

    private int checkComments(GHPullRequest pr) {
        int count = 0;
        try {
            for (GHIssueComment comment : pr.getComments()) {
                if (this.updated.compareTo(comment.getUpdatedAt()) >= 0) continue;
                ++count;
                try {
                    this.checkComment(comment);
                }
                catch (IOException ex) {
                    logger.log(Level.SEVERE, "Couldn't check comment #" + comment.getId(), ex);
                }
            }
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Couldn't obtain comments.", e);
        }
        return count;
    }

    private void checkMergeable(GHPullRequest pr) {
        try {
            int r = 5;
            while (pr.getMergeable() == null && r-- > 0) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ex) {
                    break;
                }
                pr = this.repo.getPullRequest(this.id);
            }
            this.mergeable = pr.getMergeable() != null && pr.getMergeable() != false;
        }
        catch (IOException e) {
            this.mergeable = false;
            logger.log(Level.SEVERE, "Couldn't obtain mergeable status.", e);
        }
    }

    private void obtainAuthorEmail(GHPullRequest pr) {
        try {
            this.authorEmail = pr.getUser().getEmail();
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Couldn't obtain author email.", e);
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof GhprbPullRequest)) {
            return false;
        }
        GhprbPullRequest o = (GhprbPullRequest)obj;
        return o.id == this.id;
    }

    public int hashCode() {
        int hash = 7;
        hash = 89 * hash + this.id;
        return hash;
    }

    public int getId() {
        return this.id;
    }

    public String getHead() {
        return this.head;
    }

    public boolean isMergeable() {
        return this.mergeable;
    }

    public String getTarget() {
        return this.target;
    }

    public String getAuthorEmail() {
        return this.authorEmail;
    }

    public String getTitle() {
        return this.title;
    }
}

