/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.ghprb;

import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jenkinsci.plugins.ghprb.GhprbTrigger;
import org.kohsuke.github.GHOrganization;
import org.kohsuke.github.GHUser;
import org.kohsuke.github.GitHub;

public class GhprbGitHub {
    private static final Logger logger = Logger.getLogger(GhprbGitHub.class.getName());
    private GitHub gh;

    private void connect() throws IOException {
        String accessToken = GhprbTrigger.getDscp().getAccessToken();
        String serverAPIUrl = GhprbTrigger.getDscp().getServerAPIUrl();
        if (accessToken != null && !accessToken.isEmpty()) {
            try {
                this.gh = GitHub.connectUsingOAuth((String)serverAPIUrl, (String)accessToken);
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "Can''t connect to {0} using oauth", serverAPIUrl);
                throw e;
            }
        } else {
            this.gh = GitHub.connect((String)GhprbTrigger.getDscp().getUsername(), null, (String)GhprbTrigger.getDscp().getPassword());
        }
    }

    public GitHub get() throws IOException {
        if (this.gh == null) {
            this.connect();
        }
        return this.gh;
    }

    public boolean isUserMemberOfOrganization(String organisation, String member) {
        try {
            GHOrganization org = this.get().getOrganization(organisation);
            List members = org.getMembers();
            for (GHUser user : members) {
                if (!user.getLogin().equals(member)) continue;
                return true;
            }
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, null, ex);
            return false;
        }
        return false;
    }
}

