/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.ghprb;

import hudson.model.Cause;
import org.apache.commons.lang.StringUtils;

public class GhprbCause
extends Cause {
    private final String commit;
    private final int pullID;
    private final boolean merged;
    private final String targetBranch;
    private final String authorEmail;
    private final String title;

    public GhprbCause(String commit, int pullID, boolean merged, String targetBranch, String authorEmail, String title) {
        this.commit = commit;
        this.pullID = pullID;
        this.merged = merged;
        this.targetBranch = targetBranch;
        this.authorEmail = authorEmail;
        this.title = title;
    }

    public String getShortDescription() {
        return "GitHub pull request #" + this.pullID + " of commit " + this.commit + (this.merged ? " automatically merged." : ".");
    }

    public String getCommit() {
        return this.commit;
    }

    public boolean isMerged() {
        return this.merged;
    }

    public int getPullID() {
        return this.pullID;
    }

    public String getTargetBranch() {
        return this.targetBranch;
    }

    public String getAuthorEmail() {
        return this.authorEmail;
    }

    public String getTitle() {
        return this.title != null ? this.title : "";
    }

    public String getAbbreviatedTitle() {
        return StringUtils.abbreviate((String)this.getTitle(), (int)30);
    }
}

