/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.ghprb;

import hudson.model.AbstractBuild;
import hudson.model.Cause;
import hudson.model.Result;
import hudson.model.queue.QueueTaskFuture;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jenkinsci.plugins.ghprb.GhprbCause;
import org.jenkinsci.plugins.ghprb.GhprbPullRequest;
import org.jenkinsci.plugins.ghprb.GhprbRepository;
import org.jenkinsci.plugins.ghprb.GhprbTrigger;
import org.kohsuke.github.GHCommitState;
import org.kohsuke.github.GHIssueState;
import org.kohsuke.github.GHPullRequest;

public class GhprbBuilds {
    private static final Logger logger = Logger.getLogger(GhprbBuilds.class.getName());
    private GhprbTrigger trigger;
    private GhprbRepository repo;

    public GhprbBuilds(GhprbTrigger trigger, GhprbRepository repo) {
        this.trigger = trigger;
        this.repo = repo;
    }

    public String build(GhprbPullRequest pr) {
        StringBuilder sb = new StringBuilder();
        if (this.cancelBuild(pr.getId())) {
            sb.append("Previous build stopped.");
        }
        if (pr.isMergeable()) {
            sb.append(" Merged build triggered.");
        } else {
            sb.append(" Build triggered.");
        }
        GhprbCause cause = new GhprbCause(pr.getHead(), pr.getId(), pr.isMergeable(), pr.getTarget(), pr.getAuthorEmail(), pr.getTitle());
        QueueTaskFuture<?> build = this.trigger.startJob(cause);
        if (build == null) {
            logger.log(Level.SEVERE, "Job did not start");
        }
        return sb.toString();
    }

    private boolean cancelBuild(int id) {
        return false;
    }

    private GhprbCause getCause(AbstractBuild build) {
        Cause cause = build.getCause(GhprbCause.class);
        if (cause == null || !(cause instanceof GhprbCause)) {
            return null;
        }
        return (GhprbCause)cause;
    }

    public void onStarted(AbstractBuild build) {
        GhprbCause c = this.getCause(build);
        if (c == null) {
            return;
        }
        this.repo.createCommitStatus(build, GHCommitState.PENDING, c.isMerged() ? "Merged build started." : "Build started.", c.getPullID());
        try {
            build.setDescription("<a title=\"" + c.getTitle() + "\" href=\"" + this.repo.getRepoUrl() + "/pull/" + c.getPullID() + "\">PR #" + c.getPullID() + "</a>: " + c.getAbbreviatedTitle());
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, "Can't update build description", ex);
        }
    }

    public void onCompleted(AbstractBuild build) {
        GhprbCause c = this.getCause(build);
        if (c == null) {
            return;
        }
        GHCommitState state = build.getResult() == Result.SUCCESS ? GHCommitState.SUCCESS : (build.getResult() == Result.UNSTABLE ? GHCommitState.valueOf((String)GhprbTrigger.getDscp().getUnstableAs()) : GHCommitState.FAILURE);
        this.repo.createCommitStatus(build, state, c.isMerged() ? "Merged build finished." : "Build finished.", c.getPullID());
        String publishedURL = GhprbTrigger.getDscp().getPublishedURL();
        if (publishedURL != null && !publishedURL.isEmpty()) {
            String msg = state == GHCommitState.SUCCESS ? GhprbTrigger.getDscp().getMsgSuccess() : GhprbTrigger.getDscp().getMsgFailure();
            this.repo.addComment(c.getPullID(), msg + "\nRefer to this link for build results: " + publishedURL + build.getUrl());
        }
        if (state == GHCommitState.FAILURE && this.trigger.isAutoCloseFailedPullRequests().booleanValue()) {
            try {
                GHPullRequest pr = this.repo.getPullRequest(c.getPullID());
                if (pr.getState().equals((Object)GHIssueState.OPEN)) {
                    this.repo.closePullRequest(c.getPullID());
                }
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, "Can't close pull request", ex);
            }
        }
    }
}

