/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.ghprb;

import com.coravy.hudson.plugins.github.GithubProjectProperty;
import hudson.model.AbstractProject;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.ghprb.GhprbBuilds;
import org.jenkinsci.plugins.ghprb.GhprbGitHub;
import org.jenkinsci.plugins.ghprb.GhprbPullRequest;
import org.jenkinsci.plugins.ghprb.GhprbRepository;
import org.jenkinsci.plugins.ghprb.GhprbTrigger;

public class Ghprb {
    private static final Logger logger = Logger.getLogger(Ghprb.class.getName());
    private static final Pattern githubUserRepoPattern = Pattern.compile("^(http[s]?://[^/]*)/([^/]*)/([^/]*).*");
    private HashSet<String> admins;
    private HashSet<String> whitelisted;
    private HashSet<String> organisations;
    private String triggerPhrase;
    private GhprbTrigger trigger;
    private GhprbRepository repository;
    private GhprbBuilds builds;
    private AbstractProject<?, ?> project;
    private String githubServer;
    private boolean checked = false;
    private final Pattern retestPhrasePattern = Pattern.compile(GhprbTrigger.getDscp().getRetestPhrase());
    private final Pattern whitelistPhrasePattern = Pattern.compile(GhprbTrigger.getDscp().getWhitelistPhrase());
    private final Pattern oktotestPhrasePattern = Pattern.compile(GhprbTrigger.getDscp().getOkToTestPhrase());

    private Ghprb() {
    }

    public static Builder getBuilder() {
        return new Builder();
    }

    public void addWhitelist(String author) {
        logger.log(Level.INFO, "Adding {0} to whitelist", author);
        this.whitelisted.add(author);
        this.trigger.addWhitelist(author);
    }

    public GhprbBuilds getBuilds() {
        return this.builds;
    }

    public GhprbRepository getRepository() {
        return this.repository;
    }

    public GhprbGitHub getGitHub() {
        return this.trigger.getDescriptor().getGitHub();
    }

    void run() {
        if (this.trigger.getUseGitHubHooks().booleanValue() && this.checked) {
            return;
        }
        this.checked = true;
        this.repository.check();
    }

    void stop() {
        this.repository = null;
        this.builds = null;
    }

    public String getHookUrl() {
        return Jenkins.getInstance().getRootUrl() + "ghprbhook" + "/";
    }

    public boolean isRetestPhrase(String comment) {
        return this.retestPhrasePattern.matcher(comment).matches();
    }

    public boolean isWhitelistPhrase(String comment) {
        return this.whitelistPhrasePattern.matcher(comment).matches();
    }

    public boolean isOktotestPhrase(String comment) {
        return this.oktotestPhrasePattern.matcher(comment).matches();
    }

    public boolean isTriggerPhrase(String comment) {
        return !this.triggerPhrase.equals("") && comment.contains(this.triggerPhrase);
    }

    public boolean ifOnlyTriggerPhrase() {
        return this.trigger.getOnlyTriggerPhrase();
    }

    public boolean isWhitelisted(String username) {
        return this.trigger.getPermitAll() != false || this.whitelisted.contains(username) || this.admins.contains(username) || this.isInWhitelistedOrganisation(username);
    }

    public boolean isAdmin(String username) {
        return this.admins.contains(username);
    }

    private boolean isInWhitelistedOrganisation(String username) {
        for (String organisation : this.organisations) {
            if (!this.getGitHub().isUserMemberOfOrganization(organisation, username)) continue;
            return true;
        }
        return false;
    }

    String getGitHubServer() {
        return this.githubServer;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder {
        private Ghprb gml = new Ghprb();
        private String user;
        private String repo;
        private Map<Integer, GhprbPullRequest> pulls;

        public Builder setTrigger(GhprbTrigger trigger) {
            if (this.gml == null) {
                return this;
            }
            this.gml.trigger = trigger;
            this.gml.admins = new HashSet<String>(Arrays.asList(trigger.getAdminlist().split("\\s+")));
            this.gml.admins.remove("");
            this.gml.whitelisted = new HashSet<String>(Arrays.asList(trigger.getWhitelist().split("\\s+")));
            this.gml.whitelisted.remove("");
            this.gml.organisations = new HashSet<String>(Arrays.asList(trigger.getOrgslist().split("\\s+")));
            this.gml.organisations.remove("");
            this.gml.triggerPhrase = trigger.getTriggerPhrase();
            return this;
        }

        public Builder setPulls(Map<Integer, GhprbPullRequest> pulls) {
            if (this.gml == null) {
                return this;
            }
            this.pulls = pulls;
            return this;
        }

        public Builder setProject(AbstractProject<?, ?> project) {
            if (this.gml == null) {
                return this;
            }
            this.gml.project = project;
            GithubProjectProperty ghpp = (GithubProjectProperty)project.getProperty(GithubProjectProperty.class);
            if (ghpp == null || ghpp.getProjectUrl() == null) {
                logger.log(Level.WARNING, "A github project url is required.");
                this.gml = null;
                return this;
            }
            String baseUrl = ghpp.getProjectUrl().baseUrl();
            Matcher m = githubUserRepoPattern.matcher(baseUrl);
            if (!m.matches()) {
                logger.log(Level.WARNING, "Invalid github project url: {0}", baseUrl);
                this.gml = null;
                return this;
            }
            this.gml.githubServer = m.group(1);
            this.user = m.group(2);
            this.repo = m.group(3);
            return this;
        }

        public Ghprb build() {
            if (this.gml == null || this.pulls == null || this.gml.trigger == null || this.gml.project == null) {
                throw new IllegalStateException();
            }
            this.gml.repository = new GhprbRepository(this.user, this.repo, this.gml, this.pulls);
            this.gml.repository.init();
            if (this.gml.trigger.getUseGitHubHooks().booleanValue()) {
                this.gml.repository.createHook();
            }
            this.gml.builds = new GhprbBuilds(this.gml.trigger, this.gml.repository);
            return this.gml;
        }
    }
}

