/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.ghprb;

import antlr.ANTLRException;
import com.coravy.hudson.plugins.github.GithubProjectProperty;
import com.google.common.annotations.VisibleForTesting;
import hudson.Extension;
import hudson.Util;
import hudson.matrix.MatrixProject;
import hudson.model.Action;
import hudson.model.Cause;
import hudson.model.CauseAction;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.model.ParametersDefinitionProperty;
import hudson.model.Run;
import hudson.model.Saveable;
import hudson.model.StringParameterValue;
import hudson.model.queue.QueueTaskFuture;
import hudson.plugins.git.util.BuildData;
import hudson.triggers.TriggerDescriptor;
import hudson.util.DescribableList;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import jenkins.model.ParameterizedJobMixIn;
import jenkins.util.SystemProperties;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.ghprb.Ghprb;
import org.jenkinsci.plugins.ghprb.GhprbBranch;
import org.jenkinsci.plugins.ghprb.GhprbBuilds;
import org.jenkinsci.plugins.ghprb.GhprbCause;
import org.jenkinsci.plugins.ghprb.GhprbGitHub;
import org.jenkinsci.plugins.ghprb.GhprbGitHubAuth;
import org.jenkinsci.plugins.ghprb.GhprbParametersAction;
import org.jenkinsci.plugins.ghprb.GhprbPullRequest;
import org.jenkinsci.plugins.ghprb.GhprbRepository;
import org.jenkinsci.plugins.ghprb.GhprbTriggerBackwardsCompatible;
import org.jenkinsci.plugins.ghprb.extensions.GhprbBuildStep;
import org.jenkinsci.plugins.ghprb.extensions.GhprbCommitStatus;
import org.jenkinsci.plugins.ghprb.extensions.GhprbExtension;
import org.jenkinsci.plugins.ghprb.extensions.GhprbExtensionDescriptor;
import org.jenkinsci.plugins.ghprb.extensions.GhprbGlobalDefault;
import org.jenkinsci.plugins.ghprb.extensions.comments.GhprbBuildLog;
import org.jenkinsci.plugins.ghprb.extensions.comments.GhprbBuildResultMessage;
import org.jenkinsci.plugins.ghprb.extensions.comments.GhprbBuildStatus;
import org.jenkinsci.plugins.ghprb.extensions.comments.GhprbPublishJenkinsUrl;
import org.jenkinsci.plugins.ghprb.extensions.status.GhprbSimpleStatus;
import org.kohsuke.github.GHCommitState;
import org.kohsuke.github.GHEventPayload;
import org.kohsuke.github.GitHub;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class GhprbTrigger
extends GhprbTriggerBackwardsCompatible {
    @Extension
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();
    private static final Logger LOGGER = Logger.getLogger(GhprbTrigger.class.getName());
    private static final ExecutorService POOL = Executors.newFixedThreadPool(SystemProperties.getInteger((String)(GhprbTrigger.class.getName() + ".poolSize"), (Integer)5));
    private static final boolean DISABLE_REGISTER_ON_STARTUP = SystemProperties.getBoolean((String)(GhprbTrigger.class.getName() + ".disableRegisterOnStartup"), (boolean)false);
    private final String adminlist;
    private final Boolean allowMembersOfWhitelistedOrgsAsAdmin;
    private final String orgslist;
    private final String cron;
    private final String buildDescTemplate;
    private final Boolean onlyTriggerPhrase;
    private final Boolean useGitHubHooks;
    private final Boolean permitAll;
    private String whitelist;
    private Boolean autoCloseFailedPullRequests;
    private Boolean displayBuildErrorsOnDownstreamBuilds;
    private List<GhprbBranch> whiteListTargetBranches;
    private List<GhprbBranch> blackListTargetBranches;
    private String gitHubAuthId;
    private String triggerPhrase;
    private String skipBuildPhrase;
    private String blackListCommitAuthor;
    private String blackListLabels;
    private String whiteListLabels;
    private String includedRegions;
    private String excludedRegions;
    private transient Ghprb helper;
    private transient GhprbRepository repository;
    private transient GhprbBuilds builds;
    private transient GhprbGitHub ghprbGitHub;
    private DescribableList<GhprbExtension, GhprbExtensionDescriptor> extensions = new DescribableList(Saveable.NOOP);

    @Override
    public DescribableList<GhprbExtension, GhprbExtensionDescriptor> getExtensions() {
        if (this.extensions == null) {
            this.extensions = new DescribableList(Saveable.NOOP, (Collection)Util.fixNull(this.extensions));
            this.extensions.add((Object)new GhprbSimpleStatus());
        }
        return this.extensions;
    }

    private void setExtensions(List<GhprbExtension> extensions) {
        DescribableList rawList = new DescribableList(Saveable.NOOP, (Collection)Util.fixNull(extensions));
        this.extensions = Ghprb.onlyOneEntry((DescribableList<GhprbExtension, GhprbExtensionDescriptor>)rawList, GhprbCommitStatus.class);
        for (GhprbExtension ext : this.getDescriptor().getExtensions()) {
            if (!(ext instanceof GhprbGlobalDefault)) continue;
            Ghprb.addIfMissing(this.extensions, Ghprb.getGlobal(((Object)((Object)ext)).getClass()), ((Object)((Object)ext)).getClass());
        }
    }

    @DataBoundConstructor
    public GhprbTrigger(String adminlist, String whitelist, String orgslist, String cron, String triggerPhrase, Boolean onlyTriggerPhrase, Boolean useGitHubHooks, Boolean permitAll, Boolean autoCloseFailedPullRequests, Boolean displayBuildErrorsOnDownstreamBuilds, String commentFilePath, String skipBuildPhrase, String blackListCommitAuthor, List<GhprbBranch> whiteListTargetBranches, List<GhprbBranch> blackListTargetBranches, Boolean allowMembersOfWhitelistedOrgsAsAdmin, String msgSuccess, String msgFailure, String commitStatusContext, String gitHubAuthId, String buildDescTemplate, String blackListLabels, String whiteListLabels, List<GhprbExtension> extensions, String includedRegions, String excludedRegions) throws ANTLRException {
        super(cron);
        this.adminlist = adminlist;
        this.whitelist = whitelist;
        this.orgslist = orgslist;
        this.cron = cron;
        this.triggerPhrase = triggerPhrase;
        this.onlyTriggerPhrase = onlyTriggerPhrase;
        this.useGitHubHooks = useGitHubHooks;
        this.permitAll = permitAll;
        this.autoCloseFailedPullRequests = autoCloseFailedPullRequests;
        this.displayBuildErrorsOnDownstreamBuilds = displayBuildErrorsOnDownstreamBuilds;
        this.skipBuildPhrase = skipBuildPhrase;
        this.blackListCommitAuthor = blackListCommitAuthor;
        this.whiteListTargetBranches = whiteListTargetBranches;
        this.blackListTargetBranches = blackListTargetBranches;
        this.gitHubAuthId = gitHubAuthId;
        this.allowMembersOfWhitelistedOrgsAsAdmin = allowMembersOfWhitelistedOrgsAsAdmin;
        this.buildDescTemplate = buildDescTemplate;
        this.blackListLabels = blackListLabels;
        this.whiteListLabels = whiteListLabels;
        this.includedRegions = includedRegions;
        this.excludedRegions = excludedRegions;
        this.setExtensions(extensions);
        this.configVersion = 3;
    }

    public Object readResolve() {
        this.convertPropertiesToExtensions();
        this.checkGitHubApiAuth();
        return this;
    }

    private void checkGitHubApiAuth() {
        if (this.gitHubApiAuth != null) {
            this.gitHubAuthId = this.gitHubApiAuth.getId();
            this.gitHubApiAuth = null;
        }
    }

    public static DescriptorImpl getDscp() {
        return DESCRIPTOR;
    }

    private void initState() throws IOException {
        GithubProjectProperty ghpp = (GithubProjectProperty)((Job)this.job).getProperty(GithubProjectProperty.class);
        if (ghpp == null || ghpp.getProjectUrl() == null) {
            throw new IllegalStateException("A GitHub project url is required.");
        }
        String baseUrl = ghpp.getProjectUrl().baseUrl();
        Matcher m = Ghprb.GITHUB_USER_REPO_PATTERN.matcher(baseUrl);
        if (!m.matches()) {
            throw new IllegalStateException(String.format("Invalid GitHub project url: %s", baseUrl));
        }
        String reponame = m.group(2);
        this.repository = new GhprbRepository(reponame, this);
        this.repository.load();
        Map<Integer, GhprbPullRequest> pulls = this.pullRequests;
        this.pullRequests = null;
        try {
            Map<Integer, GhprbPullRequest> prs = this.getDescriptor().getPullRequests(((Job)this.job).getFullName());
            if (prs != null) {
                prs = new ConcurrentHashMap<Integer, GhprbPullRequest>(prs);
                if (pulls == null) {
                    pulls = prs;
                } else {
                    pulls.putAll(prs);
                }
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Unable to transfer map of pull requests", e);
        }
        if (pulls != null) {
            this.repository.addPullRequests(pulls);
            this.repository.save();
        }
        this.builds = new GhprbBuilds(this, this.repository);
        this.repository.init();
        this.ghprbGitHub = new GhprbGitHub(this);
    }

    public void start(Job<?, ?> project, boolean newInstance) {
        super.start(project, newInstance);
        String name = project.getFullName();
        if (!project.isBuildable()) {
            LOGGER.log(Level.FINE, "Project is disabled, not starting trigger for job " + name);
            return;
        }
        if (project.getProperty(GithubProjectProperty.class) == null) {
            LOGGER.log(Level.INFO, "GitHub project property is missing the URL, cannot start ghprb trigger for job " + name);
            return;
        }
        try {
            this.initState();
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, "Can't start ghprb trigger", ex);
            return;
        }
        LOGGER.log(Level.INFO, "Starting the ghprb trigger for the {0} job; newInstance is {1}", new String[]{name, String.valueOf(newInstance)});
        this.helper = new Ghprb(this);
        if (this.getUseGitHubHooks().booleanValue()) {
            LOGGER.log(Level.FINEST, "Disable registering hooks on startup: {0}", new String[]{String.valueOf(DISABLE_REGISTER_ON_STARTUP)});
            if (GhprbTrigger.getDscp().getManageWebhooks().booleanValue() && (newInstance || !DISABLE_REGISTER_ON_STARTUP)) {
                Object[] params = new String[]{String.valueOf(SystemProperties.getInteger((String)(GhprbTrigger.class.getName() + ".poolSize"), (Integer)5))};
                LOGGER.log(Level.FINEST, "Registering hook with GitHub.  Thread pool size: {0}", params);
                POOL.submit(new StartHookRunnable(this.repository));
            }
            GhprbTrigger.DESCRIPTOR.addRepoTrigger(this.getRepository().getName(), (Job)this.job);
        }
    }

    public void stop() {
        String repo;
        String name = this.job != null ? ((Job)this.job).getFullName() : "NOT STARTED";
        LOGGER.log(Level.INFO, "Stopping the ghprb trigger for project {0}", name);
        if (this.repository != null && !StringUtils.isEmpty((String)(repo = this.repository.getName()))) {
            GhprbTrigger.DESCRIPTOR.removeRepoTrigger(repo, (Job)this.job);
        }
        super.stop();
    }

    public void run() {
        if (this.getUseGitHubHooks().booleanValue()) {
            LOGGER.log(Level.FINE, "Use webHooks is set, so not running trigger");
            return;
        }
        if (!this.isActive()) {
            return;
        }
        LOGGER.log(Level.FINE, "Running trigger for {0}", ((Job)this.job).getFullName());
        this.repository.check();
    }

    public QueueTaskFuture<?> scheduleBuild(GhprbCause cause, GhprbRepository repo) {
        Run lastBuild22;
        try {
            for (GhprbExtension ext : Ghprb.getJobExtensions(this, GhprbBuildStep.class)) {
                if (!(ext instanceof GhprbBuildStep)) continue;
                ((GhprbBuildStep)((Object)ext)).onScheduleBuild((Job)this.job, cause);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Unable to execute extentions for scheduleBuild", e);
        }
        ArrayList<ParameterValue> values = this.getDefaultParameters();
        String commitSha = cause.isMerged() ? "origin/pr/" + cause.getPullID() + "/merge" : cause.getCommit();
        values.add((ParameterValue)new StringParameterValue("sha1", commitSha));
        values.add((ParameterValue)new StringParameterValue("ghprbActualCommit", cause.getCommit()));
        String triggerAuthor = "";
        String triggerAuthorEmail = "";
        String triggerAuthorLogin = "";
        GhprbPullRequest pr = this.getRepository().getPullRequest(cause.getPullID());
        String lastBuildId = pr.getLastBuildId();
        BuildData buildData = null;
        if (!(this.job instanceof MatrixProject) && !StringUtils.isEmpty((String)lastBuildId) && (lastBuild22 = ((Job)this.job).getBuild(lastBuildId)) != null) {
            buildData = (BuildData)lastBuild22.getAction(BuildData.class);
        }
        try {
            triggerAuthor = this.getString(cause.getTriggerSender().getName(), "");
        }
        catch (Exception lastBuild22) {
            // empty catch block
        }
        try {
            triggerAuthorEmail = this.getString(cause.getTriggerSender().getEmail(), "");
        }
        catch (Exception lastBuild22) {
            // empty catch block
        }
        try {
            triggerAuthorLogin = this.getString(cause.getTriggerSender().getLogin(), "");
        }
        catch (Exception lastBuild22) {
            // empty catch block
        }
        this.setCommitAuthor(cause, values);
        values.add((ParameterValue)new StringParameterValue("ghprbAuthorRepoGitUrl", this.getString(cause.getAuthorRepoGitUrl(), "")));
        values.add((ParameterValue)new StringParameterValue("ghprbTriggerAuthor", triggerAuthor));
        values.add((ParameterValue)new StringParameterValue("ghprbTriggerAuthorEmail", triggerAuthorEmail));
        values.add((ParameterValue)new StringParameterValue("ghprbTriggerAuthorLogin", triggerAuthorLogin));
        values.add((ParameterValue)new StringParameterValue("ghprbTriggerAuthorLoginMention", !triggerAuthorLogin.isEmpty() ? "@" + triggerAuthorLogin : ""));
        StringParameterValue pullIdPv = new StringParameterValue("ghprbPullId", String.valueOf(cause.getPullID()));
        values.add((ParameterValue)pullIdPv);
        values.add((ParameterValue)new StringParameterValue("ghprbTargetBranch", String.valueOf(cause.getTargetBranch())));
        values.add((ParameterValue)new StringParameterValue("ghprbSourceBranch", String.valueOf(cause.getSourceBranch())));
        values.add((ParameterValue)new StringParameterValue("GIT_BRANCH", String.valueOf(cause.getSourceBranch())));
        values.add((ParameterValue)new StringParameterValue("ghprbPullAuthorEmail", this.getString(cause.getAuthorEmail(), "")));
        values.add((ParameterValue)new StringParameterValue("ghprbPullAuthorLogin", String.valueOf(cause.getPullRequestAuthor().getLogin())));
        values.add((ParameterValue)new StringParameterValue("ghprbPullAuthorLoginMention", "@" + cause.getPullRequestAuthor().getLogin()));
        values.add((ParameterValue)new StringParameterValue("ghprbPullDescription", this.escapeText(String.valueOf(cause.getShortDescription()))));
        values.add((ParameterValue)new StringParameterValue("ghprbPullTitle", this.escapeText(String.valueOf(cause.getTitle()))));
        values.add((ParameterValue)new StringParameterValue("ghprbPullLink", String.valueOf(cause.getUrl())));
        values.add((ParameterValue)new StringParameterValue("ghprbPullLongDescription", this.escapeText(String.valueOf(cause.getDescription()))));
        values.add((ParameterValue)new StringParameterValue("ghprbCommentBody", this.escapeText(String.valueOf(cause.getCommentBody()))));
        values.add((ParameterValue)new StringParameterValue("ghprbGhRepository", this.getString(cause.getRepositoryName(), "")));
        values.add((ParameterValue)new StringParameterValue("ghprbCredentialsId", this.getString(cause.getCredentialsId(), "")));
        ParameterizedJobMixIn scheduledJob = new ParameterizedJobMixIn(){

            protected Job asJob() {
                return (Job)GhprbTrigger.this.job;
            }
        };
        return scheduledJob.scheduleBuild2(Jenkins.getInstance().getQuietPeriod(), new Action[]{new CauseAction((Cause)cause), new GhprbParametersAction(values), buildData});
    }

    private void setCommitAuthor(GhprbCause cause, ArrayList<ParameterValue> values) {
        String authorName = "";
        String authorEmail = "";
        if (cause.getCommitAuthor() != null) {
            authorName = this.getString(cause.getCommitAuthor().getName(), "");
            authorEmail = this.getString(cause.getCommitAuthor().getEmail(), "");
        }
        values.add((ParameterValue)new StringParameterValue("ghprbActualCommitAuthor", authorName));
        values.add((ParameterValue)new StringParameterValue("ghprbActualCommitAuthorEmail", authorEmail));
    }

    private String escapeText(String text) {
        return text.replace("\n", "\\n").replace("\r", "\\r").replace("\"", "\\\"");
    }

    private ArrayList<ParameterValue> getDefaultParameters() {
        ArrayList<ParameterValue> values = new ArrayList<ParameterValue>();
        ParametersDefinitionProperty pdp = (ParametersDefinitionProperty)((Job)this.job).getProperty(ParametersDefinitionProperty.class);
        if (pdp != null) {
            for (ParameterDefinition pd : pdp.getParameterDefinitions()) {
                values.add(pd.getDefaultParameterValue());
            }
        }
        return values;
    }

    private String getString(String actual, String d) {
        return actual == null ? d : actual;
    }

    public String getGitHubAuthId() {
        return this.gitHubAuthId == null ? "" : this.gitHubAuthId;
    }

    public GhprbGitHubAuth getGitHubApiAuth() {
        Iterator<GhprbGitHubAuth> iterator;
        if (this.gitHubAuthId == null && (iterator = this.getDescriptor().getGithubAuth().iterator()).hasNext()) {
            GhprbGitHubAuth auth = iterator.next();
            this.gitHubAuthId = auth.getId();
            this.getDescriptor().save();
            return auth;
        }
        return this.getDescriptor().getGitHubAuth(this.gitHubAuthId);
    }

    public GitHub getGitHub() throws IOException {
        GhprbGitHubAuth auth = this.getGitHubApiAuth();
        return auth.getConnection((Item)this.getActualProject());
    }

    public Job<?, ?> getActualProject() {
        return (Job)this.job;
    }

    public void addWhitelist(String author) {
        this.whitelist = this.whitelist + " " + author;
        try {
            ((Job)this.job).save();
        }
        catch (IOException ex) {
            LOGGER.log(Level.SEVERE, "Failed to save new whitelist", ex);
        }
    }

    public String getBuildDescTemplate() {
        return this.buildDescTemplate == null ? "" : this.buildDescTemplate;
    }

    public String getAdminlist() {
        if (this.adminlist == null) {
            return "";
        }
        return this.adminlist;
    }

    public Boolean getAllowMembersOfWhitelistedOrgsAsAdmin() {
        return this.allowMembersOfWhitelistedOrgsAsAdmin != null && this.allowMembersOfWhitelistedOrgsAsAdmin != false;
    }

    public String getWhitelist() {
        if (this.whitelist == null) {
            return "";
        }
        return this.whitelist;
    }

    public String getOrgslist() {
        if (this.orgslist == null) {
            return "";
        }
        return this.orgslist;
    }

    public String getCron() {
        return this.cron;
    }

    public String getTriggerPhrase() {
        if (this.triggerPhrase == null) {
            return "";
        }
        return this.triggerPhrase;
    }

    public String getSkipBuildPhrase() {
        if (StringUtils.isEmpty((String)this.skipBuildPhrase)) {
            return this.getDescriptor().getSkipBuildPhrase();
        }
        return this.skipBuildPhrase;
    }

    public String getBlackListCommitAuthor() {
        if (StringUtils.isEmpty((String)this.blackListCommitAuthor)) {
            return this.getDescriptor().getBlackListCommitAuthor();
        }
        return this.blackListCommitAuthor;
    }

    public String getBlackListLabels() {
        if (this.blackListLabels == null) {
            return "";
        }
        return this.blackListLabels;
    }

    public String getWhiteListLabels() {
        if (this.whiteListLabels == null) {
            return "";
        }
        return this.whiteListLabels;
    }

    public Boolean getOnlyTriggerPhrase() {
        return this.onlyTriggerPhrase != null && this.onlyTriggerPhrase != false;
    }

    public Boolean getUseGitHubHooks() {
        return this.useGitHubHooks != null && this.useGitHubHooks != false;
    }

    public Ghprb getHelper() {
        if (this.helper == null) {
            this.helper = new Ghprb(this);
        }
        return this.helper;
    }

    public Boolean getPermitAll() {
        return this.permitAll != null && this.permitAll != false;
    }

    public Boolean getAutoCloseFailedPullRequests() {
        if (this.autoCloseFailedPullRequests == null) {
            Boolean autoClose = this.getDescriptor().getAutoCloseFailedPullRequests();
            return autoClose != null && autoClose != false;
        }
        return this.autoCloseFailedPullRequests;
    }

    public Boolean getDisplayBuildErrorsOnDownstreamBuilds() {
        if (this.displayBuildErrorsOnDownstreamBuilds == null) {
            Boolean displayErrors = this.getDescriptor().getDisplayBuildErrorsOnDownstreamBuilds();
            return displayErrors != null && displayErrors != false;
        }
        return this.displayBuildErrorsOnDownstreamBuilds;
    }

    private List<GhprbBranch> normalizeTargetBranches(List<GhprbBranch> branches) {
        if (branches == null || branches.size() == 1 && branches.get(0).getBranch().equals("")) {
            return new ArrayList<GhprbBranch>();
        }
        return branches;
    }

    public List<GhprbBranch> getWhiteListTargetBranches() {
        return this.normalizeTargetBranches(this.whiteListTargetBranches);
    }

    public List<GhprbBranch> getBlackListTargetBranches() {
        return this.normalizeTargetBranches(this.blackListTargetBranches);
    }

    public String getIncludedRegions() {
        if (this.includedRegions == null) {
            return "";
        }
        return this.includedRegions;
    }

    public String getExcludedRegions() {
        if (this.excludedRegions == null) {
            return "";
        }
        return this.excludedRegions;
    }

    public DescriptorImpl getDescriptor() {
        return DESCRIPTOR;
    }

    @VisibleForTesting
    void setHelper(Ghprb helper) {
        this.helper = helper;
    }

    public GhprbBuilds getBuilds() {
        if (this.builds == null && this.isActive()) {
            this.builds = new GhprbBuilds(this, this.getRepository());
        }
        return this.builds;
    }

    public GhprbGitHub getGhprbGitHub() {
        if (this.ghprbGitHub == null && this.isActive()) {
            this.ghprbGitHub = new GhprbGitHub(this);
        }
        return this.ghprbGitHub;
    }

    public boolean isActive() {
        String name = this.job != null ? ((Job)this.job).getFullName() : "NOT STARTED";
        boolean isActive = true;
        if (this.job == null) {
            LOGGER.log(Level.FINE, "Project was never set, start was never run");
            isActive = false;
        } else if (!((Job)this.job).isBuildable()) {
            LOGGER.log(Level.FINE, "Project is disabled, ignoring trigger run call for job {0}", name);
            isActive = false;
        } else if (this.getRepository() == null) {
            LOGGER.log(Level.SEVERE, "The ghprb trigger for {0} wasn''t properly started - repository is null", name);
            isActive = false;
        }
        return isActive;
    }

    public GhprbRepository getRepository() {
        if (this.repository == null && this.job != null && ((Job)this.job).isBuildable()) {
            try {
                this.initState();
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, "Unable to init trigger state!", e);
            }
        }
        return this.repository;
    }

    public String getProjectName() {
        String projectName = this.job == null ? "NOT_STARTED" : ((Job)this.job).getFullName();
        return projectName;
    }

    public boolean matchSignature(String body, String signature) {
        if (!this.isActive()) {
            return false;
        }
        GhprbGitHubAuth auth = this.getGitHubApiAuth();
        return auth == null ? false : auth.checkSignature(body, signature);
    }

    public void handleComment(GHEventPayload.IssueComment issueComment) throws IOException {
        GhprbRepository repo = this.getRepository();
        LOGGER.log(Level.INFO, "Checking comment on PR #{0} for job {1}", new Object[]{issueComment.getIssue().getNumber(), this.getProjectName()});
        repo.onIssueCommentHook(issueComment);
    }

    public void handlePR(GHEventPayload.PullRequest pr) throws IOException {
        GhprbRepository repo = this.getRepository();
        LOGGER.log(Level.INFO, "Checking PR #{0} for job {1}", new Object[]{pr.getNumber(), this.getProjectName()});
        repo.onPullRequestHook(pr);
    }

    class StartHookRunnable
    implements Runnable {
        private final Logger logger = Logger.getLogger(StartHookRunnable.class.getName());
        private final GhprbRepository repository;

        StartHookRunnable(GhprbRepository repository) {
            this.repository = repository;
        }

        @Override
        public void run() {
            this.repository.createHook();
            this.logger.log(Level.INFO, "Created hook for {0}", new String[]{this.repository.getName()});
        }
    }

    public static final class DescriptorImpl
    extends TriggerDescriptor {
        private static final Pattern ADMIN_LIST_PATTERN = Pattern.compile("(\\p{Alnum}(-?+\\p{Alnum})*+|\\s)*+");
        static final int INITIAL_CAPACITY = 5;
        static final int MAX_DESCRIPTION_LENGTH = 50;
        static final int DELAY = 5000;
        private Integer configVersion;
        private String whitelistPhrase = ".*add\\W+to\\W+whitelist.*";
        private String okToTestPhrase = ".*ok\\W+to\\W+test.*";
        private String retestPhrase = ".*test\\W+this\\W+please.*";
        private String skipBuildPhrase = ".*\\[skip\\W+ci\\].*";
        private String blackListCommitAuthor = "";
        private String cron = "H/5 * * * *";
        private Boolean useComments = false;
        private Boolean useDetailedComments = false;
        private Boolean manageWebhooks = true;
        private GHCommitState unstableAs = GHCommitState.FAILURE;
        private List<GhprbBranch> whiteListTargetBranches;
        private List<GhprbBranch> blackListTargetBranches;
        private Boolean autoCloseFailedPullRequests = false;
        private Boolean displayBuildErrorsOnDownstreamBuilds = false;
        private String blackListLabels;
        private String whiteListLabels;
        private List<GhprbGitHubAuth> githubAuth;
        private String adminlist;
        private String requestForTestingPhrase;
        private transient Map<String, Map<Integer, GhprbPullRequest>> jobs;
        private transient Map<String, Set<Job<?, ?>>> repoJobs;
        private DescribableList<GhprbExtension, GhprbExtensionDescriptor> extensions;
        @Deprecated
        private transient String publishedURL;
        @Deprecated
        private transient Integer logExcerptLines;
        @Deprecated
        private transient String msgSuccess;
        @Deprecated
        private transient String msgFailure;
        @Deprecated
        private transient String commitStatusContext;
        @Deprecated
        private transient String accessToken;
        @Deprecated
        private transient String username;
        @Deprecated
        private transient String password;
        @Deprecated
        private transient String serverAPIUrl;

        public GhprbGitHubAuth getGitHubAuth(String gitHubAuthId) {
            if (gitHubAuthId == null) {
                return this.getGithubAuth().get(0);
            }
            GhprbGitHubAuth firstAuth = null;
            for (GhprbGitHubAuth auth : this.getGithubAuth()) {
                if (firstAuth == null) {
                    firstAuth = auth;
                }
                if (!auth.getId().equals(gitHubAuthId)) continue;
                return auth;
            }
            return firstAuth;
        }

        public List<GhprbGitHubAuth> getGithubAuth() {
            if (this.githubAuth == null || this.githubAuth.size() == 0) {
                this.githubAuth = new ArrayList<GhprbGitHubAuth>(1);
                this.githubAuth.add(new GhprbGitHubAuth(null, null, null, "Anonymous connection", null, null));
            }
            return this.githubAuth;
        }

        public List<GhprbGitHubAuth> getDefaultAuth(List<GhprbGitHubAuth> githubAuth) {
            if (githubAuth != null && githubAuth.size() > 0) {
                return githubAuth;
            }
            return this.getGithubAuth();
        }

        public List<GhprbExtensionDescriptor> getExtensionDescriptors() {
            return GhprbExtensionDescriptor.allProject();
        }

        public List<GhprbExtensionDescriptor> getGlobalExtensionDescriptors() {
            return GhprbExtensionDescriptor.allGlobal();
        }

        public DescribableList<GhprbExtension, GhprbExtensionDescriptor> getExtensions() {
            if (this.extensions == null) {
                this.extensions = new DescribableList(Saveable.NOOP);
            }
            return this.extensions;
        }

        public DescriptorImpl() {
            this.load();
            this.readBackFromLegacy();
            if (this.repoJobs == null) {
                this.repoJobs = new ConcurrentHashMap();
            }
            this.saveAfterPause();
        }

        private void saveAfterPause() {
            new Timer().schedule(new TimerTask(){

                @Override
                public void run() {
                    DescriptorImpl.this.save();
                }
            }, 5000L);
        }

        @DataBoundSetter
        public void setWhitelistPhrase(String whitelistPhrase) {
            this.whitelistPhrase = whitelistPhrase;
        }

        @DataBoundSetter
        public void setOkToTestPhrase(String okToTestPhrase) {
            this.okToTestPhrase = okToTestPhrase;
        }

        @DataBoundSetter
        public void setRetestPhrase(String retestPhrase) {
            this.retestPhrase = retestPhrase;
        }

        @DataBoundSetter
        public void setSkipBuildPhrase(String skipBuildPhrase) {
            this.skipBuildPhrase = skipBuildPhrase;
        }

        @DataBoundSetter
        public void setBlackListCommitAuthor(String blackListCommitAuthor) {
            this.blackListCommitAuthor = blackListCommitAuthor;
        }

        @DataBoundSetter
        public void setCron(String cron) {
            this.cron = cron;
        }

        @DataBoundSetter
        public void setUseComments(Boolean useComments) {
            this.useComments = useComments;
        }

        @DataBoundSetter
        public void setUseDetailedComments(Boolean useDetailedComments) {
            this.useDetailedComments = useDetailedComments;
        }

        @DataBoundSetter
        public void setManageWebhooks(Boolean manageWebhooks) {
            this.manageWebhooks = manageWebhooks;
        }

        @DataBoundSetter
        public void setAutoCloseFailedPullRequests(Boolean autoCloseFailedPullRequests) {
            this.autoCloseFailedPullRequests = autoCloseFailedPullRequests;
        }

        @DataBoundSetter
        public void setBlackListLabels(String blackListLabels) {
            this.blackListLabels = blackListLabels;
        }

        @DataBoundSetter
        public void setWhiteListLabels(String whiteListLabels) {
            this.whiteListLabels = whiteListLabels;
        }

        @DataBoundSetter
        public void setGithubAuth(List<GhprbGitHubAuth> githubAuth) {
            this.githubAuth = githubAuth;
        }

        @DataBoundSetter
        public void setAdminlist(String adminlist) {
            this.adminlist = adminlist;
        }

        @DataBoundSetter
        public void setRequestForTestingPhrase(String requestForTestingPhrase) {
            this.requestForTestingPhrase = requestForTestingPhrase;
        }

        public boolean isApplicable(Item item) {
            return item instanceof Job && item instanceof ParameterizedJobMixIn.ParameterizedJob;
        }

        public String getDisplayName() {
            return "GitHub Pull Request Builder";
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            this.adminlist = formData.getString("adminlist");
            this.requestForTestingPhrase = formData.getString("requestForTestingPhrase");
            this.whitelistPhrase = formData.getString("whitelistPhrase");
            this.okToTestPhrase = formData.getString("okToTestPhrase");
            this.retestPhrase = formData.getString("retestPhrase");
            this.skipBuildPhrase = formData.getString("skipBuildPhrase");
            this.blackListCommitAuthor = formData.getString("blackListCommitAuthor");
            this.cron = formData.getString("cron");
            this.useComments = formData.getBoolean("useComments");
            this.useDetailedComments = formData.getBoolean("useDetailedComments");
            this.manageWebhooks = formData.getBoolean("manageWebhooks");
            this.unstableAs = GHCommitState.valueOf((String)formData.getString("unstableAs"));
            this.autoCloseFailedPullRequests = formData.getBoolean("autoCloseFailedPullRequests");
            this.displayBuildErrorsOnDownstreamBuilds = formData.getBoolean("displayBuildErrorsOnDownstreamBuilds");
            this.blackListLabels = formData.getString("blackListLabels");
            this.whiteListLabels = formData.getString("whiteListLabels");
            this.githubAuth = req.bindJSONToList(GhprbGitHubAuth.class, formData.get("githubAuth"));
            this.extensions = new DescribableList(Saveable.NOOP);
            try {
                this.extensions.rebuildHetero(req, formData, this.getGlobalExtensionDescriptors(), "extensions");
                Ghprb.addIfMissing(this.extensions, new GhprbSimpleStatus(), GhprbCommitStatus.class);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.readBackFromLegacy();
            this.saveAfterPause();
            return super.configure(req, formData);
        }

        public FormValidation doCheckAdminlist(@QueryParameter String value) throws ServletException {
            if (!ADMIN_LIST_PATTERN.matcher(value).matches()) {
                return FormValidation.error((String)"GitHub username may only contain alphanumeric characters or dashes and cannot have multiple consecutive dashes and cannot begin or end with a dash. Separate them with whitespaces.");
            }
            return FormValidation.ok();
        }

        public ListBoxModel doFillUnstableAsItems() {
            GHCommitState[] results;
            ListBoxModel items = new ListBoxModel();
            for (GHCommitState nextResult : results = new GHCommitState[]{GHCommitState.SUCCESS, GHCommitState.ERROR, GHCommitState.FAILURE}) {
                String text = StringUtils.capitalize((String)nextResult.toString().toLowerCase());
                items.add(text, nextResult.toString());
                if (!this.unstableAs.toString().equals(nextResult.toString())) continue;
                ((ListBoxModel.Option)items.get((int)(items.size() - 1))).selected = true;
            }
            return items;
        }

        public String getAdminlist() {
            return this.adminlist;
        }

        public String getRequestForTestingPhrase() {
            return this.requestForTestingPhrase;
        }

        public String getWhitelistPhrase() {
            return this.whitelistPhrase;
        }

        public String getOkToTestPhrase() {
            return this.okToTestPhrase;
        }

        public String getRetestPhrase() {
            return this.retestPhrase;
        }

        public String getSkipBuildPhrase() {
            return this.skipBuildPhrase;
        }

        public String getBlackListCommitAuthor() {
            return this.blackListCommitAuthor;
        }

        public String getCron() {
            return this.cron;
        }

        public Boolean getUseComments() {
            return this.useComments;
        }

        public Boolean getUseDetailedComments() {
            return this.useDetailedComments;
        }

        public String getBlackListLabels() {
            return this.blackListLabels;
        }

        public String getWhiteListLabels() {
            return this.whiteListLabels;
        }

        public Boolean getManageWebhooks() {
            return this.manageWebhooks;
        }

        public Boolean getAutoCloseFailedPullRequests() {
            return this.autoCloseFailedPullRequests;
        }

        public Boolean getDisplayBuildErrorsOnDownstreamBuilds() {
            return this.displayBuildErrorsOnDownstreamBuilds;
        }

        public GHCommitState getUnstableAs() {
            return this.unstableAs;
        }

        public Integer getConfigVersion() {
            return this.configVersion;
        }

        public boolean isUseComments() {
            return this.useComments != null && this.useComments != false;
        }

        public boolean isUseDetailedComments() {
            return this.useDetailedComments != null && this.useDetailedComments != false;
        }

        public ListBoxModel doFillGitHubAuthIdItems(@QueryParameter(value="gitHubAuthId") String gitHubAuthId) {
            ListBoxModel model = new ListBoxModel();
            for (GhprbGitHubAuth auth : this.getGithubAuth()) {
                String description = Util.fixNull((String)auth.getDescription());
                int length = description.length();
                length = length > 50 ? 50 : length;
                ListBoxModel.Option next = new ListBoxModel.Option(auth.getServerAPIUrl() + " : " + description.substring(0, length), auth.getId());
                if (!StringUtils.isEmpty((String)gitHubAuthId) && gitHubAuthId.equals(auth.getId())) {
                    next.selected = true;
                }
                model.add((Object)next);
            }
            return model;
        }

        public Map<Integer, GhprbPullRequest> getPullRequests(String projectName) {
            Map<Integer, GhprbPullRequest> ret = null;
            if (this.jobs != null && this.jobs.containsKey(projectName)) {
                ret = this.jobs.get(projectName);
                this.jobs.remove(projectName);
            }
            return ret;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addRepoTrigger(String repo, Job<?, ?> project) {
            if (project == null || StringUtils.isEmpty((String)repo)) {
                return;
            }
            LOGGER.log(Level.FINE, "Adding [{0}] to webhooks repo [{1}]", new Object[]{project.getFullName(), repo});
            DescriptorImpl descriptorImpl = this;
            synchronized (descriptorImpl) {
                Set<Object> projects = this.repoJobs.get(repo);
                if (projects == null) {
                    LOGGER.log(Level.FINE, "No other projects found, creating new repo set");
                    projects = Collections.newSetFromMap(new WeakHashMap());
                    this.repoJobs.put(repo, projects);
                } else {
                    LOGGER.log(Level.FINE, "Adding project to current repo set, length: {0}", new Object[]{projects.size()});
                }
                projects.add(project);
            }
        }

        private void removeRepoTrigger(String repo, Job<?, ?> project) {
            Set<Job<?, ?>> projects = this.repoJobs.get(repo);
            if (project != null && projects != null) {
                LOGGER.log(Level.FINE, "Removing [{0}] from webhooks repo [{1}]", new Object[]{repo, project.getFullName()});
                projects.remove(project);
            }
        }

        public Set<Job<?, ?>> getRepoTriggers(String repo) {
            if (this.repoJobs == null) {
                this.repoJobs = new ConcurrentHashMap(5);
            }
            LOGGER.log(Level.FINE, "Retrieving triggers for repo [{0}]", new Object[]{repo});
            Set<Object> projects = this.repoJobs.get(repo);
            if (projects != null) {
                for (Job<?, ?> project : projects) {
                    LOGGER.log(Level.FINE, "Found project [{0}] for webhook repo [{1}]", new Object[]{project.getFullName(), repo});
                }
            } else {
                projects = Collections.newSetFromMap(new WeakHashMap(0));
            }
            return projects;
        }

        public List<GhprbBranch> getWhiteListTargetBranches() {
            return this.whiteListTargetBranches;
        }

        public List<GhprbBranch> getBlackListTargetBranches() {
            return this.blackListTargetBranches;
        }

        public void readBackFromLegacy() {
            GhprbGitHubAuth auth;
            if (this.configVersion == null) {
                this.configVersion = 0;
            }
            if (this.logExcerptLines != null && this.logExcerptLines > 0) {
                this.addIfMissing(new GhprbBuildLog(this.logExcerptLines));
                this.logExcerptLines = null;
            }
            if (!StringUtils.isEmpty((String)this.publishedURL)) {
                this.addIfMissing(new GhprbPublishJenkinsUrl(this.publishedURL));
                this.publishedURL = null;
            }
            if (!StringUtils.isEmpty((String)this.msgFailure) || !StringUtils.isEmpty((String)this.msgSuccess)) {
                ArrayList<GhprbBuildResultMessage> messages = new ArrayList<GhprbBuildResultMessage>(2);
                if (!StringUtils.isEmpty((String)this.msgFailure)) {
                    messages.add(new GhprbBuildResultMessage(GHCommitState.FAILURE, this.msgFailure));
                    this.msgFailure = null;
                }
                if (!StringUtils.isEmpty((String)this.msgSuccess)) {
                    messages.add(new GhprbBuildResultMessage(GHCommitState.SUCCESS, this.msgSuccess));
                    this.msgSuccess = null;
                }
                this.addIfMissing(new GhprbBuildStatus(messages));
            }
            if (this.configVersion < 1) {
                GhprbSimpleStatus status = new GhprbSimpleStatus(this.commitStatusContext);
                this.addIfMissing(status);
                this.commitStatusContext = null;
            }
            if (!StringUtils.isEmpty((String)this.accessToken)) {
                try {
                    auth = new GhprbGitHubAuth(this.serverAPIUrl, null, Ghprb.createCredentials(this.serverAPIUrl, this.accessToken), "Pre credentials Token", null, null);
                    if (this.githubAuth == null) {
                        this.githubAuth = new ArrayList<GhprbGitHubAuth>(1);
                    }
                    this.githubAuth.add(auth);
                    this.accessToken = null;
                    this.serverAPIUrl = null;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (!StringUtils.isEmpty((String)this.username) || !StringUtils.isEmpty((String)this.password)) {
                try {
                    auth = new GhprbGitHubAuth(this.serverAPIUrl, null, Ghprb.createCredentials(this.serverAPIUrl, this.username, this.password), "Pre credentials username and password", null, null);
                    if (this.githubAuth == null) {
                        this.githubAuth = new ArrayList<GhprbGitHubAuth>(1);
                    }
                    this.githubAuth.add(auth);
                    this.username = null;
                    this.password = null;
                    this.serverAPIUrl = null;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.configVersion = 1;
        }

        private void addIfMissing(GhprbExtension ext) {
            if (this.getExtensions().get(((Object)((Object)ext)).getClass()) == null) {
                this.getExtensions().add((Object)ext);
            }
        }
    }
}

