/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.ghprb;

import com.google.common.annotations.VisibleForTesting;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Job;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import hudson.util.FormValidation;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.annotation.Nonnull;
import jenkins.tasks.SimpleBuildStep;
import org.jenkinsci.plugins.ghprb.Ghprb;
import org.jenkinsci.plugins.ghprb.GhprbCause;
import org.jenkinsci.plugins.ghprb.GhprbTrigger;
import org.kohsuke.github.GHIssue;
import org.kohsuke.github.GHPullRequest;
import org.kohsuke.github.GHPullRequestCommitDetail;
import org.kohsuke.github.GHRef;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GHUser;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.GitUser;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class GhprbPullRequestMerge
extends Recorder
implements SimpleBuildStep {
    private transient TaskListener listener;
    private final Boolean onlyAdminsMerge;
    private final Boolean disallowOwnCode;
    private final String mergeComment;
    private final Boolean failOnNonMerge;
    private final Boolean deleteOnMerge;
    private final Boolean allowMergeWithoutTriggerPhrase;
    private transient GhprbTrigger trigger;
    private transient Ghprb helper;
    private transient GhprbCause cause;
    private transient GHPullRequest pr;

    @DataBoundConstructor
    public GhprbPullRequestMerge(String mergeComment, boolean onlyAdminsMerge, boolean disallowOwnCode, boolean failOnNonMerge, boolean deleteOnMerge, boolean allowMergeWithoutTriggerPhrase) {
        this.mergeComment = mergeComment;
        this.onlyAdminsMerge = onlyAdminsMerge;
        this.disallowOwnCode = disallowOwnCode;
        this.failOnNonMerge = failOnNonMerge;
        this.deleteOnMerge = deleteOnMerge;
        this.allowMergeWithoutTriggerPhrase = allowMergeWithoutTriggerPhrase;
    }

    public String getMergeComment() {
        return this.mergeComment;
    }

    public boolean getOnlyAdminsMerge() {
        return this.onlyAdminsMerge == null ? false : this.onlyAdminsMerge;
    }

    public boolean getDisallowOwnCode() {
        return this.disallowOwnCode == null ? false : this.disallowOwnCode;
    }

    public boolean getFailOnNonMerge() {
        return this.failOnNonMerge == null ? false : this.failOnNonMerge;
    }

    public boolean getDeleteOnMerge() {
        return this.deleteOnMerge == null ? false : this.deleteOnMerge;
    }

    public Boolean getAllowMergeWithoutTriggerPhrase() {
        return this.allowMergeWithoutTriggerPhrase == null ? Boolean.valueOf(false) : this.allowMergeWithoutTriggerPhrase;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }

    @VisibleForTesting
    void setHelper(Ghprb helper) {
        this.helper = helper;
    }

    public void perform(@Nonnull Run<?, ?> run, @Nonnull FilePath filePath, @Nonnull Launcher launcher, @Nonnull TaskListener taskListener) throws InterruptedException, IOException {
        GHUser triggerSender;
        this.listener = taskListener;
        Job project = run.getParent();
        if (run.getResult().isWorseThan(Result.SUCCESS)) {
            this.listener.getLogger().println("Build did not succeed, merge will not be run");
            return;
        }
        this.trigger = Ghprb.extractTrigger(project);
        if (this.trigger == null) {
            return;
        }
        this.cause = Ghprb.getCause(run);
        if (this.cause == null) {
            return;
        }
        this.pr = this.trigger.getRepository().getActualPullRequest(this.cause.getPullID());
        if (this.helper == null) {
            this.helper = new Ghprb(this.trigger);
        }
        if (this.helper.isBotUser(triggerSender = this.cause.getTriggerSender())) {
            this.listener.getLogger().println("Comment from bot user " + triggerSender.getLogin() + " ignored.");
            return;
        }
        boolean intendToMerge = false;
        boolean canMerge = true;
        String commentBody = this.cause.getCommentBody();
        if (!(this.getAllowMergeWithoutTriggerPhrase().booleanValue() || commentBody != null && this.helper.isTriggerPhrase(commentBody))) {
            this.listener.getLogger().println("The comment does not contain the required trigger phrase.");
        } else {
            intendToMerge = true;
        }
        if (intendToMerge && this.getOnlyAdminsMerge() && (triggerSender == null || !this.helper.isAdmin(triggerSender))) {
            canMerge = false;
            String msg = "Only admins can merge this pull request, " + (triggerSender != null ? triggerSender.getLogin() + " is not an admin" : " and build was triggered via automation") + ".";
            this.listener.getLogger().println(msg);
            if (triggerSender != null) {
                this.commentOnRequest(String.format("Code not merged because @%s (%s) is not in the Admin list.", triggerSender.getLogin(), triggerSender.getName()));
            }
        }
        if (intendToMerge && this.getDisallowOwnCode() && (triggerSender == null || this.isOwnCode(this.pr, triggerSender))) {
            canMerge = false;
            if (triggerSender != null) {
                this.listener.getLogger().println("The commentor is also one of the contributors.");
                this.commentOnRequest(String.format("Code not merged because @%s (%s) has committed code in the request.", triggerSender.getLogin(), triggerSender.getName()));
            }
        }
        Boolean isMergeable = this.cause.isMerged();
        if (intendToMerge && canMerge && (isMergeable == null || !isMergeable.booleanValue())) {
            this.listener.getLogger().println("Pull request cannot be automerged.");
            this.commentOnRequest("Pull request is not mergeable.");
            this.listener.error("%: Pull request is not mergeable. isMergeable=%s", new Object[]{Result.FAILURE.toString(), isMergeable});
            return;
        }
        if (intendToMerge && canMerge) {
            this.listener.getLogger().println("Merging the pull request");
            try {
                Field ghRootField = GHIssue.class.getDeclaredField("root");
                ghRootField.setAccessible(true);
                Object ghRoot = ghRootField.get(this.pr);
                Method anonMethod = GitHub.class.getMethod("isAnonymous", new Class[0]);
                anonMethod.setAccessible(true);
                Boolean isAnonymous = (Boolean)anonMethod.invoke(ghRoot, new Object[0]);
                this.listener.getLogger().println("Merging PR[" + this.pr + "] is anonymous: " + isAnonymous);
            }
            catch (Exception e) {
                e.printStackTrace(this.listener.getLogger());
            }
            String mergeComment = Ghprb.replaceMacros(run, this.listener, this.getMergeComment());
            this.pr.merge(mergeComment);
            this.listener.getLogger().println("Pull request successfully merged");
            this.deleteBranch(run, launcher, this.listener);
        }
        if (intendToMerge && !canMerge && this.getFailOnNonMerge()) {
            run.setResult(Result.FAILURE);
            return;
        }
    }

    private void deleteBranch(Run<?, ?> build, Launcher launcher, TaskListener listener) {
        if (!this.getDeleteOnMerge()) {
            return;
        }
        String branchName = this.pr.getHead().getRef();
        try {
            GHRepository repo = this.pr.getRepository();
            GHRef ref = repo.getRef("heads/" + branchName);
            ref.delete();
            listener.getLogger().println("Deleted branch " + branchName);
        }
        catch (IOException e) {
            listener.getLogger().println("Unable to delete branch " + branchName);
            e.printStackTrace(listener.getLogger());
        }
    }

    private void commentOnRequest(String comment) {
        try {
            this.trigger.getRepository().addComment(this.pr.getNumber(), comment);
        }
        catch (Exception e) {
            this.listener.getLogger().println("Failed to add comment");
            e.printStackTrace(this.listener.getLogger());
        }
    }

    private boolean isOwnCode(GHPullRequest pr, GHUser commenter) {
        try {
            String commenterName = commenter.getName();
            String commenterEmail = commenter.getEmail();
            String commenterLogin = commenter.getLogin();
            GHUser prUser = pr.getUser();
            if (prUser.getLogin().equals(commenterLogin)) {
                String msg = commenterName + " (" + commenterLogin + ")  has submitted the PR[" + pr.getNumber() + pr.getNumber() + "] that is to be merged";
                this.listener.getLogger().println(msg);
                return true;
            }
            for (GHPullRequestCommitDetail detail : pr.listCommits()) {
                GHPullRequestCommitDetail.Commit commit = detail.getCommit();
                GitUser committer = commit.getCommitter();
                String committerName = committer.getName();
                String committerEmail = committer.getEmail();
                boolean isSame = false;
                isSame |= commenterName != null && commenterName.equals(committerName);
                if (!(isSame |= commenterEmail != null && commenterEmail.equals(committerEmail))) continue;
                String msg = commenterName + " (" + commenterEmail + ")  has commits in PR[" + pr.getNumber() + "] that is to be merged";
                this.listener.getLogger().println(msg);
                return isSame;
            }
        }
        catch (IOException e) {
            this.listener.getLogger().println("Unable to get committer name");
            e.printStackTrace(this.listener.getLogger());
        }
        return false;
    }

    @Extension(ordinal=-1.0)
    public static class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public String getDisplayName() {
            return "Github Pull Request Merger";
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public FormValidation doCheck(@AncestorInPath Job<?, ?> project, @QueryParameter String value) throws IOException {
            FilePath buildDirectory = new FilePath(project.getBuildDir());
            return FilePath.validateFileMask((FilePath)buildDirectory, (String)value);
        }
    }
}

