/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.ghprb;

import com.google.common.base.Joiner;
import hudson.model.Run;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.ghprb.Ghprb;
import org.jenkinsci.plugins.ghprb.GhprbBranch;
import org.jenkinsci.plugins.ghprb.GhprbBuilds;
import org.jenkinsci.plugins.ghprb.GhprbRepository;
import org.jenkinsci.plugins.ghprb.GhprbTrigger;
import org.kohsuke.github.GHCommitPointer;
import org.kohsuke.github.GHIssue;
import org.kohsuke.github.GHIssueComment;
import org.kohsuke.github.GHLabel;
import org.kohsuke.github.GHPullRequest;
import org.kohsuke.github.GHPullRequestCommitDetail;
import org.kohsuke.github.GHUser;
import org.kohsuke.github.GitUser;

public class GhprbPullRequest {
    private static final Logger LOGGER = Logger.getLogger(GhprbPullRequest.class.getName());
    @Deprecated
    private transient GHUser author;
    @Deprecated
    private transient String title;
    @Deprecated
    private transient String reponame;
    @Deprecated
    private transient URL url;
    @Deprecated
    private transient String description;
    @Deprecated
    private transient String target;
    @Deprecated
    private transient String source;
    @Deprecated
    private transient String authorRepoGitUrl;
    @Deprecated
    private transient Boolean changed = true;
    private transient String authorEmail;
    private transient Ghprb helper;
    private transient GhprbRepository repo;
    private transient GHPullRequest pr;
    private transient GHUser triggerSender;
    private transient GitUser commitAuthor;
    private transient String commentBody;
    private transient boolean shouldRun = false;
    private transient boolean triggered = false;
    private transient boolean mergeable = false;
    private transient boolean initialCommentCheckDone = false;
    private final int id;
    private Date updated;
    private String head;
    private String base;
    private boolean accepted = false;
    private String lastBuildId;

    public static String getRequestForTestingPhrase() {
        return GhprbTrigger.getDscp().getRequestForTestingPhrase();
    }

    private boolean setUpdated(Date lastUpdateTime) {
        if (this.updated == null || this.updated.compareTo(lastUpdateTime) < 0) {
            this.updated = lastUpdateTime;
            return true;
        }
        return false;
    }

    private void setHead(String newHead) {
        this.head = StringUtils.isEmpty((String)newHead) ? this.head : newHead;
    }

    private void setBase(String newBase) {
        this.base = StringUtils.isEmpty((String)newBase) ? this.base : newBase;
    }

    private void setAccepted(boolean shouldRun) {
        this.accepted = true;
        this.shouldRun = shouldRun;
    }

    public GhprbPullRequest(GHPullRequest pr, Ghprb ghprb, GhprbRepository repo) {
        GHUser author;
        this.id = pr.getNumber();
        this.setPullRequest(pr);
        this.helper = ghprb;
        this.repo = repo;
        try {
            author = pr.getUser();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        String reponame = repo.getName();
        if (ghprb.isWhitelisted(author)) {
            this.setAccepted(true);
        } else {
            LOGGER.log(Level.INFO, "Author of #{0} {1} on {2} not in whitelist!", new Object[]{this.id, author.getLogin(), reponame});
            if (!this.containsComment(pr, GhprbPullRequest.getRequestForTestingPhrase())) {
                repo.addComment(this.id, GhprbTrigger.getDscp().getRequestForTestingPhrase());
            }
        }
        LOGGER.log(Level.INFO, "Created Pull Request #{0} on {1} by {2} ({3}) updated at: {4} SHA: {5}", new Object[]{this.id, reponame, author.getLogin(), this.getAuthorEmail(), this.updated, this.head});
    }

    private boolean containsComment(GHPullRequest ghPullRequest, String expectedBody) {
        List prComments;
        try {
            prComments = ghPullRequest.getComments();
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Failed to get comments for PR " + ghPullRequest, e);
            return false;
        }
        for (GHIssueComment comment : prComments) {
            if (comment.getBody() == null || !comment.getBody().equals(expectedBody)) continue;
            return true;
        }
        return false;
    }

    public void init(Ghprb helper, GhprbRepository repo) {
        this.helper = helper;
        this.repo = repo;
    }

    public void check(GHPullRequest ghpr, boolean isWebhook) {
        if (this.helper.isProjectDisabled()) {
            LOGGER.log(Level.FINE, "Project is disabled, ignoring pull request");
            return;
        }
        this.updatePR(ghpr, null, isWebhook);
        this.commitAuthor = this.getPRCommitAuthor();
        this.checkSkipBuild();
        this.checkBlackListLabels();
        this.checkWhiteListLabels();
        this.tryBuild();
    }

    private void checkBlackListLabels() {
        Set<String> labelsToIgnore = this.helper.getBlackListLabels();
        if (labelsToIgnore != null && !labelsToIgnore.isEmpty()) {
            try {
                for (GHLabel label : this.pr.getLabels()) {
                    if (!labelsToIgnore.contains(label.getName())) continue;
                    LOGGER.log(Level.INFO, "Found label {0} in ignore list, pull request will be ignored.", label.getName());
                    this.shouldRun = false;
                }
            }
            catch (Error e) {
                LOGGER.log(Level.SEVERE, "Failed to read blacklist labels", e);
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, "Failed to read blacklist labels", e);
            }
        }
    }

    private void checkWhiteListLabels() {
        Set<String> labelsMustContain = this.helper.getWhiteListLabels();
        if (labelsMustContain != null && !labelsMustContain.isEmpty()) {
            boolean containsWhiteListLabel = false;
            try {
                for (GHLabel label : this.pr.getLabels()) {
                    if (!labelsMustContain.contains(label.getName())) continue;
                    LOGGER.log(Level.INFO, "Found label {0} in whitelist", label.getName());
                    containsWhiteListLabel = true;
                }
                if (!containsWhiteListLabel) {
                    LOGGER.log(Level.INFO, "Can't find any of whitelist label.");
                    this.shouldRun = false;
                }
            }
            catch (Error e) {
                LOGGER.log(Level.SEVERE, "Failed to read whitelist labels", e);
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, "Failed to read whitelist labels", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkSkipBuild() {
        GhprbPullRequest ghprbPullRequest = this;
        synchronized (ghprbPullRequest) {
            String skipBuildPhrase = this.helper.checkSkipBuildPhrase((GHIssue)this.pr);
            if (!StringUtils.isEmpty((String)skipBuildPhrase)) {
                LOGGER.log(Level.INFO, "Pull request commented with {0} skipBuildPhrase. Hence skipping the build.", skipBuildPhrase);
                this.shouldRun = false;
                return;
            }
            if (this.commitAuthor == null) {
                return;
            }
            String blackListCommitAuthor = this.helper.checkBlackListCommitAuthor(this.commitAuthor.getName());
            if (!StringUtils.isEmpty((String)blackListCommitAuthor)) {
                LOGGER.log(Level.FINE, "Pull request triggered by user: {0}. Skipping build because that user is blacklisted.", blackListCommitAuthor);
                this.shouldRun = false;
            }
        }
    }

    public void check(GHIssueComment comment) {
        if (this.helper.isProjectDisabled()) {
            LOGGER.log(Level.FINE, "Project is disabled, ignoring comment");
            return;
        }
        this.updatePR(null, comment, true);
        this.commitAuthor = null;
        this.checkSkipBuild();
        this.checkBlackListLabels();
        this.checkWhiteListLabels();
        this.tryBuild();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updatePR(GHPullRequest ghpr, GHIssueComment comment, boolean isWebhook) {
        try {
            Date updatedDate;
            Date lastUpdateTime = this.updated;
            Date date = updatedDate = comment != null ? comment.getUpdatedAt() : ghpr.getUpdatedAt();
            if (this.updated == null || this.updated.compareTo(updatedDate) < 0) {
                String user = comment != null ? comment.getUser().getName() : ghpr.getUser().getName();
                LOGGER.log(Level.INFO, "Pull request #{0} was updated/initialized on {1} at {2} by {3} ({4})", new Object[]{this.id, this.repo.getName(), updatedDate, user, comment != null ? "comment" : "PR update"});
            }
            GhprbPullRequest ghprbPullRequest = this;
            synchronized (ghprbPullRequest) {
                boolean wasUpdated = this.setUpdated(updatedDate);
                if (ghpr != null) {
                    this.setPullRequest(ghpr);
                }
                GHPullRequest pullRequest = this.getPullRequest();
                if (!this.accepted && this.helper.isWhitelisted(this.getPullRequestAuthor())) {
                    LOGGER.log(Level.INFO, "Pull request #{0}'s author has been whitelisted", new Object[]{this.id});
                    this.setAccepted(false);
                }
                int commentsChecked = 0;
                this.commentBody = null;
                if (!(!wasUpdated || isWebhook && this.initialCommentCheckDone)) {
                    this.initialCommentCheckDone = true;
                    commentsChecked = this.checkComments(pullRequest, lastUpdateTime);
                } else if (comment != null) {
                    this.checkComment(comment);
                    commentsChecked = 1;
                }
                boolean newCommit = this.checkCommit(pullRequest);
                if (!newCommit && commentsChecked == 0) {
                    LOGGER.log(Level.INFO, "Pull request #{0} was updated on repo {1} but there aren''t any new comments nor commits; that may mean that commit status was updated.", new Object[]{this.id, this.repo.getName()});
                }
            }
        }
        catch (Error e) {
            LOGGER.log(Level.SEVERE, "Exception caught while updating the PR", e);
        }
        catch (IOException ex) {
            LOGGER.log(Level.SEVERE, "Exception caught while updating the PR", ex);
        }
    }

    private boolean matchesAnyBranch(String target, List<GhprbBranch> branches) {
        for (GhprbBranch b : branches) {
            if (!b.matches(target)) continue;
            return true;
        }
        return false;
    }

    public boolean isAllowedTargetBranch() {
        List<GhprbBranch> whiteListBranches = this.helper.getWhiteListTargetBranches();
        List<GhprbBranch> blackListBranches = this.helper.getBlackListTargetBranches();
        String target = this.getTarget();
        if (!whiteListBranches.isEmpty() && !this.matchesAnyBranch(target, whiteListBranches)) {
            LOGGER.log(Level.FINEST, "PR #{0} target branch: {1} isn''t in our whitelist of target branches: {2}", new Object[]{this.id, target, Joiner.on((char)',').skipNulls().join(whiteListBranches)});
            return false;
        }
        if (!blackListBranches.isEmpty() && this.matchesAnyBranch(target, blackListBranches)) {
            LOGGER.log(Level.FINEST, "PR #{0} target branch: {1} is in our blacklist of target branches: {2}", new Object[]{this.id, target, Joiner.on((char)',').skipNulls().join(blackListBranches)});
            return false;
        }
        return true;
    }

    private GitUser getPRCommitAuthor() {
        try {
            for (GHPullRequestCommitDetail commitDetails : this.pr.listCommits()) {
                if (!commitDetails.getSha().equals(this.getHead())) continue;
                return commitDetails.getCommit().getCommitter();
            }
        }
        catch (Error e) {
            LOGGER.log(Level.INFO, "Unable to get PR commits: ", e);
        }
        catch (Exception ex) {
            LOGGER.log(Level.INFO, "Unable to get PR commits: ", ex);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean containsWatchedPaths(GHPullRequest pr) {
        GhprbPullRequest ghprbPullRequest = this;
        synchronized (ghprbPullRequest) {
            List<Pattern> included = this.helper.getIncludedRegionPatterns();
            List<Pattern> excluded = this.helper.getExcludedRegionPatterns();
            if (included.isEmpty() && excluded.isEmpty()) {
                return true;
            }
            ArrayList<String> paths = new ArrayList<String>();
            for (Object fileDetail : pr.listFiles().withPageSize(100)) {
                paths.add(fileDetail.getFilename());
            }
            ArrayList<String> includedPaths = new ArrayList<String>(paths.size());
            if (!included.isEmpty()) {
                block4: for (String path : paths) {
                    for (Pattern pattern : included) {
                        if (!pattern.matcher(path).matches()) continue;
                        includedPaths.add(path);
                        continue block4;
                    }
                }
            } else {
                includedPaths.addAll(paths);
            }
            ArrayList<String> excludedPaths = new ArrayList<String>();
            if (!excluded.isEmpty()) {
                block6: for (String path : includedPaths) {
                    for (Pattern pattern : excluded) {
                        if (!pattern.matcher(path).matches()) continue;
                        excludedPaths.add(path);
                        continue block6;
                    }
                }
            }
            if (excluded.isEmpty() && !included.isEmpty() && includedPaths.isEmpty()) {
                LOGGER.log(Level.FINEST, "No paths matched included region whitelist in the pull request");
                return false;
            }
            if (includedPaths.size() == excludedPaths.size()) {
                LOGGER.log(Level.FINEST, "Found only excluded paths in the pull request");
                return false;
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryBuild() {
        GhprbPullRequest ghprbPullRequest = this;
        synchronized (ghprbPullRequest) {
            if (this.helper.isProjectDisabled()) {
                LOGGER.log(Level.FINEST, "Project is disabled, not trying to build");
                this.shouldRun = false;
                this.triggered = false;
            }
            if (this.helper.ifOnlyTriggerPhrase() && !this.triggered) {
                LOGGER.log(Level.FINEST, "Trigger only phrase but we are not triggered");
                this.shouldRun = false;
            }
            this.triggered = false;
            if (!this.isAllowedTargetBranch()) {
                LOGGER.log(Level.FINEST, "Branch is not whitelisted or is blacklisted, skipping the build");
                return;
            }
            if (this.shouldRun && !this.containsWatchedPaths(this.pr)) {
                LOGGER.log(Level.FINEST, "Pull request contains no watched paths, skipping the build");
                this.shouldRun = false;
            }
            if (this.shouldRun) {
                this.shouldRun = false;
                LOGGER.log(Level.FINEST, "Running the build");
                if (this.pr != null) {
                    LOGGER.log(Level.FINEST, "PR is not null, checking if mergable");
                    this.checkMergeable();
                    this.getPRCommitAuthor();
                }
                LOGGER.log(Level.FINEST, "Running build...");
                this.build();
            }
        }
    }

    private void build() {
        GhprbBuilds builder = this.helper.getBuilds();
        builder.build(this, this.triggerSender, this.commentBody);
    }

    private boolean checkCommit(GHPullRequest pr) {
        GHCommitPointer head = pr.getHead();
        GHCommitPointer base = pr.getBase();
        String headSha = head.getSha();
        String baseSha = base.getSha();
        if (StringUtils.equals((String)headSha, (String)this.head) && StringUtils.equals((String)baseSha, (String)this.base)) {
            return false;
        }
        LOGGER.log(Level.FINE, "New commit. Sha: Head[{0} => {1}] Base[{2} => {3}]", new Object[]{this.head, headSha, this.base, baseSha});
        this.setHead(headSha);
        this.setBase(baseSha);
        if (this.accepted) {
            this.shouldRun = true;
        }
        return true;
    }

    private void checkComment(GHIssueComment comment) throws IOException {
        GHUser sender = comment.getUser();
        String body = comment.getBody();
        String senderName = sender.getName();
        LOGGER.log(Level.FINEST, "[{0}] Added comment: {1}", new Object[]{senderName != null ? senderName : sender.getLogin(), body});
        if (this.helper.isWhitelistPhrase(body) && this.helper.isAdmin(sender)) {
            GHIssue parent = comment.getParent();
            GHUser author = parent.getUser();
            if (!this.helper.isWhitelisted(author)) {
                LOGGER.log(Level.FINEST, "Author {0} not whitelisted, adding to whitelist.", author);
                this.helper.addWhitelist(author.getLogin());
            }
            this.setAccepted(true);
        } else if (this.helper.isOktotestPhrase(body) && this.helper.isAdmin(sender)) {
            LOGGER.log(Level.FINEST, "Admin {0} gave OK to test", sender);
            this.setAccepted(true);
        } else if (this.helper.isRetestPhrase(body)) {
            LOGGER.log(Level.FINEST, "Retest phrase");
            if (this.helper.isAdmin(sender)) {
                LOGGER.log(Level.FINEST, "Admin {0} gave retest phrase", sender);
                this.shouldRun = true;
            } else if (this.accepted && this.helper.isWhitelisted(sender)) {
                LOGGER.log(Level.FINEST, "Retest accepted and user {0} is whitelisted", sender);
                this.shouldRun = true;
            }
        } else if (this.helper.isTriggerPhrase(body)) {
            LOGGER.log(Level.FINEST, "Trigger phrase");
            if (this.helper.isAdmin(sender)) {
                LOGGER.log(Level.FINEST, "Admin {0} ran trigger phrase", sender);
                this.shouldRun = true;
                this.triggered = true;
            } else if (this.accepted && this.helper.isWhitelisted(sender)) {
                LOGGER.log(Level.FINEST, "Trigger accepted and user {0} is whitelisted", sender);
                this.shouldRun = true;
                this.triggered = true;
            }
        }
        if (this.shouldRun) {
            this.triggerSender = sender;
            this.commentBody = body;
        }
    }

    private int checkComments(GHPullRequest ghpr, Date lastUpdatedTime) {
        int count = 0;
        LOGGER.log(Level.FINEST, "Checking for comments after: {0}", lastUpdatedTime);
        try {
            for (GHIssueComment comment : ghpr.getComments()) {
                LOGGER.log(Level.FINEST, "Comment was made at: {0}", comment.getUpdatedAt());
                if (lastUpdatedTime.compareTo(comment.getUpdatedAt()) >= 0) continue;
                LOGGER.log(Level.FINEST, "Comment was made after last update time, {0}", comment.getBody());
                ++count;
                try {
                    this.checkComment(comment);
                }
                catch (IOException ex) {
                    LOGGER.log(Level.SEVERE, "Couldn't check comment #" + comment.getId(), ex);
                }
            }
        }
        catch (Error e) {
            LOGGER.log(Level.SEVERE, "Couldn't obtain comments.", e);
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Couldn't obtain comments.", e);
        }
        return count;
    }

    public boolean checkMergeable() {
        try {
            int r = 5;
            Boolean isMergeable = this.pr.getMergeable();
            while (isMergeable == null && r-- > 0) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ex) {
                    break;
                }
                this.getPullRequest(true);
                isMergeable = this.pr.getMergeable();
            }
            this.mergeable = isMergeable != null && isMergeable != false;
        }
        catch (Error e) {
            LOGGER.log(Level.SEVERE, "Couldn't obtain mergeable status.", e);
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Couldn't obtain mergeable status.", e);
        }
        return this.mergeable;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof GhprbPullRequest)) {
            return false;
        }
        GhprbPullRequest o = (GhprbPullRequest)obj;
        return o.id == this.id;
    }

    public int hashCode() {
        int hash = 7;
        hash = 89 * hash + this.id;
        return hash;
    }

    public int getId() {
        return this.id;
    }

    public String getHead() {
        return this.head;
    }

    public String getAuthorRepoGitUrl() {
        GHCommitPointer prHead = this.pr.getHead();
        String authorRepoGitUrl = "";
        if (prHead != null && prHead.getRepository() != null) {
            authorRepoGitUrl = prHead.getRepository().getHttpTransportUrl();
        }
        return authorRepoGitUrl;
    }

    public boolean isMergeable() {
        return this.mergeable;
    }

    public String getTarget() {
        try {
            return this.getPullRequest().getBase().getRef();
        }
        catch (IOException e) {
            return "UNKNOWN";
        }
    }

    public String getSource() {
        try {
            return this.getPullRequest().getHead().getRef();
        }
        catch (IOException e) {
            return "UNKNOWN";
        }
    }

    public String getTitle() {
        try {
            return this.getPullRequest().getTitle();
        }
        catch (IOException e) {
            return "UNKNOWN";
        }
    }

    public URL getUrl() throws IOException {
        return this.getPullRequest().getHtmlUrl();
    }

    public String getDescription() {
        try {
            return this.getPullRequest().getBody();
        }
        catch (IOException e) {
            return "UNKNOWN";
        }
    }

    public GitUser getCommitAuthor() {
        return this.commitAuthor;
    }

    public GHUser getPullRequestAuthor() throws IOException {
        return this.getPullRequest().getUser();
    }

    public GHPullRequest getPullRequest() throws IOException {
        return this.getPullRequest(false);
    }

    public GHPullRequest getPullRequest(boolean force) throws IOException {
        if (this.pr == null || force) {
            this.setPullRequest(this.repo.getActualPullRequest(this.id));
        }
        return this.pr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setPullRequest(GHPullRequest pr) {
        if (pr == null) {
            return;
        }
        GhprbPullRequest ghprbPullRequest = this;
        synchronized (ghprbPullRequest) {
            this.pr = pr;
            try {
                if (this.updated == null) {
                    this.setUpdated(pr.getCreatedAt());
                }
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Unable to get date for new PR", e);
                this.setUpdated(new Date());
            }
            if (StringUtils.isEmpty((String)this.head)) {
                GHCommitPointer prHead = pr.getHead();
                this.setHead(prHead.getSha());
            }
            if (StringUtils.isEmpty((String)this.base)) {
                GHCommitPointer prBase = pr.getBase();
                this.setBase(prBase.getSha());
            }
        }
    }

    public String getAuthorEmail() {
        if (StringUtils.isEmpty((String)this.authorEmail)) {
            try {
                GHUser user = this.getPullRequestAuthor();
                this.authorEmail = user.getEmail();
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, "Unable to fetch author info for " + this.id);
            }
        }
        this.authorEmail = StringUtils.isEmpty((String)this.authorEmail) ? "" : this.authorEmail;
        return this.authorEmail;
    }

    public void setBuild(Run<?, ?> build) {
        this.lastBuildId = build.getId();
    }

    public String getLastBuildId() {
        return this.lastBuildId;
    }
}

