/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.ghprb;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.IdCredentials;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.cloudbees.plugins.credentials.domains.URIRequirementBuilder;
import com.google.common.base.Joiner;
import hudson.Extension;
import hudson.Util;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.security.ACL;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.ghprb.Ghprb;
import org.jenkinsci.plugins.ghprb.HttpConnectorWithJenkinsProxy;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;
import org.kohsuke.github.GHAuthorization;
import org.kohsuke.github.GHCommitState;
import org.kohsuke.github.GHIssue;
import org.kohsuke.github.GHMyself;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.GitHubBuilder;
import org.kohsuke.github.HttpConnector;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.verb.POST;

public class GhprbGitHubAuth
extends AbstractDescribableImpl<GhprbGitHubAuth> {
    private static final Logger LOGGER = Logger.getLogger(GhprbGitHubAuth.class.getName());
    @Extension
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();
    private static final int SHA1_PREFIX_LENGTH = 5;
    private static final int INITIAL_CAPACITY = 3;
    private final String serverAPIUrl;
    private final String jenkinsUrl;
    private final String credentialsId;
    private final String id;
    private final String description;
    private final Secret secret;
    private transient GitHub gh;

    @DataBoundConstructor
    public GhprbGitHubAuth(String serverAPIUrl, String jenkinsUrl, String credentialsId, String description, String id, Secret secret) {
        if (StringUtils.isEmpty((String)serverAPIUrl)) {
            serverAPIUrl = "https://api.github.com";
        }
        this.serverAPIUrl = Util.fixEmptyAndTrim((String)serverAPIUrl);
        this.jenkinsUrl = Util.fixEmptyAndTrim((String)jenkinsUrl);
        this.credentialsId = Util.fixEmpty((String)credentialsId);
        if (StringUtils.isEmpty((String)id)) {
            id = UUID.randomUUID().toString();
        }
        this.id = IdCredentials.Helpers.fixEmptyId((String)id);
        this.description = description;
        this.secret = secret;
    }

    @Exported
    public String getServerAPIUrl() {
        return this.serverAPIUrl;
    }

    @Exported
    public String getJenkinsUrl() {
        return this.jenkinsUrl;
    }

    @Exported
    public String getCredentialsId() {
        return this.credentialsId;
    }

    @Exported
    public String getDescription() {
        return this.description;
    }

    @Exported
    public String getId() {
        return this.id;
    }

    @Exported
    public Secret getSecret() {
        return this.secret;
    }

    public boolean checkSignature(String body, String signature) {
        block5: {
            if (this.secret == null || StringUtils.isEmpty((String)this.secret.getPlainText())) {
                return true;
            }
            if (signature != null && signature.startsWith("sha1=")) {
                String expected = signature.substring(5);
                String algorithm = "HmacSHA1";
                try {
                    SecretKeySpec keySpec = new SecretKeySpec(this.secret.getPlainText().getBytes(Charset.forName("UTF-8")), algorithm);
                    Mac mac = Mac.getInstance(algorithm);
                    mac.init(keySpec);
                    byte[] localSignatureBytes = mac.doFinal(body.getBytes("UTF-8"));
                    String localSignature = Hex.encodeHexString((byte[])localSignatureBytes);
                    if (!localSignature.equals(expected)) {
                        LOGGER.log(Level.SEVERE, "Local signature {0} does not match external signature {1}", new Object[]{localSignature, expected});
                        return false;
                    }
                    break block5;
                }
                catch (Exception e) {
                    LOGGER.log(Level.SEVERE, "Couldn't match both signatures");
                    return false;
                }
            }
            LOGGER.log(Level.SEVERE, "Request doesn't contain a signature. Check that github has a secret that should be attached to the hook");
            return false;
        }
        LOGGER.log(Level.INFO, "Signatures checking OK");
        return true;
    }

    private static GitHubBuilder getBuilder(Item context, String serverAPIUrl, String credentialsId) {
        String contextName;
        GitHubBuilder builder = new GitHubBuilder().withEndpoint(serverAPIUrl).withConnector((HttpConnector)new HttpConnectorWithJenkinsProxy());
        String string = contextName = context == null ? "(Jenkins.instance)" : context.getFullDisplayName();
        if (StringUtils.isEmpty((String)credentialsId)) {
            LOGGER.log(Level.WARNING, "credentialsId not set for context {0}, using anonymous connection", contextName);
            return builder;
        }
        StandardCredentials credentials = Ghprb.lookupCredentials(context, credentialsId, serverAPIUrl);
        if (credentials == null) {
            LOGGER.log(Level.SEVERE, "Failed to look up credentials for context {0} using id: {1}", new Object[]{contextName, credentialsId});
        } else if (credentials instanceof StandardUsernamePasswordCredentials) {
            LOGGER.log(Level.FINEST, "Using username/password for context {0}", contextName);
            StandardUsernamePasswordCredentials upCredentials = (StandardUsernamePasswordCredentials)credentials;
            builder.withPassword(upCredentials.getUsername(), upCredentials.getPassword().getPlainText());
        } else if (credentials instanceof StringCredentials) {
            LOGGER.log(Level.FINEST, "Using OAuth token for context {0}", contextName);
            StringCredentials tokenCredentials = (StringCredentials)credentials;
            builder.withOAuthToken(tokenCredentials.getSecret().getPlainText());
        } else {
            LOGGER.log(Level.SEVERE, "Unknown credential type for context {0} using id: {1}: {2}", new Object[]{contextName, credentialsId, credentials.getClass().getName()});
            return null;
        }
        return builder;
    }

    private void buildConnection(Item context) {
        GitHubBuilder builder = GhprbGitHubAuth.getBuilder(context, this.serverAPIUrl, this.credentialsId);
        if (builder == null) {
            LOGGER.log(Level.SEVERE, "Unable to get builder using credentials: {0}", this.credentialsId);
            return;
        }
        try {
            this.gh = builder.build();
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Unable to connect using credentials: " + this.credentialsId, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GitHub getConnection(Item context) throws IOException {
        GhprbGitHubAuth ghprbGitHubAuth = this;
        synchronized (ghprbGitHubAuth) {
            if (this.gh == null) {
                this.buildConnection(context);
            }
            return this.gh;
        }
    }

    public DescriptorImpl getDescriptor() {
        return DESCRIPTOR;
    }

    public static final class DescriptorImpl
    extends Descriptor<GhprbGitHubAuth> {
        public String getDisplayName() {
            return "GitHub Auth";
        }

        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath Item context, @QueryParameter String serverAPIUrl, @QueryParameter String credentialsId) {
            List domainRequirements = URIRequirementBuilder.fromUri((String)serverAPIUrl).build();
            ArrayList<CredentialsMatcher> matchers = new ArrayList<CredentialsMatcher>(3);
            if (!StringUtils.isEmpty((String)credentialsId)) {
                matchers.add(0, CredentialsMatchers.withId((String)credentialsId));
            }
            matchers.add(CredentialsMatchers.instanceOf(StandardUsernamePasswordCredentials.class));
            matchers.add(CredentialsMatchers.instanceOf(StringCredentials.class));
            List credentials = CredentialsProvider.lookupCredentials(StandardCredentials.class, (Item)context, (Authentication)ACL.SYSTEM, (List)domainRequirements);
            return new StandardListBoxModel().withMatching(CredentialsMatchers.anyOf((CredentialsMatcher[])matchers.toArray(new CredentialsMatcher[0])), (Iterable)credentials);
        }

        @POST
        public FormValidation doCreateApiToken(@QueryParameter(value="serverAPIUrl") String serverAPIUrl, @QueryParameter(value="credentialsId") String credentialsId, @QueryParameter(value="username") String username, @QueryParameter(value="password") String password) {
            try {
                String tokenId;
                Jenkins.getInstance().checkPermission(Jenkins.ADMINISTER);
                GitHubBuilder builder = new GitHubBuilder().withEndpoint(serverAPIUrl).withConnector((HttpConnector)new HttpConnectorWithJenkinsProxy());
                if (StringUtils.isEmpty((String)credentialsId)) {
                    if (StringUtils.isEmpty((String)username) || StringUtils.isEmpty((String)password)) {
                        return FormValidation.error((String)"Username and Password required");
                    }
                    builder.withPassword(username, password);
                } else {
                    StandardCredentials credentials = Ghprb.lookupCredentials(null, credentialsId, serverAPIUrl);
                    if (credentials instanceof StandardUsernamePasswordCredentials) {
                        StandardUsernamePasswordCredentials upCredentials = (StandardUsernamePasswordCredentials)credentials;
                        builder.withPassword(upCredentials.getUsername(), upCredentials.getPassword().getPlainText());
                    } else {
                        return FormValidation.error((String)"No username/password credentials provided");
                    }
                }
                GitHub gh = builder.build();
                GHAuthorization token = gh.createToken(Arrays.asList("repo:status", "repo"), "Jenkins GitHub Pull Request Builder", null);
                try {
                    tokenId = Ghprb.createCredentials(serverAPIUrl, token.getToken());
                }
                catch (Exception e) {
                    tokenId = "Unable to create credentials: " + e.getMessage();
                }
                return FormValidation.ok((String)("Access token created: " + token.getToken() + " token CredentialsID: " + tokenId));
            }
            catch (IOException ex) {
                return FormValidation.error((String)("GitHub API token couldn't be created: " + ex.getMessage()));
            }
        }

        public FormValidation doCheckServerAPIUrl(@QueryParameter String value) {
            if ("https://api.github.com".equals(value)) {
                return FormValidation.ok();
            }
            if (value.endsWith("/api/v3") || value.endsWith("/api/v3/")) {
                return FormValidation.ok();
            }
            return FormValidation.warning((String)"GitHub API URI is \"https://api.github.com\". GitHub Enterprise API URL ends with \"/api/v3\"");
        }

        @POST
        public FormValidation doCheckRepoAccess(@QueryParameter(value="serverAPIUrl") String serverAPIUrl, @QueryParameter(value="credentialsId") String credentialsId, @QueryParameter(value="repo") String repo) {
            Jenkins.getInstance().checkPermission(Jenkins.ADMINISTER);
            try {
                GitHubBuilder builder = GhprbGitHubAuth.getBuilder(null, serverAPIUrl, credentialsId);
                if (builder == null) {
                    return FormValidation.error((String)("Unable to look up GitHub credentials using ID: " + credentialsId + "!!"));
                }
                GitHub gh = builder.build();
                GHRepository repository = gh.getRepository(repo);
                StringBuilder sb = new StringBuilder();
                sb.append("User has access to: ");
                ArrayList<String> permissions = new ArrayList<String>(3);
                if (repository.hasAdminAccess()) {
                    permissions.add("Admin");
                }
                if (repository.hasPushAccess()) {
                    permissions.add("Push");
                }
                if (repository.hasPullAccess()) {
                    permissions.add("Pull");
                }
                sb.append(Joiner.on((String)", ").join(permissions));
                return FormValidation.ok((String)sb.toString());
            }
            catch (Exception ex) {
                return FormValidation.error((String)("Unable to connect to GitHub API: " + ex));
            }
        }

        @POST
        public FormValidation doTestGithubAccess(@QueryParameter(value="serverAPIUrl") String serverAPIUrl, @QueryParameter(value="credentialsId") String credentialsId) {
            Jenkins.getInstance().checkPermission(Jenkins.ADMINISTER);
            try {
                GitHubBuilder builder = GhprbGitHubAuth.getBuilder(null, serverAPIUrl, credentialsId);
                if (builder == null) {
                    return FormValidation.error((String)("Unable to look up GitHub credentials using ID: " + credentialsId + "!!"));
                }
                GitHub gh = builder.build();
                GHMyself me = gh.getMyself();
                String name = me.getName();
                String email = me.getEmail();
                String login = me.getLogin();
                String comment = String.format("Connected to %s as %s (%s) login: %s", serverAPIUrl, name, email, login);
                return FormValidation.ok((String)comment);
            }
            catch (Exception ex) {
                return FormValidation.error((String)("Unable to connect to GitHub API: " + ex));
            }
        }

        public FormValidation doTestComment(@QueryParameter(value="serverAPIUrl") String serverAPIUrl, @QueryParameter(value="credentialsId") String credentialsId, @QueryParameter(value="repo") String repoName, @QueryParameter(value="issueId") int issueId, @QueryParameter(value="message1") String comment) {
            try {
                GitHubBuilder builder = GhprbGitHubAuth.getBuilder(null, serverAPIUrl, credentialsId);
                if (builder == null) {
                    return FormValidation.error((String)("Unable to look up GitHub credentials using ID: " + credentialsId + "!!"));
                }
                GitHub gh = builder.build();
                GHRepository repo = gh.getRepository(repoName);
                GHIssue issue = repo.getIssue(issueId);
                issue.comment(comment);
                return FormValidation.ok((String)("Issued comment to issue: " + issue.getHtmlUrl()));
            }
            catch (Exception ex) {
                return FormValidation.error((String)("Unable to issue comment: " + ex));
            }
        }

        public FormValidation doTestUpdateStatus(@QueryParameter(value="serverAPIUrl") String serverAPIUrl, @QueryParameter(value="credentialsId") String credentialsId, @QueryParameter(value="repo") String repoName, @QueryParameter(value="sha1") String sha1, @QueryParameter(value="state") GHCommitState state, @QueryParameter(value="url") String url, @QueryParameter(value="message2") String message, @QueryParameter(value="context") String context) {
            try {
                GitHubBuilder builder = GhprbGitHubAuth.getBuilder(null, serverAPIUrl, credentialsId);
                if (builder == null) {
                    return FormValidation.error((String)("Unable to look up GitHub credentials using ID: " + credentialsId + "!!"));
                }
                GitHub gh = builder.build();
                GHRepository repo = gh.getRepository(repoName);
                repo.createCommitStatus(sha1, state, url, message, context);
                return FormValidation.ok((String)("Updated status of: " + sha1));
            }
            catch (Exception ex) {
                return FormValidation.error((String)("Unable to update status: " + ex));
            }
        }

        public ListBoxModel doFillStateItems(@QueryParameter(value="state") String state) {
            ListBoxModel items = new ListBoxModel();
            for (GHCommitState commitState : GHCommitState.values()) {
                items.add(commitState.toString(), commitState.toString());
                if (!state.equals(commitState.toString())) continue;
                ((ListBoxModel.Option)items.get((int)(items.size() - 1))).selected = true;
            }
            return items;
        }
    }
}

