/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.ghprb;

import hudson.model.Cause;
import java.net.URL;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.github.GHUser;
import org.kohsuke.github.GitUser;

public class GhprbCause
extends Cause {
    public static final int MAX_WIDTH = 30;
    private final String commit;
    private final int pullID;
    private final boolean merged;
    private final String targetBranch;
    private final String sourceBranch;
    private final String authorEmail;
    private final String title;
    private final URL url;
    private final transient GHUser triggerSender;
    private final String commentBody;
    private final transient GitUser commitAuthor;
    private final transient GHUser pullRequestAuthor;
    private final String description;
    private final String authorRepoGitUrl;
    private final String repoName;
    private final String credentialsId;

    public GhprbCause(String commit, int pullID, boolean merged, String targetBranch, String sourceBranch, String authorEmail, String title, URL url, GHUser triggerSender, String commentBody, GitUser commitAuthor, GHUser pullRequestAuthor, String description, String authorRepoGitUrl, String repoName, String credentialsId) {
        this.commit = commit;
        this.pullID = pullID;
        this.merged = merged;
        this.targetBranch = targetBranch;
        this.sourceBranch = sourceBranch;
        this.authorEmail = authorEmail;
        this.title = title;
        this.url = url;
        this.description = description;
        this.triggerSender = triggerSender;
        this.commentBody = commentBody;
        this.commitAuthor = commitAuthor;
        this.pullRequestAuthor = pullRequestAuthor;
        this.authorRepoGitUrl = authorRepoGitUrl;
        this.repoName = repoName;
        this.credentialsId = credentialsId;
    }

    public String getShortDescription() {
        return "GitHub pull request #" + this.pullID + " of commit " + this.commit + (this.merged ? ", no merge conflicts." : ", has merge conflicts.");
    }

    public String getCommit() {
        return this.commit;
    }

    public boolean isMerged() {
        return this.merged;
    }

    public int getPullID() {
        return this.pullID;
    }

    public String getTargetBranch() {
        return this.targetBranch;
    }

    public String getSourceBranch() {
        return this.sourceBranch;
    }

    public String getAuthorEmail() {
        return this.authorEmail;
    }

    public URL getUrl() {
        return this.url;
    }

    public GHUser getTriggerSender() {
        return this.triggerSender;
    }

    public String getCommentBody() {
        return this.commentBody;
    }

    public GHUser getPullRequestAuthor() {
        return this.pullRequestAuthor;
    }

    public String getTitle() {
        return this.title != null ? this.title : "";
    }

    public String getAbbreviatedTitle() {
        return StringUtils.abbreviate((String)this.getTitle(), (int)30);
    }

    public GitUser getCommitAuthor() {
        return this.commitAuthor;
    }

    public String getDescription() {
        return this.description;
    }

    public String getAuthorRepoGitUrl() {
        return this.authorRepoGitUrl;
    }

    public String getRepositoryName() {
        return this.repoName;
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }
}

