/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.ghprb;

import com.google.common.annotations.VisibleForTesting;
import hudson.Launcher;
import hudson.Util;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.queue.QueueTaskFuture;
import hudson.plugins.git.util.BuildData;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.ghprb.Ghprb;
import org.jenkinsci.plugins.ghprb.GhprbCause;
import org.jenkinsci.plugins.ghprb.GhprbPullRequest;
import org.jenkinsci.plugins.ghprb.GhprbRepository;
import org.jenkinsci.plugins.ghprb.GhprbTrigger;
import org.jenkinsci.plugins.ghprb.extensions.GhprbBuildStep;
import org.jenkinsci.plugins.ghprb.extensions.GhprbCommentAppender;
import org.jenkinsci.plugins.ghprb.extensions.GhprbCommitStatus;
import org.jenkinsci.plugins.ghprb.extensions.GhprbCommitStatusException;
import org.jenkinsci.plugins.ghprb.extensions.GhprbExtension;
import org.kohsuke.github.GHCommitState;
import org.kohsuke.github.GHIssueState;
import org.kohsuke.github.GHPullRequest;
import org.kohsuke.github.GHUser;

public class GhprbBuilds {
    private static final Logger LOGGER = Logger.getLogger(GhprbBuilds.class.getName());
    private static final int WAIT_TIMEOUT = 1000;
    private static final int WAIT_COUNTER = 60;
    private final GhprbTrigger trigger;
    private final GhprbRepository repo;

    public GhprbBuilds(GhprbTrigger trigger, GhprbRepository repo) {
        this.trigger = trigger;
        this.repo = repo;
    }

    public void build(GhprbPullRequest pr, GHUser triggerSender, String commentBody) {
        URL url = null;
        GHUser prAuthor = null;
        try {
            url = pr.getUrl();
            prAuthor = pr.getPullRequestAuthor();
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Unable to get PR author or PR URL", e);
        }
        GhprbCause cause = new GhprbCause(pr.getHead(), pr.getId(), pr.isMergeable(), pr.getTarget(), pr.getSource(), pr.getAuthorEmail(), pr.getTitle(), url, triggerSender, commentBody, pr.getCommitAuthor(), prAuthor, pr.getDescription(), pr.getAuthorRepoGitUrl(), this.repo.getName(), this.trigger.getGitHubApiAuth().getCredentialsId());
        for (GhprbExtension ext : Ghprb.getJobExtensions(this.trigger, GhprbCommitStatus.class)) {
            if (!(ext instanceof GhprbCommitStatus)) continue;
            try {
                ((GhprbCommitStatus)((Object)ext)).onBuildTriggered(this.trigger.getActualProject(), pr.getHead(), pr.isMergeable(), pr.getId(), this.repo.getGitHubRepo());
            }
            catch (GhprbCommitStatusException e) {
                this.repo.commentOnFailure(null, null, e);
            }
        }
        QueueTaskFuture<?> build = this.trigger.scheduleBuild(cause, this.repo);
        if (build == null) {
            LOGGER.log(Level.SEVERE, "Job did not start");
        }
    }

    public void onStarted(Run<?, ?> build, TaskListener listener) {
        PrintStream logger = listener.getLogger();
        GhprbCause c = Ghprb.getCause(build);
        if (c == null) {
            return;
        }
        GhprbTrigger trigger = Ghprb.extractTrigger(build);
        GhprbPullRequest pullRequest = trigger.getRepository().getPullRequest(c.getPullID());
        pullRequest.setBuild(build);
        try {
            GHPullRequest pr = pullRequest.getPullRequest(true);
            int counter = 0;
            Boolean isMergeable = pr.getMergeable();
            boolean isMerged = pr.isMerged();
            while (isMergeable == null && !isMerged && counter++ < 60) {
                Thread.sleep(1000L);
                isMergeable = pr.getMergeable();
                isMerged = pr.isMerged();
            }
            if (isMerged) {
                logger.println("PR has already been merged, builds using the merged sha1 will fail!!!");
            } else if (isMergeable == null) {
                logger.println("PR merge status couldn't be retrieved, maybe GitHub hasn't settled yet");
            } else if (isMergeable.booleanValue() != c.isMerged()) {
                logger.println("!!! PR mergeability status has changed !!!  ");
                if (isMergeable.booleanValue()) {
                    logger.println("PR now has NO merge conflicts");
                } else if (!isMergeable.booleanValue()) {
                    logger.println("PR now has merge conflicts!");
                }
            }
        }
        catch (Exception e) {
            logger.print("Unable to query GitHub for status of PullRequest");
            e.printStackTrace(logger);
        }
        for (GhprbExtension ext : Ghprb.getJobExtensions(trigger, GhprbCommitStatus.class)) {
            if (!(ext instanceof GhprbCommitStatus)) continue;
            try {
                ((GhprbCommitStatus)((Object)ext)).onBuildStart(build, listener, this.repo.getGitHubRepo());
            }
            catch (GhprbCommitStatusException e) {
                this.repo.commentOnFailure(build, listener, e);
            }
        }
        try {
            String template = trigger.getBuildDescTemplate();
            if (StringUtils.isEmpty((String)template)) {
                template = "<a title=\"$title\" href=\"$url\">PR #$pullId</a>: $abbrTitle";
            }
            Map<String, String> vars = this.getVariables(c);
            template = Util.replaceMacro((String)template, vars);
            template = Ghprb.replaceMacros(build, listener, template);
            build.setDescription(template);
        }
        catch (IOException ex) {
            logger.print("Can't update build description");
            ex.printStackTrace(logger);
        }
    }

    public Map<String, String> getVariables(GhprbCause c) {
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("title", c.getTitle());
        if (c.getUrl() != null) {
            vars.put("url", c.getUrl().toString());
        } else {
            vars.put("url", "");
        }
        vars.put("pullId", Integer.toString(c.getPullID()));
        vars.put("abbrTitle", c.getAbbreviatedTitle());
        return vars;
    }

    public void onCompleted(Run<?, ?> build, TaskListener listener) {
        Object abortAction;
        GhprbCause c = Ghprb.getCause(build);
        if (c == null) {
            return;
        }
        for (BuildData data : build.getActions(BuildData.class)) {
            if (data.getLastBuiltRevision() == null || data.getLastBuiltRevision().getSha1String().equals(c.getCommit())) continue;
            build.getActions().remove(data);
            break;
        }
        if (build.getResult() == Result.ABORTED && (abortAction = (GhprbBuildStep)build.getAction(GhprbBuildStep.class)) != null) {
            return;
        }
        for (GhprbExtension ext : Ghprb.getJobExtensions(this.trigger, GhprbCommitStatus.class)) {
            if (!(ext instanceof GhprbCommitStatus)) continue;
            try {
                ((GhprbCommitStatus)((Object)ext)).onBuildComplete(build, listener, this.repo.getGitHubRepo());
            }
            catch (GhprbCommitStatusException e) {
                this.repo.commentOnFailure(build, listener, e);
            }
        }
        GHCommitState state = Ghprb.getState(build);
        this.commentOnBuildResult(build, listener, state, c);
        if (state == GHCommitState.FAILURE && this.trigger.getAutoCloseFailedPullRequests().booleanValue()) {
            this.closeFailedRequest(listener, c);
        }
    }

    private void closeFailedRequest(TaskListener listener, GhprbCause c) {
        try {
            GHPullRequest pr = this.repo.getActualPullRequest(c.getPullID());
            if (pr.getState().equals((Object)GHIssueState.OPEN)) {
                this.repo.closePullRequest(c.getPullID());
            }
        }
        catch (IOException ex) {
            listener.getLogger().println("Can't close pull request");
            ex.printStackTrace(listener.getLogger());
        }
    }

    @VisibleForTesting
    void commentOnBuildResult(Run<?, ?> build, TaskListener listener, GHCommitState state, GhprbCause c) {
        StringBuilder msg = new StringBuilder();
        for (GhprbExtension ext : Ghprb.getJobExtensions(this.trigger, GhprbCommentAppender.class)) {
            if (!(ext instanceof GhprbCommentAppender)) continue;
            String cmt = ((GhprbCommentAppender)((Object)ext)).postBuildComment(build, listener);
            if ("--none--".equals(cmt)) {
                return;
            }
            msg.append(cmt);
        }
        if (msg.length() > 0) {
            listener.getLogger().println(msg);
            this.repo.addComment(c.getPullID(), msg.toString(), build, listener);
        }
    }

    public void onEnvironmentSetup(Run build, Launcher launcher, TaskListener listener) {
        GhprbCause c = Ghprb.getCause(build);
        if (c == null) {
            return;
        }
        LOGGER.log(Level.FINE, "Job: " + build.getFullDisplayName() + " Attempting to send GitHub commit status");
        for (GhprbExtension ext : Ghprb.getJobExtensions(this.trigger, GhprbCommitStatus.class)) {
            if (!(ext instanceof GhprbCommitStatus)) continue;
            try {
                ((GhprbCommitStatus)((Object)ext)).onEnvironmentSetup(build, listener, this.repo.getGitHubRepo());
            }
            catch (GhprbCommitStatusException e) {
                this.repo.commentOnFailure(build, listener, e);
            }
        }
    }
}

