/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.gwt.resolvers;

import com.google.common.base.Charsets;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import java.io.ByteArrayInputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.jenkinsci.plugins.gwt.ExpressionType;
import org.jenkinsci.plugins.gwt.GenericVariable;
import org.jenkinsci.plugins.gwt.resolvers.JsonFlattener;
import org.jenkinsci.plugins.gwt.resolvers.VariablesResolver;
import org.jenkinsci.plugins.gwt.resolvers.XmlFlattener;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class PostContentParameterResolver {
    private static final Logger LOGGER = Logger.getLogger(VariablesResolver.class.getName());
    private final XmlFlattener xmlFlattener = new XmlFlattener();
    private final JsonFlattener jsonFlattener = new JsonFlattener();

    public Map<String, String> getPostContentParameters(List<GenericVariable> configuredGenericVariables, String incomingPostContent) {
        HashMap resolvedVariables = Maps.newHashMap();
        if (configuredGenericVariables != null) {
            for (GenericVariable gv : configuredGenericVariables) {
                boolean notResolved;
                Map<String, String> resolvedMap = this.resolve(incomingPostContent, gv);
                boolean bl = notResolved = resolvedMap.isEmpty() || resolvedMap.containsKey(gv.getVariableName()) && resolvedMap.get(gv.getVariableName()).isEmpty();
                if (notResolved && gv.getDefaultValue() != null) {
                    resolvedMap.put(gv.getVariableName(), gv.getDefaultValue());
                }
                resolvedVariables.putAll(resolvedMap);
            }
        }
        return resolvedVariables;
    }

    private Map<String, String> resolve(String incomingPostContent, GenericVariable gv) {
        try {
            if (!Strings.isNullOrEmpty((String)incomingPostContent) && gv != null && gv.getExpression() != null && !gv.getExpression().isEmpty()) {
                if (gv.getExpressionType() == ExpressionType.JSONPath) {
                    return this.resolveJsonPath(incomingPostContent, gv);
                }
                if (gv.getExpressionType() == ExpressionType.XPath) {
                    return this.resolveXPath(incomingPostContent, gv);
                }
                throw new IllegalStateException("Not recognizing " + (Object)((Object)gv.getExpressionType()));
            }
        }
        catch (Throwable e) {
            LOGGER.log(Level.INFO, "Unable to resolve " + gv.getVariableName() + " with " + (Object)((Object)gv.getExpressionType()) + " " + gv.getExpression() + " in\n" + incomingPostContent, e);
        }
        return new HashMap<String, String>();
    }

    private Map<String, String> resolveJsonPath(String incomingPostContent, GenericVariable gv) {
        try {
            Object resolved = JsonPath.read((String)incomingPostContent, (String)gv.getExpression(), (Predicate[])new Predicate[0]);
            Map<String, String> flatterned = this.jsonFlattener.flattenJson(gv.getVariableName(), gv.getRegexpFilter(), resolved);
            if (gv.getExpression().trim().equals("$")) {
                flatterned.put(gv.getVariableName(), incomingPostContent);
            }
            return flatterned;
        }
        catch (PathNotFoundException e) {
            return new HashMap<String, String>();
        }
    }

    private Map<String, String> resolveXPath(String incomingPostContent, GenericVariable gv) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        InputSource inputSource = new InputSource(new ByteArrayInputStream(incomingPostContent.getBytes(Charsets.UTF_8)));
        Document doc = builder.parse(inputSource);
        XPathFactory xPathfactory = XPathFactory.newInstance();
        XPath xpath = xPathfactory.newXPath();
        XPathExpression expr = xpath.compile(gv.getExpression());
        Object resolved = expr.evaluate(doc, XPathConstants.NODESET);
        return this.xmlFlattener.flatternXmlNode(gv, (NodeList)resolved);
    }
}

