/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.gwt.whitelist;

import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.jenkinsci.plugins.gwt.whitelist.WhitelistException;

public class HMACVerifier {
    public static void hmacVerify(Map<String, List<String>> headers, String postContent, String hmacHeader, String hmacSecret, String algorithm) throws WhitelistException {
        String headerValue = HMACVerifier.getHeaderValue(hmacHeader, headers);
        String calculateHmac = HMACVerifier.getCalculatedHmac(postContent, hmacSecret, algorithm);
        String calculateHmacBase64 = new String(Base64.getEncoder().encode(calculateHmac.getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
        if (!headerValue.equalsIgnoreCase(calculateHmac) && !headerValue.equalsIgnoreCase(calculateHmacBase64)) {
            throw new WhitelistException("HMAC verification failed with \"" + hmacHeader + "\" as \"" + headerValue + "\" and algorithm " + algorithm);
        }
    }

    private static String getCalculatedHmac(String postContent, String hmacSecret, String algorithm) {
        try {
            byte[] byteKey = hmacSecret.getBytes("UTF-8");
            Mac sha512_HMAC = Mac.getInstance(algorithm);
            SecretKeySpec keySpec = new SecretKeySpec(byteKey, algorithm);
            sha512_HMAC.init(keySpec);
            byte[] mac_data = sha512_HMAC.doFinal(postContent.getBytes(StandardCharsets.UTF_8));
            return HMACVerifier.bytesToHex(mac_data);
        }
        catch (UnsupportedEncodingException | InvalidKeyException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    private static String bytesToHex(byte[] bytes) {
        char[] hexArray = "0123456789ABCDEF".toCharArray();
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = hexArray[v >>> 4];
            hexChars[j * 2 + 1] = hexArray[v & 0xF];
        }
        return new String(hexChars);
    }

    private static String getHeaderValue(String hmacHeader, Map<String, List<String>> headers) throws WhitelistException {
        for (Map.Entry<String, List<String>> ck : headers.entrySet()) {
            boolean oneValue;
            boolean sameHeader = ck.getKey().equalsIgnoreCase(hmacHeader);
            boolean bl = oneValue = ck.getValue().size() == 1;
            if (!sameHeader || !oneValue) continue;
            String value = ck.getValue().get(0);
            if (value.contains("=") && !value.endsWith("=")) {
                return value.split("=")[1];
            }
            return value;
        }
        throw new WhitelistException("Was unable to find header with name \"" + hmacHeader + "\" among " + headers);
    }
}

