/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.gwt.resolvers;

import com.google.common.base.Optional;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jenkinsci.plugins.gwt.GenericRequestVariable;
import org.jenkinsci.plugins.gwt.resolvers.FlattenerUtils;

public class RequestParameterResolver {
    public Map<String, String> getRequestParameters(List<GenericRequestVariable> configuredGenericRequestVariables, Map<String, String[]> incomingParameterMap) {
        HashMap resolvedVariables = Maps.newHashMap();
        if (incomingParameterMap != null) {
            for (Map.Entry<String, String[]> paramenterMapEntry : incomingParameterMap.entrySet()) {
                String requestParamName = paramenterMapEntry.getKey();
                Optional<GenericRequestVariable> configuredVariable = this.findConfiguredVariable(configuredGenericRequestVariables, requestParamName);
                if (!configuredVariable.isPresent()) continue;
                String[] values = paramenterMapEntry.getValue();
                for (int i = 0; i < values.length; ++i) {
                    boolean firstAndOnlyValue;
                    String filteredValue = FlattenerUtils.filter(values[i], ((GenericRequestVariable)((Object)configuredVariable.get())).getRegexpFilter());
                    resolvedVariables.put(FlattenerUtils.toVariableName(requestParamName) + "_" + i, filteredValue);
                    boolean bl = firstAndOnlyValue = i == 0 && values.length == 1;
                    if (!firstAndOnlyValue) continue;
                    resolvedVariables.put(FlattenerUtils.toVariableName(requestParamName), filteredValue);
                }
            }
        }
        return resolvedVariables;
    }

    private Optional<GenericRequestVariable> findConfiguredVariable(List<GenericRequestVariable> genericRequestVariables, String requestParamName) {
        if (genericRequestVariables != null) {
            for (GenericRequestVariable v : genericRequestVariables) {
                if (!v.getParameterName().equals(requestParamName)) continue;
                return Optional.of((Object)((Object)v));
            }
        }
        return Optional.absent();
    }
}

