/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.gearman;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import hudson.model.Action;
import hudson.model.Cause;
import hudson.model.Computer;
import hudson.model.ParameterValue;
import hudson.model.Queue;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TextParameterValue;
import hudson.model.queue.QueueTaskFuture;
import hudson.plugins.gearman.AvailabilityMonitor;
import hudson.plugins.gearman.GearmanPluginUtil;
import hudson.plugins.gearman.GearmanProject;
import hudson.plugins.gearman.GearmanProxy;
import hudson.plugins.gearman.MyGearmanWorkerImpl;
import hudson.plugins.gearman.NodeAssignmentAction;
import hudson.plugins.gearman.NodeParametersAction;
import hudson.slaves.OfflineCause;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import jenkins.model.Jenkins;
import org.gearman.client.GearmanIOEventListener;
import org.gearman.client.GearmanJobResult;
import org.gearman.client.GearmanJobResultImpl;
import org.gearman.common.GearmanJobServerSession;
import org.gearman.worker.AbstractGearmanFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StartJobWorker
extends AbstractGearmanFunction {
    private static final Logger logger = LoggerFactory.getLogger((String)"hudson.plugins.gearman.logger");
    Computer computer;
    GearmanProject project;
    String masterName;
    MyGearmanWorkerImpl worker;

    public StartJobWorker(GearmanProject project, Computer computer, String masterName, MyGearmanWorkerImpl worker) {
        this.project = project;
        this.computer = computer;
        this.masterName = masterName;
        this.worker = worker;
    }

    private String buildStatusData(Run<?, ?> build) {
        Map projectBuildData;
        Result result;
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("name", this.project.getJob().getName());
        data.put("number", build.getNumber());
        data.put("manager", this.masterName);
        data.put("worker", this.worker.getWorkerID());
        String rootUrl = Jenkins.getInstance().getRootUrl();
        if (rootUrl != null) {
            data.put("url", rootUrl + build.getUrl());
        }
        if ((result = build.getResult()) != null) {
            data.put("result", result.toString());
        }
        if ((projectBuildData = this.project.getBuildData(build)) != null) {
            data.putAll(projectBuildData);
        }
        Gson gson = new Gson();
        return gson.toJson(data);
    }

    public GearmanJobResult executeFunction() {
        try {
            return this.safeExecuteFunction();
        }
        catch (Exception inner) {
            RuntimeException outer = new RuntimeException(inner);
            throw outer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GearmanJobResult safeExecuteFunction() throws Exception {
        String jobData;
        String decodedUniqueId = null;
        if (this.uniqueId != null) {
            decodedUniqueId = new String(this.uniqueId, "UTF-8");
        }
        ArrayList<ParameterValue> buildParams = new ArrayList<ParameterValue>();
        String decodedData = null;
        boolean offlineWhenComplete = false;
        if (this.data != null) {
            decodedData = new String((byte[])this.data, "UTF-8");
            Gson gson = new Gson();
            Map inParams = (Map)gson.fromJson(decodedData, new TypeToken<Map<String, String>>(){}.getType());
            for (Map.Entry entry : inParams.entrySet()) {
                buildParams.add((ParameterValue)new TextParameterValue((String)entry.getKey(), (String)entry.getValue()));
            }
            String offline = (String)inParams.get("OFFLINE_NODE_WHEN_COMPLETE");
            if (offline != null && (offline.equals("1") || offline.equals("true") || offline.equals("True") || offline.equals("TRUE"))) {
                offlineWhenComplete = true;
            }
        }
        String runNodeName = GearmanPluginUtil.getRealName(this.computer);
        NodeAssignmentAction runNode = new NodeAssignmentAction(runNodeName);
        NodeParametersAction params = new NodeParametersAction(buildParams, decodedUniqueId);
        Action[] actions = new Action[]{runNode, params};
        AvailabilityMonitor availability = GearmanProxy.getInstance().getAvailabilityMonitor(this.computer);
        availability.expectUUID(decodedUniqueId);
        logger.info("---- Worker " + this.worker + " scheduling " + this.project.getJob().getName() + " build #" + this.project.getJob().getNextBuildNumber() + " on " + runNodeName + " with UUID " + decodedUniqueId + " and build params " + buildParams);
        QueueTaskFuture future = this.project.scheduleBuild2(0, (Cause)new Cause.UserIdCause(), actions);
        try {
            GearmanJobServerSession sess = null;
            for (GearmanIOEventListener listener : this.listeners) {
                if (!(listener instanceof GearmanJobServerSession)) continue;
                sess = (GearmanJobServerSession)listener;
            }
            Queue.Executable exec = (Queue.Executable)future.getStartCondition().get();
            Run currBuild = (Run)exec;
            if (!offlineWhenComplete) {
                availability.unlock(this.worker);
            }
            long now = new Date().getTime();
            int duration = (int)(now - currBuild.getStartTimeInMillis());
            int estimatedDuration = (int)currBuild.getEstimatedDuration();
            jobData = this.buildStatusData(currBuild);
            this.sendData(jobData.getBytes("UTF-8"));
            sess.driveSessionIO();
            this.sendStatus(estimatedDuration, duration);
            sess.driveSessionIO();
            future.get();
            jobData = this.buildStatusData(currBuild);
        }
        finally {
            if (offlineWhenComplete) {
                if (this.computer == null) {
                    logger.error("---- Worker " + this.worker + " has no computer while trying to take node offline.");
                } else {
                    logger.info("---- Worker " + this.worker + " setting node offline.");
                    this.computer.setTemporarilyOffline(true, (OfflineCause)new OfflineCause.ByCLI("Offline due to Gearman request"));
                }
            }
        }
        GearmanJobResultImpl gjr = new GearmanJobResultImpl(this.jobHandle, true, jobData.getBytes("UTF-8"), "".getBytes("UTF-8"), "".getBytes("UTF-8"), 0L, 0L);
        return gjr;
    }
}

