/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.gearman;

import hudson.model.Computer;
import hudson.model.Queue;
import hudson.plugins.gearman.AvailabilityMonitor;
import hudson.plugins.gearman.MyGearmanWorkerImpl;
import hudson.plugins.gearman.NodeParametersAction;
import jenkins.model.Jenkins;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeAvailabilityMonitor
implements AvailabilityMonitor {
    private final Queue queue;
    private final Jenkins jenkins;
    private final Computer computer;
    private MyGearmanWorkerImpl workerHoldingLock = null;
    private String expectedUUID = null;
    private static final Logger logger = LoggerFactory.getLogger((String)"hudson.plugins.gearman.logger");

    NodeAvailabilityMonitor(Computer computer) {
        this.computer = computer;
        this.queue = Queue.getInstance();
        this.jenkins = Jenkins.getInstance();
    }

    public Computer getComputer() {
        return this.computer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void lock(MyGearmanWorkerImpl worker) throws InterruptedException {
        logger.debug("AvailabilityMonitor lock request: " + worker);
        while (true) {
            boolean busy = false;
            Queue queue = this.queue;
            synchronized (queue) {
                if (this.workerHoldingLock == null) {
                    if (this.computer.countIdle() == 0) {
                        busy = true;
                    } else {
                        if (!this.jenkins.isQuietingDown()) {
                            logger.debug("AvailabilityMonitor got lock: " + worker);
                            this.workerHoldingLock = worker;
                            return;
                        }
                        busy = true;
                    }
                } else {
                    busy = true;
                }
                if (!busy) continue;
            }
            NodeAvailabilityMonitor nodeAvailabilityMonitor = this;
            synchronized (nodeAvailabilityMonitor) {
                this.wait(5000L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unlock(MyGearmanWorkerImpl worker) {
        logger.debug("AvailabilityMonitor unlock request: " + worker);
        Queue queue = this.queue;
        synchronized (queue) {
            if (this.workerHoldingLock == worker) {
                this.workerHoldingLock = null;
                this.expectedUUID = null;
                logger.debug("AvailabilityMonitor unlocked: " + worker);
            } else {
                logger.debug("Worker does not own AvailabilityMonitor lock: " + worker);
            }
        }
        this.wake();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void wake() {
        logger.debug("AvailabilityMonitor wake request");
        NodeAvailabilityMonitor nodeAvailabilityMonitor = this;
        synchronized (nodeAvailabilityMonitor) {
            logger.debug("AvailabilityMonitor woken");
            this.notifyAll();
        }
    }

    @Override
    public void expectUUID(String UUID2) {
        if (this.expectedUUID != null) {
            logger.error("AvailabilityMonitor told to expect UUID " + UUID2 + "while already expecting " + this.expectedUUID);
        }
        this.expectedUUID = UUID2;
    }

    @Override
    public boolean canTake(Queue.BuildableItem item) {
        logger.debug("AvailabilityMonitor canTake request for " + this.workerHoldingLock);
        NodeParametersAction param = (NodeParametersAction)item.getAction(NodeParametersAction.class);
        if (param != null) {
            logger.debug("AvailabilityMonitor canTake request for UUID " + param.getUuid() + " expecting " + this.expectedUUID);
            if (this.expectedUUID != null && this.expectedUUID.equalsIgnoreCase(param.getUuid())) {
                return true;
            }
        }
        return this.workerHoldingLock == null;
    }
}

