/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.gearman;

import hudson.plugins.gearman.AvailabilityMonitor;
import java.io.IOException;
import java.nio.channels.Selector;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import org.gearman.client.GearmanIOEventListener;
import org.gearman.common.GearmanException;
import org.gearman.common.GearmanJobServerConnection;
import org.gearman.common.GearmanJobServerIpConnectionFactory;
import org.gearman.common.GearmanJobServerSession;
import org.gearman.common.GearmanNIOJobServerConnectionFactory;
import org.gearman.common.GearmanPacket;
import org.gearman.common.GearmanPacketImpl;
import org.gearman.common.GearmanPacketMagic;
import org.gearman.common.GearmanPacketType;
import org.gearman.common.GearmanServerResponseHandler;
import org.gearman.common.GearmanSessionEvent;
import org.gearman.common.GearmanSessionEventHandler;
import org.gearman.common.GearmanTask;
import org.gearman.util.ByteUtils;
import org.gearman.worker.GearmanFunction;
import org.gearman.worker.GearmanFunctionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MyGearmanWorkerImpl
implements GearmanSessionEventHandler {
    private static final String DESCRIPION_PREFIX = "GearmanWorker";
    private ConcurrentLinkedQueue<GearmanSessionEvent> eventList = null;
    private Selector ioAvailable = null;
    private static final Logger LOG = LoggerFactory.getLogger((String)"org.gearman.worker.logger");
    private String id;
    private Map<String, FunctionDefinition> functionMap;
    private State state;
    private ExecutorService executorService;
    private GearmanJobServerSession session = null;
    private final GearmanJobServerIpConnectionFactory connFactory = new GearmanNIOJobServerConnectionFactory();
    private volatile boolean jobUniqueIdRequired = false;
    private FunctionRegistry functionRegistry;
    private AvailabilityMonitor availability;

    public void reconnect() {
        LOG.info("---- Worker " + this + " starting reconnect for " + this.session.toString());
        this.availability.unlock(this);
        try {
            this.session.initSession(this.ioAvailable, (GearmanSessionEventHandler)this);
            if (this.id != null) {
                this.sendToAll((GearmanPacket)new GearmanPacketImpl(GearmanPacketMagic.REQ, GearmanPacketType.SET_CLIENT_ID, ByteUtils.toUTF8Bytes((String)this.id)));
            }
            this.eventList = new ConcurrentLinkedQueue();
            this.functionRegistry.setUpdated(true);
            this.functionMap.clear();
        }
        catch (IOException e) {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e1) {
                LOG.warn("---- Worker " + this + " interrupted while reconnecting", (Throwable)e);
                return;
            }
        }
        LOG.info("---- Worker " + this + " ending reconnect for " + this.session.toString());
    }

    public MyGearmanWorkerImpl(AvailabilityMonitor availability) {
        this(null, availability);
    }

    public MyGearmanWorkerImpl(ExecutorService executorService, AvailabilityMonitor availability) {
        this.availability = availability;
        this.eventList = new ConcurrentLinkedQueue();
        this.id = "GearmanWorker:" + Thread.currentThread().getId();
        this.functionMap = new HashMap<String, FunctionDefinition>();
        this.state = State.IDLE;
        this.executorService = executorService;
        this.functionRegistry = new FunctionRegistry();
        try {
            this.ioAvailable = Selector.open();
        }
        catch (IOException ioe) {
            LOG.warn("---- Worker " + this + " failed to open IO selector", (Throwable)ioe);
        }
    }

    public String toString() {
        return this.id;
    }

    public void setFunctions(Set<GearmanFunctionFactory> functions) {
        LOG.info("---- Worker " + this + " registering " + functions.size() + " functions");
        this.functionRegistry.setFunctions(functions);
        this.ioAvailable.wakeup();
    }

    public Set getRegisteredFunctions() {
        HashSet<String> ret = new HashSet<String>();
        Set<GearmanFunctionFactory> functions = this.functionRegistry.getFunctions();
        if (functions == null) {
            return ret;
        }
        for (GearmanFunctionFactory factory : functions) {
            ret.add(factory.getFunctionName());
        }
        return ret;
    }

    private void registerFunctions() throws IOException {
        Set<GearmanFunctionFactory> functions = this.functionRegistry.getFunctions();
        if (functions == null) {
            return;
        }
        HashMap<String, FunctionDefinition> newFunctionMap = new HashMap<String, FunctionDefinition>();
        if (functions.isEmpty() || this.functionMap.isEmpty()) {
            this.sendToAll((GearmanPacket)new GearmanPacketImpl(GearmanPacketMagic.REQ, GearmanPacketType.RESET_ABILITIES, new byte[0]));
            this.session.driveSessionIO();
            LOG.debug("---- Worker " + this + " reset functions");
            if (!this.isRunning()) {
                this.functionMap.clear();
                return;
            }
        }
        if (!functions.isEmpty()) {
            for (GearmanFunctionFactory factory : functions) {
                FunctionDefinition def = new FunctionDefinition(0L, factory);
                newFunctionMap.put(factory.getFunctionName(), def);
                if (!this.functionMap.containsKey(factory.getFunctionName())) {
                    this.sendToAll(this.generateCanDoPacket(def));
                    this.session.driveSessionIO();
                    if (!this.isRunning()) {
                        this.functionMap.clear();
                        return;
                    }
                    LOG.debug("---- Worker " + this + " registered function " + factory.getFunctionName());
                }
                this.functionMap.remove(factory.getFunctionName());
            }
            for (FunctionDefinition def : this.functionMap.values()) {
                this.sendToAll(this.generateCantDoPacket(def));
                this.session.driveSessionIO();
                if (!this.isRunning()) {
                    this.functionMap.clear();
                    return;
                }
                LOG.debug("---- Worker " + this + " unregistered function " + def.getFactory().getFunctionName());
            }
        }
        this.functionMap = newFunctionMap;
        GearmanSessionEvent nextEvent = this.eventList.peek();
        if (nextEvent == null || nextEvent.getPacket().getPacketType() != GearmanPacketType.NOOP) {
            GearmanPacketImpl p = new GearmanPacketImpl(GearmanPacketMagic.RES, GearmanPacketType.NOOP, new byte[0]);
            GearmanSessionEvent event = new GearmanSessionEvent((GearmanPacket)p, this.session);
            this.session.handleSessionEvent(event);
        }
    }

    public void enqueueNoopEvent() {
        GearmanPacketImpl p = new GearmanPacketImpl(GearmanPacketMagic.RES, GearmanPacketType.NOOP, new byte[0]);
        GearmanSessionEvent event = new GearmanSessionEvent((GearmanPacket)p, this.session);
        this.enqueueEvent(event);
    }

    public void work() {
        GearmanSessionEvent event = null;
        GearmanFunction function = null;
        LOG.info("---- Worker " + this + " starting work");
        if (!this.state.equals((Object)State.IDLE)) {
            throw new IllegalStateException("Can not call work while worker is running or shutting down");
        }
        this.state = State.RUNNING;
        this.enqueueNoopEvent();
        while (this.isRunning()) {
            LOG.debug("---- Worker " + this + " top of run loop");
            if (!this.session.isInitialized()) {
                LOG.debug("---- Worker " + this + " run loop reconnect");
                this.reconnect();
                this.enqueueNoopEvent();
                continue;
            }
            try {
                LOG.debug("---- Worker " + this + " run loop register functions");
                this.registerFunctions();
            }
            catch (IOException io) {
                LOG.warn("---- Worker " + this + " receieved IOException while registering functions", (Throwable)io);
                this.session.closeSession();
                continue;
            }
            if (!this.isRunning() || !this.session.isInitialized()) continue;
            event = this.eventList.poll();
            function = this.processSessionEvent(event);
            if (!this.isRunning() || !this.session.isInitialized()) continue;
            if (function != null) {
                LOG.info("---- Worker " + this + " executing function");
                this.submitFunction(function);
                this.enqueueNoopEvent();
                continue;
            }
            if (!this.isRunning() || !this.session.isInitialized()) continue;
            int interestOps = 1;
            if (this.session.sessionHasDataToWrite()) {
                interestOps |= 4;
            }
            this.session.getSelectionKey().interestOps(interestOps);
            try {
                this.ioAvailable.select();
            }
            catch (IOException io) {
                LOG.warn("---- Worker " + this + " receieved IOException while selecting for IO", (Throwable)io);
                this.session.closeSession();
                continue;
            }
            if (this.ioAvailable.selectedKeys().contains(this.session.getSelectionKey())) {
                LOG.debug("---- Worker " + this + " received input in run loop");
                if (!this.session.isInitialized()) {
                    LOG.debug("---- Worker " + this + " session is no longer initialized");
                    continue;
                }
                try {
                    this.session.driveSessionIO();
                }
                catch (IOException io) {
                    LOG.warn("---- Worker " + this + " received IOException while driving IO on session " + this.session, (Throwable)io);
                    this.session.closeSession();
                    continue;
                }
            }
            LOG.debug("---- Worker " + this + " run loop finished driving session io");
        }
        this.shutDownWorker(true);
    }

    private void sendGrabJob(GearmanJobServerSession s) throws InterruptedException {
        this.availability.lock(this);
        GearmanTask grabJobTask = new GearmanTask((GearmanServerResponseHandler)new GrabJobEventHandler(s), (GearmanPacket)new GearmanPacketImpl(GearmanPacketMagic.REQ, this.getGrabJobPacketType(), new byte[0]));
        s.submitTask(grabJobTask);
    }

    public void handleSessionEvent(GearmanSessionEvent event) throws IllegalArgumentException, IllegalStateException {
        this.enqueueEvent(event);
    }

    public void enqueueEvent(GearmanSessionEvent event) {
        this.eventList.add(event);
    }

    private GearmanFunction processSessionEvent(GearmanSessionEvent event) throws IllegalArgumentException, IllegalStateException {
        if (event != null) {
            GearmanPacket p = event.getPacket();
            GearmanJobServerSession s = event.getSession();
            GearmanPacketType t = p.getPacketType();
            LOG.debug("---- Worker " + this + " handling session event ( Session = " + s + " Event = " + t + " )");
            switch (t) {
                case JOB_ASSIGN: {
                    LOG.info("---- Worker " + this + " received job assignment");
                    return this.addNewJob(event);
                }
                case JOB_ASSIGN_UNIQ: {
                    LOG.info("---- Worker " + this + " received unique job assignment");
                    return this.addNewJob(event);
                }
                case NOOP: {
                    LOG.debug("---- Worker " + this + " sending grab job after wakeup");
                    try {
                        this.sendGrabJob(s);
                    }
                    catch (InterruptedException e) {
                        LOG.warn("---- Worker " + this + " interrupted while waiting for okay to send grab job", (Throwable)e);
                    }
                    break;
                }
                case NO_JOB: {
                    this.availability.unlock(this);
                    LOG.debug("---- Worker " + this + " sending pre sleep after no_job");
                    GearmanTask preSleepTask = new GearmanTask((GearmanServerResponseHandler)new GrabJobEventHandler(s), (GearmanPacket)new GearmanPacketImpl(GearmanPacketMagic.REQ, GearmanPacketType.PRE_SLEEP, new byte[0]));
                    s.submitTask(preSleepTask);
                    break;
                }
                case ECHO_RES: {
                    break;
                }
                case OPTION_RES: {
                    break;
                }
                case ERROR: {
                    s.closeSession();
                    break;
                }
                default: {
                    LOG.warn("---- Worker " + this + " received unknown packet type " + t + " from session " + s + "; closing connection");
                    s.closeSession();
                }
            }
        }
        return null;
    }

    public boolean addServer(String host, int port) {
        return this.addServer(this.connFactory.createConnection(host, port));
    }

    public boolean addServer(GearmanJobServerConnection conn) throws IllegalArgumentException, IllegalStateException {
        if (conn == null) {
            throw new IllegalArgumentException("Connection can not be null");
        }
        if (this.session != null) {
            return true;
        }
        this.session = new GearmanJobServerSession(conn);
        this.reconnect();
        LOG.debug("---- Worker " + this + " added server " + conn);
        return true;
    }

    public void setWorkerID(String id) throws IllegalArgumentException {
        if (id == null) {
            throw new IllegalArgumentException("Worker ID may not be null");
        }
        this.id = id;
        if (this.session.isInitialized()) {
            this.sendToAll((GearmanPacket)new GearmanPacketImpl(GearmanPacketMagic.REQ, GearmanPacketType.SET_CLIENT_ID, ByteUtils.toUTF8Bytes((String)id)));
        }
    }

    public String getWorkerID() {
        return this.id;
    }

    public void stop() {
        this.state = State.SHUTTINGDOWN;
    }

    public List<Exception> shutdown() {
        return this.shutDownWorker(false);
    }

    public boolean isRunning() {
        return this.state.equals((Object)State.RUNNING);
    }

    public void setJobUniqueIdRequired(boolean requiresJobUUID) {
        this.jobUniqueIdRequired = requiresJobUUID;
    }

    public boolean isJobUniqueIdRequired() {
        return this.jobUniqueIdRequired;
    }

    private GearmanPacket generateCanDoPacket(FunctionDefinition def) {
        GearmanPacketType pt = GearmanPacketType.CAN_DO;
        byte[] data = ByteUtils.toUTF8Bytes((String)def.getFactory().getFunctionName());
        return new GearmanPacketImpl(GearmanPacketMagic.REQ, pt, data);
    }

    private GearmanPacket generateCantDoPacket(FunctionDefinition def) {
        GearmanPacketType pt = GearmanPacketType.CANT_DO;
        byte[] data = ByteUtils.toUTF8Bytes((String)def.getFactory().getFunctionName());
        return new GearmanPacketImpl(GearmanPacketMagic.REQ, pt, data);
    }

    private void sendToAll(GearmanPacket p) {
        this.sendToAll(null, p);
    }

    private void sendToAll(GearmanServerResponseHandler handler, GearmanPacket p) {
        GearmanTask gsr = new GearmanTask(handler, p);
        this.session.submitTask(gsr);
    }

    private List<Exception> shutDownWorker(boolean completeTasks) {
        LOG.info("---- Worker " + this + " commencing shutdown");
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        if (this.executorService != null) {
            if (completeTasks) {
                this.executorService.shutdown();
            } else {
                this.executorService.shutdownNow();
            }
        }
        this.session.closeSession();
        try {
            this.ioAvailable.close();
        }
        catch (IOException ioe) {
            LOG.warn("---- Worker " + this + " encountered IOException while closing selector: ", (Throwable)ioe);
        }
        this.state = State.IDLE;
        LOG.info("---- Worker " + this + " completed shutdown");
        return exceptions;
    }

    private GearmanFunction addNewJob(GearmanSessionEvent event) {
        GearmanPacket p = event.getPacket();
        byte[] handle = p.getDataComponentValue(GearmanPacket.DataComponentName.JOB_HANDLE);
        byte[] functionNameBytes = p.getDataComponentValue(GearmanPacket.DataComponentName.FUNCTION_NAME);
        byte[] data = p.getDataComponentValue(GearmanPacket.DataComponentName.DATA);
        byte[] unique = p.getDataComponentValue(GearmanPacket.DataComponentName.UNIQUE_ID);
        String functionName = ByteUtils.fromUTF8Bytes((byte[])functionNameBytes);
        FunctionDefinition def = this.functionMap.get(functionName);
        if (def != null) {
            GearmanFunction function = def.getFactory().getFunction();
            function.setData((Object)data);
            function.setJobHandle(handle);
            function.registerEventListener((GearmanIOEventListener)this.session);
            if (unique != null && unique.length > 0) {
                function.setUniqueId(unique);
            }
            return function;
        }
        GearmanTask gsr = new GearmanTask((GearmanPacket)new GearmanPacketImpl(GearmanPacketMagic.REQ, GearmanPacketType.WORK_FAIL, handle));
        this.session.submitTask(gsr);
        this.availability.unlock(this);
        this.enqueueNoopEvent();
        return null;
    }

    private void submitFunction(GearmanFunction fun) {
        try {
            if (this.executorService == null) {
                fun.call();
            } else {
                this.executorService.submit(fun);
            }
            this.session.driveSessionIO();
        }
        catch (IOException io) {
            LOG.warn("---- Worker " + this + " receieved IOException while running function", (Throwable)io);
            this.session.closeSession();
        }
        catch (Exception e) {
            LOG.warn("---- Worker " + this + " exception while executing function " + fun.getName(), (Throwable)e);
        }
        this.availability.unlock(this);
    }

    private GearmanPacketType getGrabJobPacketType() {
        if (this.jobUniqueIdRequired) {
            return GearmanPacketType.GRAB_JOB_UNIQ;
        }
        return GearmanPacketType.GRAB_JOB;
    }

    static class FunctionRegistry {
        private Set<GearmanFunctionFactory> functions = new HashSet<GearmanFunctionFactory>();
        private boolean updated = false;

        FunctionRegistry() {
        }

        public synchronized Set<GearmanFunctionFactory> getFunctions() {
            if (this.updated) {
                this.updated = false;
                return this.functions;
            }
            return null;
        }

        public synchronized void setFunctions(Set<GearmanFunctionFactory> functions) {
            this.functions = functions;
            this.updated = true;
        }

        public synchronized void setUpdated(boolean updated) {
            this.updated = updated;
        }
    }

    static class FunctionDefinition {
        private final long timeout;
        private final GearmanFunctionFactory factory;

        FunctionDefinition(long timeout, GearmanFunctionFactory factory) {
            this.timeout = timeout;
            this.factory = factory;
        }

        long getTimeout() {
            return this.timeout;
        }

        GearmanFunctionFactory getFactory() {
            return this.factory;
        }
    }

    class GrabJobEventHandler
    implements GearmanServerResponseHandler {
        private final GearmanJobServerSession session;
        private boolean isDone = false;

        GrabJobEventHandler(GearmanJobServerSession session) {
            this.session = session;
        }

        public void handleEvent(GearmanPacket event) throws GearmanException {
            MyGearmanWorkerImpl.this.handleSessionEvent(new GearmanSessionEvent(event, this.session));
            this.isDone = true;
        }

        public boolean isDone() {
            return this.isDone;
        }
    }

    public static enum State {
        IDLE,
        RUNNING,
        SHUTTINGDOWN;

    }
}

