/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.gearman;

import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Cause;
import hudson.model.Job;
import hudson.model.Label;
import hudson.model.Run;
import hudson.model.queue.QueueTaskFuture;
import hudson.plugins.gearman.GearmanAbstractProject;
import hudson.plugins.gearman.GearmanWorkflowProject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;

public abstract class GearmanProject<JobT extends Job, RunT extends Run> {
    private JobT project;

    static boolean isSupported(Object object) {
        return object instanceof WorkflowJob || object instanceof AbstractProject;
    }

    static GearmanProject projectFactory(Job<?, ?> job) {
        if (job instanceof WorkflowJob) {
            return new GearmanWorkflowProject((WorkflowJob)job);
        }
        if (job instanceof AbstractProject) {
            return new GearmanAbstractProject((AbstractProject)job);
        }
        throw new IllegalArgumentException(job + "is not supported!");
    }

    static List<GearmanProject> getAllItems() {
        return Jenkins.getInstance().getAllItems(Job.class).stream().filter(job -> GearmanProject.isSupported(job)).map(job -> GearmanProject.projectFactory(job)).collect(Collectors.toList());
    }

    public GearmanProject(JobT project) {
        this.project = project;
    }

    abstract boolean isDisabled();

    abstract Label getAssignedLabel();

    abstract QueueTaskFuture scheduleBuild2(int var1, Cause var2, Action ... var3);

    protected Map getBuildData(RunT run) {
        return null;
    }

    public JobT getJob() {
        return this.project;
    }
}

