/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.gearman;

import hudson.model.Computer;
import hudson.model.Run;
import hudson.plugins.gearman.GearmanProject;
import hudson.security.ACL;
import java.io.IOException;
import java.util.Optional;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.acegisecurity.context.SecurityContext;
import org.acegisecurity.context.SecurityContextHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GearmanPluginUtil {
    private static final Logger logger = LoggerFactory.getLogger((String)"hudson.plugins.gearman.logger");

    public static String getRealName(Computer computer) {
        if (Jenkins.getInstance().getComputer("") == computer) {
            return "master";
        }
        return computer.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Run<?, ?> findBuild(String jobName, int buildNumber) {
        SecurityContext oldContext = ACL.impersonate((Authentication)ACL.SYSTEM);
        try {
            Run run;
            Optional<GearmanProject> aproject = GearmanProject.getAllItems().stream().filter(item -> item.getJob().getName().equalsIgnoreCase(jobName)).findFirst();
            if (aproject.isPresent() && (run = aproject.get().getJob().getBuildByNumber(buildNumber)) != null) {
                Run run2 = run;
                return run2;
            }
            Run<?, ?> run3 = null;
            return run3;
        }
        finally {
            SecurityContextHolder.setContext((SecurityContext)oldContext);
        }
    }

    public static void setBuildDescription(Run build, String description) throws IOException {
        SecurityContext oldContext = ACL.impersonate((Authentication)ACL.SYSTEM);
        try {
            build.setDescription(description);
        }
        finally {
            SecurityContextHolder.setContext((SecurityContext)oldContext);
        }
    }
}

