/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.gearman;

import hudson.model.Computer;
import hudson.model.Label;
import hudson.model.Node;
import hudson.model.labels.LabelAtom;
import hudson.plugins.gearman.AbstractWorkerThread;
import hudson.plugins.gearman.AvailabilityMonitor;
import hudson.plugins.gearman.CustomGearmanFunctionFactory;
import hudson.plugins.gearman.GearmanProject;
import hudson.plugins.gearman.StartJobWorker;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.gearman.worker.GearmanFunctionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutorWorkerThread
extends AbstractWorkerThread {
    private static final Logger logger = LoggerFactory.getLogger((String)"hudson.plugins.gearman.logger");
    private final Computer computer;
    private final String masterName;
    private HashMap<String, GearmanFunctionFactory> functionMap;

    public ExecutorWorkerThread(String host, int port, String name, Computer computer, String masterName, AvailabilityMonitor availability) {
        super(host, port, name, availability);
        this.computer = computer;
        this.masterName = masterName;
    }

    @Override
    protected void initWorker() {
        this.availability.unlock(this.worker);
        super.initWorker();
        this.functionMap = new HashMap();
    }

    @Override
    public void registerJobs() {
        if (this.worker == null || this.functionMap == null) {
            return;
        }
        HashMap<String, CustomGearmanFunctionFactory> newFunctionMap = new HashMap<String, CustomGearmanFunctionFactory>();
        if (!this.computer.isOffline()) {
            Node node = this.computer.getNode();
            for (GearmanProject project : GearmanProject.getAllItems()) {
                if (project.isDisabled()) continue;
                String projectName = project.getJob().getName();
                Label label = project.getAssignedLabel();
                if (label == null) {
                    if (node.getMode() == Node.Mode.EXCLUSIVE) continue;
                    String jobFunctionName = "build:" + projectName;
                    newFunctionMap.put(jobFunctionName, new CustomGearmanFunctionFactory(jobFunctionName, StartJobWorker.class.getName(), project, this.computer, this.masterName, this.worker));
                    continue;
                }
                Set projectLabelNodes = label.getNodes();
                Set projectLabelAtoms = label.listAtoms();
                Set nodeLabelAtoms = node.getAssignedLabels();
                HashSet nodeProjectLabelAtoms = new HashSet(projectLabelAtoms);
                nodeProjectLabelAtoms.retainAll(nodeLabelAtoms);
                if (!projectLabelNodes.contains(node)) continue;
                String jobFunctionName = "build:" + projectName;
                newFunctionMap.put(jobFunctionName, new CustomGearmanFunctionFactory(jobFunctionName, StartJobWorker.class.getName(), project, this.computer, this.masterName, this.worker));
                for (LabelAtom labelAtom : nodeProjectLabelAtoms) {
                    jobFunctionName = "build:" + projectName + ":" + labelAtom.getDisplayName();
                    newFunctionMap.put(jobFunctionName, new CustomGearmanFunctionFactory(jobFunctionName, StartJobWorker.class.getName(), project, this.computer, this.masterName, this.worker));
                }
            }
        }
        if (!newFunctionMap.keySet().equals(this.functionMap.keySet())) {
            this.functionMap = newFunctionMap;
            HashSet<GearmanFunctionFactory> functionSet = new HashSet<GearmanFunctionFactory>(this.functionMap.values());
            this.updateJobs(functionSet);
        }
    }

    public synchronized Computer getComputer() {
        return this.computer;
    }
}

