/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.gearman;

import hudson.model.Computer;
import hudson.plugins.gearman.GearmanProject;
import hudson.plugins.gearman.MyGearmanWorkerImpl;
import java.lang.reflect.Constructor;
import org.gearman.worker.DefaultGearmanFunctionFactory;
import org.gearman.worker.GearmanFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomGearmanFunctionFactory
extends DefaultGearmanFunctionFactory {
    private final GearmanProject project;
    private final Computer computer;
    private final String theClass;
    private final String masterName;
    private final MyGearmanWorkerImpl worker;
    private static final Logger LOG = LoggerFactory.getLogger((String)"org.gearman.worker.logger");

    public CustomGearmanFunctionFactory(String functionName, String className, GearmanProject project, Computer computer, String masterName, MyGearmanWorkerImpl worker) {
        super(functionName, className);
        this.theClass = className;
        this.project = project;
        this.computer = computer;
        this.masterName = masterName;
        this.worker = worker;
    }

    public GearmanFunction getFunction() {
        return CustomGearmanFunctionFactory.createFunctionInstance(this.theClass, this.project, this.computer, this.masterName, this.worker);
    }

    private static GearmanFunction createFunctionInstance(String className, GearmanProject project, Computer computer, String masterName, MyGearmanWorkerImpl worker) {
        GearmanFunction f = null;
        try {
            Class<?> c = Class.forName(className);
            Constructor<?> con = c.getConstructor(GearmanProject.class, Computer.class, String.class, MyGearmanWorkerImpl.class);
            Object o = con.newInstance(project, computer, masterName, worker);
            if (o instanceof GearmanFunction) {
                f = (GearmanFunction)o;
            } else {
                LOG.warn("Specified class " + className + " is not a Gearman Function ");
            }
        }
        catch (Exception e) {
            LOG.warn("Unable to create instance of Function: " + className, (Throwable)e);
        }
        return f;
    }
}

