/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.gearman;

import hudson.Extension;
import hudson.model.Computer;
import hudson.model.TaskListener;
import hudson.plugins.gearman.GearmanPluginConfig;
import hudson.plugins.gearman.GearmanProxy;
import hudson.slaves.ComputerListener;
import hudson.slaves.OfflineCause;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Extension
public class ComputerListenerImpl
extends ComputerListener {
    private static final Logger logger = LoggerFactory.getLogger((String)"hudson.plugins.gearman.logger");

    public void onConfigurationChange() {
        logger.info("---- " + ComputerListenerImpl.class.getName() + ": onConfigurationChange");
        if (!GearmanPluginConfig.get().isEnablePlugin()) {
            return;
        }
        GearmanProxy.getInstance().registerJobs();
    }

    public void onOffline(Computer c) {
        logger.info("---- " + ComputerListenerImpl.class.getName() + ": onOffline computer" + c);
        if (!GearmanPluginConfig.get().isEnablePlugin()) {
            return;
        }
        GearmanProxy.getInstance().stop(c);
    }

    public void onOnline(Computer c, TaskListener listener) throws IOException, InterruptedException {
        logger.info("---- " + ComputerListenerImpl.class.getName() + ": onOnline computer " + c);
        if (!GearmanPluginConfig.get().isEnablePlugin()) {
            return;
        }
        GearmanProxy gp = GearmanProxy.getInstance();
        gp.createManagementWorker();
        gp.createExecutorWorkersOnNode(c);
    }

    public void onTemporarilyOffline(Computer c, OfflineCause cause) {
        logger.info("---- " + ComputerListenerImpl.class.getName() + ": onTemporarilyOffline computer " + c);
        if (!GearmanPluginConfig.get().isEnablePlugin()) {
            return;
        }
        GearmanProxy.getInstance().registerJobs();
    }

    public void onTemporarilyOnline(Computer c) {
        logger.info("---- " + ComputerListenerImpl.class.getName() + ": onTemporarilyOnline computer " + c);
        if (!GearmanPluginConfig.get().isEnablePlugin()) {
            return;
        }
        GearmanProxy.getInstance().registerJobs();
    }
}

