/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.gearman;

import hudson.plugins.gearman.AvailabilityMonitor;
import hudson.plugins.gearman.GearmanNIOJobServerConnectionImpl;
import hudson.plugins.gearman.MyGearmanWorkerImpl;
import java.util.Date;
import java.util.Set;
import org.gearman.common.GearmanJobServerConnection;
import org.gearman.common.GearmanNIOJobServerConnection;
import org.gearman.worker.GearmanFunctionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractWorkerThread
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger((String)"hudson.plugins.gearman.logger");
    protected String host;
    protected int port;
    protected String name;
    protected MyGearmanWorkerImpl worker;
    protected GearmanNIOJobServerConnection conn;
    protected AvailabilityMonitor availability;
    private Thread thread;
    private boolean running = false;

    public AbstractWorkerThread(String host, int port, String name, AvailabilityMonitor availability) {
        this.setHost(host);
        this.setPort(port);
        this.setName(name);
        this.setAvailability(availability);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initWorker() {
        AbstractWorkerThread abstractWorkerThread = this;
        synchronized (abstractWorkerThread) {
            if (this.running) {
                this.worker = new MyGearmanWorkerImpl(this.getAvailability());
                this.conn = new GearmanNIOJobServerConnectionImpl(this.host, this.port);
            }
        }
    }

    protected void testInitWorker() {
        this.running = true;
        this.initWorker();
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public AvailabilityMonitor getAvailability() {
        return this.availability;
    }

    public void setAvailability(AvailabilityMonitor availability) {
        this.availability = availability;
    }

    public void registerJobs() {
        logger.info("---- AbstractorWorker registerJobs function ----");
    }

    public void updateJobs(Set<GearmanFunctionFactory> functions) {
        this.worker.setFunctions(functions);
    }

    public void start() {
        this.running = true;
        this.thread = new Thread((Runnable)this, "Gearman worker " + this.name);
        this.thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        logger.info("---- " + this.getName() + " Request to stop AWT: " + this);
        logger.info("---- " + this.getName() + "   Thread: " + this.thread + " name: " + this.thread.getName());
        logger.info("---- " + this.getName() + "   Worker: " + this.worker);
        AbstractWorkerThread abstractWorkerThread = this;
        synchronized (abstractWorkerThread) {
            this.running = false;
            if (this.worker != null) {
                this.worker.stop();
            }
        }
        logger.info("---- " + this.getName() + "   Interrupting worker");
        this.thread.interrupt();
        logger.info("---- " + this.getName() + " Stop request done");
    }

    @Override
    public void run() {
        this.initWorker();
        while (this.running) {
            try {
                logger.info("---- Starting Worker " + this.getName() + " (" + new Date().toString() + ")");
                this.worker.addServer((GearmanJobServerConnection)this.conn);
                this.worker.setWorkerID(this.name);
                this.worker.setJobUniqueIdRequired(true);
                this.registerJobs();
                this.worker.work();
            }
            catch (Exception e) {
                logger.error("---- Exception while running worker " + this.getName(), (Throwable)e);
                if (!this.running) continue;
                this.worker.shutdown();
                if (!this.running) continue;
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException e2) {
                    logger.error("---- Exception while waiting to restart worker " + this.getName(), (Throwable)e2);
                }
                if (!this.running) continue;
                this.initWorker();
            }
        }
    }

    public boolean isAlive() {
        return this.thread.isAlive();
    }
}

