/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.gcm.user;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.WriterException;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.QRCodeWriter;
import hudson.Extension;
import hudson.model.AbstractModelObject;
import hudson.model.UnprotectedRootAction;
import hudson.model.User;
import hudson.model.UserProperty;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import jenkins.security.ApiTokenProperty;
import org.acegisecurity.context.SecurityContextHolder;
import org.jenkinsci.plugins.gcm.im.GcmPublisher;
import org.jenkinsci.plugins.gcm.user.GcmUserTokenProperty;
import org.json.simple.JSONObject;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.HttpResponses;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.WebMethod;

@Extension
public class GcmRegistrar
extends AbstractModelObject
implements UnprotectedRootAction {
    public String getUrlName() {
        return "gcm";
    }

    public HttpResponse doRegister(final @QueryParameter(required=true) String token) throws ServletException, IOException {
        return new HttpResponse(){

            public void generateResponse(StaplerRequest req, StaplerResponse rsp, Object node) throws IOException, ServletException {
                User user = GcmRegistrar.getCurrentUser();
                if (user == null) {
                    throw HttpResponses.error((int)403, (String)"User not authenticated.");
                }
                user.addProperty((UserProperty)new GcmUserTokenProperty(token));
                user.save();
                rsp.setStatus(200);
                rsp.getWriter().write("API token updated successfully.");
            }
        };
    }

    @WebMethod(name={"generateQrCode.png"})
    public HttpResponse doGenerateQrCode() {
        User user = GcmRegistrar.getCurrentUser();
        if (user == null) {
            return HttpResponses.redirectToContextRoot();
        }
        String userId = user.getId();
        String userApiToken = ((ApiTokenProperty)user.getProperty(ApiTokenProperty.class)).getApiToken();
        String jenkinsUrl = Jenkins.getInstance().getRootUrl();
        String googleProjectNumber = GcmPublisher.DESCRIPTOR.getProjectNumber();
        JSONObject params = new JSONObject();
        params.put((Object)"senderId", (Object)googleProjectNumber);
        params.put((Object)"url", (Object)jenkinsUrl);
        params.put((Object)"username", (Object)userId);
        params.put((Object)"token", (Object)userApiToken);
        final String content = params.toJSONString();
        return new HttpResponse(){

            public void generateResponse(StaplerRequest req, StaplerResponse rsp, Object node) throws IOException, ServletException {
                QRCodeWriter qr = new QRCodeWriter();
                BitMatrix matrix = null;
                try {
                    matrix = qr.encode(content, BarcodeFormat.QR_CODE, 450, 450);
                    rsp.setStatus(200);
                    rsp.setContentType("image/png");
                    MatrixToImageWriter.writeToStream((BitMatrix)matrix, (String)"png", (OutputStream)rsp.getOutputStream());
                }
                catch (WriterException e) {
                    throw HttpResponses.error((int)500, (Throwable)e);
                }
            }
        };
    }

    private static User getCurrentUser() {
        String userId = SecurityContextHolder.getContext().getAuthentication().getName();
        return User.get((String)userId, (boolean)false);
    }

    public String getDisplayName() {
        return null;
    }

    public String getSearchUrl() {
        return null;
    }

    public String getIconFileName() {
        return null;
    }
}

