/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.fstrigger.triggers.filecontent;

import hudson.Extension;
import hudson.Util;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jenkinsci.lib.xtrigger.XTriggerException;
import org.jenkinsci.lib.xtrigger.XTriggerLog;
import org.jenkinsci.plugins.fstrigger.core.FSTriggerContentFileType;
import org.jenkinsci.plugins.fstrigger.core.FSTriggerContentFileTypeDescriptor;
import org.kohsuke.stapler.DataBoundConstructor;

public class ZIPFileContent
extends FSTriggerContentFileType {
    protected transient List<ZipEntry> zipEntries = new ArrayList<ZipEntry>();
    private transient StringBuilder zipContent;
    private static final long serialVersionUID = 1L;

    @DataBoundConstructor
    public ZIPFileContent() {
    }

    @Override
    public Object getMemoryInfo() {
        return this.zipEntries;
    }

    @Override
    public void setMemoryInfo(Object memoryInfo) {
        if (memoryInfo != null && !(memoryInfo instanceof List)) {
            throw new IllegalArgumentException(String.format("The memory info %s object is not a List object.", memoryInfo));
        }
        if (memoryInfo != null) {
            this.zipEntries = (List)memoryInfo;
        }
    }

    private List<ZipEntry> getListZipEntries(Enumeration<? extends ZipEntry> entriesEnumeration) {
        ArrayList<ZipEntry> zipEntries = new ArrayList<ZipEntry>();
        while (entriesEnumeration.hasMoreElements()) {
            zipEntries.add(entriesEnumeration.nextElement());
        }
        return zipEntries;
    }

    @Override
    protected void initForContent(File file) throws XTriggerException {
        try (ZipFile zipFile = new ZipFile(file);){
            this.zipContent = new StringBuilder();
            this.fillZipContent(zipFile.entries(), this.zipContent);
            this.zipEntries = this.getListZipEntries(zipFile.entries());
        }
        catch (IOException ioe) {
            throw new XTriggerException((Throwable)ioe);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean isTriggeringBuildForContent(File file, XTriggerLog log) throws XTriggerException {
        try (ZipFile zipFile = new ZipFile(file);){
            List<ZipEntry> newZipEntries = this.getListZipEntries(zipFile.entries());
            boolean changed = true;
            Iterator<ZipEntry> zipEntryIterator = this.zipEntries.iterator();
            Iterator<ZipEntry> newZipEntryIterator = newZipEntries.iterator();
            while (zipEntryIterator.hasNext() && newZipEntryIterator.hasNext()) {
                boolean changedMd5;
                boolean bothIsDirectory;
                boolean bl;
                ZipEntry initZipEntry = zipEntryIterator.next();
                ZipEntry newZipEntry = newZipEntryIterator.next();
                if (initZipEntry == null) {
                    bl = true;
                    return bl;
                }
                if (newZipEntry == null) {
                    bl = true;
                    return bl;
                }
                if (!initZipEntry.getName().equals(newZipEntry.getName())) {
                    log.info(String.format("The name of the '%s' entry has changed.", initZipEntry.getName()));
                    log.info(this.displayZipEntries(zipFile.entries()));
                    bl = true;
                    return bl;
                }
                if (initZipEntry.getSize() != newZipEntry.getSize()) {
                    log.info(String.format("The size of the entry '%s' has changed.", initZipEntry.getName()));
                    log.info(this.displayZipEntries(zipFile.entries()));
                    bl = true;
                    return bl;
                }
                if (initZipEntry.getTime() != newZipEntry.getTime()) {
                    log.info(String.format("The time of the '%s' entry has changed.", initZipEntry.getName()));
                    log.info(this.displayZipEntries(zipFile.entries()));
                    bl = true;
                    return bl;
                }
                boolean bl2 = bothIsDirectory = initZipEntry.isDirectory() && newZipEntry.isDirectory();
                if (bothIsDirectory) {
                    log.info(String.format("The type (file or directory) of the '%s' entry has changed.", initZipEntry.getName()));
                    log.info(this.displayZipEntries(zipFile.entries()));
                    boolean bl3 = true;
                    return bl3;
                }
                if (initZipEntry.getCrc() != newZipEntry.getCrc()) {
                    log.info(String.format("The crc of the '%s' entry has changed.", initZipEntry.getName()));
                    log.info(this.displayZipEntries(zipFile.entries()));
                    boolean bl4 = true;
                    return bl4;
                }
                byte[] initBytes = initZipEntry.getExtra();
                byte[] newBytes = newZipEntry.getExtra();
                if (initBytes == null && newBytes == null) {
                    changedMd5 = false;
                } else if (initBytes == null || newBytes == null) {
                    changedMd5 = true;
                } else {
                    String newMd5;
                    String initMd5 = Util.getDigestOf((String)new String(initZipEntry.getExtra(), StandardCharsets.UTF_8));
                    boolean bl5 = changedMd5 = !initMd5.equals(newMd5 = Util.getDigestOf((String)new String(newZipEntry.getExtra(), StandardCharsets.UTF_8)));
                }
                if (changedMd5) {
                    log.info(String.format("The content the '%s' entry has changed.", initZipEntry.getName()));
                    log.info(this.displayZipEntries(zipFile.entries()));
                    boolean bl6 = true;
                    return bl6;
                }
                changed = false;
            }
            boolean bl = changed;
            return bl;
        }
        catch (IOException ioe) {
            throw new XTriggerException((Throwable)ioe);
        }
    }

    private String displayZipEntries(Enumeration<? extends ZipEntry> newZipEntries) {
        StringBuilder sb = new StringBuilder();
        sb.append("The content of the zip file has changed.\n");
        sb.append("The old content is:\n");
        sb.append((CharSequence)this.zipContent);
        sb.append("The new content is:\n");
        this.fillZipContent(newZipEntries, sb);
        return sb.toString();
    }

    private void fillZipContent(Enumeration<? extends ZipEntry> entries, StringBuilder sb) {
        while (entries.hasMoreElements()) {
            ZipEntry zipEntry = entries.nextElement();
            Object[] elements = new Object[]{"Name:" + zipEntry.getName(), "Size:" + zipEntry.getSize(), "Tme:" + zipEntry.getTime(), "isDirectory:" + zipEntry.isDirectory(), "Crc:" + zipEntry.getCrc()};
            sb.append(Arrays.toString(elements));
            sb.append("\n");
        }
    }

    protected Object readResolve() {
        this.zipEntries = new ArrayList<ZipEntry>();
        return this;
    }

    @Extension
    public static class ZIPFileContentDescriptor
    extends FSTriggerContentFileTypeDescriptor<ZIPFileContent> {
        @Override
        public Class<? extends FSTriggerContentFileType> getType() {
            return ZIPFileContent.class;
        }

        public String getDisplayName() {
            return "Monitor the contents of a ZIP file";
        }

        @Override
        public String getLabel() {
            return "ZIP File";
        }
    }
}

