/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.fstrigger.triggers.filecontent;

import hudson.Extension;
import hudson.util.FormValidation;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jenkinsci.lib.xtrigger.XTriggerException;
import org.jenkinsci.lib.xtrigger.XTriggerLog;
import org.jenkinsci.plugins.fstrigger.core.FSTriggerContentFileType;
import org.jenkinsci.plugins.fstrigger.core.FSTriggerContentFileTypeDescriptor;
import org.jenkinsci.plugins.fstrigger.triggers.filecontent.TextFileContentEntry;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class TextFileContent
extends FSTriggerContentFileType {
    private List<TextFileContentEntry> regexElements;

    @DataBoundConstructor
    public TextFileContent(List<TextFileContentEntry> element) {
        this.regexElements = element;
    }

    @Override
    public Object getMemoryInfo() {
        return this.regexElements;
    }

    @Override
    public void setMemoryInfo(Object memoryInfo) {
        if (memoryInfo != null && !(memoryInfo instanceof List)) {
            throw new IllegalArgumentException(String.format("The memory info %s object is not a List object.", memoryInfo));
        }
        this.regexElements = (List)memoryInfo;
    }

    public List<TextFileContentEntry> getRegexElements() {
        return this.regexElements;
    }

    @Override
    protected void initForContent(File file) throws XTriggerException {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean isTriggeringBuildForContent(File file, XTriggerLog log) throws XTriggerException {
        try (InputStreamReader fileReader = new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8);
             BufferedReader bufferedReader = new BufferedReader(fileReader);){
            Pattern pattern;
            String line;
            block32: while (true) {
                String regex;
                Matcher matcher;
                line = bufferedReader.readLine();
                if (line == null) return false;
                Iterator<TextFileContentEntry> iterator = this.regexElements.iterator();
                do {
                    if (!iterator.hasNext()) continue block32;
                    TextFileContentEntry regexEntry = iterator.next();
                    regex = regexEntry.getRegex();
                    if (regex != null) continue;
                    log.info("You have to provide a pattern for each entry");
                    boolean bl = false;
                    return bl;
                } while (!(matcher = (pattern = Pattern.compile(regex)).matcher(line)).matches());
                break;
            }
            log.info(String.format("The line '%s' matches the pattern '%s'", line, pattern));
            boolean bl = true;
            return bl;
        }
        catch (IOException fne) {
            throw new XTriggerException((Throwable)fne);
        }
    }

    @Extension
    public static class LogFileContentDescriptor
    extends FSTriggerContentFileTypeDescriptor<TextFileContent> {
        @Override
        public Class<? extends FSTriggerContentFileType> getType() {
            return TextFileContent.class;
        }

        public String getDisplayName() {
            return "Poll the contents of a text file (e.g. log file)";
        }

        @Override
        public String getLabel() {
            return "Text File";
        }

        public FormValidation doCheckRegex(@QueryParameter String value) {
            if (value == null || value.trim().isEmpty()) {
                return FormValidation.error((String)"You must provide a regular expression.");
            }
            return FormValidation.ok();
        }
    }
}

