/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.fstrigger.triggers.filecontent;

import hudson.Extension;
import hudson.Util;
import hudson.util.FormValidation;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Properties;
import org.jenkinsci.lib.xtrigger.XTriggerException;
import org.jenkinsci.lib.xtrigger.XTriggerLog;
import org.jenkinsci.plugins.fstrigger.core.FSTriggerContentFileType;
import org.jenkinsci.plugins.fstrigger.core.FSTriggerContentFileTypeDescriptor;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class PropertiesFileContent
extends FSTriggerContentFileType {
    protected static final String KEY_SEPARATOR = ",";
    protected String keys2Inspect;
    protected boolean allKeys;
    private transient Properties properties = new Properties();
    private static final long serialVersionUID = 1L;

    @DataBoundConstructor
    public PropertiesFileContent(String keys2Inspect, boolean allKeys) {
        if (keys2Inspect != null && !keys2Inspect.trim().isEmpty()) {
            this.keys2Inspect = Util.fixEmpty((String)keys2Inspect);
        }
        this.allKeys = allKeys;
    }

    @Override
    public Object getMemoryInfo() {
        return this.properties;
    }

    @Override
    public void setMemoryInfo(Object memoryInfo) {
        if (memoryInfo != null && !(memoryInfo instanceof Properties)) {
            throw new IllegalArgumentException(String.format("The memory info %s object is not a Properties object.", memoryInfo));
        }
        this.properties = (Properties)memoryInfo;
    }

    public String getKeys2Inspect() {
        return this.keys2Inspect;
    }

    public boolean isAllKeys() {
        return this.allKeys;
    }

    private boolean isPropertiesFile(Properties prop) {
        if (prop.isEmpty()) {
            return false;
        }
        boolean ok = true;
        for (Map.Entry<Object, Object> entry : prop.entrySet()) {
            String valueStr;
            Object value = entry.getValue();
            if (value == null) {
                return false;
            }
            if (value instanceof String && (valueStr = String.valueOf(value)).trim().isEmpty()) {
                ok = false;
                continue;
            }
            ok = true;
        }
        return ok;
    }

    private Properties computePropertiesObject(File file) throws XTriggerException {
        Properties propsReader = new Properties();
        try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8);){
            propsReader.load(reader);
        }
        catch (IOException ioe) {
            throw new XTriggerException((Throwable)ioe);
        }
        if (!this.isPropertiesFile(propsReader)) {
            throw new XTriggerException(String.format("The '%s' has no properties", file));
        }
        if (this.allKeys) {
            return propsReader;
        }
        Properties propsWriter = new Properties();
        if (this.keys2Inspect != null) {
            String[] keys;
            for (String key : keys = this.keys2Inspect.split(KEY_SEPARATOR)) {
                if (!propsReader.containsKey(key = key.trim())) continue;
                propsWriter.put(key, propsReader.getProperty(key));
            }
        }
        return propsWriter;
    }

    @Override
    protected void initForContent(File file) throws XTriggerException {
        this.properties = this.computePropertiesObject(file);
    }

    @Override
    protected boolean isTriggeringBuildForContent(File file, XTriggerLog log) throws XTriggerException {
        Properties newProperties = this.computePropertiesObject(file);
        assert (newProperties != null);
        if (this.properties.size() != newProperties.size()) {
            String msg = String.format("The new content file contains %d properties whereas the previous content contains %d properties", this.properties.size(), this.properties.size());
            log.info(msg);
            return true;
        }
        for (Map.Entry<Object, Object> entry : this.properties.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            Object newValue = newProperties.get(key);
            if (newValue == null) {
                String msg = String.format("The property '%s' is not longer available.", key);
                log.info(msg);
                return true;
            }
            if (newValue.equals(value)) continue;
            String msg = String.format("The previous value for the property '%s' was '%s' but it's now '%s'.", key, value, newValue);
            log.info(msg);
            return true;
        }
        return false;
    }

    protected Object readResolve() {
        this.properties = new Properties();
        return this;
    }

    @Extension
    public static class PropertiesFileContentDescriptor
    extends FSTriggerContentFileTypeDescriptor<PropertiesFileContent> {
        @Override
        public Class<? extends FSTriggerContentFileType> getType() {
            return PropertiesFileContent.class;
        }

        public String getDisplayName() {
            return "Monitor the contents of a properties file";
        }

        @Override
        public String getLabel() {
            return "Properties File";
        }

        public FormValidation doCheckKeys2Inspect(@QueryParameter String value) {
            if (value == null || value.trim().isEmpty()) {
                return FormValidation.error((String)"You must provide keys.");
            }
            return FormValidation.ok();
        }
    }
}

