/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.fstrigger.service;

import hudson.FilePath;
import hudson.model.AbstractProject;
import hudson.model.Node;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import jenkins.MasterToSlaveFileCallable;
import org.jenkinsci.lib.envinject.EnvInjectException;
import org.jenkinsci.lib.envinject.service.EnvVarsResolver;
import org.jenkinsci.lib.xtrigger.XTriggerException;
import org.jenkinsci.lib.xtrigger.XTriggerLog;
import org.jenkinsci.plugins.fstrigger.service.FSTriggerFileNameRetriever;
import org.jenkinsci.plugins.fstrigger.triggers.FileNameTriggerInfo;

public class FSTriggerComputeFileService
implements Serializable {
    public FilePath computedFile(Node node, AbstractProject project, final FileNameTriggerInfo fileInfo, final XTriggerLog log) throws XTriggerException {
        if (node == null || node.getRootPath() == null) {
            throw new XTriggerException("A valid node must be set.");
        }
        FilePath rootPath = node.getRootPath();
        if (rootPath == null) {
            throw new XTriggerException("An online node must be set.");
        }
        EnvVarsResolver varsRetriever = new EnvVarsResolver();
        try {
            final Map envVars = varsRetriever.getPollingEnvVars(project, node);
            return (FilePath)rootPath.act((FilePath.FileCallable)new MasterToSlaveFileCallable<FilePath>(){

                public FilePath invoke(File file, VirtualChannel virtualChannel) throws IOException {
                    File f;
                    try {
                        f = new FSTriggerFileNameRetriever(fileInfo, log, envVars).getFile();
                    }
                    catch (XTriggerException e) {
                        throw new IOException(e);
                    }
                    if (f == null) {
                        return null;
                    }
                    return new FilePath(f);
                }
            });
        }
        catch (IOException | InterruptedException | EnvInjectException e) {
            throw new XTriggerException(e);
        }
    }
}

