/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.fstrigger.core;

import hudson.ExtensionPoint;
import hudson.model.Describable;
import hudson.model.Descriptor;
import java.io.File;
import java.io.Serializable;
import jenkins.model.Jenkins;
import org.jenkinsci.lib.xtrigger.XTriggerException;
import org.jenkinsci.lib.xtrigger.XTriggerLog;
import org.jenkinsci.plugins.fstrigger.core.FSTriggerContentFileTypeDescriptor;

public abstract class FSTriggerContentFileType
implements ExtensionPoint,
Describable<FSTriggerContentFileType>,
Serializable {
    protected transient String jobName;

    public void initMemoryFields(String jobName, File file) throws XTriggerException {
        this.jobName = jobName;
        if (file == null) {
            throw new NullPointerException("The given file input reference is not set.");
        }
        if (!file.exists()) {
            throw new XTriggerException(String.format("The given file '%s' doesn't exist.", file));
        }
        this.initForContent(file);
    }

    public boolean isTriggeringBuild(File file, XTriggerLog log) throws XTriggerException {
        if (file == null) {
            throw new NullPointerException("The given file input reference is not set.");
        }
        if (!file.exists()) {
            throw new XTriggerException(String.format("The given file '%s' doesn't exist.", file));
        }
        return this.isTriggeringBuildForContent(file, log);
    }

    public Descriptor<FSTriggerContentFileType> getDescriptor() {
        return (FSTriggerContentFileTypeDescriptor)Jenkins.get().getDescriptor(this.getClass());
    }

    protected abstract void initForContent(File var1) throws XTriggerException;

    protected abstract boolean isTriggeringBuildForContent(File var1, XTriggerLog var2) throws XTriggerException;

    public abstract Object getMemoryInfo();

    public abstract void setMemoryInfo(Object var1);
}

