/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.plugin.jenkins.steps.types;

import com.fortify.plugin.jenkins.Messages;
import com.fortify.plugin.jenkins.steps.types.ProjectScanType;
import hudson.Extension;
import hudson.tasks.Maven;
import hudson.tools.ToolDescriptor;
import hudson.tools.ToolInstallation;
import hudson.util.ListBoxModel;
import java.util.ArrayList;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class MavenScanType
extends ProjectScanType {
    private String mavenOptions;
    private String mavenInstallationName;

    @DataBoundConstructor
    public MavenScanType() {
    }

    public String getMavenOptions() {
        return this.mavenOptions;
    }

    public String getMavenInstallationName() {
        return this.mavenInstallationName;
    }

    @DataBoundSetter
    public void setMavenOptions(String mavenOptions) {
        this.mavenOptions = mavenOptions;
    }

    @DataBoundSetter
    public void setMavenInstallationName(String mavenInstallationName) {
        this.mavenInstallationName = mavenInstallationName;
    }

    @Extension
    @Symbol(value={"fortifyMaven3"})
    public static final class DescriptorImpl
    extends ProjectScanType.ProjectScanTypeDescriptor {
        public DescriptorImpl() {
            super(MavenScanType.class);
        }

        @Override
        public String getDisplayName() {
            return Messages.MavenScanType_DisplayName();
        }

        public ListBoxModel doFillMavenInstallationNameItems() {
            Maven.MavenInstallation[] installations = this.getInstallations();
            ListBoxModel result = new ListBoxModel();
            result.add("(Default)");
            for (Maven.MavenInstallation nextMvn : installations) {
                String nextName = nextMvn.getName();
                result.add(nextName);
            }
            return result;
        }

        public Maven.MavenInstallation[] getInstallations() {
            ArrayList<Maven.MavenInstallation> r = new ArrayList<Maven.MavenInstallation>();
            for (ToolDescriptor desc : ToolInstallation.all()) {
                for (ToolInstallation inst : desc.getInstallations()) {
                    if (!(inst instanceof Maven.MavenInstallation)) continue;
                    Maven.MavenInstallation nextMvn = (Maven.MavenInstallation)inst;
                    r.add(nextMvn);
                }
            }
            return r.toArray(new Maven.MavenInstallation[r.size()]);
        }
    }
}

