/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.plugin.jenkins.steps.types;

import com.fortify.plugin.jenkins.Messages;
import com.fortify.plugin.jenkins.steps.Validators;
import com.fortify.plugin.jenkins.steps.types.ProjectScanType;
import hudson.Extension;
import hudson.plugins.gradle.GradleInstallation;
import hudson.tools.ToolDescriptor;
import hudson.tools.ToolInstallation;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.util.ArrayList;
import java.util.UUID;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class GradleScanType
extends ProjectScanType {
    private boolean useWrapper;
    private String gradleTasks;
    private String gradleOptions;
    private String gradleInstallationName;

    @DataBoundConstructor
    public GradleScanType() {
    }

    public boolean getUseWrapper() {
        return this.useWrapper;
    }

    public String getGradleTasks() {
        return this.gradleTasks;
    }

    public String getGradleOptions() {
        return this.gradleOptions;
    }

    public String getGradleInstallationName() {
        return this.gradleInstallationName;
    }

    @DataBoundSetter
    public void setUseWrapper(boolean useWrapper) {
        this.useWrapper = useWrapper;
    }

    @DataBoundSetter
    public void setGradleTasks(String gradleTasks) {
        this.gradleTasks = gradleTasks;
    }

    @DataBoundSetter
    public void setGradleOptions(String gradleOptions) {
        this.gradleOptions = gradleOptions;
    }

    @DataBoundSetter
    public void setGradleInstallationName(String gradleInstallationName) {
        this.gradleInstallationName = gradleInstallationName;
    }

    @Extension
    @Symbol(value={"fortifyGradle"})
    public static final class DescriptorImpl
    extends ProjectScanType.ProjectScanTypeDescriptor {
        public DescriptorImpl() {
            super(GradleScanType.class);
        }

        @Override
        public String getDisplayName() {
            return Messages.GradleScanType_DisplayName();
        }

        public FormValidation doCheckGradleTasks(@QueryParameter String value) {
            return Validators.checkFieldNotEmpty(value);
        }

        public ListBoxModel doFillGradleInstallationNameItems() {
            GradleInstallation[] installations = this.getInstallations();
            ListBoxModel result = new ListBoxModel();
            result.add("(Default)");
            for (GradleInstallation nextGradle : installations) {
                String nextName = nextGradle.getName();
                result.add(nextName);
            }
            return result;
        }

        public GradleInstallation[] getInstallations() {
            ArrayList<GradleInstallation> r = new ArrayList<GradleInstallation>();
            for (ToolDescriptor desc : ToolInstallation.all()) {
                for (ToolInstallation inst : desc.getInstallations()) {
                    if (!(inst instanceof GradleInstallation)) continue;
                    GradleInstallation nextGradle = (GradleInstallation)inst;
                    r.add(nextGradle);
                }
            }
            return r.toArray(new GradleInstallation[r.size()]);
        }

        public String generateId() {
            return UUID.randomUUID().toString();
        }
    }
}

