/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.plugin.jenkins.steps.types;

import com.fortify.plugin.jenkins.Messages;
import com.fortify.plugin.jenkins.steps.Validators;
import com.fortify.plugin.jenkins.steps.types.ProjectScanType;
import hudson.Extension;
import hudson.util.FormValidation;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class DotnetSourceScanType
extends ProjectScanType {
    private String dotnetFrameworkVersion;
    private String dotnetLibdirs;
    private String dotnetSrcFiles;
    private String dotnetAddOptions;

    @DataBoundConstructor
    public DotnetSourceScanType() {
    }

    public String getDotnetFrameworkVersion() {
        return this.dotnetFrameworkVersion;
    }

    public String getDotnetLibdirs() {
        return this.dotnetLibdirs;
    }

    public String getDotnetSrcFiles() {
        return this.dotnetSrcFiles;
    }

    public String getDotnetAddOptions() {
        return this.dotnetAddOptions;
    }

    @DataBoundSetter
    public void setDotnetFrameworkVersion(String dotnetFrameworkVersion) {
        this.dotnetFrameworkVersion = dotnetFrameworkVersion;
    }

    @DataBoundSetter
    public void setDotnetLibdirs(String dotnetLibdirs) {
        this.dotnetLibdirs = dotnetLibdirs;
    }

    @DataBoundSetter
    public void setDotnetSrcFiles(String dotnetSrcFiles) {
        this.dotnetSrcFiles = dotnetSrcFiles;
    }

    @DataBoundSetter
    public void setDotnetAddOptions(String dotnetAddOptions) {
        this.dotnetAddOptions = dotnetAddOptions;
    }

    @Extension
    @Symbol(value={"fortifyDotnetSrc"})
    public static final class DescriptorImpl
    extends ProjectScanType.ProjectScanTypeDescriptor {
        public DescriptorImpl() {
            super(DotnetSourceScanType.class);
        }

        @Override
        public String getDisplayName() {
            return Messages.DotnetSourceScanType_DisplayName();
        }

        public FormValidation doCheckDotnetFrameworkVersion(@QueryParameter String value) {
            FormValidation testEmpty = Validators.checkFieldNotEmpty(value);
            if (testEmpty == FormValidation.ok()) {
                return Validators.checkValidVersionNumber(value);
            }
            return testEmpty;
        }

        public FormValidation doCheckDotnetSrcFiles(@QueryParameter String value) {
            return Validators.checkFieldNotEmpty(value);
        }
    }
}

