/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.plugin.jenkins.steps;

import com.fortify.plugin.jenkins.FPRSummary;
import com.fortify.plugin.jenkins.FortifyPlugin;
import com.fortify.plugin.jenkins.FortifyUploadBuildAction;
import com.fortify.plugin.jenkins.Messages;
import com.fortify.plugin.jenkins.PathUtils;
import com.fortify.plugin.jenkins.RemoteService;
import com.fortify.plugin.jenkins.TableAction;
import com.fortify.plugin.jenkins.bean.GroupingProfile;
import com.fortify.plugin.jenkins.bean.GroupingValueBean;
import com.fortify.plugin.jenkins.bean.IssueBean;
import com.fortify.plugin.jenkins.bean.IssueFolderBean;
import com.fortify.plugin.jenkins.fortifyclient.FortifyClient;
import com.fortify.plugin.jenkins.steps.FortifyStep;
import com.fortify.plugin.jenkins.steps.Validators;
import com.fortify.ssc.restclient.model.Artifact;
import com.google.common.collect.ImmutableSet;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Item;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.StreamBuildListener;
import hudson.model.TaskListener;
import hudson.util.ComboBoxModel;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.steps.SynchronousNonBlockingStepExecution;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.verb.POST;

public class FortifyUpload
extends FortifyStep
implements Serializable {
    private static final long serialVersionUID = -8308672776705963290L;
    private boolean accessToProject = true;
    private int pageSize = 0;
    private boolean isPipeline = true;
    private String resultsFile;
    private String filterSet;
    private String failureCriteria;
    private String appName;
    private String appVersion;
    private String timeout;
    private String pollingInterval;

    public FortifyUpload(boolean isPipeline, String appName, String appVersion) {
        this(appName, appVersion);
        this.isPipeline = isPipeline;
    }

    @DataBoundConstructor
    public FortifyUpload(String appName, String appVersion) {
        this.appName = appName != null ? appName.trim() : "";
        this.appVersion = appName != null ? appVersion.trim() : "";
    }

    public String getAppName() {
        return this.appName;
    }

    public String getAppVersion() {
        return this.appVersion;
    }

    @DataBoundSetter
    public void setResultsFile(String resultsFile) {
        this.resultsFile = resultsFile;
    }

    public String getResultsFile() {
        return this.resultsFile;
    }

    @DataBoundSetter
    public void setFilterSet(String filterSet) {
        this.filterSet = filterSet != null ? filterSet.trim() : "";
    }

    public String getFilterSet() {
        return this.filterSet;
    }

    @DataBoundSetter
    public void setFailureCriteria(String failureCriteria) {
        this.failureCriteria = failureCriteria != null ? failureCriteria.trim() : "";
    }

    public String getFailureCriteria() {
        return this.failureCriteria;
    }

    public String getTimeout() {
        return this.timeout;
    }

    @DataBoundSetter
    public void setTimeout(String timeout) {
        this.timeout = timeout;
    }

    @DataBoundSetter
    public void setPollingInterval(String pollingInterval) {
        this.pollingInterval = pollingInterval;
    }

    public String getPollingInterval() {
        return this.pollingInterval;
    }

    public boolean isPipeline() {
        return this.isPipeline;
    }

    public String getResolvedFpr(TaskListener listener) {
        String s = this.resolve(this.getResultsFile(), listener);
        return PathUtils.appendExtentionIfNotEmpty(s, ".fpr", ".fpr", ".zip");
    }

    public String getResolvedAppName(TaskListener listener) {
        return this.resolve(this.getAppName(), listener);
    }

    public String getResolvedAppVersion(TaskListener listener) {
        return this.resolve(this.getAppVersion(), listener);
    }

    public String getResolvedFilterSet(TaskListener listener) {
        return this.resolve(this.getFilterSet(), listener);
    }

    public String getResolvedFailureCriteria(TaskListener listener) {
        return this.resolve(this.getFailureCriteria(), listener);
    }

    public Integer getResolvedTimeout(TaskListener listener) {
        if (this.getTimeout() != null) {
            try {
                return Integer.parseInt(this.resolve(this.getTimeout(), listener));
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return null;
    }

    public Integer getResolvedPollingInterval(TaskListener listener) {
        if (this.getPollingInterval() != null) {
            try {
                return Integer.parseInt(this.resolve(this.getPollingInterval(), listener));
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return null;
    }

    @Override
    public boolean prebuild(AbstractBuild<?, ?> build, BuildListener listener) {
        return true;
    }

    @Override
    public StepExecution start(StepContext context) throws Exception {
        return new Execution(this, context);
    }

    public void perform(Run<?, ?> run, FilePath workspace, EnvVars vars, Launcher launcher, TaskListener listener) throws InterruptedException, IOException {
        this.performAndReturnIssueCount(run, workspace, vars, launcher, listener);
    }

    public Integer performAndReturnIssueCount(Run<?, ?> run, FilePath workspace, EnvVars vars, Launcher launcher, TaskListener listener) throws InterruptedException, IOException {
        PrintStream log = listener.getLogger();
        this.setLastBuild(run);
        RemoteService service = new RemoteService(this.getResolvedFpr(listener));
        FPRSummary summary = (FPRSummary)workspace.act((FilePath.FileCallable)service);
        Long artifactId = this.uploadToSSC(summary, workspace, listener);
        this.pollFprProcessing(run, artifactId, listener);
        log.println("Retrieving build statistics from SSC");
        this.calculateFprStatistics(summary, listener);
        log.printf("Calculated NVS=%f, failedCount=%d%n", summary.getNvs(), summary.getFailedCount());
        log.println("Saving build summary");
        if (this.isPipeline) {
            summary.save(run.getRootDir(), this.getResolvedAppName(listener), this.getResolvedAppVersion(listener));
        } else {
            summary.save(run.getRootDir(), null, null);
        }
        if (summary.getFailedCount() > 0) {
            log.printf("FortifyJenkins plugin: this build is considered unstable because Fail Condition met %d vulnerabilities%n", summary.getFailedCount());
            run.setResult(Result.UNSTABLE);
        }
        String appName = this.getResolvedAppName(listener);
        String appVersion = this.getResolvedAppVersion(listener);
        FortifyUploadBuildAction buildAction = (FortifyUploadBuildAction)run.getAction(FortifyUploadBuildAction.class);
        if (buildAction == null) {
            buildAction = new FortifyUploadBuildAction();
            run.addAction((Action)buildAction);
        }
        buildAction.addAppVersion(run.getParent(), this, appName, appVersion);
        return summary.getFailedCount();
    }

    private Long uploadToSSC(FPRSummary summary, FilePath workspace, TaskListener listener) throws InterruptedException, IOException {
        PrintStream log = listener.getLogger();
        log.println("Fortify Jenkins plugin v " + VERSION);
        log.println("Performing Fortify upload process");
        String logMsg = summary.getLogMessage();
        if (!StringUtils.isBlank((String)logMsg)) {
            log.println(logMsg);
        }
        File localFPR = null;
        localFPR = summary.getFprFile().isRemote() ? this.copyToLocalTmp(summary.getFprFile()) : new File(summary.getFprFile().toURI());
        log.printf("Using analysis results file: %s%n", summary.getFprFile().toURI());
        Long artifactId = null;
        if (!StringUtils.isBlank((String)this.getResolvedAppName(listener)) && !StringUtils.isBlank((String)this.getResolvedAppVersion(listener)) && FortifyPlugin.DESCRIPTOR.canUploadToSsc()) {
            Long l;
            log.printf("Uploading analysis results file to SSC at %s to application '%s' and application version '%s'%n", FortifyPlugin.DESCRIPTOR.getUrl(), this.getResolvedAppName(listener), this.getResolvedAppVersion(listener));
            try {
                final Long projectId = this.createNewOrGetProject(listener);
                final File fpr = localFPR;
                artifactId = FortifyPlugin.runWithFortifyClient(FortifyPlugin.DESCRIPTOR.getToken(), new FortifyClient.Command<Long>(){

                    @Override
                    public Long runWith(FortifyClient client) throws Exception {
                        return client.uploadFPR(fpr, projectId);
                    }
                });
                log.printf("Analysis results uploaded successfully. artifact id = %d%n", artifactId);
                l = artifactId;
            }
            catch (Throwable t) {
                try {
                    log.println("Error uploading to SSC: " + FortifyPlugin.DESCRIPTOR.getUrl());
                    String message = t.getMessage();
                    log.println(message);
                    t.printStackTrace(log);
                    throw new AbortException("Error uploading to SSC: " + message);
                }
                catch (Throwable throwable) {
                    if (summary.getFprFile().isRemote() && null != localFPR && localFPR.exists()) {
                        try {
                            boolean deleted = localFPR.delete();
                            if (!deleted) {
                                log.printf("Can't delete local analysis results file: %s%n", localFPR.getCanonicalFile());
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace(log);
                        }
                    }
                    throw throwable;
                }
            }
            if (summary.getFprFile().isRemote() && null != localFPR && localFPR.exists()) {
                try {
                    boolean deleted = localFPR.delete();
                    if (!deleted) {
                        log.printf("Can't delete local analysis results file: %s%n", localFPR.getCanonicalFile());
                    }
                }
                catch (Exception e) {
                    e.printStackTrace(log);
                }
            }
            return l;
        }
        log.printf("Analysis results file uploading was skipped. Some of the required settings are not specified: Application Name='%s', Application Version='%s', serverUrl='%s', authenticationToken='%s'%n", this.getResolvedAppName(listener), this.getResolvedAppVersion(listener), FortifyPlugin.DESCRIPTOR.getUrl(), FortifyPlugin.DESCRIPTOR.getToken());
        throw new AbortException("Analysis results uploading was skipped. Some of the required settings are not specified.");
    }

    private void pollFprProcessing(Run<?, ?> run, Long artifactId, TaskListener listener) throws IOException {
        int sleepInMinutes;
        PrintStream log = listener.getLogger();
        boolean isProcessingComplete = false;
        int timeoutInMinutes = this.getResolvedTimeout(listener) != null ? this.getResolvedTimeout(listener) : 0;
        int timeoutInMillis = timeoutInMinutes * 60 * 1000;
        long timeoutAfter = System.currentTimeMillis() + (long)timeoutInMillis;
        Integer resolvedPollingInterval = this.getResolvedPollingInterval(listener);
        int n = sleepInMinutes = resolvedPollingInterval != null ? resolvedPollingInterval : 1;
        if (sleepInMinutes == 0) {
            log.println("Polling interval of 0 disables waiting");
            return;
        }
        int sleepInMillis = sleepInMinutes * 60 * 1000;
        while (!isProcessingComplete) {
            long diff;
            log.printf("Sleep for %d minute(s)%n", sleepInMinutes);
            long sleepUntil = System.currentTimeMillis() + (long)sleepInMillis;
            while ((diff = sleepUntil - System.currentTimeMillis()) > 0L) {
                try {
                    Thread.sleep(diff);
                }
                catch (InterruptedException interruptedException) {}
            }
            try {
                final Long artifactIdFinal = artifactId;
                Artifact.StatusEnum status = FortifyPlugin.runWithFortifyClient(FortifyPlugin.DESCRIPTOR.getToken(), new FortifyClient.Command<Artifact.StatusEnum>(){

                    @Override
                    public Artifact.StatusEnum runWith(FortifyClient client) throws Exception {
                        Artifact artifact = client.getArtifactInfo(artifactIdFinal);
                        return artifact.getStatus();
                    }
                });
                switch (status) {
                    case PROCESS_COMPLETE: {
                        isProcessingComplete = true;
                        break;
                    }
                    case ERROR_PROCESSING: {
                        throw new AbortException("SSC encountered an error processing the artifact");
                    }
                    case REQUIRE_AUTH: {
                        log.println("The artifact needs to be approved for processing in SSC. Will continue to wait...");
                        break;
                    }
                    case SCHED_PROCESSING: {
                        log.println("The artifact was scheduled for processing on SSC. Will continue to wait...");
                        break;
                    }
                    case PROCESSING: {
                        log.println("The artifact is being processed by SSC. Will continue to wait...");
                        break;
                    }
                    default: {
                        log.println("Unexpected artifact status: " + status.name());
                        isProcessingComplete = true;
                    }
                }
                if (isProcessingComplete) {
                    break;
                }
            }
            catch (Throwable t) {
                String message = t.getMessage();
                log.println("Error checking artifact status. " + message);
                t.printStackTrace(log);
                throw new AbortException("Failed to retrieve artifact statistics from SSC. " + message);
            }
            if (timeoutInMinutes <= 0 || (diff = timeoutAfter - System.currentTimeMillis()) > 0L) continue;
            this.setBuildUncompleted(run, log, timeoutInMinutes);
        }
    }

    private void setBuildUncompleted(Run<?, ?> run, PrintStream log, int timeoutInMinutes) throws IOException {
        long projectVersionId = this.getProjectVersionId(log);
        String appArtifactsURL = this.getAppArtifactsURL(projectVersionId);
        run.setResult(Result.NOT_BUILT);
        run.setDescription("A timeout has been reached when checking SSC for status of artifacts, this could happen on long running processing jobs and does not mean that the build failed. You can check the status in SSC here: " + appArtifactsURL);
        throw new AbortException("Timeout of " + timeoutInMinutes + " minute(s) is reached.");
    }

    private long getProjectVersionId(PrintStream log) throws AbortException {
        long projectVersionId;
        try {
            projectVersionId = FortifyPlugin.runWithFortifyClient(FortifyPlugin.DESCRIPTOR.getToken(), new FortifyClient.Command<Long>(){

                @Override
                public Long runWith(FortifyClient client) throws Exception {
                    return client.getProjectVersionId(FortifyUpload.this.appName, FortifyUpload.this.appVersion);
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new AbortException("Error occurred during FPR polling: " + e.getMessage());
        }
        return projectVersionId;
    }

    private String getAppArtifactsURL(Long projectVersionId) {
        return FortifyPlugin.DESCRIPTOR.getUrl() + "/html/ssc/version/" + projectVersionId + "/artifacts";
    }

    private void calculateFprStatistics(FPRSummary summary, TaskListener listener) {
        listener = listener == null ? new StreamBuildListener(System.out, Charset.defaultCharset()) : listener;
        PrintStream log = listener.getLogger();
        int CFPO = 0;
        int HFPO = 0;
        int MFPO = 0;
        int LFPO = 0;
        int PABOVE = 0;
        int P3 = 0;
        int P2 = 0;
        int P1 = 0;
        int failedCount = 0;
        int totalIssues = 0;
        List<IssueFolderBean> folders = this.getFolders(listener);
        Long versionId = null;
        try {
            versionId = this.createNewOrGetProject(listener);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (IssueFolderBean folder : folders) {
            List<GroupingValueBean> groupingValues;
            log.printf("Processing folder = %s ...%n", folder.getName());
            if ("Critical".equals(folder.getName()) || "Hot".equals(folder.getName())) {
                groupingValues = this.getGroupingValues(versionId, folder.getId(), null, "Analysis", listener);
                log.printf("Got %d audit values for folder = %s%n", groupingValues.size(), folder.getName());
                for (GroupingValueBean group : groupingValues) {
                    if ("Not an Issue".equals(group.getName())) continue;
                    CFPO += group.getTotalCount();
                }
                continue;
            }
            if ("High".equals(folder.getName()) || "Warning".equals(folder.getName())) {
                groupingValues = this.getGroupingValues(versionId, folder.getId(), null, "Analysis", listener);
                log.printf("Got %d audit values for folder = %s%n", groupingValues.size(), folder.getName());
                for (GroupingValueBean group : groupingValues) {
                    if ("Not an Issue".equals(group.getName())) continue;
                    HFPO += group.getTotalCount();
                }
                continue;
            }
            if ("Medium".equals(folder.getName())) {
                groupingValues = this.getGroupingValues(versionId, folder.getId(), null, "Analysis", listener);
                log.printf("Got %d audit values for folder = %s%n", groupingValues.size(), folder.getName());
                for (GroupingValueBean group : groupingValues) {
                    if ("Not an Issue".equals(group.getName())) continue;
                    MFPO += group.getTotalCount();
                }
                continue;
            }
            if ("Low".equals(folder.getName()) || "Info".equals(folder.getName())) {
                groupingValues = this.getGroupingValues(versionId, folder.getId(), null, "Analysis", listener);
                log.printf("Got %d audit values for folder = %s%n", groupingValues.size(), folder.getName());
                for (GroupingValueBean group : groupingValues) {
                    if ("Not an Issue".equals(group.getName())) continue;
                    LFPO += group.getTotalCount();
                }
                continue;
            }
            if (!"All".equals(folder.getName())) continue;
            groupingValues = this.getGroupingValues(versionId, folder.getId(), null, "Analysis", listener);
            log.printf("Got %d audit values for folder = %s%n", groupingValues.size(), folder.getName());
            totalIssues = folder.getIssueCount();
            for (GroupingValueBean group : groupingValues) {
                if (group.getName().startsWith("Exploitable")) {
                    PABOVE += group.getTotalCount();
                    continue;
                }
                if (group.getName().startsWith("Suspicious")) {
                    P3 += group.getTotalCount();
                    continue;
                }
                if (group.getName().startsWith("Bad Practice")) {
                    P2 += group.getTotalCount();
                    continue;
                }
                if (!group.getName().startsWith("Reliability Issue")) continue;
                P1 += group.getTotalCount();
            }
            if (StringUtils.isBlank((String)this.getResolvedFailureCriteria(listener))) continue;
            List<GroupingValueBean> groupingValuesByCondition = this.getGroupingValues(versionId, folder.getId(), this.getFailureCriteria(), "Analysis", listener);
            log.printf("Got %d grouping values for folder = %s, condition = '%s'%n", groupingValues.size(), folder.getName(), this.getFailureCriteria());
            for (GroupingValueBean group : groupingValuesByCondition) {
                if ("Not an Issue".equals(group.getName())) continue;
                failedCount += group.getTotalCount();
            }
        }
        double NVS = (((double)CFPO * 10.0 + (double)(HFPO * 5) + (double)MFPO * 1.0 + (double)LFPO * 0.1) * 0.5 + ((double)P1 * 2.0 + (double)P2 * 4.0 + (double)P3 * 16.0 + (double)PABOVE * 64.0) * 0.5) / 1.0;
        summary.setNvs(NVS);
        summary.setFailedCount(failedCount);
        summary.setTotalIssues(totalIssues);
        summary.setFolderBeans(folders);
    }

    public List<GroupingValueBean> getGroupingValues(final Long versionId, final String folderId, final String searchCondition, final String groupingName, TaskListener taskListener) {
        TaskListener listener;
        Object object = listener = taskListener != null ? taskListener : new StreamBuildListener(System.out, Charset.defaultCharset());
        if (FortifyPlugin.DESCRIPTOR.canUploadToSsc()) {
            PrintStream logger = listener.getLogger();
            try {
                final OutputStreamWriter log = new OutputStreamWriter((OutputStream)logger, "UTF-8");
                Map<String, List<String>> map = FortifyPlugin.runWithFortifyClient(FortifyPlugin.DESCRIPTOR.getToken(), new FortifyClient.Command<Map<String, List<String>>>(){

                    @Override
                    public Map<String, List<String>> runWith(FortifyClient client) throws Exception {
                        return client.getGroupingValues(versionId == null ? Long.valueOf(Long.MIN_VALUE) : versionId, folderId, FortifyUpload.this.getResolvedFilterSet(listener), searchCondition == null ? "" : searchCondition, groupingName, new PrintWriter(log, true));
                    }
                });
                ArrayList<GroupingValueBean> list = new ArrayList<GroupingValueBean>(map.size());
                for (Map.Entry<String, List<String>> entry : map.entrySet()) {
                    List<String> attributes = entry.getValue();
                    if (attributes.size() != 5) continue;
                    GroupingValueBean next = new GroupingValueBean(entry.getKey(), folderId, attributes);
                    list.add(next);
                }
                return list;
            }
            catch (Throwable e) {
                logger.println(e.getMessage());
                e.printStackTrace(logger);
            }
        }
        return Collections.emptyList();
    }

    public List<IssueFolderBean> getFolders(TaskListener taskListener) {
        final TaskListener listener = taskListener != null ? taskListener : new StreamBuildListener(System.out, Charset.defaultCharset());
        this.accessToProject = true;
        this.getResolvedAppVersion(listener);
        if (FortifyPlugin.DESCRIPTOR.canUploadToSsc()) {
            PrintStream logger = listener.getLogger();
            try {
                final OutputStreamWriter log = new OutputStreamWriter((OutputStream)logger, "UTF-8");
                final Long versionId = this.createNewOrGetProject(listener);
                Map<String, List<String>> map = FortifyPlugin.runWithFortifyClient(FortifyPlugin.DESCRIPTOR.getToken(), new FortifyClient.Command<Map<String, List<String>>>(){

                    @Override
                    public Map<String, List<String>> runWith(FortifyClient client) throws Exception {
                        return client.getFolderIdToAttributesList(versionId == null ? Long.valueOf(Long.MIN_VALUE) : versionId, FortifyUpload.this.getResolvedFilterSet(listener), new PrintWriter(log, true));
                    }
                });
                ArrayList<IssueFolderBean> list = new ArrayList<IssueFolderBean>(map.size());
                for (Map.Entry<String, List<String>> entry : map.entrySet()) {
                    List<String> attributes = entry.getValue();
                    if (attributes.size() != 5) continue;
                    list.add(new IssueFolderBean(entry.getKey(), this.getResolvedAppName(listener), this.getResolvedAppVersion(listener), attributes));
                }
                return list;
            }
            catch (Throwable e) {
                String message = e.getMessage();
                if (message.toLowerCase().contains("access denied")) {
                    this.accessToProject = false;
                }
                logger.println(message);
                e.printStackTrace(logger);
            }
        }
        return Collections.emptyList();
    }

    public List<GroupingProfile> getGroupingProfiles(TaskListener taskListener) {
        final TaskListener listener = taskListener != null ? taskListener : new StreamBuildListener(System.out, Charset.defaultCharset());
        this.accessToProject = true;
        if (FortifyPlugin.DESCRIPTOR.canUploadToSsc()) {
            PrintStream logger = listener.getLogger();
            try {
                final OutputStreamWriter log = new OutputStreamWriter((OutputStream)logger, "UTF-8");
                final Long versionId = this.createNewOrGetProject(listener);
                List<GroupingProfile> groupingProfiles = FortifyPlugin.runWithFortifyClient(FortifyPlugin.DESCRIPTOR.getToken(), new FortifyClient.Command<List<GroupingProfile>>(){

                    @Override
                    public List<GroupingProfile> runWith(FortifyClient client) throws Exception {
                        return client.getGroupingProfiles(versionId == null ? Long.valueOf(Long.MIN_VALUE) : versionId, FortifyUpload.this.getResolvedFilterSet(listener), new PrintWriter(log, true));
                    }
                });
                return groupingProfiles;
            }
            catch (Throwable e) {
                String message = e.getMessage();
                if (message.toLowerCase().contains("access denied")) {
                    this.accessToProject = false;
                }
                logger.println(message);
                e.printStackTrace(logger);
            }
        }
        return Collections.emptyList();
    }

    public List<IssueBean> getIssuesByFolder(final String folderId, final int startPage, final int pageSize, final TableAction.SortOrder sortOrder, final boolean downNotUp, final boolean showingAllNotNew, final String selectedGrouping, TaskListener taskListener) {
        if (FortifyPlugin.DESCRIPTOR.canUploadToSsc()) {
            final TaskListener listener = taskListener != null ? taskListener : new StreamBuildListener(System.out, Charset.defaultCharset());
            PrintStream logger = listener.getLogger();
            try {
                final OutputStreamWriter log = new OutputStreamWriter((OutputStream)logger, "UTF-8");
                final Long versionId = this.createNewOrGetProject(listener);
                Map<String, IssueBean> map = FortifyPlugin.runWithFortifyClient(FortifyPlugin.DESCRIPTOR.getToken(), new FortifyClient.Command<Map<String, IssueBean>>(){

                    @Override
                    public Map<String, IssueBean> runWith(FortifyClient client) throws Exception {
                        return client.getIssuesByFolderId(versionId == null ? Long.valueOf(Long.MIN_VALUE) : versionId, folderId, startPage, pageSize, FortifyUpload.this.getResolvedFilterSet(listener), selectedGrouping, sortOrder.getModelSorting() == null ? "" : sortOrder.getModelSorting(), downNotUp, showingAllNotNew, new PrintWriter(log, true));
                    }
                });
                ArrayList<IssueBean> list = new ArrayList<IssueBean>(map.size());
                for (Map.Entry<String, IssueBean> issueInstanceEntry : map.entrySet()) {
                    IssueBean issueBean = issueInstanceEntry.getValue();
                    issueBean.setProjectName(this.getResolvedAppName(listener));
                    issueBean.setProjectVersionName(this.getResolvedAppVersion(listener));
                    list.add(issueBean);
                }
                ArrayList<IssueBean> results = list;
                return results;
            }
            catch (Throwable e) {
                logger.println(e.getMessage());
                e.printStackTrace(logger);
            }
        }
        return Collections.emptyList();
    }

    private Long createNewOrGetProject(TaskListener taskListener) throws Exception {
        final TaskListener listener = taskListener == null ? new StreamBuildListener(System.out, Charset.defaultCharset()) : taskListener;
        final OutputStreamWriter log = new OutputStreamWriter((OutputStream)listener.getLogger(), "UTF-8");
        Long versionId = FortifyPlugin.runWithFortifyClient(FortifyPlugin.DESCRIPTOR.getToken(), new FortifyClient.Command<Long>(){

            @Override
            public Long runWith(FortifyClient client) throws Exception {
                return client.createProject(FortifyUpload.this.getResolvedAppName(listener), FortifyUpload.this.getResolvedAppVersion(listener), FortifyPlugin.DESCRIPTOR.getProjectTemplate(), Collections.emptyMap(), new PrintWriter(log, true));
            }
        });
        return versionId;
    }

    public boolean getAccessToProject() {
        return this.accessToProject;
    }

    public boolean isSettingUpdated() {
        return FortifyPlugin.DESCRIPTOR.isSettingUpdated();
    }

    public int getIssuePageSize() {
        Integer breakdownPageSize = FortifyPlugin.DESCRIPTOR.getBreakdownPageSize();
        if (null == breakdownPageSize) {
            breakdownPageSize = 50;
        }
        if (this.pageSize == 0) {
            this.pageSize = breakdownPageSize;
        }
        return this.pageSize;
    }

    public void setIssuePageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    private File copyToLocalTmp(FilePath file) throws IOException, InterruptedException {
        File tmpFile = new File(Util.createTempDir(), file.getName());
        FilePath tmpFP = new FilePath(tmpFile);
        file.copyTo(tmpFP);
        return tmpFile;
    }

    private static class Execution
    extends SynchronousNonBlockingStepExecution<Integer> {
        private FortifyUpload upload;
        private static final long serialVersionUID = 1L;

        protected Execution(FortifyUpload upload, StepContext context) {
            super(context);
            this.upload = upload;
        }

        protected Integer run() throws Exception {
            StepContext context = this.getContext();
            TaskListener listener = (TaskListener)context.get(TaskListener.class);
            listener.getLogger().println("Running FortifyUpload step");
            return this.upload.performAndReturnIssueCount((Run)context.get(Run.class), (FilePath)context.get(FilePath.class), (EnvVars)context.get(EnvVars.class), (Launcher)context.get(Launcher.class), listener);
        }
    }

    @Extension
    public static class DescriptorImpl
    extends StepDescriptor {
        public String getDisplayName() {
            return Messages.FortifyUpload_DisplayName();
        }

        public String getFunctionName() {
            return "fortifyUpload";
        }

        public Set<? extends Class<?>> getRequiredContext() {
            return ImmutableSet.of(Run.class, FilePath.class, EnvVars.class, Launcher.class, TaskListener.class);
        }

        @POST
        public ComboBoxModel getApplicationNameItems(@AncestorInPath Item item) {
            return FortifyPlugin.DESCRIPTOR.getAppNameItems(item);
        }

        @POST
        public ComboBoxModel getApplicationVersionItems(@QueryParameter String applicationName, @AncestorInPath Item item) {
            return FortifyPlugin.DESCRIPTOR.getAppVersionItems(applicationName, item);
        }

        @POST
        public void doRefreshApplications(StaplerRequest req, StaplerResponse rsp, @QueryParameter String value, @AncestorInPath Item item) throws Exception {
            FortifyPlugin.DESCRIPTOR.doRefreshProjects(req, rsp, value, item);
        }

        @POST
        public void doRefreshVersions(StaplerRequest req, StaplerResponse rsp, @QueryParameter String value, @AncestorInPath Item item) throws Exception {
            FortifyPlugin.DESCRIPTOR.doRefreshVersions(req, rsp, value, item);
        }

        @POST
        public ListBoxModel doFillFilterSetItems(@QueryParameter String appName, @QueryParameter String appVersion, @AncestorInPath Item item) {
            return FortifyPlugin.DESCRIPTOR.doFillFilterSetItems(appName, appVersion, item);
        }

        public FormValidation doCheckAppName(@QueryParameter String value) {
            return Validators.checkFieldNotEmpty(value);
        }

        public FormValidation doCheckAppVersion(@QueryParameter String value) {
            return Validators.checkFieldNotEmpty(value);
        }

        public FormValidation doCheckUploadWaitTime(@QueryParameter String value) {
            return Validators.checkValidInteger(value);
        }
    }
}

