/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.plugin.jenkins.steps;

import com.fortify.plugin.jenkins.FortifyPlugin;
import com.fortify.plugin.jenkins.Messages;
import com.fortify.plugin.jenkins.ProxyConfig;
import com.fortify.plugin.jenkins.steps.FortifyStep;
import com.google.common.collect.ImmutableSet;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.steps.SynchronousNonBlockingStepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class FortifyUpdate
extends FortifyStep {
    private String updateServerURL;
    private String locale;
    private boolean acceptKey = false;
    private transient String proxyURL;
    private transient String proxyUsername;
    private transient String proxyPassword;
    private transient boolean useProxy;

    @DataBoundConstructor
    public FortifyUpdate(String updateServerURL, String locale) {
        this.updateServerURL = updateServerURL;
        this.locale = locale;
    }

    @Deprecated
    public FortifyUpdate(String updateServerURL, String proxyURL, String proxyUsername, String proxyPassword, boolean useProxy) {
        this.updateServerURL = updateServerURL;
        this.proxyURL = proxyURL;
        this.proxyUsername = proxyUsername;
        this.proxyPassword = proxyPassword;
        this.useProxy = useProxy;
    }

    public String getUpdateServerURL() {
        return this.updateServerURL;
    }

    public String getLocale() {
        return this.locale;
    }

    @DataBoundSetter
    public void setAcceptKey(boolean accpeptKey) {
        this.acceptKey = accpeptKey;
    }

    public boolean getAcceptKey() {
        return this.acceptKey;
    }

    @Deprecated
    public String getProxyURL() {
        return this.proxyURL;
    }

    @Deprecated
    public String getProxyUsername() {
        return this.proxyUsername;
    }

    @Deprecated
    public String getProxyPassword() {
        return this.proxyPassword;
    }

    @Deprecated
    public boolean getUseProxy() {
        return this.useProxy;
    }

    @DataBoundSetter
    public void setUpdateServerURL(String updateServerURL) {
        this.updateServerURL = updateServerURL;
    }

    @DataBoundSetter
    public void setLocale(String locale) {
        this.locale = locale;
    }

    @DataBoundSetter
    @Deprecated
    public void setProxyURL(String proxyURL) {
        this.proxyURL = proxyURL;
    }

    @DataBoundSetter
    @Deprecated
    public void setProxyUsername(String proxyUsername) {
        this.proxyUsername = proxyUsername;
    }

    @DataBoundSetter
    @Deprecated
    public void setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
    }

    @DataBoundSetter
    @Deprecated
    public void setUseProxy(boolean useProxy) {
        this.useProxy = useProxy;
    }

    public String getResolvedUpdateServerURL(TaskListener listener) {
        return this.resolve(this.getUpdateServerURL(), listener);
    }

    public String getResolvedLocale(TaskListener listener) {
        return this.resolve(this.getLocale(), listener);
    }

    @Deprecated
    public String getResolvedUpdateProxyURL(TaskListener listener) {
        return this.resolve(this.getProxyURL(), listener);
    }

    @Deprecated
    public String getResolvedUpdateProxyUsername(TaskListener listener) {
        return this.resolve(this.getProxyUsername(), listener);
    }

    @Deprecated
    public String getResolvedUpdateProxyPassword(TaskListener listener) {
        return this.resolve(this.getProxyPassword(), listener);
    }

    @Override
    public StepExecution start(StepContext context) throws Exception {
        return new Execution(this, context);
    }

    public void perform(Run<?, ?> build, FilePath workspace, EnvVars vars, Launcher launcher, TaskListener listener) throws InterruptedException, IOException {
        Pair<String, Integer> hostAndPort;
        String proxyUrl;
        ProxyConfig proxyConfig;
        String localeStr;
        PrintStream log = listener.getLogger();
        log.println("Fortify Jenkins plugin v " + VERSION);
        log.println("Launching fortifyupdate command");
        LinkedList<Pair> cmdsAndMasks = new LinkedList<Pair>();
        String fortifyUpdate = this.getFortifyUpdateExecutable(build, workspace, launcher, listener, vars);
        cmdsAndMasks.add(Pair.of((Object)fortifyUpdate, (Object)Boolean.FALSE));
        String updateServerUrl = this.getResolvedUpdateServerURL(listener);
        if (!StringUtils.isBlank((String)updateServerUrl)) {
            try {
                URL url = new URL(updateServerUrl);
                if ("http".equalsIgnoreCase(url.getProtocol()) || "https".equalsIgnoreCase(url.getProtocol())) {
                    cmdsAndMasks.add(Pair.of((Object)"-url", (Object)Boolean.FALSE));
                    cmdsAndMasks.add(Pair.of((Object)updateServerUrl, (Object)Boolean.FALSE));
                } else {
                    log.println(Messages.ForitfyUpdate_URL_Protocol_Warning(updateServerUrl));
                }
                if (Boolean.TRUE.equals(this.getAcceptKey())) {
                    cmdsAndMasks.add(Pair.of((Object)"-acceptKey", (Object)Boolean.FALSE));
                }
            }
            catch (MalformedURLException mue) {
                log.println(Messages.FortifyUpdate_URL_Invalid(updateServerUrl));
            }
        }
        if (!StringUtils.isBlank((String)(localeStr = this.getResolvedLocale(listener)))) {
            cmdsAndMasks.add(Pair.of((Object)"-locale", (Object)Boolean.FALSE));
            cmdsAndMasks.add(Pair.of((Object)localeStr, (Object)Boolean.FALSE));
        }
        if (FortifyPlugin.DESCRIPTOR.getIsProxy() && (proxyConfig = FortifyPlugin.DESCRIPTOR.getProxyConfig()) != null && !StringUtils.isBlank((String)(proxyUrl = proxyConfig.getProxyUrlFor(StringUtils.isBlank((String)updateServerUrl) ? "https://update.fortify.com" : updateServerUrl))) && !StringUtils.isBlank((String)((String)(hostAndPort = ProxyConfig.parseProxyHostAndPort(proxyUrl)).getLeft()))) {
            cmdsAndMasks.add(Pair.of((Object)"-proxyhost", (Object)Boolean.FALSE));
            cmdsAndMasks.add(Pair.of((Object)hostAndPort.getLeft(), (Object)Boolean.FALSE));
            cmdsAndMasks.add(Pair.of((Object)"-proxyport", (Object)Boolean.FALSE));
            cmdsAndMasks.add(Pair.of((Object)String.valueOf((Integer)hostAndPort.getRight()), (Object)Boolean.FALSE));
            String username = Secret.toString((Secret)proxyConfig.getProxyUsername());
            if (!StringUtils.isBlank((String)username)) {
                cmdsAndMasks.add(Pair.of((Object)"-proxyUsername", (Object)Boolean.FALSE));
                cmdsAndMasks.add(Pair.of((Object)username, (Object)Boolean.TRUE));
                String pwd = Secret.toString((Secret)proxyConfig.getProxyPassword());
                if (!StringUtils.isBlank((String)pwd)) {
                    cmdsAndMasks.add(Pair.of((Object)"-proxyPassword", (Object)Boolean.FALSE));
                    cmdsAndMasks.add(Pair.of((Object)pwd, (Object)Boolean.TRUE));
                }
            }
        }
        ArrayList args = new ArrayList(cmdsAndMasks.size());
        boolean[] masks = new boolean[cmdsAndMasks.size()];
        cmdsAndMasks.stream().forEach(p -> {
            args.add(p.getLeft());
            masks[cmdsAndMasks.indexOf((Object)p)] = (Boolean)p.getRight();
        });
        Launcher.ProcStarter p2 = launcher.launch().cmds(args).masks(masks).envs((Map)vars).stdout((OutputStream)log).stderr((OutputStream)log).pwd(workspace);
        int exitcode = p2.start().join();
        log.println(Messages.FortifyUpdate_Result(exitcode));
        if (exitcode != 0) {
            build.setResult(Result.FAILURE);
            throw new AbortException(Messages.FortifyUpdate_Error());
        }
    }

    private String getFortifyUpdateExecutable(Run<?, ?> build, FilePath workspace, Launcher launcher, TaskListener listener, EnvVars vars) throws InterruptedException, IOException {
        return this.getExecutable("fortifyupdate" + (launcher.isUnix() ? "" : ".cmd"), build, workspace, listener, "FORTIFY_HOME", vars);
    }

    public static class Builder {
        private String updateServerURL;
        private String locale;
        private Boolean acceptKey = Boolean.FALSE;

        public Builder updateServerURL(String updateServerURL) {
            if (StringUtils.isNotBlank((String)updateServerURL)) {
                this.updateServerURL = updateServerURL;
            }
            return this;
        }

        public Builder locale(String localeString) {
            if (StringUtils.isNotBlank((String)localeString)) {
                this.locale = localeString;
            }
            return this;
        }

        public Builder acceptKey(Boolean acceptKey) {
            this.acceptKey = acceptKey == null ? Boolean.FALSE : acceptKey;
            return this;
        }

        public FortifyUpdate build() {
            FortifyUpdate fortifyUpdate = new FortifyUpdate(this.updateServerURL, this.locale);
            fortifyUpdate.setAcceptKey(this.acceptKey);
            return fortifyUpdate;
        }
    }

    private static class Execution
    extends SynchronousNonBlockingStepExecution<Void> {
        private transient FortifyUpdate fu;
        private static final long serialVersionUID = 1L;

        protected Execution(FortifyUpdate fu, StepContext context) {
            super(context);
            this.fu = fu;
        }

        protected Void run() throws Exception {
            StepContext context = this.getContext();
            ((TaskListener)context.get(TaskListener.class)).getLogger().println("Running FortifyUpdate step");
            if (!((FilePath)context.get(FilePath.class)).exists()) {
                ((FilePath)context.get(FilePath.class)).mkdirs();
            }
            this.fu.perform((Run)context.get(Run.class), (FilePath)context.get(FilePath.class), (EnvVars)context.get(EnvVars.class), (Launcher)context.get(Launcher.class), (TaskListener)context.get(TaskListener.class));
            return null;
        }
    }

    @Extension
    public static class DescriptorImpl
    extends StepDescriptor {
        private static final String DEFAULT_URL = "https://update.fortify.com";

        public String getDefaultURL() {
            return DEFAULT_URL;
        }

        public String getFunctionName() {
            return "fortifyUpdate";
        }

        public String getDisplayName() {
            return Messages.FortifyUpdate_DisplayName();
        }

        public Set<? extends Class<?>> getRequiredContext() {
            return ImmutableSet.of(Run.class, FilePath.class, EnvVars.class, Launcher.class, TaskListener.class);
        }

        public ListBoxModel doFillLocaleItems(@QueryParameter String locale) {
            ListBoxModel items = new ListBoxModel();
            items.add("English", "en");
            items.add("Chinese Simplified", "zh_CN");
            items.add("Chinese Traditional", "zh_TW");
            items.add("Japanese", "ja");
            items.add("Korean", "ko");
            items.add("Portuguese (Brazil)", "pt_BR");
            items.add("Spanish", "es");
            if (StringUtils.isBlank((String)locale)) {
                ((ListBoxModel.Option)items.get((int)0)).selected = true;
            }
            return items;
        }
    }
}

