/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.plugin.jenkins.steps;

import com.fortify.plugin.jenkins.Messages;
import com.fortify.plugin.jenkins.steps.FortifySCAStep;
import com.fortify.plugin.jenkins.steps.Validators;
import com.fortify.plugin.jenkins.steps.types.AdvancedScanType;
import com.fortify.plugin.jenkins.steps.types.DevenvScanType;
import com.fortify.plugin.jenkins.steps.types.DotnetSourceScanType;
import com.fortify.plugin.jenkins.steps.types.GradleScanType;
import com.fortify.plugin.jenkins.steps.types.JavaScanType;
import com.fortify.plugin.jenkins.steps.types.MavenScanType;
import com.fortify.plugin.jenkins.steps.types.MsbuildScanType;
import com.fortify.plugin.jenkins.steps.types.OtherScanType;
import com.fortify.plugin.jenkins.steps.types.ProjectScanType;
import com.google.common.collect.ImmutableSet;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.Node;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.util.FormValidation;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.steps.SynchronousNonBlockingStepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class FortifyTranslate
extends FortifySCAStep {
    private ProjectScanType projectScanType;
    private String excludeList;
    private Node currentNode;

    @DataBoundConstructor
    public FortifyTranslate(String buildID, ProjectScanType projectScanType) {
        this.buildID = buildID;
        this.projectScanType = projectScanType;
    }

    public void setCurrentNode(Node node) {
        this.currentNode = node;
    }

    public ProjectScanType getProjectScanType() {
        return this.projectScanType;
    }

    public void setJavaVersion(String javaVersion) {
        ((JavaScanType)this.projectScanType).setJavaVersion(javaVersion);
    }

    public void setJavaClasspath(String javaClasspath) {
        ((JavaScanType)this.projectScanType).setJavaClasspath(javaClasspath);
    }

    public void setJavaSrcFiles(String javaSrcFiles) {
        ((JavaScanType)this.projectScanType).setJavaSrcFiles(javaSrcFiles);
    }

    public void setJavaAddOptions(String javaAddOptions) {
        ((JavaScanType)this.projectScanType).setJavaAddOptions(javaAddOptions);
    }

    public void setDotnetProject(String dotnetProject) {
        if (this.projectScanType instanceof DevenvScanType) {
            ((DevenvScanType)this.projectScanType).setDotnetProject(dotnetProject);
        } else {
            ((MsbuildScanType)this.projectScanType).setDotnetProject(dotnetProject);
        }
    }

    public void setDotnetAddOptions(String dotnetAddOptions) {
        if (this.projectScanType instanceof DevenvScanType) {
            ((DevenvScanType)this.projectScanType).setDotnetAddOptions(dotnetAddOptions);
        } else if (this.projectScanType instanceof MsbuildScanType) {
            ((MsbuildScanType)this.projectScanType).setDotnetAddOptions(dotnetAddOptions);
        } else {
            ((DotnetSourceScanType)this.projectScanType).setDotnetAddOptions(dotnetAddOptions);
        }
    }

    public void setDotnetFrameworkVersion(String dotnetFrameworkVersion) {
        ((DotnetSourceScanType)this.projectScanType).setDotnetFrameworkVersion(dotnetFrameworkVersion);
    }

    public void setDotnetLibdirs(String dotnetLibdirs) {
        ((DotnetSourceScanType)this.projectScanType).setDotnetLibdirs(dotnetLibdirs);
    }

    public void setDotnetSrcFiles(String dotnetSrcFiles) {
        ((DotnetSourceScanType)this.projectScanType).setDotnetSrcFiles(dotnetSrcFiles);
    }

    public void setMavenOptions(String mavenOptions) {
        ((MavenScanType)this.projectScanType).setMavenOptions(mavenOptions);
    }

    public void setMavenName(String mName) {
        ((MavenScanType)this.projectScanType).setMavenInstallationName(mName);
    }

    public void setUseWrapper(boolean useWrapper) {
        ((GradleScanType)this.projectScanType).setUseWrapper(useWrapper);
    }

    public void setGradleTasks(String gradleTasks) {
        ((GradleScanType)this.projectScanType).setGradleTasks(gradleTasks);
    }

    public void setGradleOptions(String gradleOptions) {
        ((GradleScanType)this.projectScanType).setGradleOptions(gradleOptions);
    }

    public void setOtherOptions(String otherOptions) {
        ((OtherScanType)this.projectScanType).setOtherOptions(otherOptions);
    }

    public void setOtherIncludesList(String otherIncludesList) {
        ((OtherScanType)this.projectScanType).setOtherIncludesList(otherIncludesList);
    }

    public void setAdvOptions(String advOptions) {
        ((AdvancedScanType)this.projectScanType).setAdvOptions(advOptions);
    }

    public String getExcludeList() {
        return this.excludeList;
    }

    @DataBoundSetter
    public void setExcludeList(String excludeList) {
        this.excludeList = excludeList;
    }

    public String getResolvedJavaClasspath(JavaScanType javaType, TaskListener listener) {
        return this.resolve(javaType.getJavaClasspath(), listener);
    }

    public String getResolvedJavaSrcFiles(JavaScanType javaType, TaskListener listener) {
        return this.resolve(javaType.getJavaSrcFiles(), listener);
    }

    public String getResolvedJavaAddOptions(JavaScanType javaType, TaskListener listener) {
        return this.resolve(javaType.getJavaAddOptions(), listener);
    }

    public String getResolvedDotnetProjects(ProjectScanType projectScanType, TaskListener listener) {
        if (projectScanType instanceof DevenvScanType) {
            return this.resolve(((DevenvScanType)projectScanType).getDotnetProject(), listener);
        }
        return this.resolve(((MsbuildScanType)projectScanType).getDotnetProject(), listener);
    }

    public String getResolvedDotnetAddOptions(ProjectScanType projectScanType, TaskListener listener) {
        if (projectScanType instanceof DevenvScanType) {
            return this.resolve(((DevenvScanType)projectScanType).getDotnetAddOptions(), listener);
        }
        if (projectScanType instanceof MsbuildScanType) {
            return this.resolve(((MsbuildScanType)projectScanType).getDotnetAddOptions(), listener);
        }
        return this.resolve(((DotnetSourceScanType)projectScanType).getDotnetAddOptions(), listener);
    }

    public String getResolvedDotnetFrameworkVersion(DotnetSourceScanType dotnetSrcType, TaskListener listener) {
        return this.resolve(dotnetSrcType.getDotnetFrameworkVersion(), listener);
    }

    public String getResolvedDotnetLibdirs(DotnetSourceScanType dotnetSrcType, TaskListener listener) {
        return this.resolve(dotnetSrcType.getDotnetLibdirs(), listener);
    }

    public String getResolvedDotnetSrcFiles(DotnetSourceScanType dotnetSrcType, TaskListener listener) {
        return this.resolve(dotnetSrcType.getDotnetSrcFiles(), listener);
    }

    public String getResolvedMavenOptions(MavenScanType mavenType, TaskListener listener) {
        return this.resolve(mavenType.getMavenOptions(), listener);
    }

    public String getResolvedGradleTasks(GradleScanType gradleType, TaskListener listener) {
        return this.resolve(gradleType.getGradleTasks(), listener);
    }

    public String getResolvedGradleOptions(GradleScanType gradleType, TaskListener listener) {
        return this.resolve(gradleType.getGradleOptions(), listener);
    }

    public String getResolvedOtherOptions(OtherScanType otherType, TaskListener listener) {
        return this.resolve(otherType.getOtherOptions(), listener);
    }

    public String getResolvedOtherIncludesList(OtherScanType otherType, TaskListener listener) {
        return this.resolve(otherType.getOtherIncludesList(), listener);
    }

    public String getResolvedTranslationExcludeList(TaskListener listener) {
        return this.resolve(this.getExcludeList(), listener);
    }

    public String getResolvedAdvOptions(AdvancedScanType advType, TaskListener listener) {
        return this.resolve(advType.getAdvOptions(), listener);
    }

    @Override
    public StepExecution start(StepContext context) throws Exception {
        return new Execution(this, context);
    }

    public void perform(Run<?, ?> build, FilePath workspace, EnvVars vars, Launcher launcher, TaskListener listener) throws InterruptedException, IOException {
        String option;
        this.setLastBuild(build);
        PrintStream log = listener.getLogger();
        log.println("Fortify Jenkins plugin v " + VERSION);
        log.println("Launching Fortify SCA translate command");
        String projectRoot = workspace.child(".fortify").getRemote();
        String sourceanalyzer = this.getSourceAnalyzerExecutable(build, workspace, launcher, listener, vars);
        ArrayList<String> args = new ArrayList<String>();
        args.add(sourceanalyzer);
        args.add("-Dcom.fortify.sca.ProjectRoot=" + projectRoot);
        args.add("-b");
        args.add(this.getResolvedBuildID(listener));
        Integer intOption = this.getResolvedMaxHeap(listener);
        if (intOption != null) {
            args.add("-Xmx" + intOption + "M");
        }
        if (StringUtils.isNotEmpty((String)(option = this.getResolvedAddJVMOptions(listener)))) {
            this.addAllArguments(args, option);
        }
        if (StringUtils.isNotEmpty((String)(option = this.getResolvedLogFile(listener)))) {
            args.add("-logfile");
            args.add(option);
        }
        if (this.getDebug()) {
            args.add("-debug");
        }
        if (this.getVerbose()) {
            args.add("-verbose");
        }
        if (this.projectScanType instanceof AdvancedScanType) {
            log.println("Running Advanced translation");
            option = this.getResolvedAdvOptions((AdvancedScanType)this.projectScanType, listener);
            if (StringUtils.isNotEmpty((String)option)) {
                this.addAllArguments(args, option);
            }
        } else if (this.projectScanType instanceof JavaScanType) {
            log.println("Running Java translation");
            option = this.getResolvedTranslationExcludeList(listener);
            if (StringUtils.isNotEmpty((String)option)) {
                this.addAllArguments(args, option, "-exclude");
            }
            if (StringUtils.isNotEmpty((String)(option = ((JavaScanType)this.projectScanType).getJavaVersion()))) {
                args.add("-source");
                args.add(option);
            }
            if (StringUtils.isNotEmpty((String)(option = this.getResolvedJavaClasspath((JavaScanType)this.projectScanType, listener)))) {
                args.add("-cp");
                args.add(option);
            }
            if (StringUtils.isNotEmpty((String)(option = this.getResolvedJavaAddOptions((JavaScanType)this.projectScanType, listener)))) {
                this.addAllArguments(args, option);
            }
            if (StringUtils.isNotEmpty((String)(option = this.getResolvedJavaSrcFiles((JavaScanType)this.projectScanType, listener)))) {
                this.addAllArguments(args, option);
            }
        } else if (this.projectScanType instanceof DevenvScanType) {
            log.println("Running .NET devenv translation");
            option = this.getResolvedTranslationExcludeList(listener);
            if (StringUtils.isNotEmpty((String)option)) {
                this.addAllArguments(args, option, "-exclude");
            }
            args.add(this.getDevenvExecutable(build, workspace, launcher, listener, vars));
            option = this.getResolvedDotnetProjects(this.projectScanType, listener);
            if (StringUtils.isNotEmpty((String)option)) {
                args.add(option);
            }
            if (StringUtils.isNotEmpty((String)(option = this.getResolvedDotnetAddOptions(this.projectScanType, listener)))) {
                this.addAllArguments(args, option);
            }
        } else if (this.projectScanType instanceof MsbuildScanType) {
            log.println("Running .NET MSBuild translation");
            option = this.getResolvedTranslationExcludeList(listener);
            if (StringUtils.isNotEmpty((String)option)) {
                this.addAllArguments(args, option, "-exclude");
            }
            args.add(this.getMSBuildExecutable(build, workspace, launcher, listener, vars));
            option = this.getResolvedDotnetProjects(this.projectScanType, listener);
            if (StringUtils.isNotEmpty((String)option)) {
                args.add(option);
            }
            if (StringUtils.isNotEmpty((String)(option = this.getResolvedDotnetAddOptions(this.projectScanType, listener)))) {
                this.addAllArguments(args, option);
            }
        } else if (this.projectScanType instanceof DotnetSourceScanType) {
            log.println("Running .NET source code translation");
            option = this.getResolvedTranslationExcludeList(listener);
            if (StringUtils.isNotEmpty((String)option)) {
                this.addAllArguments(args, option, "-exclude");
            }
            if (StringUtils.isNotEmpty((String)(option = this.getResolvedDotnetFrameworkVersion((DotnetSourceScanType)this.projectScanType, listener)))) {
                args.add("-dotnet-version");
                args.add(option);
            }
            if (StringUtils.isNotEmpty((String)(option = this.getResolvedDotnetLibdirs((DotnetSourceScanType)this.projectScanType, listener)))) {
                args.add("-libdirs");
                args.add(option);
            }
            if (StringUtils.isNotEmpty((String)(option = this.getResolvedDotnetAddOptions(this.projectScanType, listener)))) {
                this.addAllArguments(args, option);
            }
            if (StringUtils.isNotEmpty((String)(option = this.getResolvedDotnetSrcFiles((DotnetSourceScanType)this.projectScanType, listener)))) {
                this.addAllArguments(args, option);
            }
        } else if (this.projectScanType instanceof MavenScanType) {
            log.println("Running Maven 3 translation");
            String mavenInstallationName = ((MavenScanType)this.projectScanType).getMavenInstallationName();
            args.add(this.getMavenExecutable(build, workspace, launcher, listener, mavenInstallationName, this.currentNode, vars));
            option = this.getResolvedTranslationExcludeList(listener);
            if (StringUtils.isNotEmpty((String)option)) {
                this.addMavenExcludes(args, option, launcher.isUnix());
            }
            if (StringUtils.isNotEmpty((String)(option = this.getResolvedMavenOptions((MavenScanType)this.projectScanType, listener)))) {
                this.addAllArguments(args, option);
            }
        } else if (this.projectScanType instanceof GradleScanType) {
            log.println("Running Gradle translation");
            if (this.getVerbose()) {
                args.add("-gradle");
            }
            String gradleInstallationName = ((GradleScanType)this.projectScanType).getGradleInstallationName();
            option = this.getResolvedTranslationExcludeList(listener);
            if (StringUtils.isNotEmpty((String)option)) {
                this.addAllArguments(args, option, "-exclude");
            }
            args.add(this.getGradleExecutable(((GradleScanType)this.projectScanType).getUseWrapper(), build, workspace, launcher, listener, gradleInstallationName, this.currentNode, vars));
            option = this.getResolvedGradleOptions((GradleScanType)this.projectScanType, listener);
            if (StringUtils.isNotEmpty((String)option)) {
                this.addAllArguments(args, option);
            }
            if (StringUtils.isNotEmpty((String)(option = this.getResolvedGradleTasks((GradleScanType)this.projectScanType, listener)))) {
                this.addAllArguments(args, option);
            }
        } else if (this.projectScanType instanceof OtherScanType) {
            log.println("Running Other translation");
            option = this.getResolvedTranslationExcludeList(listener);
            if (StringUtils.isNotEmpty((String)option)) {
                this.addAllArguments(args, option, "-exclude");
            }
            if (StringUtils.isNotEmpty((String)(option = this.getResolvedOtherOptions((OtherScanType)this.projectScanType, listener)))) {
                this.addAllArguments(args, option);
            }
            if (StringUtils.isNotEmpty((String)(option = this.getResolvedOtherIncludesList((OtherScanType)this.projectScanType, listener)))) {
                this.addAllArguments(args, option);
            }
        }
        Launcher.ProcStarter ps = launcher.decorateByEnv(vars).launch().pwd(workspace).cmds(args).envs((Map)vars).stdout((OutputStream)listener.getLogger()).stderr((OutputStream)listener.getLogger());
        int exitcode = ps.join();
        log.println(Messages.FortifyTranslate_Result(exitcode));
        if (exitcode != 0) {
            build.setResult(Result.FAILURE);
            throw new AbortException(Messages.FortifyTranslate_Error());
        }
    }

    private void addMavenExcludes(List<String> args, String argsToAdd, boolean isUnix) {
        StringBuilder excludeParam = new StringBuilder();
        Iterator<String> itr = Arrays.asList(Util.tokenize((String)argsToAdd)).iterator();
        while (itr.hasNext()) {
            excludeParam.append(itr.next());
            if (!itr.hasNext()) continue;
            excludeParam.append(isUnix ? ":" : ";");
        }
        args.add("-Dfortify.sca.exclude=" + excludeParam.toString());
    }

    private static class Execution
    extends SynchronousNonBlockingStepExecution<Void> {
        private transient FortifyTranslate ft;
        private static final long serialVersionUID = 1L;

        protected Execution(FortifyTranslate ft, StepContext context) {
            super(context);
            this.ft = ft;
        }

        protected Void run() throws Exception {
            StepContext context = this.getContext();
            TaskListener taskListener = (TaskListener)context.get(TaskListener.class);
            taskListener.getLogger().println("Running FortifyTranslate step");
            FilePath workspace = (FilePath)context.get(FilePath.class);
            if (!workspace.exists()) {
                workspace.mkdirs();
            }
            this.ft.setCurrentNode((Node)context.get(Node.class));
            this.ft.perform((Run)context.get(Run.class), workspace, (EnvVars)context.get(EnvVars.class), (Launcher)context.get(Launcher.class), taskListener);
            return null;
        }
    }

    @Extension
    public static class DescriptorImpl
    extends StepDescriptor {
        public DescriptorImpl() {
            this.load();
        }

        public String getFunctionName() {
            return "fortifyTranslate";
        }

        public String getDisplayName() {
            return Messages.FortifyTranslate_DisplayName();
        }

        public Set<? extends Class<?>> getRequiredContext() {
            return ImmutableSet.of(Run.class, FilePath.class, EnvVars.class, Launcher.class, TaskListener.class);
        }

        public FormValidation doCheckBuildID(@QueryParameter String value) {
            return Validators.checkFieldNotEmpty(value);
        }

        public FormValidation doCheckMaxHeap(@QueryParameter String value) {
            return Validators.checkValidInteger(value);
        }
    }
}

