/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.plugin.jenkins.steps;

import com.fortify.plugin.jenkins.FindExecutableRemoteService;
import com.fortify.plugin.jenkins.FortifyPlugin;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Run;
import hudson.model.StreamBuildListener;
import hudson.model.TaskListener;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import jenkins.tasks.SimpleBuildStep;
import org.apache.commons.lang3.tuple.Pair;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepExecution;

public abstract class FortifyStep
extends Step
implements SimpleBuildStep {
    public static final String VERSION = FortifyPlugin.getPluginVersion();
    protected Run<?, ?> lastBuild;

    protected void setLastBuild(Run<?, ?> lastBuild) {
        this.lastBuild = lastBuild;
    }

    protected String getExecutable(String filename, Run<?, ?> build, FilePath workspace, TaskListener listener, String targetEnvVarName, EnvVars env) throws InterruptedException, IOException {
        PrintStream logger = listener.getLogger();
        String home = null;
        String path = null;
        boolean isEnvVarSetProperly = true;
        if (targetEnvVarName != null && !targetEnvVarName.equalsIgnoreCase("PATH") && (home = (String)env.get((Object)targetEnvVarName)) != null && FortifyStep.endsWithBin(home = home.trim())) {
            logger.println("WARNING: Environment variable " + targetEnvVarName + " should not point to bin directory");
            isEnvVarSetProperly = false;
        }
        for (Map.Entry entry : env.entrySet()) {
            String envVarName = (String)entry.getKey();
            if (!"PATH".equalsIgnoreCase(targetEnvVarName)) continue;
            path = (String)env.get((Object)envVarName);
        }
        return this.findExecutablePath(filename, home, path, workspace, logger, targetEnvVarName, isEnvVarSetProperly);
    }

    private static boolean endsWithBin(String str) {
        return str.endsWith("bin") || str.endsWith("bin/") || str.endsWith("bin\\");
    }

    private String findExecutablePath(String filename, String home, String path, FilePath workspace, PrintStream logger, String targetEnvVarName, boolean isEnvVarSetProperly) throws IOException, InterruptedException {
        String executablePath = (String)workspace.act((FilePath.FileCallable)new FindExecutableRemoteService(filename, home, path, workspace));
        if (executablePath == null) {
            throw new FileNotFoundException("ERROR: executable not found: " + filename + "; " + this.composeEnvVarErrorMessage(filename, targetEnvVarName, isEnvVarSetProperly));
        }
        logger.printf("Found executable: %s%n", executablePath);
        return executablePath;
    }

    private String composeEnvVarErrorMessage(String filename, String targetEnvVarName, boolean isEnvVarSetProperly) {
        StringBuilder errorMsg = new StringBuilder();
        errorMsg.append("make sure that either ");
        if (targetEnvVarName != null) {
            errorMsg.append(targetEnvVarName).append(" environment variable is set");
            if (!isEnvVarSetProperly) {
                errorMsg.append(" properly");
            }
            errorMsg.append(" or ");
        }
        errorMsg.append(filename).append(" is on the PATH or in workspace");
        return errorMsg.toString();
    }

    protected String resolve(String param, TaskListener listener) {
        if (param == null) {
            return "";
        }
        if (this.lastBuild == null) {
            return param;
        }
        listener = listener == null ? new StreamBuildListener(System.out, Charset.defaultCharset()) : listener;
        try {
            EnvVars vars = this.lastBuild.getEnvironment(listener);
            return vars.expand(param);
        }
        catch (IOException iOException) {
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return param;
    }

    public boolean prebuild(AbstractBuild<?, ?> build, BuildListener listener) {
        return false;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        if (build != null && launcher != null && listener != null && build.getWorkspace() != null) {
            this.perform((Run)build, build.getWorkspace(), build.getEnvironment((TaskListener)listener), launcher, (TaskListener)listener);
        }
        return true;
    }

    public Action getProjectAction(AbstractProject<?, ?> project) {
        return null;
    }

    public Collection<? extends Action> getProjectActions(AbstractProject<?, ?> project) {
        return Collections.emptyList();
    }

    public StepExecution start(StepContext arg0) throws Exception {
        return null;
    }

    protected void addAllArguments(List<String> args, String argsToAdd) {
        for (String s : Util.tokenize((String)argsToAdd)) {
            args.add(s);
        }
    }

    protected void addAllArguments(List<String> args, String argsToAdd, String flag) {
        for (String s : Util.tokenize((String)argsToAdd)) {
            args.add(flag);
            args.add(s);
        }
    }

    protected void addAllArgumentsWithNoMasks(List<Pair<String, Boolean>> args, String argsToAdd, String flag) {
        for (String s : Util.tokenize((String)argsToAdd)) {
            args.add((Pair<String, Boolean>)Pair.of((Object)flag, (Object)Boolean.FALSE));
            args.add((Pair<String, Boolean>)Pair.of((Object)s, (Object)Boolean.FALSE));
        }
    }
}

