/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.plugin.jenkins.steps;

import com.fortify.plugin.jenkins.FortifyPlugin;
import com.fortify.plugin.jenkins.Messages;
import com.fortify.plugin.jenkins.PathUtils;
import com.fortify.plugin.jenkins.steps.FortifySCAStep;
import com.fortify.plugin.jenkins.steps.Validators;
import com.google.common.collect.ImmutableSet;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.util.FormValidation;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.steps.SynchronousNonBlockingStepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class FortifyScan
extends FortifySCAStep {
    private String resultsFile;
    private String customRulepacks;
    private String addOptions;

    @DataBoundConstructor
    public FortifyScan(String buildID) {
        this.buildID = buildID;
    }

    public String getResolvedResultsFile(TaskListener listener) {
        String s = this.resolve(this.getResultsFile(), listener);
        return PathUtils.appendExtentionIfNotEmpty(s, ".fpr", new String[0]);
    }

    public String getResolvedCustomRulepacks(TaskListener listener) {
        return this.resolve(this.getCustomRulepacks(), listener);
    }

    public String getResolvedAddOptions(TaskListener listener) {
        return this.resolve(this.getAddOptions(), listener);
    }

    public String getResultsFile() {
        return this.resultsFile;
    }

    @DataBoundSetter
    public void setResultsFile(String resultsFile) {
        this.resultsFile = resultsFile;
    }

    public String getCustomRulepacks() {
        return this.customRulepacks;
    }

    @DataBoundSetter
    public void setCustomRulepacks(String customRulepacks) {
        this.customRulepacks = customRulepacks;
    }

    public String getAddOptions() {
        return this.addOptions;
    }

    @DataBoundSetter
    public void setAddOptions(String addOptions) {
        this.addOptions = addOptions;
    }

    @Override
    public StepExecution start(StepContext context) throws Exception {
        return new Execution(this, context);
    }

    public void perform(Run<?, ?> build, FilePath workspace, EnvVars vars, Launcher launcher, TaskListener listener) throws InterruptedException, IOException {
        String option;
        this.setLastBuild(build);
        PrintStream log = listener.getLogger();
        log.println("Fortify Jenkins plugin v " + VERSION);
        log.println("Launching Fortify SCA scan command");
        String projectRoot = workspace.child(".fortify").getRemote();
        String sourceanalyzer = null;
        if (sourceanalyzer == null) {
            sourceanalyzer = this.getSourceAnalyzerExecutable(build, workspace, launcher, listener, vars);
        }
        ArrayList<String> args = new ArrayList<String>();
        args.add(sourceanalyzer);
        args.add("-Dcom.fortify.sca.ProjectRoot=" + projectRoot);
        args.add("-b");
        args.add(this.getResolvedBuildID(listener));
        Integer intOption = this.getResolvedMaxHeap(listener);
        if (intOption != null) {
            args.add("-Xmx" + intOption + "M");
        }
        if (StringUtils.isNotEmpty((String)(option = this.getResolvedAddJVMOptions(listener)))) {
            this.addAllArguments(args, option);
        }
        if (StringUtils.isNotEmpty((String)(option = this.getResolvedLogFile(listener)))) {
            args.add("-logfile");
            args.add(option);
        }
        if (this.getDebug()) {
            args.add("-debug");
        }
        if (this.getVerbose()) {
            args.add("-verbose");
        }
        args.add("-scan");
        args.add("-f");
        option = this.getResolvedResultsFile(listener);
        if (StringUtils.isNotEmpty((String)option)) {
            args.add(option);
        } else {
            args.add("scan.fpr");
        }
        option = this.getResolvedCustomRulepacks(listener);
        if (StringUtils.isNotEmpty((String)option)) {
            args.add("-rules");
            args.add(option);
        }
        if (StringUtils.isNotEmpty((String)(option = this.getResolvedAddOptions(listener)))) {
            this.addAllArguments(args, option);
        }
        Launcher.ProcStarter ps = launcher.decorateByEnv(vars).launch().pwd(workspace).cmds(args).envs((Map)vars).stdout((OutputStream)listener.getLogger()).stderr((OutputStream)listener.getLogger());
        int exitcode = ps.join();
        log.println(Messages.FortifyScan_Result(exitcode));
        if (exitcode != 0) {
            build.setResult(Result.FAILURE);
            throw new AbortException(Messages.FortifyScan_Error());
        }
    }

    private static class Execution
    extends SynchronousNonBlockingStepExecution<Void> {
        private transient FortifyScan fs;
        private static final long serialVersionUID = 1L;

        protected Execution(FortifyScan fs, StepContext context) {
            super(context);
            this.fs = fs;
        }

        protected Void run() throws Exception {
            if (FortifyPlugin.DESCRIPTOR.isDisableLocalScans()) {
                throw new AbortException(Messages.FortifyScan_Local_NotSupported());
            }
            StepContext context = this.getContext();
            ((TaskListener)context.get(TaskListener.class)).getLogger().println("Running FortifyScan step");
            if (!((FilePath)context.get(FilePath.class)).exists()) {
                ((FilePath)context.get(FilePath.class)).mkdirs();
            }
            this.fs.perform((Run)context.get(Run.class), (FilePath)context.get(FilePath.class), (EnvVars)context.get(EnvVars.class), (Launcher)context.get(Launcher.class), (TaskListener)context.get(TaskListener.class));
            return null;
        }
    }

    @Extension
    public static class DescriptorImpl
    extends StepDescriptor {
        public String getFunctionName() {
            return "fortifyScan";
        }

        public String getDisplayName() {
            return Messages.FortifyScan_DisplayName();
        }

        public Set<? extends Class<?>> getRequiredContext() {
            return ImmutableSet.of(Run.class, FilePath.class, EnvVars.class, Launcher.class, TaskListener.class);
        }

        public FormValidation doCheckBuildID(@QueryParameter String value) {
            return Validators.checkFieldNotEmpty(value);
        }

        public FormValidation doCheckMaxHeap(@QueryParameter String value) {
            return Validators.checkValidInteger(value);
        }
    }
}

