/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.plugin.jenkins.steps;

import com.fortify.plugin.jenkins.steps.FortifyStep;
import hudson.DescriptorExtensionList;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Node;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.gradle.GradleInstallation;
import hudson.tasks.Maven;
import hudson.tools.ToolDescriptor;
import hudson.tools.ToolInstallation;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.kohsuke.stapler.DataBoundSetter;

public abstract class FortifySCAStep
extends FortifyStep {
    protected String buildID;
    protected String maxHeap;
    protected String addJVMOptions;
    protected boolean debug;
    protected boolean verbose;
    protected String logFile;

    public String getBuildID() {
        return this.buildID;
    }

    public String getMaxHeap() {
        return this.maxHeap;
    }

    @DataBoundSetter
    public void setMaxHeap(String maxHeap) {
        this.maxHeap = maxHeap;
    }

    public String getAddJVMOptions() {
        return this.addJVMOptions;
    }

    @DataBoundSetter
    public void setAddJVMOptions(String addJVMOptions) {
        this.addJVMOptions = addJVMOptions;
    }

    public boolean getDebug() {
        return this.debug;
    }

    public boolean getVerbose() {
        return this.verbose;
    }

    public String getLogFile() {
        return this.logFile;
    }

    @DataBoundSetter
    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    @DataBoundSetter
    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    @DataBoundSetter
    public void setLogFile(String logFile) {
        this.logFile = logFile;
    }

    protected String getSourceAnalyzerExecutable(Run<?, ?> build, FilePath workspace, Launcher launcher, TaskListener listener, EnvVars vars) throws InterruptedException, IOException {
        return this.getExecutable("sourceanalyzer" + (launcher.isUnix() ? "" : ".exe"), build, workspace, listener, "FORTIFY_HOME", vars);
    }

    protected String getMavenExecutable(Run<?, ?> build, FilePath workspace, Launcher launcher, TaskListener listener, String mavenInstallationName, Node currentNode, EnvVars envVars) throws InterruptedException, IOException {
        String result = "";
        DescriptorExtensionList tools = ToolInstallation.all();
        ToolDescriptor ti = (ToolDescriptor)tools.find(Maven.MavenInstallation.class);
        if (ti != null) {
            for (ToolInstallation inst : ti.getInstallations()) {
                String instName = inst.getName();
                if ((instName != null || mavenInstallationName != null) && (instName == null || !instName.equalsIgnoreCase(mavenInstallationName))) continue;
                Maven.MavenInstallation mvn = (Maven.MavenInstallation)inst;
                if (currentNode != null) {
                    mvn = mvn.forNode(currentNode, listener);
                }
                mvn = mvn.forEnvironment(envVars);
                mvn.buildEnvVars(envVars);
                result = mvn.getExecutable(launcher);
                if (result != null && !result.isEmpty()) break;
            }
        }
        if (result == null || result.isEmpty()) {
            if (envVars.containsKey((Object)"MAVEN_HOME")) {
                result = this.getExecutableForEnvVar(build, workspace, launcher, listener, ".bat", ".cmd", "MAVEN_HOME", envVars);
            } else if (envVars.containsKey((Object)"M2_HOME")) {
                result = this.getExecutableForEnvVar(build, workspace, launcher, listener, ".cmd", ".bat", "M2_HOME", envVars);
            }
            if (result == null || result.isEmpty()) {
                result = this.getExecutableForEnvVar(build, workspace, launcher, listener, ".bat", ".cmd", "PATH", envVars);
            }
        }
        listener.getLogger().println("Using Maven executable " + result);
        return result;
    }

    private String getExecutableForEnvVar(Run<?, ?> build, FilePath workspace, Launcher launcher, TaskListener listener, String ext1, String ext2, String targetEnvVarName, EnvVars vars) throws InterruptedException, IOException {
        if (launcher.isUnix()) {
            return this.getExecutable("mvn", build, workspace, listener, targetEnvVarName, vars);
        }
        try {
            return this.getExecutable("mvn" + ext1, build, workspace, listener, targetEnvVarName, vars);
        }
        catch (FileNotFoundException ex) {
            return this.getExecutable("mvn" + ext2, build, workspace, listener, targetEnvVarName, vars);
        }
    }

    protected String getGradleExecutable(boolean useWrapper, Run<?, ?> build, FilePath workspace, Launcher launcher, TaskListener listener, String gradleInstallationName, Node currentNode, EnvVars envVars) throws InterruptedException, IOException {
        String result = "";
        DescriptorExtensionList tools = ToolInstallation.all();
        ToolDescriptor ti = (ToolDescriptor)tools.find(GradleInstallation.class);
        if (ti != null) {
            for (ToolInstallation inst : ti.getInstallations()) {
                String instName = inst.getName();
                if ((instName != null || gradleInstallationName != null) && (instName == null || !instName.equalsIgnoreCase(gradleInstallationName))) continue;
                GradleInstallation gradle = (GradleInstallation)inst;
                if (currentNode != null) {
                    gradle = gradle.forNode(currentNode, listener);
                }
                gradle = gradle.forEnvironment(envVars);
                gradle.buildEnvVars(envVars);
                result = gradle.getExecutable(launcher);
                if (result != null && !result.isEmpty()) break;
            }
        }
        if (result == null || result.isEmpty()) {
            result = this.getExecutable("gradle" + (useWrapper ? "w" : "") + (launcher.isUnix() ? "" : ".bat"), build, workspace, listener, "GRADLE_HOME", envVars);
        }
        listener.getLogger().println("Using Gradle executable " + result);
        return result;
    }

    protected String getDevenvExecutable(Run<?, ?> build, FilePath workspace, Launcher launcher, TaskListener listener, EnvVars envVars) throws InterruptedException, IOException {
        if (launcher.isUnix()) {
            throw new RuntimeException("Sorry, devenv is not supported on Unix platform.");
        }
        return this.getExecutable("devenv.exe", build, workspace, listener, null, envVars);
    }

    protected String getMSBuildExecutable(Run<?, ?> build, FilePath workspace, Launcher launcher, TaskListener listener, EnvVars envVars) throws InterruptedException, IOException {
        if (launcher.isUnix()) {
            throw new RuntimeException("Sorry, msbuild is not supported on Unix platform.");
        }
        return this.getExecutable("msbuild.exe", build, workspace, listener, null, envVars);
    }

    public Integer getResolvedMaxHeap(TaskListener listener) {
        if (this.getMaxHeap() != null) {
            try {
                return Integer.parseInt(this.resolve(String.valueOf(this.getMaxHeap()), listener));
            }
            catch (NumberFormatException nfe) {
                return null;
            }
        }
        return null;
    }

    public String getResolvedBuildID(TaskListener listener) {
        return this.resolve(this.getBuildID(), listener);
    }

    public String getResolvedAddJVMOptions(TaskListener listener) {
        return this.resolve(this.getAddJVMOptions(), listener);
    }

    public String getResolvedLogFile(TaskListener listener) {
        return this.resolve(this.getLogFile(), listener);
    }
}

