/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.plugin.jenkins.steps;

import com.fortify.plugin.jenkins.FortifyPlugin;
import com.fortify.plugin.jenkins.steps.FortifyCloudScanStep;
import com.fortify.plugin.jenkins.steps.Validators;
import com.google.common.collect.ImmutableSet;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Item;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.util.ComboBoxModel;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import jenkins.tasks.SimpleBuildStep;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.steps.SynchronousNonBlockingStepExecution;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.verb.POST;

public class CloudScanMbs
extends FortifyCloudScanStep
implements SimpleBuildStep {
    private FortifyPlugin.RemoteOptionalConfigBlock remoteOptionalConfig;
    private FortifyPlugin.UploadSSCBlock uploadSSC;
    private String buildID;

    @DataBoundConstructor
    public CloudScanMbs(String buildID) {
        this.buildID = buildID;
    }

    public String getBuildID() {
        return this.buildID;
    }

    public FortifyPlugin.RemoteOptionalConfigBlock getRemoteOptionalConfig() {
        return this.remoteOptionalConfig;
    }

    @DataBoundSetter
    public void setRemoteOptionalConfig(FortifyPlugin.RemoteOptionalConfigBlock remoteOptionalConfig) {
        this.remoteOptionalConfig = remoteOptionalConfig;
    }

    public FortifyPlugin.UploadSSCBlock getUploadSSC() {
        return this.uploadSSC;
    }

    @DataBoundSetter
    public void setUploadSSC(FortifyPlugin.UploadSSCBlock uploadSSC) {
        this.uploadSSC = uploadSSC;
    }

    public String getSensorPoolName() {
        return this.getRemoteOptionalConfig() == null ? "" : this.getRemoteOptionalConfig().getSensorPoolUUID();
    }

    public String getEmailAddr() {
        return this.getRemoteOptionalConfig() == null ? "" : this.getRemoteOptionalConfig().getNotifyEmail();
    }

    public String getScaScanOptions() {
        return this.getRemoteOptionalConfig() == null ? "" : this.getRemoteOptionalConfig().getScanOptions();
    }

    public String getRulepacks() {
        return this.getRemoteOptionalConfig() == null ? "" : this.getRemoteOptionalConfig().getCustomRulepacks();
    }

    public String getFilterFile() {
        return this.getRemoteOptionalConfig() == null ? "" : this.getRemoteOptionalConfig().getFilterFile();
    }

    public String getApplicationName() {
        return this.getUploadSSC() == null ? "" : this.getUploadSSC().getAppName();
    }

    public String getApplicationVersion() {
        return this.getUploadSSC() == null ? "" : this.getUploadSSC().getAppVersion();
    }

    public String getResolvedSensorPoolName(TaskListener listener) {
        return this.resolve(this.getSensorPoolName(), listener);
    }

    public String getResolvedEmailAddr(TaskListener listener) {
        return this.resolve(this.getEmailAddr(), listener);
    }

    public String getResolvedRulepacks(TaskListener listener) {
        return this.resolve(this.getRulepacks(), listener);
    }

    public String getResolvedFilterFile(TaskListener listener) {
        return this.resolve(this.getFilterFile(), listener);
    }

    public String getResolvedBuildID(TaskListener listener) {
        return this.resolve(this.getBuildID(), listener);
    }

    @Override
    public String getResolvedScanArgs(TaskListener listener) {
        return this.resolve(this.getScaScanOptions(), listener);
    }

    public String getResolvedApplicationName(TaskListener listener) {
        return this.resolve(this.getApplicationName(), listener);
    }

    public String getResolvedApplicationVersion(TaskListener listener) {
        return this.resolve(this.getApplicationVersion(), listener);
    }

    @Override
    public StepExecution start(StepContext context) throws Exception {
        return new Execution(this, context);
    }

    public void perform(Run<?, ?> run, FilePath filePath, EnvVars vars, Launcher launcher, TaskListener taskListener) throws InterruptedException, IOException {
        String cloudscanExec;
        this.setLastBuild(run);
        PrintStream log = taskListener.getLogger();
        log.println("Fortify Jenkins plugin v " + VERSION);
        log.println("Performing Fortify remote scan");
        String projectRoot = filePath.child(".fortify").getRemote();
        try {
            cloudscanExec = this.getScancentralExecutable(run, filePath, launcher, taskListener, vars);
        }
        catch (FileNotFoundException ex) {
            log.println("WARNING: Cannot find scancentral executable");
            try {
                cloudscanExec = this.getCloudScanExecutable(run, filePath, launcher, taskListener, vars);
            }
            catch (FileNotFoundException exception) {
                throw new RuntimeException("Cannot find cloudscan executable");
            }
        }
        ArrayList<Pair<String, Boolean>> args = new ArrayList<Pair<String, Boolean>>(20);
        args.add(Pair.of((Object)cloudscanExec, (Object)Boolean.FALSE));
        if (StringUtils.isNotBlank((String)FortifyPlugin.DESCRIPTOR.getUrl())) {
            args.add(Pair.of((Object)"-sscurl", (Object)Boolean.FALSE));
            args.add(Pair.of((Object)FortifyPlugin.DESCRIPTOR.getUrl(), (Object)Boolean.FALSE));
            args.add(Pair.of((Object)"-ssctoken", (Object)Boolean.FALSE));
            args.add(Pair.of((Object)FortifyPlugin.DESCRIPTOR.getToken(), (Object)Boolean.TRUE));
        } else if (StringUtils.isNotBlank((String)FortifyPlugin.DESCRIPTOR.getCtrlUrl())) {
            args.add(Pair.of((Object)"-url", (Object)Boolean.FALSE));
            args.add(Pair.of((Object)FortifyPlugin.DESCRIPTOR.getCtrlUrl(), (Object)Boolean.FALSE));
        } else {
            throw new AbortException("Fortify remote scan execution failed: No SSC or Controller URL found");
        }
        args.add(Pair.of((Object)"start", (Object)Boolean.FALSE));
        args.add(Pair.of((Object)"-b", (Object)Boolean.FALSE));
        args.add(Pair.of((Object)this.getResolvedBuildID(taskListener), (Object)Boolean.FALSE));
        args.add(Pair.of((Object)"-project-root", (Object)Boolean.FALSE));
        args.add(Pair.of((Object)projectRoot, (Object)Boolean.FALSE));
        if (StringUtils.isNotEmpty((String)this.getResolvedEmailAddr(taskListener))) {
            args.add(Pair.of((Object)"-email", (Object)Boolean.FALSE));
            args.add(Pair.of((Object)this.getResolvedEmailAddr(taskListener), (Object)Boolean.TRUE));
        }
        if (StringUtils.isNotEmpty((String)this.getResolvedSensorPoolName(taskListener))) {
            args.add(Pair.of((Object)"-pool", (Object)Boolean.FALSE));
            args.add(Pair.of((Object)this.getResolvedSensorPoolName(taskListener), (Object)Boolean.FALSE));
        }
        if (StringUtils.isNotEmpty((String)this.getResolvedApplicationName(taskListener))) {
            args.add(Pair.of((Object)"-upload", (Object)Boolean.FALSE));
            args.add(Pair.of((Object)"-application", (Object)Boolean.FALSE));
            args.add((Pair<String, Boolean>)Pair.of((Object)this.getResolvedApplicationName(taskListener), (Object)Boolean.FALSE));
            args.add((Pair<String, Boolean>)Pair.of((Object)"-version", (Object)Boolean.FALSE));
            args.add((Pair<String, Boolean>)Pair.of((Object)this.getResolvedApplicationVersion(taskListener), (Object)Boolean.FALSE));
            args.add((Pair<String, Boolean>)Pair.of((Object)"-uptoken", (Object)Boolean.FALSE));
            args.add((Pair<String, Boolean>)Pair.of((Object)FortifyPlugin.DESCRIPTOR.getCtrlToken(), (Object)Boolean.TRUE));
        }
        if (StringUtils.isNotEmpty((String)this.getResolvedRulepacks(taskListener))) {
            this.addAllArgumentsWithNoMasks(args, this.getResolvedRulepacks(taskListener), "-rules");
        }
        if (StringUtils.isNotEmpty((String)this.getResolvedFilterFile(taskListener))) {
            this.addAllArgumentsWithNoMasks(args, this.getResolvedFilterFile(taskListener), "-filter");
        }
        args.add((Pair<String, Boolean>)Pair.of((Object)"-scan", (Object)Boolean.FALSE));
        if (StringUtils.isNotEmpty((String)this.getResolvedScanArgs(taskListener))) {
            args.add((Pair<String, Boolean>)Pair.of((Object)this.getResolvedScanArgs(taskListener), (Object)Boolean.FALSE));
        }
        ArrayList cmds = new ArrayList(args.size());
        boolean[] masks = new boolean[args.size()];
        args.stream().forEach(p -> {
            cmds.add(p.getLeft());
            masks[args.indexOf((Object)p)] = (Boolean)p.getRight();
        });
        Launcher.ProcStarter p2 = launcher.launch().cmds(cmds).masks(masks).envs((Map)vars).stdout((OutputStream)log).stderr((OutputStream)log).pwd(filePath);
        int exitcode = p2.start().join();
        log.println("Fortify remote scan completed with exit code: " + exitcode);
        if (exitcode != 0) {
            run.setResult(Result.FAILURE);
            throw new AbortException("Fortify remote scan execution failed.");
        }
    }

    private static class Execution
    extends SynchronousNonBlockingStepExecution<Void> {
        private transient CloudScanMbs csMbs;
        private static final long serialVersionUID = 1L;

        protected Execution(CloudScanMbs csMbs, StepContext context) {
            super(context);
            this.csMbs = csMbs;
        }

        protected Void run() throws Exception {
            StepContext context = this.getContext();
            ((TaskListener)context.get(TaskListener.class)).getLogger().println("Running Fortify remote scan step");
            if (!((FilePath)context.get(FilePath.class)).exists()) {
                ((FilePath)context.get(FilePath.class)).mkdirs();
            }
            this.csMbs.perform((Run)context.get(Run.class), (FilePath)context.get(FilePath.class), (EnvVars)context.get(EnvVars.class), (Launcher)context.get(Launcher.class), (TaskListener)context.get(TaskListener.class));
            return null;
        }
    }

    @Extension
    public static class DescriptorImpl
    extends StepDescriptor {
        public DescriptorImpl() {
            this.load();
        }

        public String getFunctionName() {
            return "fortifyRemoteScan";
        }

        public String getDisplayName() {
            return "Upload a translated project for remote scan";
        }

        public Set<? extends Class<?>> getRequiredContext() {
            return ImmutableSet.of(Run.class, FilePath.class, EnvVars.class, Launcher.class, TaskListener.class);
        }

        public FormValidation doCheckBuildID(@QueryParameter String value) {
            return Validators.checkFieldNotEmpty(value);
        }

        @POST
        public void doRefreshProjects(StaplerRequest req, StaplerResponse rsp, @QueryParameter String value, @AncestorInPath Item item) throws Exception {
            FortifyPlugin.DESCRIPTOR.doRefreshProjects(req, rsp, value, item);
        }

        @POST
        public void doRefreshVersions(StaplerRequest req, StaplerResponse rsp, @QueryParameter String value, @AncestorInPath Item item) throws Exception {
            FortifyPlugin.DESCRIPTOR.doRefreshVersions(req, rsp, value, item);
        }

        @POST
        public ComboBoxModel doFillAppNameItems(@AncestorInPath Item item) {
            return FortifyPlugin.DESCRIPTOR.doFillAppNameItems(item);
        }

        @POST
        public ComboBoxModel doFillAppVersionItems(@QueryParameter String appName, @AncestorInPath Item item) {
            return FortifyPlugin.DESCRIPTOR.doFillAppVersionItems(appName, item);
        }

        @POST
        public ListBoxModel doFillSensorPoolUUIDItems(@AncestorInPath Item item) {
            return FortifyPlugin.DESCRIPTOR.doFillSensorPoolUUIDItems(item);
        }
    }
}

