/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.plugin.jenkins.fortifyclient;

import com.fortify.plugin.jenkins.bean.MetaDataDefinition;
import com.fortify.plugin.jenkins.bean.MetaDataSelectedValue;
import com.fortify.plugin.jenkins.bean.MetaDataValue;
import com.fortify.plugin.jenkins.bean.ProjectDataEntry;
import com.fortify.plugin.jenkins.bean.ProjectMetaDataCategory;
import com.fortify.plugin.jenkins.bean.SystemUsageType;
import com.fortify.plugin.jenkins.fortifyclient.ApiClientWrapper;
import com.fortify.ssc.restclient.ApiException;
import com.fortify.ssc.restclient.model.AttributeDefinition;
import com.fortify.ssc.restclient.model.AttributeOption;
import com.fortify.ssc.restclient.model.IssueTemplate;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.LinkedHashSet;
import java.util.List;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.commons.lang.StringUtils;

public class ProjectCreationService {
    private static DatatypeFactory datatypeFactory;
    private static String DATEFORMAT;
    private final PrintWriter logWriter;
    private ApiClientWrapper apiClientWrapper;

    public static XMLGregorianCalendar convertDateToXMLGregorianCalender(Date date) {
        if (date == null) {
            return null;
        }
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTimeInMillis(date.getTime());
        return datatypeFactory.newXMLGregorianCalendar(calendar);
    }

    public ProjectCreationService(PrintWriter log, ApiClientWrapper apiClientWrapper) throws ApiException {
        this.logWriter = log;
        this.apiClientWrapper = apiClientWrapper;
    }

    public Long createProject(ProjectDataEntry projectData) throws IOException, ApiException {
        String projectVersionName;
        String projectName = projectData.getProjectName();
        Long applicationVersionId = this.getAppVersionIdIfExists(projectName, projectVersionName = projectData.getProjectVersionName());
        if (applicationVersionId != null) {
            return applicationVersionId;
        }
        ArrayList<MetaDataDefinition> serverProjectAttributeDefinitions = new ArrayList<MetaDataDefinition>();
        try {
            List<AttributeDefinition> data = this.apiClientWrapper.getAttributeDefinitions();
            if (data != null && !data.isEmpty()) {
                for (AttributeDefinition next : data) {
                    MetaDataDefinition nextDef = this.convertAttributeDefinitionToMetaDataDefinition(next);
                    serverProjectAttributeDefinitions.add(nextDef);
                }
            }
        }
        catch (Exception e) {
            this.logWriter.println(MessageFormat.format("[WARN] REST api call for attribute definitions failed: {0}", e.getLocalizedMessage()));
        }
        LinkedHashSet<MetaDataDefinition> definitionsNotSet = new LinkedHashSet<MetaDataDefinition>();
        definitionsNotSet.addAll(serverProjectAttributeDefinitions);
        for (MetaDataDefinition definition : definitionsNotSet) {
            if (!definition.isRequired().booleanValue()) continue;
            MetaDataSelectedValue newValue = new MetaDataSelectedValue();
            newValue.setMetaDataDefinitionId(definition.getId());
            newValue.setProjectVersionId(-1L);
            if (Boolean.TRUE.equals(definition.isFreeFormValue()) || Boolean.TRUE.equals(definition.isFreeFormLongValue()) || Boolean.TRUE.equals(definition.isFreeFormSensitiveValue())) {
                newValue.setFreeFormValue("some default freeform value");
                continue;
            }
            if (Boolean.TRUE.equals(definition.isIntegerValue())) {
                this.setIntegerValue(String.valueOf(0L), definition, newValue);
                continue;
            }
            if (Boolean.TRUE.equals(definition.isBooleanValue())) {
                this.setBooleanValue(String.valueOf(false), definition, newValue);
                continue;
            }
            if (Boolean.TRUE.equals(definition.isDateValue())) {
                SimpleDateFormat mmddyyyy = new SimpleDateFormat(DATEFORMAT);
                this.setDateValue(mmddyyyy.format(new Date()), definition, newValue);
                continue;
            }
            List<MetaDataValue> values = definition.getValue();
            if (values.isEmpty()) continue;
            newValue.getValue().add(values.get(0));
        }
        List<IssueTemplate> projectTemplates = null;
        try {
            projectTemplates = this.apiClientWrapper.getIssueTemplates();
        }
        catch (ApiException e) {
            this.logWriter.println(MessageFormat.format("[ERROR] REST api call to get Issue Templates failed: {0}", e.getLocalizedMessage()));
            throw e;
        }
        String selectedIssueTemplateName = projectData.getProjectTemplateName();
        selectedIssueTemplateName = !StringUtils.isEmpty((String)selectedIssueTemplateName) ? selectedIssueTemplateName : null;
        IssueTemplate issueTemplate = null;
        IssueTemplate defaultIssueTemplate = this.getDefaultIssueTemplate(projectTemplates);
        if (selectedIssueTemplateName == null) {
            issueTemplate = defaultIssueTemplate;
            this.logWriter.printf("No Issue Template selected. Using default template '%s'.%n", issueTemplate.getName());
        } else {
            for (IssueTemplate pt : projectTemplates) {
                if (!pt.getName().equals(selectedIssueTemplateName)) continue;
                issueTemplate = pt;
                break;
            }
            if (issueTemplate != null) {
                this.logWriter.printf("Selected Issue Template is '%s'%n", issueTemplate.getName());
            } else {
                issueTemplate = defaultIssueTemplate;
                this.logWriter.printf("Specified Issue Template ='%s' doesn't exist, template '%s' is used instead!%n", selectedIssueTemplateName, issueTemplate.getName());
            }
        }
        String masterAttrGuid = issueTemplate.getMasterAttrGuid();
        applicationVersionId = this.getAppVersionIdOrCreate(projectName, projectVersionName, issueTemplate.getId(), masterAttrGuid);
        return applicationVersionId;
    }

    public Long getAppVersionIdIfExists(String appName, String appVersionName) throws ApiException {
        Long appId = this.apiClientWrapper.getApplicationId(appName);
        if (appId != null) {
            return this.getAppVersionIdIfExists(appId, appVersionName);
        }
        return null;
    }

    private Long getAppVersionIdIfExists(Long appId, String appVersionName) throws ApiException {
        if (appId != null) {
            return this.apiClientWrapper.getVersionForApplication(appId, appVersionName);
        }
        return null;
    }

    private IssueTemplate getDefaultIssueTemplate(List<IssueTemplate> issueTemplates) {
        IssueTemplate issueTemplate = null;
        if (issueTemplates != null) {
            for (IssueTemplate it : issueTemplates) {
                Boolean isDefault = it.getDefaultTemplate();
                if (isDefault == null || !isDefault.booleanValue()) continue;
                issueTemplate = it;
                break;
            }
            if (issueTemplate == null) {
                issueTemplate = issueTemplates.get(0);
            }
        }
        return issueTemplate;
    }

    private Long getAppVersionIdOrCreate(String appName, String appVersionName, String issueTemplateId, String masterAttrGuid) throws ApiException {
        Long appVersionId;
        Long applicationId = this.apiClientWrapper.getApplicationId(appName);
        if (applicationId != null) {
            appVersionId = this.apiClientWrapper.getVersionForApplication(applicationId, appVersionName);
            if (appVersionId == null) {
                this.logWriter.printf("Application version '%s' does not exist for application '%s'. Will create the application version.%n", appVersionName, appName);
                appVersionId = this.apiClientWrapper.createAppOrVersion(applicationId, issueTemplateId, appName, appVersionName, masterAttrGuid, ApiClientWrapper.AppTypeEnum.APP_VERSION);
                this.apiClientWrapper.setDefaultAttributesAndCommit(appVersionId);
            }
        } else {
            this.logWriter.printf("Application '%s' does not exist. Will create application '%s' and application version '%s'.%n", appName, appName, appVersionName);
            appVersionId = this.apiClientWrapper.createAppOrVersion(null, issueTemplateId, appName, appVersionName, masterAttrGuid, ApiClientWrapper.AppTypeEnum.APPLICATION);
            this.apiClientWrapper.setDefaultAttributesAndCommit(appVersionId);
        }
        return appVersionId;
    }

    private void setIntegerValue(String projectAttributeValue, MetaDataDefinition projectAttributeDefinition, MetaDataSelectedValue value) {
        try {
            value.setIntegerValue(Long.valueOf(projectAttributeValue));
        }
        catch (NumberFormatException e) {
            this.logWriter.printf("[WARN] Failed to set an integer value of '" + projectAttributeValue + "' for '" + projectAttributeDefinition.getName() + "'; continuing with 0%n", new Object[0]);
            value.setIntegerValue(0L);
        }
    }

    private void setBooleanValue(String projectAttributeValue, MetaDataDefinition projectAttributeDefinition, MetaDataSelectedValue value) {
        try {
            value.setBooleanValue(Boolean.valueOf(projectAttributeValue));
        }
        catch (Exception e) {
            this.logWriter.printf("[WARN] Failed to set a boolean value of '" + projectAttributeValue + "' for '" + projectAttributeDefinition.getName() + "'; continuing with false%n", new Object[0]);
            value.setBooleanValue(Boolean.FALSE);
        }
    }

    private void setDateValue(String projectAttributeValue, MetaDataDefinition projectAttributeDefinition, MetaDataSelectedValue value) {
        try {
            SimpleDateFormat mmddyyyy = new SimpleDateFormat(DATEFORMAT);
            Date date = mmddyyyy.parse(projectAttributeValue);
            value.setDateValue(ProjectCreationService.convertDateToXMLGregorianCalender(date));
        }
        catch (ParseException e) {
            Date now = new Date();
            this.logWriter.printf("[WARN] Failed to set date value of '" + projectAttributeValue + "' for '" + projectAttributeDefinition.getName() + "'; continuing with '" + now + "'%n", new Object[0]);
            value.setDateValue(ProjectCreationService.convertDateToXMLGregorianCalender(now));
        }
    }

    private MetaDataDefinition convertAttributeDefinitionToMetaDataDefinition(AttributeDefinition attributeDefinition) {
        MetaDataDefinition metaDataDefinition = new MetaDataDefinition();
        metaDataDefinition.setRequired(attributeDefinition.getRequired());
        metaDataDefinition.setName(attributeDefinition.getName());
        metaDataDefinition.setAppEntityType(attributeDefinition.getAppEntityType().name());
        metaDataDefinition.setId(String.valueOf(attributeDefinition.getGuid()));
        metaDataDefinition.setHidden(attributeDefinition.getHidden());
        metaDataDefinition.setType(ProjectMetaDataCategory.fromValue(attributeDefinition.getCategory().name()));
        metaDataDefinition.setSystemUsage(SystemUsageType.fromValue(attributeDefinition.getSystemUsage().name()));
        metaDataDefinition.setDescription(attributeDefinition.getDescription());
        if (attributeDefinition.getType() == AttributeDefinition.TypeEnum.SINGLE || attributeDefinition.getType() == AttributeDefinition.TypeEnum.MULTIPLE) {
            if (attributeDefinition.getOptions() != null && attributeDefinition.getOptions().size() > 0) {
                List<MetaDataValue> values = metaDataDefinition.getValue();
                for (AttributeOption option : attributeDefinition.getOptions()) {
                    MetaDataValue nextValue = new MetaDataValue();
                    nextValue.setId(String.valueOf(option.getGuid()));
                    nextValue.setShortName(option.getName());
                    values.add(nextValue);
                }
            }
        } else {
            metaDataDefinition.setBooleanValue(AttributeDefinition.TypeEnum.BOOLEAN == attributeDefinition.getType());
            metaDataDefinition.setDateValue(AttributeDefinition.TypeEnum.DATE == attributeDefinition.getType());
            metaDataDefinition.setFileValue(AttributeDefinition.TypeEnum.FILE == attributeDefinition.getType());
            metaDataDefinition.setFreeFormSensitiveValue(AttributeDefinition.TypeEnum.SENSITIVE_TEXT == attributeDefinition.getType());
            metaDataDefinition.setFreeFormLongValue(AttributeDefinition.TypeEnum.LONG_TEXT == attributeDefinition.getType());
            metaDataDefinition.setFreeFormValue(AttributeDefinition.TypeEnum.TEXT == attributeDefinition.getType());
            metaDataDefinition.setIntegerValue(AttributeDefinition.TypeEnum.INTEGER == attributeDefinition.getType());
            metaDataDefinition.setMultiple(AttributeDefinition.TypeEnum.MULTIPLE == attributeDefinition.getType());
        }
        return metaDataDefinition;
    }

    static {
        try {
            datatypeFactory = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException e) {
            System.err.println("Cannot instantiate javax.xml.datatype.DatatypeFactory" + e.getLocalizedMessage());
        }
        DATEFORMAT = "MM/dd/yyyy";
    }
}

