/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.plugin.jenkins.fortifyclient;

import com.fortify.plugin.jenkins.ProxyConfig;
import com.fortify.plugin.jenkins.bean.GroupingProfile;
import com.fortify.plugin.jenkins.bean.IssueBean;
import com.fortify.plugin.jenkins.bean.ProjectDataEntry;
import com.fortify.plugin.jenkins.fortifyclient.ApiClientWrapper;
import com.fortify.plugin.jenkins.fortifyclient.ProjectCreationService;
import com.fortify.ssc.restclient.ApiException;
import com.fortify.ssc.restclient.model.Artifact;
import com.fortify.ssc.restclient.model.CloudPool;
import com.fortify.ssc.restclient.model.FilterSet;
import com.fortify.ssc.restclient.model.Folder;
import com.fortify.ssc.restclient.model.FolderDto;
import com.fortify.ssc.restclient.model.IssueSelector;
import com.fortify.ssc.restclient.model.IssueTemplate;
import com.fortify.ssc.restclient.model.Project;
import com.fortify.ssc.restclient.model.ProjectVersion;
import com.fortify.ssc.restclient.model.ProjectVersionIssue;
import com.fortify.ssc.restclient.model.ProjectVersionIssueGroup;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class FortifyClient {
    private ApiClientWrapper apiClientWrapper;

    public void init(String uri, String token, ProxyConfig proxyConfig, Integer connectTimeoutSeconds, Integer readTimeoutSeconds, Integer writeTimeoutSeconds) throws ApiException {
        this.apiClientWrapper = new ApiClientWrapper(uri, token, connectTimeoutSeconds, readTimeoutSeconds, writeTimeoutSeconds);
        this.apiClientWrapper.setProxy(proxyConfig);
    }

    public Map<String, Map<String, Long>> getAllVersionListEx(String query, Integer limit) throws ApiException {
        LinkedHashMap<String, Map<String, Long>> appVersionList = new LinkedHashMap<String, Map<String, Long>>();
        List<ProjectVersion> versions = this.apiClientWrapper.getAllApplicationVersions(query, limit);
        String appName = null;
        LinkedHashMap<String, Long> versionsFor = new LinkedHashMap<String, Long>();
        for (ProjectVersion prjEntry : versions) {
            String nextAppName;
            Project project = prjEntry.getProject();
            String string = nextAppName = project == null ? "" : project.getName();
            if (!nextAppName.equals(appName) && appName != null) {
                appVersionList.put(appName, versionsFor);
                versionsFor = new LinkedHashMap();
            }
            appName = nextAppName;
            versionsFor.put(prjEntry.getName(), prjEntry.getId());
        }
        return appVersionList;
    }

    public Map<String, Long> getVersionListEx(Long appId, String query, int limit) throws ApiException {
        LinkedHashMap<String, Long> versions = new LinkedHashMap<String, Long>();
        if (appId != null) {
            List<ProjectVersion> versionsFor = this.apiClientWrapper.getApplicationVersionsFor(appId, query, limit);
            for (ProjectVersion version : versionsFor) {
                versions.put(version.getName(), version.getId());
            }
        }
        return versions;
    }

    public Map<String, Long> getProjectList(String query, int limit) throws ApiException {
        LinkedHashMap<String, Long> projectList = new LinkedHashMap<String, Long>();
        List<Project> apps = this.apiClientWrapper.getApplications(query, limit);
        for (Project prjEntry : apps) {
            projectList.put(prjEntry.getName(), prjEntry.getId());
        }
        return projectList;
    }

    public Map<String, String> getProjectTemplateList() throws ApiException {
        List<IssueTemplate> issueTemplates = this.apiClientWrapper.getIssueTemplates();
        LinkedHashMap<String, String> issueTemplateList = new LinkedHashMap<String, String>();
        for (IssueTemplate issueTemplate : issueTemplates) {
            issueTemplateList.put(issueTemplate.getName(), issueTemplate.getId());
        }
        return issueTemplateList;
    }

    public Map<String, String> getCloudScanPoolList() throws ApiException {
        List<CloudPool> csPools = this.apiClientWrapper.getCloudScanPools();
        LinkedHashMap<String, String> csPoolList = new LinkedHashMap<String, String>();
        for (CloudPool cloudPool : csPools) {
            csPoolList.put(cloudPool.getName(), cloudPool.getUuid());
        }
        return csPoolList;
    }

    public Long uploadFPR(File fpr, Long appVersionId) throws ApiException {
        return this.apiClientWrapper.uploadFpr(fpr, appVersionId);
    }

    public Artifact getArtifactInfo(Long artifactId) throws ApiException {
        return this.apiClientWrapper.getArtifactInfo(artifactId);
    }

    public Long createProject(String projectName, String projectVersionName, String projectTemplateName, Map<String, String> attributeNamesAndValues, PrintWriter log) throws IOException, ApiException {
        ProjectCreationService pcs = new ProjectCreationService(log, this.apiClientWrapper);
        ProjectDataEntry projectData = new ProjectDataEntry(projectName, projectVersionName, projectTemplateName, attributeNamesAndValues);
        return pcs.createProject(projectData);
    }

    public Map<String, IssueBean> getIssuesByFolderId(Long projectVersionId, String folderId, int startPage, int pageSize, String filterSet, String groupingName, String sortOrder, Boolean ShowOnlyNewIssues, Boolean sortDownNotUp, PrintWriter log) throws ApiException {
        LinkedHashMap<String, IssueBean> result = new LinkedHashMap<String, IssueBean>();
        String filter = "FOLDER:" + folderId;
        List<ProjectVersionIssue> issues = this.apiClientWrapper.getIssuesForAppVersion(projectVersionId, startPage * pageSize, pageSize, filter, null, null);
        for (ProjectVersionIssue issue : issues) {
            IssueBean issueBean = new IssueBean();
            issueBean.setProjectVersionId(projectVersionId);
            issueBean.setIssueId(issue.getId());
            issueBean.setIssueInstanceId(issue.getIssueInstanceId());
            issueBean.setPackageName(null);
            issueBean.setClassName(null);
            issueBean.setFunction(null);
            issueBean.setSourceFilePath(issue.getFullFileName());
            issueBean.setFilePath(issue.getFullFileName());
            issueBean.setLineNumber(String.valueOf(issue.getLineNumber()));
            issueBean.setGroupName(issue.getIssueName());
            issueBean.setAssignedUser(null);
            issueBean.setCategory(issue.getIssueName());
            issueBean.setType(issue.getIssueName());
            issueBean.setConfidence(String.valueOf(issue.getConfidence()));
            issueBean.setSeverity(String.valueOf(issue.getSeverity()));
            issueBean.setSubType(null);
            issueBean.setMappedCategory(issue.getIssueName());
            issueBean.setEngineType(issue.getEngineType());
            result.put(issue.getIssueInstanceId(), issueBean);
        }
        return result;
    }

    public Map<String, List<String>> getGroupingValues(Long projectVersionId, String folderId, String filterSet, String searchCondition, String groupingName, String groupingType, PrintWriter log) throws ApiException {
        LinkedHashMap<String, List<String>> result = new LinkedHashMap<String, List<String>>();
        List<ProjectVersionIssueGroup> issueGroups = this.apiClientWrapper.getIssueGroupsForAvs(projectVersionId, searchCondition, folderId, filterSet, groupingType = groupingType == null ? this.getGroupingType(projectVersionId, groupingName, log) : groupingType);
        if (issueGroups != null) {
            for (ProjectVersionIssueGroup issueGroup : issueGroups) {
                ArrayList<String> attributes = new ArrayList<String>();
                attributes.add(issueGroup.getName());
                attributes.add(String.valueOf(issueGroup.getTotalCount()));
                attributes.add(String.valueOf(issueGroup.getVisibleCount()));
                attributes.add(String.valueOf(issueGroup.getAuditedCount()));
                attributes.add(issueGroup.getCleanName());
                result.put(issueGroup.getId(), attributes);
            }
        }
        return result;
    }

    public Map<String, List<String>> getGroupingValues(Long projectVersionId, String folderId, String filterSet, String searchCondition, String groupingName, PrintWriter log) throws ApiException {
        return this.getGroupingValues(projectVersionId, folderId, filterSet, searchCondition, groupingName, null, log);
    }

    public Map<String, List<String>> getFolderIdToAttributesList(Long versionId, String filterSetGuid, PrintWriter log) throws ApiException {
        LinkedHashMap<String, List<String>> result = new LinkedHashMap<String, List<String>>();
        FilterSet defaultFilterSet = this.apiClientWrapper.getDefaultFilterSetForAppVersion(versionId);
        if (StringUtils.isEmpty((String)filterSetGuid)) {
            filterSetGuid = defaultFilterSet.getGuid();
        }
        List<Folder> folders = this.apiClientWrapper.getFoldersForAppVersion(versionId);
        List folderDtoList = defaultFilterSet.getFolders();
        List<ProjectVersionIssueGroup> issueGroupFolders = this.apiClientWrapper.getIssueGroupFolders(versionId, filterSetGuid);
        int allTotalCount = 0;
        int allNewIssuesCount = 0;
        for (FolderDto folderDto : folderDtoList) {
            for (Folder folder : folders) {
                if (!folderDto.getGuid().equals(folder.getGuid())) continue;
                ArrayList<String> attributes = new ArrayList<String>();
                attributes.add(folder.getName());
                attributes.add(folder.getDescription());
                attributes.add(folder.getColor());
                int totalCount = this.getIssueGroupCountForFolder(issueGroupFolders, folder.getName());
                allTotalCount += totalCount;
                attributes.add(String.valueOf(totalCount));
                int newIssuesCount = this.getNewIssueCountForFolder(versionId, folder.getGuid(), filterSetGuid);
                allNewIssuesCount += newIssuesCount;
                attributes.add(String.valueOf(newIssuesCount));
                result.put(folder.getGuid(), attributes);
            }
        }
        this.addAllFolderInfo(result, allTotalCount, allNewIssuesCount);
        return result;
    }

    public Long getProjectVersionId(String appName, String appVersionName) throws ApiException {
        Long applicationId = this.apiClientWrapper.getApplicationId(appName);
        return this.apiClientWrapper.getVersionForApplication(applicationId, appVersionName);
    }

    private void addAllFolderInfo(Map<String, List<String>> result, int allTotalCount, int allNewIssuesCount) {
        ArrayList<String> attributes = new ArrayList<String>();
        attributes.add("All");
        attributes.add("");
        attributes.add("80A958");
        attributes.add(String.valueOf(allTotalCount));
        attributes.add(String.valueOf(allNewIssuesCount));
        result.put("f599639d-f500-e046-2fd1-d82b5e9b26b4", attributes);
    }

    private int getIssueGroupCountForFolder(List<ProjectVersionIssueGroup> issueGroupFolders, String folderId) {
        for (ProjectVersionIssueGroup issueGroupFolder : issueGroupFolders) {
            if (!issueGroupFolder.getCleanName().equals(folderId)) continue;
            return issueGroupFolder.getTotalCount();
        }
        return 0;
    }

    private int getNewIssueCountForFolder(Long versionId, String folderId, String filterset) throws ApiException {
        ProjectVersionIssueGroup issueGroupFolder = null;
        issueGroupFolder = this.apiClientWrapper.getNewIssueGroupForAv(versionId, folderId, filterset);
        if (issueGroupFolder != null) {
            return issueGroupFolder.getTotalCount();
        }
        return 0;
    }

    public List<GroupingProfile> getGroupingProfiles(Long versionId, String filterSet, PrintWriter log) throws ApiException {
        ArrayList<GroupingProfile> groupingProfiles = new ArrayList<GroupingProfile>();
        try {
            List<IssueSelector> issueSelectors = this.apiClientWrapper.getGroupBySetForAppVersion(versionId);
            if (issueSelectors != null) {
                for (IssueSelector issueSelector : issueSelectors) {
                    String name = issueSelector.getDisplayName();
                    GroupingProfile groupingProfile = new GroupingProfile();
                    groupingProfile.setName(name);
                    groupingProfile.setGroupingTypeString("true:" + name);
                    groupingProfiles.add(groupingProfile);
                }
            }
        }
        catch (ApiException ae) {
            log.println("Error retrieving Grouping Profiles for app version " + versionId);
            throw ae;
        }
        return groupingProfiles;
    }

    private String getGroupingType(Long projectVersionId, String groupName, PrintWriter log) {
        String groupByGuid;
        block3: {
            groupByGuid = "";
            try {
                List<IssueSelector> issueSelectors = this.apiClientWrapper.getGroupBySetForAppVersion(projectVersionId);
                if (issueSelectors == null) break block3;
                for (IssueSelector issueSelector : issueSelectors) {
                    if (!issueSelector.getDisplayName().equals(groupName)) continue;
                    groupByGuid = issueSelector.getGuid();
                    break;
                }
            }
            catch (ApiException ae) {
                log.println("Error retrieving Grouping Types for app version " + projectVersionId + " and groupName " + groupName);
            }
        }
        return groupByGuid;
    }

    public Map<String, String> getFilterSetListEx(Long verId) throws ApiException {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        if (verId != null) {
            List<FilterSet> filterSets = this.apiClientWrapper.getFilterSetsForAppVersion(verId);
            for (FilterSet nextFilterSet : filterSets) {
                result.put(nextFilterSet.getTitle(), nextFilterSet.getGuid());
            }
        }
        return result;
    }

    public static class NoReturn {
        public static final NoReturn INSTANCE = new NoReturn();

        private NoReturn() {
        }
    }

    public static interface Command<T> {
        public T runWith(FortifyClient var1) throws Exception;
    }
}

