/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.plugin.jenkins.fortifyclient;

import com.fortify.plugin.jenkins.ProxyConfig;
import com.fortify.ssc.restclient.ApiClient;
import com.fortify.ssc.restclient.ApiException;
import com.fortify.ssc.restclient.api.ArtifactControllerApi;
import com.fortify.ssc.restclient.api.ArtifactOfProjectVersionControllerApi;
import com.fortify.ssc.restclient.api.AttributeDefinitionControllerApi;
import com.fortify.ssc.restclient.api.AttributeOfProjectVersionControllerApi;
import com.fortify.ssc.restclient.api.CloudPoolControllerApi;
import com.fortify.ssc.restclient.api.FilterSetOfProjectVersionControllerApi;
import com.fortify.ssc.restclient.api.FolderOfProjectVersionControllerApi;
import com.fortify.ssc.restclient.api.IssueGroupOfProjectVersionControllerApi;
import com.fortify.ssc.restclient.api.IssueOfProjectVersionControllerApi;
import com.fortify.ssc.restclient.api.IssueSelectorSetOfProjectVersionControllerApi;
import com.fortify.ssc.restclient.api.IssueTemplateControllerApi;
import com.fortify.ssc.restclient.api.ProjectControllerApi;
import com.fortify.ssc.restclient.api.ProjectVersionControllerApi;
import com.fortify.ssc.restclient.api.ProjectVersionOfProjectControllerApi;
import com.fortify.ssc.restclient.model.ApiResultArtifact;
import com.fortify.ssc.restclient.model.ApiResultIssueFilterSelectorSet;
import com.fortify.ssc.restclient.model.ApiResultIssueTemplate;
import com.fortify.ssc.restclient.model.ApiResultListAttributeDefinition;
import com.fortify.ssc.restclient.model.ApiResultListCloudPool;
import com.fortify.ssc.restclient.model.ApiResultListFilterSet;
import com.fortify.ssc.restclient.model.ApiResultListFolder;
import com.fortify.ssc.restclient.model.ApiResultListIssueTemplate;
import com.fortify.ssc.restclient.model.ApiResultListProject;
import com.fortify.ssc.restclient.model.ApiResultListProjectVersion;
import com.fortify.ssc.restclient.model.ApiResultListProjectVersionIssue;
import com.fortify.ssc.restclient.model.ApiResultListProjectVersionIssueGroup;
import com.fortify.ssc.restclient.model.ApiResultProjectVersion;
import com.fortify.ssc.restclient.model.Artifact;
import com.fortify.ssc.restclient.model.Attribute;
import com.fortify.ssc.restclient.model.AttributeDefinition;
import com.fortify.ssc.restclient.model.AttributeOption;
import com.fortify.ssc.restclient.model.CloudPool;
import com.fortify.ssc.restclient.model.FilterSet;
import com.fortify.ssc.restclient.model.Folder;
import com.fortify.ssc.restclient.model.IssueSelector;
import com.fortify.ssc.restclient.model.IssueTemplate;
import com.fortify.ssc.restclient.model.Project;
import com.fortify.ssc.restclient.model.ProjectVersion;
import com.fortify.ssc.restclient.model.ProjectVersionIssue;
import com.fortify.ssc.restclient.model.ProjectVersionIssueGroup;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;

public class ApiClientWrapper {
    private static final String AUTH_HEADER_TOKEN = "FortifyToken";
    private ApiClient apiClient = new ApiClient();

    public ApiClientWrapper(String uri, String token, Integer connectTimeoutSeconds, Integer readTimeoutSeconds, Integer writeTimeoutSeconds) throws ApiException {
        this.apiClient.setBasePath(uri + "/api/v1");
        if (connectTimeoutSeconds != null) {
            this.apiClient.setConnectTimeout(connectTimeoutSeconds * 1000);
        }
        if (readTimeoutSeconds != null) {
            this.apiClient.setReadTimeout(readTimeoutSeconds * 1000);
        }
        if (writeTimeoutSeconds != null) {
            this.apiClient.setWriteTimeout(writeTimeoutSeconds * 1000);
        }
        try {
            this.apiClient.setApiKeyPrefix(AUTH_HEADER_TOKEN);
            this.apiClient.setApiKey(Base64.encodeBase64String((byte[])token.getBytes("UTF-8")));
        }
        catch (UnsupportedEncodingException e) {
            String msg = MessageFormat.format("[ERROR] Error encoding SSC auth token : {0}", token);
            throw new ApiException(msg + e.getLocalizedMessage());
        }
    }

    public void setProxy(ProxyConfig proxyConfig) {
        if (proxyConfig != null) {
            this.apiClient.setHttpClient(proxyConfig.decorateClient(this.apiClient.getHttpClient(), this.apiClient.getBasePath()));
        }
    }

    public List<Project> getApplications(String query, int limit) throws ApiException {
        ArrayList<Project> appList = new ArrayList<Project>();
        ProjectControllerApi projectControllerApi = new ProjectControllerApi(this.apiClient);
        String partialQuery = StringUtils.isEmpty((String)query) ? null : "name:\"*" + query + "*\"";
        ApiResultListProject apiResultListProject = projectControllerApi.listProject("name,id", Integer.valueOf(0), Integer.valueOf(limit), partialQuery, Boolean.valueOf(false), "name");
        for (Project app : apiResultListProject.getData()) {
            appList.add(app);
        }
        return appList;
    }

    public List<ProjectVersion> getAllApplicationVersions(String query, int limit) throws ApiException {
        ArrayList<ProjectVersion> appVersionList = new ArrayList<ProjectVersion>();
        ProjectVersionControllerApi projectVersionControllerApi = new ProjectVersionControllerApi(this.apiClient);
        String partialQuery = StringUtils.isEmpty((String)query) ? null : "name:\"*" + query + "*\"";
        ApiResultListProjectVersion apiResultListProjectVersion = projectVersionControllerApi.listProjectVersion("name,id,project", Integer.valueOf(0), Integer.valueOf(limit), partialQuery, Boolean.valueOf(false), "name", Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false));
        for (ProjectVersion appVersion : apiResultListProjectVersion.getData()) {
            appVersionList.add(appVersion);
        }
        return appVersionList;
    }

    public List<ProjectVersion> getApplicationVersionsFor(long applicationId, String query, int limit) throws ApiException {
        ArrayList<ProjectVersion> appVersionList = new ArrayList<ProjectVersion>();
        ProjectVersionOfProjectControllerApi appVerApi = new ProjectVersionOfProjectControllerApi(this.apiClient);
        String partialQuery = StringUtils.isEmpty((String)query) ? null : "name:\"*" + query + "*\"";
        ApiResultListProjectVersion apiResultListProjectVersion = appVerApi.listProjectVersionOfProject(Long.valueOf(applicationId), "name,id", Integer.valueOf(0), Integer.valueOf(limit), partialQuery, Boolean.valueOf(false), "name", Boolean.valueOf(false), Boolean.valueOf(false));
        for (ProjectVersion appVersion : apiResultListProjectVersion.getData()) {
            appVersionList.add(appVersion);
        }
        return appVersionList;
    }

    public List<AttributeDefinition> getAttributeDefinitions() throws ApiException {
        ArrayList<AttributeDefinition> attrDefinitionList = new ArrayList<AttributeDefinition>();
        AttributeDefinitionControllerApi attrDefinitionControllerApi = new AttributeDefinitionControllerApi(this.apiClient);
        ApiResultListAttributeDefinition apiResultListAttrDefinition = attrDefinitionControllerApi.listAttributeDefinition(null, Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE), null, null);
        for (AttributeDefinition attrDef : apiResultListAttrDefinition.getData()) {
            attrDefinitionList.add(attrDef);
        }
        return attrDefinitionList;
    }

    public List<IssueTemplate> getIssueTemplates() throws ApiException {
        ArrayList<IssueTemplate> issueTemplateList = new ArrayList<IssueTemplate>();
        IssueTemplateControllerApi issueTemplateControllerApi = new IssueTemplateControllerApi(this.apiClient);
        ApiResultListIssueTemplate apiResultListIssueTemplate = issueTemplateControllerApi.listIssueTemplate(null, Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE), null, null);
        for (IssueTemplate issueTemplate : apiResultListIssueTemplate.getData()) {
            issueTemplateList.add(issueTemplate);
        }
        return issueTemplateList;
    }

    public List<CloudPool> getCloudScanPools() throws ApiException {
        ArrayList<CloudPool> cloudPoolList = new ArrayList<CloudPool>();
        CloudPoolControllerApi cloudPoolControllerApi = new CloudPoolControllerApi(this.apiClient);
        ApiResultListCloudPool apiResultListCloudPool = cloudPoolControllerApi.listCloudPool("name,uuid", Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE), null, Boolean.valueOf(false), null);
        for (CloudPool cloudPool : apiResultListCloudPool.getData()) {
            cloudPoolList.add(cloudPool);
        }
        return cloudPoolList;
    }

    public List<ProjectVersionIssueGroup> getIssueGroupsForAvs(Long avId, String searchCondition, String folderId, String filterSet, String groupingType) throws ApiException {
        ArrayList<ProjectVersionIssueGroup> issueGroups = new ArrayList<ProjectVersionIssueGroup>();
        IssueGroupOfProjectVersionControllerApi issueGroupControllerApi = new IssueGroupOfProjectVersionControllerApi(this.apiClient);
        ApiResultListProjectVersionIssueGroup apiResultList = issueGroupControllerApi.listIssueGroupOfProjectVersion(avId, Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE), searchCondition, "issues", filterSet, null, Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(true), "FOLDER:" + folderId, groupingType);
        for (ProjectVersionIssueGroup projectVersionIssueGroup : apiResultList.getData()) {
            issueGroups.add(projectVersionIssueGroup);
        }
        return issueGroups;
    }

    public List<ProjectVersionIssueGroup> getIssueGroupFolders(Long avId, String filterSet) throws ApiException {
        ArrayList<ProjectVersionIssueGroup> issueGroups = new ArrayList<ProjectVersionIssueGroup>();
        IssueGroupOfProjectVersionControllerApi issueGroupControllerApi = new IssueGroupOfProjectVersionControllerApi(this.apiClient);
        ApiResultListProjectVersionIssueGroup apiResultList = issueGroupControllerApi.listIssueGroupOfProjectVersion(avId, Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE), null, "issues", filterSet, null, Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(true), null, "FOLDER");
        for (ProjectVersionIssueGroup projectVersionIssueGroup : apiResultList.getData()) {
            issueGroups.add(projectVersionIssueGroup);
        }
        return issueGroups;
    }

    public ProjectVersionIssueGroup getNewIssueGroupForAv(Long avId, String folderId, String filterSet) throws ApiException {
        IssueGroupOfProjectVersionControllerApi issueGroupControllerApi = new IssueGroupOfProjectVersionControllerApi(this.apiClient);
        ApiResultListProjectVersionIssueGroup apiResultList = issueGroupControllerApi.listIssueGroupOfProjectVersion(avId, Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE), "11111111-1111-1111-1111-111111111167", "issues", null, null, Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(true), "FOLDER:" + folderId, filterSet);
        Iterator iterator = apiResultList.getData().iterator();
        if (iterator.hasNext()) {
            ProjectVersionIssueGroup projectVersionIssueGroup = (ProjectVersionIssueGroup)iterator.next();
            return projectVersionIssueGroup;
        }
        return null;
    }

    public List<FilterSet> getFilterSetsForAppVersion(Long appVersionId) throws ApiException {
        ArrayList<FilterSet> filterSetList = new ArrayList<FilterSet>();
        FilterSetOfProjectVersionControllerApi filterSetOfProjectVersionControllerApi = new FilterSetOfProjectVersionControllerApi(this.apiClient);
        ApiResultListFilterSet apiResultListFilterSet = filterSetOfProjectVersionControllerApi.listFilterSetOfProjectVersion(appVersionId, Integer.valueOf(0), Integer.valueOf(-1), null);
        for (FilterSet filterset : apiResultListFilterSet.getData()) {
            filterSetList.add(filterset);
        }
        return filterSetList;
    }

    public FilterSet getDefaultFilterSetForAppVersion(Long appVersionId) throws ApiException {
        FilterSet defaultFilterSet = null;
        List<FilterSet> filterSetList = this.getFilterSetsForAppVersion(appVersionId);
        if (filterSetList != null) {
            for (FilterSet filterSet : filterSetList) {
                if (!filterSet.getDefaultFilterSet().booleanValue()) continue;
                defaultFilterSet = filterSet;
                break;
            }
        }
        if (defaultFilterSet == null) {
            defaultFilterSet = filterSetList.get(0);
        }
        return defaultFilterSet;
    }

    public List<ProjectVersionIssue> getIssuesForAppVersion(Long appVersionId, int startPage, int pageSize, String filter, String groupId, String groupingType) throws ApiException {
        ArrayList<ProjectVersionIssue> issues = new ArrayList<ProjectVersionIssue>();
        IssueOfProjectVersionControllerApi issueSetOfProjectVersionControllerApi = new IssueOfProjectVersionControllerApi(this.apiClient);
        ApiResultListProjectVersionIssue apiResultListProjectVersionIssue = issueSetOfProjectVersionControllerApi.listIssueOfProjectVersion(appVersionId, Integer.valueOf(startPage), Integer.valueOf(pageSize), null, null, "issueName", null, null, Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(true), null, filter, groupId, groupingType, null);
        for (ProjectVersionIssue issue : apiResultListProjectVersionIssue.getData()) {
            issues.add(issue);
        }
        return issues;
    }

    public List<IssueSelector> getGroupBySetForAppVersion(Long appVersionId) throws ApiException {
        ArrayList<IssueSelector> list = new ArrayList<IssueSelector>();
        IssueSelectorSetOfProjectVersionControllerApi issueSelectorSetOfProjectVersionControllerApi = new IssueSelectorSetOfProjectVersionControllerApi(this.apiClient);
        ApiResultIssueFilterSelectorSet apiResultIssueFilterSelectorSet = issueSelectorSetOfProjectVersionControllerApi.getIssueSelectorSetOfProjectVersion(appVersionId, null);
        for (IssueSelector item : apiResultIssueFilterSelectorSet.getData().getGroupBySet()) {
            list.add(item);
        }
        return list;
    }

    public Long getApplicationId(String appName) throws ApiException {
        Project application = null;
        if (!StringUtils.isEmpty((String)appName)) {
            String appQuery = "name:\"" + appName + "\"";
            ProjectControllerApi projectControllerApi = new ProjectControllerApi(this.apiClient);
            ApiResultListProject apiResultListProject = projectControllerApi.listProject(null, Integer.valueOf(0), Integer.valueOf(1), appQuery, Boolean.valueOf(false), null);
            if (apiResultListProject.getData().size() > 0) {
                application = (Project)apiResultListProject.getData().get(0);
            }
        }
        return application != null ? application.getId() : null;
    }

    public Long getVersionForApplication(Long applicationId, String appVersionName) throws ApiException {
        ProjectVersion applicationVersion = null;
        String versionQuery = "name:\"" + appVersionName + "\"";
        ProjectVersionOfProjectControllerApi projectVersionOfProjectControllerApi = new ProjectVersionOfProjectControllerApi(this.apiClient);
        ApiResultListProjectVersion apiResultListProjectVersion = projectVersionOfProjectControllerApi.listProjectVersionOfProject(applicationId, null, Integer.valueOf(0), Integer.valueOf(1), versionQuery, Boolean.valueOf(false), null, Boolean.valueOf(false), Boolean.valueOf(false));
        if (apiResultListProjectVersion.getData().size() > 0) {
            applicationVersion = (ProjectVersion)apiResultListProjectVersion.getData().get(0);
        }
        return applicationVersion != null ? applicationVersion.getId() : null;
    }

    public IssueTemplate getIssueTemplate(Project application) throws ApiException {
        IssueTemplate issueTemplate = null;
        IssueTemplateControllerApi issueTemplateControllerApi = new IssueTemplateControllerApi(this.apiClient);
        if (application != null && application.getIssueTemplateId() != null) {
            ApiResultIssueTemplate apiResultIssueTemplate = issueTemplateControllerApi.readIssueTemplate(application.getIssueTemplateId(), null);
            issueTemplate = apiResultIssueTemplate.getData();
        } else {
            issueTemplate = this.getDefaultIssueTemplate();
        }
        return issueTemplate;
    }

    private IssueTemplate getDefaultIssueTemplate() throws ApiException {
        IssueTemplate issueTemplate = null;
        List<IssueTemplate> issueTemplates = this.getIssueTemplates();
        if (issueTemplates != null) {
            for (IssueTemplate template : issueTemplates) {
                if (template == null || !template.getDefaultTemplate().booleanValue()) continue;
                issueTemplate = template;
                break;
            }
            if (issueTemplate == null) {
                issueTemplate = issueTemplates.get(0);
            }
        }
        return issueTemplate;
    }

    public Long createAppOrVersion(Long appId, String issueTemplateId, String appName, String appVersionName, String masterAttrGuid, AppTypeEnum type) throws ApiException {
        Long appVersionId;
        ProjectVersion appVersion = new ProjectVersion();
        appVersion.setName(appVersionName);
        appVersion.setIssueTemplateId(issueTemplateId);
        appVersion.setMasterAttrGuid(masterAttrGuid);
        appVersion.setActive(Boolean.valueOf(true));
        appVersion.setCommitted(Boolean.valueOf(false));
        if (type == AppTypeEnum.APPLICATION) {
            Project app = new Project();
            app.setName(appName);
            if (issueTemplateId != null) {
                app.setIssueTemplateId(issueTemplateId);
            } else {
                IssueTemplate it = this.getDefaultIssueTemplate();
                if (it != null) {
                    app.setIssueTemplateId(it.getId());
                }
            }
            appVersion.setProject(app);
            ProjectVersionControllerApi projectVersionControllerApi = new ProjectVersionControllerApi(this.apiClient);
            try {
                ApiResultProjectVersion apiResultProjectVersion = projectVersionControllerApi.createProjectVersion(appVersion);
                ProjectVersion newVersion = apiResultProjectVersion.getData();
                appVersionId = newVersion.getId();
            }
            catch (ApiException ex) {
                throw new ApiException((Throwable)ex);
            }
        }
        ProjectVersionOfProjectControllerApi projectVersionOfProjectControllerApi = new ProjectVersionOfProjectControllerApi(this.apiClient);
        try {
            ApiResultProjectVersion apiResultProjectVersion = projectVersionOfProjectControllerApi.createProjectVersionOfProject(appId, appVersion);
            ProjectVersion newVersion = apiResultProjectVersion.getData();
            appVersionId = newVersion.getId();
        }
        catch (ApiException ex) {
            throw new ApiException((Throwable)ex);
        }
        return appVersionId;
    }

    public void setDefaultAttributesAndCommit(Long appVersionId) throws ApiException {
        AttributeDefinitionControllerApi attributeDefinitionControllerApi = new AttributeDefinitionControllerApi(this.apiClient);
        String required = "required:true";
        ArrayList<Attribute> reqAttributes = new ArrayList<Attribute>();
        try {
            ApiResultListAttributeDefinition apiResultListAttributeDefinition = attributeDefinitionControllerApi.listAttributeDefinition(null, Integer.valueOf(0), Integer.valueOf(0), required, null);
            for (AttributeDefinition def : apiResultListAttributeDefinition.getData()) {
                if (def.getHasDefault().booleanValue()) continue;
                if (!"URL".equals(def.getName())) {
                    Attribute attribute;
                    if (def.getType() == AttributeDefinition.TypeEnum.TEXT) {
                        attribute = new Attribute();
                        attribute.setValue("changeme");
                        attribute.setAttributeDefinitionId(def.getId());
                        reqAttributes.add(attribute);
                        continue;
                    }
                    if (def.getType() != AttributeDefinition.TypeEnum.SINGLE && def.getType() != AttributeDefinition.TypeEnum.MULTIPLE) continue;
                    attribute = new Attribute();
                    AttributeOption first = (AttributeOption)def.getOptions().get(0);
                    ArrayList<AttributeOption> options = new ArrayList<AttributeOption>();
                    options.add(first);
                    attribute.setValues(options);
                    attribute.setAttributeDefinitionId(def.getId());
                    reqAttributes.add(attribute);
                    continue;
                }
                break;
            }
        }
        catch (ApiException ex) {
            throw new ApiException((Throwable)ex);
        }
        AttributeOfProjectVersionControllerApi attributeOfProjectVersionControllerApi = new AttributeOfProjectVersionControllerApi(this.apiClient);
        try {
            for (Attribute att : reqAttributes) {
                attributeOfProjectVersionControllerApi.createAttributeOfProjectVersion(appVersionId, att);
            }
        }
        catch (ApiException ex) {
            throw new ApiException((Throwable)ex);
        }
        ProjectVersionControllerApi projectVersionControllerApi = new ProjectVersionControllerApi(this.apiClient);
        try {
            ProjectVersion appVersion = new ProjectVersion();
            appVersion.setCommitted(Boolean.valueOf(true));
            projectVersionControllerApi.updateProjectVersion(appVersionId, appVersion);
        }
        catch (ApiException ex) {
            throw new ApiException((Throwable)ex);
        }
    }

    public Long uploadFpr(@Nonnull File fpr, @Nonnull Long appVersionId) throws ApiException {
        ArtifactOfProjectVersionControllerApi artifactOfProjectVersionControllerApi = new ArtifactOfProjectVersionControllerApi(this.apiClient);
        ApiResultArtifact result = artifactOfProjectVersionControllerApi.uploadArtifactOfProjectVersion(appVersionId, fpr, null);
        return result.getData().getId();
    }

    public Artifact getArtifactInfo(@Nonnull Long artifactId) throws ApiException {
        ArtifactControllerApi artifactControllerApi = new ArtifactControllerApi(this.apiClient);
        return artifactControllerApi.readArtifact(artifactId, null, null).getData();
    }

    public List<Folder> getFoldersForAppVersion(Long appVersionId) throws ApiException {
        ArrayList<Folder> folders = new ArrayList<Folder>();
        FolderOfProjectVersionControllerApi folderOfProjectVersionControllerApi = new FolderOfProjectVersionControllerApi(this.apiClient);
        ApiResultListFolder apiResultListFolder = folderOfProjectVersionControllerApi.listFolderOfProjectVersion(appVersionId);
        for (Folder folder : apiResultListFolder.getData()) {
            folders.add(folder);
        }
        return folders;
    }

    public static enum AppTypeEnum {
        APPLICATION,
        APP_VERSION;

    }
}

