/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.plugin.jenkins.credentials;

import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.impl.BaseStandardCredentials;
import com.fortify.plugin.jenkins.credentials.FortifyApiToken;
import hudson.Extension;
import hudson.util.FormValidation;
import hudson.util.Secret;
import javax.annotation.CheckForNull;
import lombok.NonNull;
import org.apache.commons.lang.StringUtils;
import org.jenkins.ui.icon.Icon;
import org.jenkins.ui.icon.IconSet;
import org.jenkins.ui.icon.IconType;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class StandardFortifyApiToken
extends BaseStandardCredentials
implements FortifyApiToken {
    private static final long serialVersionUID = -7103736612075250489L;
    @NonNull
    private final Secret token;

    @DataBoundConstructor
    public StandardFortifyApiToken(@CheckForNull CredentialsScope scope, @CheckForNull String id, @NonNull String token, @CheckForNull String description) {
        super(scope, id, description);
        if (token == null) {
            throw new NullPointerException("token is marked non-null but is null");
        }
        this.token = Secret.fromString((String)token);
    }

    @Override
    @NonNull
    public Secret getToken() {
        return this.token;
    }

    @Extension
    public static class DefaultFortifyApiTokenDescriptor
    extends BaseStandardCredentials.BaseStandardCredentialsDescriptor {
        @NonNull
        public String getDisplayName() {
            return "Fortify Connection Token";
        }

        public String getIconClassName() {
            return "icon-fortify-credentials";
        }

        public FormValidation doCheckToken(@QueryParameter Secret token) {
            if (StringUtils.isBlank((String)Secret.toString((Secret)token))) {
                return FormValidation.error((String)"Token cannot be empty");
            }
            return FormValidation.ok();
        }

        static {
            IconSet.icons.addIcon(new Icon("icon-fortify-credentials icon-sm", "fortify/icons/f-16x16.png", "width: 16px; height: 16px;", IconType.PLUGIN));
            IconSet.icons.addIcon(new Icon("icon-fortify-credentials icon-md", "fortify/icons/f-24x24.png", "width: 16px; height: 16px;", IconType.PLUGIN));
            IconSet.icons.addIcon(new Icon("icon-fortify-credentials icon-lg", "fortify/icons/f-32x32.png", "width: 16px; height: 16px;", IconType.PLUGIN));
            IconSet.icons.addIcon(new Icon("icon-fortify-credentials icon-xlg", "fortify/icons/f-48x48.png", "width: 16px; height: 16px;", IconType.PLUGIN));
        }
    }
}

