/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.plugin.jenkins;

import com.fortify.plugin.jenkins.FPRSummary;
import com.fortify.plugin.jenkins.bean.IssueBean;
import com.fortify.plugin.jenkins.bean.IssueFolderBean;
import com.fortify.plugin.jenkins.steps.FortifyUpload;
import hudson.model.Action;
import hudson.model.Job;
import hudson.model.Run;
import hudson.model.StreamBuildListener;
import hudson.model.TaskListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.bind.JavaScriptMethod;
import org.kohsuke.stapler.verb.POST;

public class TableAction
implements Action {
    private Long lastChanged;
    private long lastUpdated;
    private String projectFullName;
    private FortifyUpload manager;
    private String appName;
    private String appVersion;
    private List<IssueFolderBean> folders;

    public TableAction(Job<?, ?> project, FortifyUpload upload, String appName, String appVersion) {
        this.projectFullName = project.getFullName();
        this.manager = upload;
        this.appName = appName;
        this.appVersion = appVersion;
    }

    public String getAppName() {
        return this.appName;
    }

    public String getAppVersion() {
        return this.appVersion;
    }

    public boolean getAccess() {
        return this.manager.getAccessToProject();
    }

    public String getDisplayName() {
        String name = "Fortify Assessment";
        if (this.appName != null || this.appVersion != null) {
            name = name + " (";
            if (this.appName != null) {
                name = name + this.appName;
                if (this.appVersion != null) {
                    name = name + "-";
                }
            }
            if (this.appVersion != null) {
                name = name + this.appVersion;
            }
            name = name + ")";
        }
        return name;
    }

    public String getIconFileName() {
        return "/plugin/fortify/icons/SSC-32x32.gif";
    }

    public String getUrlName() {
        String url = "fortify-issues";
        return url;
    }

    private Run<?, ?> getLastBuild() {
        Job<?, ?> project = this.getProject();
        if (project != null) {
            Run lastBuild = project.getLastBuild();
            if (lastBuild != null && lastBuild.isBuilding()) {
                lastBuild = lastBuild.getPreviousBuild();
            }
            return lastBuild;
        }
        return null;
    }

    public Job<?, ?> getProject() {
        if (this.projectFullName != null) {
            List allProjects = Jenkins.get().getAllItems(Job.class);
            for (Job next : allProjects) {
                if (next == null || !this.projectFullName.equals(next.getFullName())) continue;
                return next;
            }
        }
        return null;
    }

    public MergedBuildStatistics getBuildStats() {
        BuildStatistics lastBuildStats = this.getLastBuildStats();
        if (lastBuildStats != null) {
            return new MergedBuildStatistics(lastBuildStats, this.getPreviousBuildStats());
        }
        return null;
    }

    public BuildStatistics getLastBuildStats() {
        Run<?, ?> lastBuild = this.getLastBuild();
        return lastBuild == null ? null : this.getBuildStatsFor(lastBuild);
    }

    public BuildStatistics getPreviousBuildStats() {
        Run<?, ?> lastBuild = this.getLastBuild();
        Run previousBuild = null;
        if (lastBuild != null) {
            previousBuild = lastBuild.getPreviousBuild();
        }
        return previousBuild == null ? null : this.getBuildStatsFor(previousBuild);
    }

    private BuildStatistics getBuildStatsFor(Run<?, ?> build) {
        FPRSummary buildSummary = new FPRSummary();
        try {
            if (this.manager.isPipeline()) {
                buildSummary.load(build.getRootDir(), this.appName, this.appVersion);
            } else {
                buildSummary.load(build.getRootDir(), null, null);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        ArrayList<FolderStatistics> folderStats = new ArrayList<FolderStatistics>();
        for (IssueFolderBean next : buildSummary.getFolderBeans()) {
            folderStats.add(new FolderStatistics(next.getName(), next.getIssueCount()));
        }
        return new BuildStatistics(build.getDisplayName(), buildSummary.getTotalIssues(), buildSummary.getTotalIssues(), folderStats);
    }

    private boolean isUpdateNeeded() {
        if (this.manager.isSettingUpdated() || !this.manager.getAccessToProject()) {
            return true;
        }
        return this.getLastChanged() > this.lastUpdated;
    }

    long getLastChanged() {
        if (this.lastChanged == null) {
            this.lastChanged = 0L;
        }
        return this.lastChanged;
    }

    void setLastChanged(long currentTimeMillis) {
        this.lastChanged = currentTimeMillis;
    }

    public synchronized List<IssueFolderBean> getFolders() {
        if (this.folders == null || this.isUpdateNeeded()) {
            this.lastUpdated = System.currentTimeMillis();
            this.folders = this.manager.getFolders((TaskListener)new StreamBuildListener(System.out, Charset.defaultCharset()));
        }
        return this.folders;
    }

    @POST
    public void doSetPageSize(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        String size = req.getParameter("size");
        Integer hadValue = (Integer)req.getSession().getAttribute("pageSize");
        if (hadValue == null) {
            hadValue = this.manager.getIssuePageSize();
        }
        if (StringUtils.isNotBlank((String)size)) {
            try {
                View view;
                int pageSize = Integer.parseInt(size);
                if (pageSize != hadValue && (view = (View)req.getSession().getAttribute("currentView")) != null) {
                    view.setPage(0);
                    view.setPageSize(pageSize);
                }
                req.getSession().setAttribute("pageSize", (Object)pageSize);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.doAjaxIssues(req, rsp);
    }

    public void doSelectedGrouping(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
    }

    @POST
    public void doShowAllNotNew(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        View view;
        String all = req.getParameter("all");
        if (StringUtils.isBlank((String)all)) {
            return;
        }
        boolean showingAllNotNew = "yes".equalsIgnoreCase(all.trim());
        Boolean hadValue = (Boolean)req.getSession().getAttribute("showingAllNotNew");
        if (hadValue == null) {
            hadValue = Boolean.TRUE;
        }
        if (showingAllNotNew != hadValue && (view = (View)req.getSession().getAttribute("currentView")) != null) {
            view.setPage(0);
            view.setShowingAllNotNew(showingAllNotNew);
        }
        req.getSession().setAttribute("showingAllNotNew", (Object)showingAllNotNew);
        this.doAjaxIssues(req, rsp);
    }

    @POST
    public void doUpdateIssueList(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        View view;
        String viewName = req.getParameter("folder");
        if (StringUtils.isBlank((String)viewName)) {
            return;
        }
        String page = req.getParameter("page");
        int pageNum = 0;
        if (StringUtils.isNotBlank((String)page)) {
            try {
                pageNum = Integer.parseInt(page);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((view = (View)req.getSession().getAttribute("currentView")) != null) {
            view.setFolder(this.getFolderByName(viewName));
            view.setPage(pageNum);
            req.getSession().setAttribute("currentView", (Object)view);
        }
        this.doAjaxIssues(req, rsp);
    }

    @POST
    public void doAjaxIssues(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        Object currView = req.getSession().getAttribute("currentView");
        if ("yes".equalsIgnoreCase(req.getParameter("firstTime")) || currView == null) {
            List<IssueFolderBean> folders = this.getFolders();
            if (!folders.isEmpty()) {
                currView = new View(folders.get(0), this.manager, 0);
                req.getSession().setAttribute("currentView", currView);
            }
            req.getSession().setAttribute("showingAllNotNew", (Object)Boolean.TRUE);
            req.getSession().setAttribute("pageSize", (Object)this.manager.getIssuePageSize());
        }
        rsp.setContentType("text/html;charset=UTF-8");
        this.ensureNoCaching(rsp);
        req.getView((Object)this, "issuesByFriorityTable.jelly").forward((ServletRequest)req, (ServletResponse)rsp);
    }

    public void doAjaxStats(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        rsp.setContentType("text/html;charset=UTF-8");
        this.ensureNoCaching(rsp);
        req.getView((Object)this, "issueCountTable.jelly").forward((ServletRequest)req, (ServletResponse)rsp);
    }

    @POST
    public synchronized void doCheckUpdates(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        long lastChanged = this.getLastChanged();
        try {
            String stamp = req.getParameter("stamp");
            long lastUpdated = Long.parseLong(stamp);
            if (lastUpdated < lastChanged) {
                rsp.setHeader("go", "go");
                View view = (View)req.getSession().getAttribute("currentView");
                if (view != null) {
                    IssueFolderBean folder = this.getFolderByName(view.getFolder().getName());
                    if (folder != null) {
                        view.setFolder(folder);
                    }
                    req.getSession().setAttribute("currentView", (Object)view);
                }
            }
            rsp.setHeader("yourStampWas", String.valueOf(lastUpdated));
        }
        catch (NumberFormatException e) {
            rsp.setHeader("yourStampWas", "0");
        }
        rsp.setHeader("myStampWas", String.valueOf(lastChanged));
        this.ensureNoCaching(rsp);
    }

    private void ensureNoCaching(StaplerResponse rsp) {
        rsp.setHeader("Cache-Control", "no-store, no-cache, must-revalidate");
        rsp.setHeader("Pragma", "no-cache");
        rsp.setDateHeader("Expires", 0L);
    }

    private IssueFolderBean getFolderByName(String name) {
        for (IssueFolderBean next : this.getFolders()) {
            if (!next.getName().equals(name)) continue;
            return next;
        }
        return null;
    }

    public static class View
    implements Comparable,
    Serializable {
        private static final long serialVersionUID = 2272994600618007658L;
        private final FortifyUpload manager;
        private IssueFolderBean folder;
        private int page;
        private SortOrder sortOrder;
        private boolean sortDownNotUp;
        private int pageSize;
        private boolean showingAllNotNew;
        private String selectedGrouping;
        private transient List<IssueBean> issuesByFolder = null;
        private transient Boolean needsUpdate = null;

        public View(IssueFolderBean descriptor, FortifyUpload manager, int pageNum) {
            this.folder = descriptor;
            this.manager = manager;
            this.page = pageNum;
            this.sortDownNotUp = false;
            this.sortOrder = SortOrder.location;
            this.pageSize = manager.getIssuePageSize();
            this.showingAllNotNew = true;
            this.selectedGrouping = "Category";
            this.scheduleUpdate();
        }

        private void readObject(ObjectInputStream aInputStream) throws ClassNotFoundException, IOException {
            this.needsUpdate = null;
            this.issuesByFolder = null;
            aInputStream.defaultReadObject();
        }

        @JavaScriptMethod
        public String getSelectedGrouping() {
            return this.selectedGrouping;
        }

        @JavaScriptMethod
        public void setSelectedGrouping(String selectedGrouping) {
        }

        @JavaScriptMethod
        public String getDisplayName() {
            List<IssueBean> issues;
            int hasItems;
            int issueCount;
            int n = issueCount = this.showingAllNotNew ? this.folder.getIssueCount() : this.folder.getIssueNewCount();
            if (this.pageSize == -1) {
                this.pageSize = issueCount;
            }
            int n2 = hasItems = (issues = this.getIssues()) != null ? issues.size() : 0;
            if (hasItems == 0) {
                return String.format(this.page == 0 ? "%s (No Issues)" : "%s (No New Issues)", this.folder.getName());
            }
            int firstItem = this.page * this.pageSize;
            int shownItems = firstItem + hasItems;
            return String.format("%s (%d to %d out of %d)", this.folder.getName(), firstItem + 1, shownItems, issueCount);
        }

        @JavaScriptMethod
        public void setPage(int pageNum) {
            if (pageNum != this.page) {
                this.page = pageNum;
                this.scheduleUpdate();
            }
        }

        @JavaScriptMethod
        public int getPage() {
            return this.page;
        }

        @JavaScriptMethod
        public int getNextPage() {
            return this.page + 1;
        }

        @JavaScriptMethod
        public int getPreviousPage() {
            return this.page - 1;
        }

        @JavaScriptMethod
        public IssueFolderBean getFolder() {
            return this.folder;
        }

        @JavaScriptMethod
        public String getSortOrder() {
            return this.sortOrder == null ? "" : this.sortOrder.name();
        }

        @JavaScriptMethod
        public boolean getSortDownNotUp() {
            return this.sortDownNotUp;
        }

        @JavaScriptMethod
        public List<IssueBean> getIssues() {
            if (this.folder.isEmpty()) {
                return Collections.emptyList();
            }
            if (this.needsUpdate()) {
                this.needsUpdate = Boolean.FALSE;
                this.issuesByFolder = this.manager.getIssuesByFolder(this.folder.getId(), this.page, this.pageSize, this.sortOrder, this.sortDownNotUp, this.showingAllNotNew, this.getSelectedGrouping(), (TaskListener)new StreamBuildListener(System.out, Charset.defaultCharset()));
            }
            return this.issuesByFolder;
        }

        private boolean needsUpdate() {
            if (this.needsUpdate == null) {
                this.needsUpdate = Boolean.TRUE;
            }
            return this.needsUpdate;
        }

        @JavaScriptMethod
        public void scheduleUpdate() {
            this.needsUpdate = Boolean.TRUE;
        }

        @JavaScriptMethod
        public boolean isHasNext() {
            if (this.pageSize == -1 || this.folder.isEmpty()) {
                return false;
            }
            int shown = (this.page + 1) * this.pageSize;
            int total = this.showingAllNotNew ? this.folder.getIssueCount() : this.folder.getIssueNewCount();
            return total > shown;
        }

        @JavaScriptMethod
        public boolean isHasPrevious() {
            if (this.pageSize == -1 || this.folder.isEmpty()) {
                return false;
            }
            return this.page > 0;
        }

        public int compareTo(Object o) {
            View otherView = (View)o;
            return otherView.getFolder().compareTo(this.getFolder());
        }

        public boolean equals(Object obj) {
            if (obj instanceof View) {
                View otherView = (View)obj;
                return otherView.getFolder().equals(this.getFolder()) && otherView.getPage() == this.getPage();
            }
            return super.equals(obj);
        }

        public int hashCode() {
            return this.getFolder().hashCode() + 31 * this.getPage();
        }

        @JavaScriptMethod
        public void setSortOrder(SortOrder order) {
            this.sortOrder = order;
        }

        @JavaScriptMethod
        public void setFolder(IssueFolderBean folder) {
            this.folder = folder;
            this.scheduleUpdate();
        }

        @JavaScriptMethod
        public void setPageSize(int pageSize) {
            this.pageSize = pageSize;
            this.scheduleUpdate();
        }

        @JavaScriptMethod
        public void setShowingAllNotNew(boolean showingAllNotNew) {
            this.showingAllNotNew = showingAllNotNew;
            this.scheduleUpdate();
        }
    }

    public static final class MergedBuildStatistics
    extends BuildStatistics {
        private BuildStatistics second;

        public MergedBuildStatistics(BuildStatistics first, BuildStatistics second) {
            super(first.name, first.totalIssues, first.newIssues, MergedBuildStatistics.mergeFolders(first, second));
            this.second = second;
        }

        private static List<MergedFolderStatistics> mergeFolders(BuildStatistics first, BuildStatistics second) {
            ArrayList<MergedFolderStatistics> result = new ArrayList<MergedFolderStatistics>();
            for (FolderStatistics folderStatistics : first.getFolders()) {
                if ("All".equals(folderStatistics.getName())) continue;
                FolderStatistics prev = null;
                if (second != null) {
                    for (FolderStatistics folderStatistics2 : second.getFolders()) {
                        if (!folderStatistics2.getName().equals(folderStatistics.getName())) continue;
                        prev = folderStatistics2;
                        break;
                    }
                }
                result.add(new MergedFolderStatistics(folderStatistics, prev));
            }
            return result;
        }

        public boolean isHasPrev() {
            return this.second != null;
        }

        public String getPrevBuildName() {
            return this.isHasPrev() ? this.second.getName() : null;
        }

        public int getPrevTotal() {
            return this.isHasPrev() ? this.second.totalIssues : -1;
        }

        public int getPrevNew() {
            return this.isHasPrev() ? this.second.newIssues : -1;
        }

        public boolean isLess() {
            return this.isHasPrev() && ((BuildStatistics)this).totalIssues < this.getPrevTotal();
        }

        public boolean isMore() {
            return this.isHasPrev() && ((BuildStatistics)this).totalIssues > this.getPrevTotal();
        }
    }

    public static class BuildStatistics {
        private String name;
        private int totalIssues;
        private int newIssues;
        private List<? extends FolderStatistics> folderValues;

        public BuildStatistics(String name, int totalIssues, int newIssues, List<? extends FolderStatistics> folderValues) {
            this.name = name;
            this.totalIssues = totalIssues;
            this.newIssues = newIssues;
            this.folderValues = folderValues;
        }

        public String getName() {
            return this.name;
        }

        public String getTotal() {
            return String.valueOf(this.totalIssues);
        }

        public String getNew() {
            return String.valueOf(this.newIssues);
        }

        public List<? extends FolderStatistics> getFolders() {
            return this.folderValues;
        }
    }

    public static class MergedFolderStatistics
    extends FolderStatistics {
        private FolderStatistics second;

        public MergedFolderStatistics(FolderStatistics first, FolderStatistics second) {
            super(first.name, first.issueCount);
            this.second = second;
        }

        public boolean isHasPrev() {
            return this.second != null;
        }

        public int getPrevIssueCount() {
            return this.isHasPrev() ? this.second.getIssueCount() : -1;
        }

        public boolean isLess() {
            return this.isHasPrev() && this.getIssueCount() < this.getPrevIssueCount();
        }

        public boolean isMore() {
            return this.isHasPrev() && this.getIssueCount() > this.getPrevIssueCount();
        }
    }

    public static class FolderStatistics {
        private String name;
        private int issueCount;

        public FolderStatistics(String name, int issueCount) {
            this.name = name;
            this.issueCount = issueCount;
        }

        public String getName() {
            return this.name;
        }

        public int getIssueCount() {
            return this.issueCount;
        }
    }

    public static enum SortOrder {
        location{

            @Override
            public String getModelSorting() {
                return "File";
            }

            @Override
            public Comparator<IssueBean> getIssueBeanComparator(final boolean reverseSort) {
                return new Comparator<IssueBean>(){

                    @Override
                    public int compare(IssueBean o1, IssueBean o2) {
                        IssueBean second;
                        IssueBean first;
                        if (reverseSort) {
                            first = o2;
                            second = o1;
                        } else {
                            first = o1;
                            second = o2;
                        }
                        if (first.getFilePath().equals(second.getFilePath())) {
                            return Integer.parseInt(first.getLineNumber()) - Integer.parseInt(second.getLineNumber());
                        }
                        return first.getFilePath().toLowerCase(Locale.ENGLISH).compareTo(second.getFilePath().toLowerCase(Locale.ENGLISH));
                    }
                };
            }
        };


        public abstract String getModelSorting();

        public abstract Comparator<IssueBean> getIssueBeanComparator(boolean var1);
    }
}

