/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.plugin.jenkins;

import com.fortify.plugin.jenkins.FPRSummary;
import hudson.FilePath;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.remoting.RoleChecker;

public class RemoteService
implements FilePath.FileCallable<FPRSummary> {
    private static final long serialVersionUID = 229830219491170076L;
    private final String fpr;
    private final StringBuilder logMsg;

    public RemoteService(String fpr) {
        this.fpr = fpr;
        this.logMsg = new StringBuilder();
    }

    public FPRSummary invoke(File workspace, VirtualChannel channel) throws IOException {
        FPRSummary summary = new FPRSummary();
        File realFPR = RemoteService.locateFPR(workspace, this.fpr);
        summary.setFprFile(new FilePath(realFPR));
        String s = this.logMsg.toString();
        if (!StringUtils.isBlank((String)s)) {
            summary.log(s);
        }
        return summary;
    }

    private static File locateFPR(File workspace, String fprPath) {
        File fpr = new File(fprPath);
        if (fpr.isAbsolute()) {
            if (fpr.exists()) {
                return fpr;
            }
            throw new RuntimeException("Analysis results file '" + fpr + "' doesn't exist!");
        }
        File fprInWorkspace = RemoteService.locateFPRInWorkspace(workspace, fprPath);
        if (null == fprInWorkspace) {
            throw new RuntimeException("Can't locate analysis results file '" + fpr + "' under workspace: " + workspace.getAbsolutePath());
        }
        return fprInWorkspace;
    }

    private static File locateFPRInWorkspace(File path, String preferredFileName) {
        String[] ext = new String[]{"fpr", "zip"};
        Iterator iterator = FileUtils.iterateFiles((File)path, (String[])ext, (boolean)true);
        long latestTime = 0L;
        File latestFile = null;
        while (iterator.hasNext()) {
            File file = (File)iterator.next();
            if (!RemoteService.isEmpty(preferredFileName) && !preferredFileName.equalsIgnoreCase(file.getName())) continue;
            if (null == latestFile) {
                latestTime = file.lastModified();
                latestFile = file;
                continue;
            }
            if (latestTime < file.lastModified()) {
                latestTime = file.lastModified();
                latestFile = file;
                continue;
            }
            if (latestTime != file.lastModified() || latestFile.getName().length() <= file.getName().length()) continue;
            latestFile = file;
        }
        return latestFile;
    }

    private static boolean isEmpty(String str) {
        return null == str || str.length() == 0;
    }

    public void checkRoles(RoleChecker arg0) throws SecurityException {
    }
}

