/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.plugin.jenkins;

import com.fortify.plugin.jenkins.FortifyException;
import com.fortify.plugin.jenkins.FortifyPlugin;
import com.fortify.plugin.jenkins.Message;
import hudson.Extension;
import hudson.ProxyConfiguration;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.util.Secret;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import okhttp3.Authenticator;
import okhttp3.Credentials;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.Route;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

public class ProxyConfig
extends AbstractDescribableImpl<ProxyConfig> {
    private static final Logger LOGGER = Logger.getLogger(FortifyPlugin.class.getName());
    private String proxyUrl;
    private Secret proxyUsername;
    private Secret proxyPassword;
    private List<Pattern> noProxyHostPatterns = Collections.emptyList();
    private boolean useJenkins = false;

    @DataBoundConstructor
    public ProxyConfig(String proxyUrl, Secret proxyUsername, Secret proxyPassword) {
        Pair<String, Integer> hostAndPort = null;
        try {
            proxyUrl = proxyUrl == null ? null : proxyUrl.trim();
            ProxyConfig.checkProxyUrlValue(proxyUrl);
            this.proxyUrl = proxyUrl;
            hostAndPort = ProxyConfig.parseProxyHostAndPort(proxyUrl);
        }
        catch (FortifyException e) {
            LOGGER.log(Level.WARNING, "Fortify proxy server configuration error: " + e.getMessage());
            this.proxyUrl = null;
        }
        if (this.proxyUrl != null && hostAndPort != null) {
            this.useJenkins = this.trySettingJenkinsProxy((String)hostAndPort.getLeft(), (Integer)hostAndPort.getRight(), proxyUsername, proxyPassword);
        }
        if (!this.useJenkins) {
            this.proxyUsername = proxyUsername;
            this.proxyPassword = proxyPassword;
            this.noProxyHostPatterns = Collections.singletonList(Pattern.compile(".*\\.fortify\\.com"));
        }
    }

    public static Pair<String, Integer> parseProxyHostAndPort(String proxyUrl) {
        if (proxyUrl == null) {
            return null;
        }
        String[] proxyUrlSplit = proxyUrl.split(":");
        String proxyHost = proxyUrlSplit[0];
        int proxyPort = 80;
        if (proxyUrlSplit.length > 1) {
            try {
                proxyPort = Integer.parseInt(proxyUrlSplit[1]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return Pair.of((Object)proxyHost, (Object)proxyPort);
    }

    private boolean trySettingJenkinsProxy(String proxyHost, int proxyPort, Secret proxyUsername, Secret proxyPassword) {
        ProxyConfiguration proxy;
        Jenkins jenkins = Jenkins.get();
        if (jenkins != null && ((proxy = jenkins.getProxy()) == null || StringUtils.isBlank((String)proxy.getName()))) {
            proxy = new ProxyConfiguration(proxyHost, proxyPort, Secret.toString((Secret)proxyUsername), Secret.toString((Secret)proxyPassword));
            proxy.setNoProxyHost("*.fortify.com");
            jenkins.setProxy(proxy);
            try {
                proxy.save();
                return true;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    private ProxyConfig() {
        this.useJenkins = true;
    }

    public String getProxyUrlFor(String url) {
        if (this.useJenkins) {
            Pair<String, Integer> hostPort = this.getJenkinsProxyHostPostFor(url);
            return hostPort == null ? "" : (String)hostPort.getLeft() + ':' + (Integer)hostPort.getRight();
        }
        for (Pattern next : this.noProxyHostPatterns) {
            if (!next.matcher(url).matches()) continue;
            return "";
        }
        return this.proxyUrl;
    }

    private Pair<String, Integer> getJenkinsProxyHostPostFor(String url) {
        String host;
        ProxyConfiguration proxyConfiguration = this.getJenkinsProxyInstanceOrNull();
        if (proxyConfiguration != null && !StringUtils.isBlank((String)(host = proxyConfiguration.getName()))) {
            if (!StringUtils.isBlank((String)url) && this.isInNoProxyHost(url, proxyConfiguration.getNoProxyHostPatterns())) {
                return null;
            }
            int port = proxyConfiguration.getPort();
            if (port <= 0) {
                port = 80;
            }
            return Pair.of((Object)host, (Object)port);
        }
        return null;
    }

    private boolean isInNoProxyHost(String url, List<Pattern> noProxyHostPatterns) {
        try {
            URL parsedUrl = new URL(url);
            String host = parsedUrl.getHost();
            if (!StringUtils.isBlank((String)host)) {
                for (Pattern next : noProxyHostPatterns) {
                    if (!next.matcher(host).matches()) continue;
                    return true;
                }
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return false;
    }

    private ProxyConfiguration getJenkinsProxyInstanceOrNull() {
        Jenkins instance = Jenkins.getInstanceOrNull();
        if (instance != null && instance.proxy != null) {
            ProxyConfiguration jenkinsProxy = instance.proxy;
            return jenkinsProxy;
        }
        return null;
    }

    public Secret getProxyUsername() {
        ProxyConfiguration proxyConfiguration;
        if (this.useJenkins && (proxyConfiguration = this.getJenkinsProxyInstanceOrNull()) != null) {
            return Secret.fromString((String)proxyConfiguration.getUserName());
        }
        return this.proxyUsername;
    }

    public Secret getProxyPassword() {
        ProxyConfiguration proxyConfiguration;
        if (this.useJenkins && (proxyConfiguration = this.getJenkinsProxyInstanceOrNull()) != null) {
            return proxyConfiguration.getSecretPassword();
        }
        return this.proxyPassword;
    }

    private static void checkProxyUrlValue(String proxyUrl) throws FortifyException {
        if (StringUtils.isNotBlank((String)proxyUrl)) {
            String[] splits = proxyUrl.split(":");
            if (splits.length > 2) {
                throw new FortifyException(new Message(4, "Invalid proxy url.  Format is <hostname>[:<port>]"));
            }
            Pattern hostPattern = Pattern.compile("([\\w\\-]+\\.)*[\\w\\-]+");
            Matcher hostMatcher = hostPattern.matcher(splits[0]);
            if (!hostMatcher.matches()) {
                throw new FortifyException(new Message(4, "Invalid proxy host"));
            }
            if (splits.length == 2) {
                try {
                    Integer.parseInt(splits[1]);
                }
                catch (NumberFormatException nfe) {
                    throw new FortifyException(new Message(4, "Invalid proxy port"));
                }
            }
        }
    }

    public OkHttpClient decorateClient(OkHttpClient client, String url) {
        OkHttpClient result = client;
        String proxyUrl = this.getProxyUrlFor(url);
        if (!StringUtils.isBlank((String)proxyUrl)) {
            Pair<String, Integer> hostPort = ProxyConfig.parseProxyHostAndPort(proxyUrl);
            Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress((String)hostPort.getLeft(), (int)((Integer)hostPort.getRight())));
            result = result.newBuilder().proxy(proxy).build();
        }
        Secret proxyUsername = this.getProxyUsername();
        Secret proxyPassword = this.getProxyPassword();
        if (proxyUsername != null && proxyPassword != null) {
            final String proxyUsernameString = proxyUsername.getPlainText();
            final String proxyPasswordString = proxyPassword.getPlainText();
            if (!StringUtils.isEmpty((String)proxyUsernameString) || !StringUtils.isEmpty((String)proxyPasswordString)) {
                Authenticator proxyAuthenticator = new Authenticator(){
                    boolean proxyAuthAttempted = false;

                    public Request authenticate(Route route, Response response) throws IOException {
                        if (this.proxyAuthAttempted) {
                            return null;
                        }
                        this.proxyAuthAttempted = true;
                        String credential = Credentials.basic((String)proxyUsernameString, (String)proxyPasswordString);
                        return response.request().newBuilder().header("Proxy-Authorization", credential).build();
                    }
                };
                result = result.newBuilder().proxyAuthenticator(proxyAuthenticator).build();
            }
        }
        return result;
    }

    public static ProxyConfig getJenkinsProxyConfig() {
        return new ProxyConfig();
    }

    @Extension
    public static final class DescriptorImpl
    extends Descriptor<ProxyConfig> {
        public String getDisplayName() {
            return "Use proxy";
        }

        public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
            return super.configure(req, json);
        }
    }
}

