/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.plugin.jenkins;

import java.io.File;
import java.io.FilenameFilter;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;

public class PathUtils {
    private static final Pattern FwdSlashSeq = Pattern.compile("//+");

    private static String getEnvironmentPath() {
        Map<String, String> env = System.getenv();
        for (Map.Entry<String, String> entry : env.entrySet()) {
            if (!"PATH".equalsIgnoreCase(entry.getKey())) continue;
            return entry.getValue();
        }
        return null;
    }

    public static File[] locateBasenameInPath(String filename) {
        String path = PathUtils.getEnvironmentPath();
        String pathSep = System.getProperty("path.separator");
        if (null != path) {
            String[] array;
            for (String s : array = path.split(Pattern.quote(pathSep))) {
                File[] files = PathUtils.findBasenameInFolder(s, filename);
                if (null == files || files.length <= 0) continue;
                return files;
            }
        }
        return null;
    }

    public static File[] findBasenameInFolder(String pathname, String filename) {
        File path = new File(pathname);
        File[] files = null;
        if (path.exists() && path.isDirectory()) {
            final String finalBasename = FilenameUtils.getBaseName((String)filename);
            FilenameFilter filter = new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return finalBasename.equalsIgnoreCase(FilenameUtils.getBaseName((String)name));
                }
            };
            files = path.listFiles(filter);
        }
        return files;
    }

    public static File locateFileInPath(String filename, String path) {
        if (path != null) {
            String[] array;
            for (String s : array = path.split(Pattern.quote(File.pathSeparator))) {
                File file;
                File folder = new File(s);
                if (!folder.isDirectory() || !(file = new File(folder, filename)).isFile()) continue;
                return file;
            }
        }
        return null;
    }

    public static String getShortFileName(String fullPath) {
        if (fullPath == null) {
            return null;
        }
        String normalizedPath = PathUtils.normalizeDirectorySeparators(fullPath);
        int lastSlash = normalizedPath.lastIndexOf("/");
        if (lastSlash == -1) {
            return fullPath;
        }
        return normalizedPath.substring(lastSlash + 1);
    }

    public static String getPath(String fullFilePath) {
        if (fullFilePath == null) {
            return null;
        }
        String normalizedPath = PathUtils.normalizeDirectorySeparators(fullFilePath);
        int lastSlash = normalizedPath.lastIndexOf("/");
        if (lastSlash == -1) {
            return "";
        }
        return normalizedPath.substring(0, lastSlash + 1);
    }

    public static String normalizeDirectorySeparators(String path) {
        if (path == null) {
            return null;
        }
        String norm = path.replace('\\', '/');
        if (norm.contains("//")) {
            norm = FwdSlashSeq.matcher(norm).replaceAll("/");
        }
        return norm;
    }

    public static String appendExtentionIfNotEmpty(String s, String defaultExtention, String ... allowedExtentions) {
        if (StringUtils.isNotEmpty((String)s)) {
            boolean extentionFound = false;
            for (String nextExtention : allowedExtentions) {
                if (!s.toLowerCase(Locale.ENGLISH).endsWith(nextExtention)) continue;
                extentionFound = true;
                break;
            }
            if (!extentionFound && !s.toLowerCase(Locale.ENGLISH).endsWith(defaultExtention)) {
                s = s + defaultExtention;
            }
        }
        return s;
    }
}

