/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.plugin.jenkins;

import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.CredentialsStore;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.domains.Domain;
import com.cloudbees.plugins.credentials.domains.URIRequirementBuilder;
import com.fortify.plugin.jenkins.FortifyException;
import com.fortify.plugin.jenkins.Message;
import com.fortify.plugin.jenkins.Messages;
import com.fortify.plugin.jenkins.ProxyConfig;
import com.fortify.plugin.jenkins.bean.ProjectTemplateBean;
import com.fortify.plugin.jenkins.bean.SensorPoolBean;
import com.fortify.plugin.jenkins.credentials.FortifyApiToken;
import com.fortify.plugin.jenkins.credentials.StandardFortifyApiToken;
import com.fortify.plugin.jenkins.fortifyclient.FortifyClient;
import com.fortify.plugin.jenkins.steps.CloudScanArguments;
import com.fortify.plugin.jenkins.steps.CloudScanMbs;
import com.fortify.plugin.jenkins.steps.CloudScanStart;
import com.fortify.plugin.jenkins.steps.FortifyClean;
import com.fortify.plugin.jenkins.steps.FortifyScan;
import com.fortify.plugin.jenkins.steps.FortifyTranslate;
import com.fortify.plugin.jenkins.steps.FortifyUpdate;
import com.fortify.plugin.jenkins.steps.FortifyUpload;
import com.fortify.plugin.jenkins.steps.remote.GradleProjectType;
import com.fortify.plugin.jenkins.steps.remote.MavenProjectType;
import com.fortify.plugin.jenkins.steps.remote.RemoteAnalysisProjectType;
import com.fortify.plugin.jenkins.steps.types.AdvancedScanType;
import com.fortify.plugin.jenkins.steps.types.DevenvScanType;
import com.fortify.plugin.jenkins.steps.types.DotnetSourceScanType;
import com.fortify.plugin.jenkins.steps.types.GradleScanType;
import com.fortify.plugin.jenkins.steps.types.JavaScanType;
import com.fortify.plugin.jenkins.steps.types.MavenScanType;
import com.fortify.plugin.jenkins.steps.types.MsbuildScanType;
import com.fortify.plugin.jenkins.steps.types.OtherScanType;
import com.fortify.plugin.jenkins.steps.types.ProjectScanType;
import com.fortify.ssc.restclient.ApiException;
import hudson.AbortException;
import hudson.BulkChange;
import hudson.Extension;
import hudson.Launcher;
import hudson.Plugin;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.AutoCompletionCandidates;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.ModelObject;
import hudson.model.Saveable;
import hudson.security.ACL;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import hudson.util.ComboBoxModel;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import jenkins.model.Jenkins;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.acegisecurity.Authentication;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.verb.POST;

public class FortifyPlugin
extends Recorder {
    private static String pluginVersion;
    private static final Logger LOGGER;
    private static Object syncObj;
    public static final int DEFAULT_PAGE_SIZE = 50;
    public static final int DEFAULT_APP_VERSION_LIST_LIMIT = 100;
    private transient UploadSSCBlock uploadSSC;
    private transient RunTranslationBlock runTranslation;
    private transient RunScanBlock runScan;
    private transient UpdateContentBlock updateContent;
    private transient boolean runSCAClean;
    private transient String buildId;
    private transient String scanFile;
    private transient String maxHeap;
    private transient String addJVMOptions;
    private AnalysisRunType analysisRunType;
    @Extension
    public static final DescriptorImpl DESCRIPTOR;

    public static String getPluginVersion() {
        Plugin plugin;
        if (pluginVersion == null && (plugin = Jenkins.get().getPlugin("fortify")) != null) {
            pluginVersion = plugin.getWrapper().getVersion();
        }
        return pluginVersion;
    }

    @DataBoundConstructor
    public FortifyPlugin(AnalysisRunType analysisRunType) {
        this.analysisRunType = analysisRunType;
    }

    @Deprecated
    public FortifyPlugin(String buildId, String scanFile, String maxHeap, String addJVMOptions, UpdateContentBlock updateContent, boolean runSCAClean, RunTranslationBlock runTranslation, RunScanBlock runScan, UploadSSCBlock uploadSSC) {
        this.buildId = buildId != null ? buildId.trim() : null;
        this.scanFile = scanFile != null ? scanFile.trim() : null;
        this.maxHeap = maxHeap;
        this.addJVMOptions = addJVMOptions;
        this.updateContent = updateContent;
        this.runSCAClean = runSCAClean;
        this.runTranslation = runTranslation;
        this.runScan = runScan;
        this.uploadSSC = uploadSSC;
    }

    protected Object readResolve() {
        if (this.runTranslation != null) {
            this.analysisRunType = new AnalysisRunType("local");
            if (this.updateContent != null) {
                this.analysisRunType.setUpdateContent(this.updateContent);
            }
            if (this.buildId != null) {
                this.analysisRunType.setBuildId(this.buildId);
            }
            if (this.scanFile != null) {
                this.analysisRunType.setScanFile(this.scanFile);
            }
            if (this.maxHeap != null) {
                this.analysisRunType.setMaxHeap(this.maxHeap);
            }
            if (this.addJVMOptions != null) {
                this.analysisRunType.setAddJVMOptions(this.addJVMOptions);
            }
            this.analysisRunType.setTranslationDebug(this.runTranslation.getTranslationDebug());
            this.analysisRunType.setTranslationVerbose(this.runTranslation.getTranslationVerbose());
            this.analysisRunType.setTranslationLogFile(this.runTranslation.getTranslationLogFile());
            this.analysisRunType.setTranslationExcludeList(this.runTranslation.getTranslationExcludeList());
            ProjectScanType scanType = null;
            if (this.runTranslation.isAdvancedTranslationType()) {
                scanType = new AdvancedScanType();
                scanType.setAdvOptions(this.runTranslation.getTranslationOptions());
            }
            if (this.runTranslation.isBasicMaven3TranslationType()) {
                scanType = new MavenScanType();
                ((MavenScanType)scanType).setMavenOptions(this.runTranslation.getMaven3Options());
                ((MavenScanType)scanType).setMavenInstallationName(this.runTranslation.getMaven3Name());
            }
            if (this.runTranslation.isBasicGradleTranslationType()) {
                scanType = new GradleScanType();
                ((GradleScanType)scanType).setUseWrapper(this.runTranslation.getGradleUseWrapper());
                ((GradleScanType)scanType).setGradleTasks(this.runTranslation.getGradleTasks());
                ((GradleScanType)scanType).setGradleOptions(this.runTranslation.getGradleOptions());
            }
            if (this.runTranslation.isBasicJavaTranslationType()) {
                scanType = new JavaScanType();
                ((JavaScanType)scanType).setJavaVersion(this.runTranslation.getTranslationJavaVersion());
                ((JavaScanType)scanType).setJavaClasspath(this.runTranslation.getTranslationClasspath());
                ((JavaScanType)scanType).setJavaSrcFiles(this.runTranslation.getTranslationSourceFiles());
                ((JavaScanType)scanType).setJavaAddOptions(this.runTranslation.getTranslationAddOptions());
            }
            if (this.runTranslation.isBasicDotNetDevenvBuildType()) {
                scanType = new DevenvScanType();
                ((DevenvScanType)scanType).setDotnetProject(this.runTranslation.getDotNetDevenvProjects());
                ((DevenvScanType)scanType).setDotnetAddOptions(this.runTranslation.getDotNetDevenvAddOptions());
            }
            if (this.runTranslation.isBasicDotNetMSBuildBuildType()) {
                scanType = new MsbuildScanType();
                ((MsbuildScanType)scanType).setDotnetProject(this.runTranslation.getDotNetMSBuildProjects());
                ((MsbuildScanType)scanType).setDotnetAddOptions(this.runTranslation.getDotNetMSBuildAddOptions());
            }
            if (this.runTranslation.isBasicDotNetSourceCodeScanType()) {
                scanType = new DotnetSourceScanType();
                ((DotnetSourceScanType)scanType).setDotnetFrameworkVersion(this.runTranslation.getDotNetSourceCodeFrameworkVersion());
                ((DotnetSourceScanType)scanType).setDotnetLibdirs(this.runTranslation.getDotNetSourceCodeLibdirs());
                ((DotnetSourceScanType)scanType).setDotnetSrcFiles(this.runTranslation.getDotNetSourceCodeSrcFiles());
                ((DotnetSourceScanType)scanType).setDotnetAddOptions(this.runTranslation.getDotNetSourceCodeAddOptions());
            }
            if (this.runTranslation.isBasicOtherTranslationType()) {
                scanType = new OtherScanType();
                ((OtherScanType)scanType).setOtherIncludesList(this.runTranslation.getOtherIncludesList());
                ((OtherScanType)scanType).setOtherOptions(this.runTranslation.getOtherOptions());
            }
            if (scanType != null) {
                this.analysisRunType.setProjectScanType(scanType);
            }
        }
        if (this.runScan != null) {
            this.analysisRunType.setRunScan(this.runScan);
        }
        if (this.uploadSSC != null) {
            this.analysisRunType.setUploadSSC(this.uploadSSC);
        }
        return this;
    }

    public boolean getAnalysisRunType() {
        return this.analysisRunType != null;
    }

    public RemoteAnalysisProjectType getRemoteAnalysisProjectType() {
        return this.getAnalysisRunType() ? this.analysisRunType.getRemoteAnalysisProjectType() : null;
    }

    public ProjectScanType getProjectScanType() {
        return this.getAnalysisRunType() ? this.analysisRunType.getProjectScanType() : null;
    }

    public boolean isRemote() {
        return this.getAnalysisRunType() && this.analysisRunType.value.equals("remote");
    }

    public boolean isMixed() {
        return this.getAnalysisRunType() && this.analysisRunType.value.equals("mixed");
    }

    public boolean isLocal() {
        return this.getAnalysisRunType() && this.analysisRunType.value.equals("local");
    }

    public boolean isUploadOnly() {
        return this.getAnalysisRunType() && this.analysisRunType.value.equals("uploadOnly");
    }

    public boolean isTranslationDebug() {
        return this.getAnalysisRunType() && this.analysisRunType.isTranslationDebug();
    }

    public boolean isTranslationVerbose() {
        return this.getAnalysisRunType() && this.analysisRunType.isTranslationVerbose();
    }

    public String getBuildId() {
        return this.getAnalysisRunType() ? this.analysisRunType.getBuildId() : "";
    }

    public String getScanFile() {
        return this.getAnalysisRunType() ? this.analysisRunType.getScanFile() : "";
    }

    public String getMaxHeap() {
        return this.getAnalysisRunType() ? this.analysisRunType.getMaxHeap() : "";
    }

    public String getAddJVMOptions() {
        return this.getAnalysisRunType() ? this.analysisRunType.getAddJVMOptions() : "";
    }

    public boolean getUpdateContent() {
        return this.getAnalysisRunType() && this.analysisRunType.getUpdateContent() != null;
    }

    @Deprecated
    public boolean getRunTranslation() {
        return this.runTranslation != null;
    }

    public boolean getRunScan() {
        return this.getAnalysisRunType() && this.analysisRunType.getRunScan() != null;
    }

    public boolean getUploadSSC() {
        return this.getAnalysisRunType() && this.analysisRunType.getUploadSSC() != null;
    }

    public String getUpdateServerUrl() {
        return this.getUpdateContent() ? this.analysisRunType.getUpdateContent().getUpdateServerUrl() : "";
    }

    public String getLocale() {
        return this.getUpdateContent() ? this.analysisRunType.getUpdateContent().getLocale() : "";
    }

    public boolean getAcceptKey() {
        return this.getUpdateContent() ? this.analysisRunType.getUpdateContent().getAcceptKey() : false;
    }

    @Deprecated
    public boolean getUpdateUseProxy() {
        return this.getUpdateContent() && this.updateContent.getUpdateUseProxy();
    }

    @Deprecated
    public String getUpdateProxyUrl() {
        return this.getUpdateUseProxy() ? this.updateContent.getUpdateProxyUrl() : "";
    }

    @Deprecated
    public String getUpdateProxyUsername() {
        return this.getUpdateUseProxy() ? this.updateContent.getUpdateProxyUsername() : "";
    }

    @Deprecated
    public String getUpdateProxyPassword() {
        return this.getUpdateUseProxy() ? this.updateContent.getUpdateProxyPassword() : "";
    }

    @Deprecated
    public String getTranslationType() {
        return this.getRunTranslation() ? this.runTranslation.getTranslationType() : "";
    }

    @Deprecated
    public boolean getIsBasicTranslationType() {
        return this.getRunTranslation() && this.runTranslation.isBasicTranslationType();
    }

    @Deprecated
    public boolean getIsAdvancedTranslationType() {
        return this.getRunTranslation() && this.runTranslation.isAdvancedTranslationType();
    }

    @Deprecated
    public boolean getIsBasicJavaTranslationType() {
        return this.getRunTranslation() && this.runTranslation.isBasicJavaTranslationType();
    }

    @Deprecated
    public boolean getIsBasicDotNetTranslationType() {
        return this.getRunTranslation() && this.runTranslation.isBasicDotNetTranslationType();
    }

    @Deprecated
    public boolean getIsBasicMaven3TranslationType() {
        return this.getRunTranslation() && this.runTranslation.isBasicMaven3TranslationType();
    }

    @Deprecated
    public boolean getIsBasicGradleTranslationType() {
        return this.getRunTranslation() && this.runTranslation.isBasicGradleTranslationType();
    }

    @Deprecated
    public boolean getIsBasicOtherTranslationType() {
        return this.getRunTranslation() && this.runTranslation.isBasicOtherTranslationType();
    }

    @Deprecated
    public String getTranslationJavaVersion() {
        return this.getRunTranslation() ? this.runTranslation.getTranslationJavaVersion() : "";
    }

    @Deprecated
    public String getTranslationJavaClasspath() {
        return this.getRunTranslation() ? this.runTranslation.getTranslationClasspath() : "";
    }

    @Deprecated
    public String getTranslationJavaSourceFiles() {
        return this.getRunTranslation() ? this.runTranslation.getTranslationSourceFiles() : "";
    }

    @Deprecated
    public String getTranslationJavaAddOptions() {
        return this.getRunTranslation() ? this.runTranslation.getTranslationAddOptions() : "";
    }

    public String getTranslationExcludeList() {
        return this.getAnalysisRunType() ? this.analysisRunType.getTranslationExcludeList() : "";
    }

    @Deprecated
    public String getTranslationOptions() {
        return this.getRunTranslation() ? this.runTranslation.getTranslationOptions() : "";
    }

    @Deprecated
    public boolean getTranslationDebug() {
        return this.getRunTranslation() && this.runTranslation.getTranslationDebug();
    }

    @Deprecated
    public boolean getTranslationVerbose() {
        return this.getRunTranslation() && this.runTranslation.getTranslationVerbose();
    }

    public String getTranslationLogFile() {
        return this.getAnalysisRunType() ? this.analysisRunType.getTranslationLogFile() : "";
    }

    @Deprecated
    public boolean getIsBasicDotNetProjectSolutionScanType() {
        return this.getRunTranslation() && this.runTranslation.isBasicDotNetProjectSolutionScanType();
    }

    @Deprecated
    public boolean getIsBasicDotNetSourceCodeScanType() {
        return this.getRunTranslation() && this.runTranslation.isBasicDotNetSourceCodeScanType();
    }

    @Deprecated
    public boolean getIsBasicDotNetDevenvBuildType() {
        return this.getRunTranslation() && this.runTranslation.isBasicDotNetDevenvBuildType();
    }

    @Deprecated
    public boolean getIsBasicDotNetMSBuildBuildType() {
        return this.getRunTranslation() && this.runTranslation.isBasicDotNetMSBuildBuildType();
    }

    @Deprecated
    public String getDotNetDevenvProjects() {
        return this.getRunTranslation() ? this.runTranslation.getDotNetDevenvProjects() : "";
    }

    @Deprecated
    public String getDotNetDevenvAddOptions() {
        return this.getRunTranslation() ? this.runTranslation.getDotNetDevenvAddOptions() : "";
    }

    @Deprecated
    public String getDotNetMSBuildProjects() {
        return this.getRunTranslation() ? this.runTranslation.getDotNetMSBuildProjects() : "";
    }

    @Deprecated
    public String getDotNetMSBuildAddOptions() {
        return this.getRunTranslation() ? this.runTranslation.getDotNetMSBuildAddOptions() : "";
    }

    @Deprecated
    public String getDotNetSourceCodeFrameworkVersion() {
        return this.getRunTranslation() ? this.runTranslation.getDotNetSourceCodeFrameworkVersion() : "";
    }

    @Deprecated
    public String getDotNetSourceCodeLibdirs() {
        return this.getRunTranslation() ? this.runTranslation.getDotNetSourceCodeLibdirs() : "";
    }

    @Deprecated
    public String getDotNetSourceCodeAddOptions() {
        return this.getRunTranslation() ? this.runTranslation.getDotNetSourceCodeAddOptions() : "";
    }

    @Deprecated
    public String getDotNetSourceCodeSrcFiles() {
        return this.getRunTranslation() ? this.runTranslation.getDotNetSourceCodeSrcFiles() : "";
    }

    @Deprecated
    public String getMaven3Options() {
        return this.getRunTranslation() ? this.runTranslation.getMaven3Options() : "";
    }

    @Deprecated
    public boolean getGradleUseWrapper() {
        return this.getRunTranslation() && this.runTranslation.getGradleUseWrapper();
    }

    @Deprecated
    public String getGradleTasks() {
        return this.getRunTranslation() ? this.runTranslation.getGradleTasks() : "";
    }

    @Deprecated
    public String getGradleOptions() {
        return this.getRunTranslation() ? this.runTranslation.getGradleOptions() : "";
    }

    @Deprecated
    public String getOtherOptions() {
        return this.getRunTranslation() ? this.runTranslation.getOtherOptions() : "";
    }

    @Deprecated
    public String getOtherIncludesList() {
        return this.getRunTranslation() ? this.runTranslation.getOtherIncludesList() : "";
    }

    public String getScanCustomRulepacks() {
        return this.getRunScan() ? this.analysisRunType.getRunScan().getScanCustomRulepacks() : "";
    }

    public String getScanAddOptions() {
        return this.getRunScan() ? this.analysisRunType.getRunScan().getScanAddOptions() : "";
    }

    public boolean getScanDebug() {
        return this.getRunScan() && this.analysisRunType.getRunScan().getScanDebug();
    }

    public boolean getScanVerbose() {
        return this.getRunScan() && this.analysisRunType.getRunScan().getScanVerbose();
    }

    public String getScanLogFile() {
        return this.getRunScan() ? this.analysisRunType.getRunScan().getScanLogFile() : "";
    }

    public String getFilterSet() {
        return this.getUploadSSC() ? this.analysisRunType.getUploadSSC().getFilterSet() : "";
    }

    public String getSearchCondition() {
        return this.getUploadSSC() ? this.analysisRunType.getUploadSSC().getSearchCondition() : "";
    }

    @Deprecated
    public String getProjectName() {
        return this.getUploadSSC() ? this.analysisRunType.getUploadSSC().getProjectName() : "";
    }

    public String getAppName() {
        return this.getUploadSSC() ? this.analysisRunType.getUploadSSC().getAppName() : "";
    }

    @Deprecated
    public String getProjectVersion() {
        return this.getUploadSSC() ? this.analysisRunType.getUploadSSC().getProjectVersion() : "";
    }

    public String getAppVersion() {
        return this.getUploadSSC() ? this.analysisRunType.getUploadSSC().getAppVersion() : "";
    }

    @Deprecated
    public String getUploadWaitTime() {
        return this.uploadSSC == null ? null : this.uploadSSC.getPollingInterval();
    }

    public String getTimeout() {
        return this.getUploadSSC() ? this.analysisRunType.getUploadSSC().getTimeout() : "";
    }

    public String getPollingInterval() {
        return this.getUploadSSC() ? this.analysisRunType.getUploadSSC().getPollingInterval() : "";
    }

    public boolean getRemoteOptionalConfig() {
        return !this.isLocal() && !this.isUploadOnly() && this.analysisRunType.getRemoteOptionalConfig() != null;
    }

    public String getSensorPoolUUID() {
        return this.getRemoteOptionalConfig() ? this.analysisRunType.getRemoteOptionalConfig().getSensorPoolUUID() : "";
    }

    public String getNotifyEmail() {
        return this.getRemoteOptionalConfig() ? this.analysisRunType.getRemoteOptionalConfig().getNotifyEmail() : "";
    }

    public String getScanOptions() {
        return this.getRemoteOptionalConfig() ? this.analysisRunType.getRemoteOptionalConfig().getScanOptions() : "";
    }

    public String getCustomRulepacks() {
        return this.getRemoteOptionalConfig() ? this.analysisRunType.getRemoteOptionalConfig().getCustomRulepacks() : "";
    }

    public String getFilterFile() {
        return this.getRemoteOptionalConfig() ? this.analysisRunType.getRemoteOptionalConfig().getFilterFile() : "";
    }

    public String getBuildTool() {
        if (!this.getAnalysisRunType()) {
            return "";
        }
        if (this.getRemoteAnalysisProjectType() instanceof GradleProjectType) {
            return "gradle";
        }
        if (this.getRemoteAnalysisProjectType() instanceof MavenProjectType) {
            return "mvn";
        }
        return "none";
    }

    public String getBuildFile() {
        if (!this.getAnalysisRunType()) {
            return "";
        }
        if (this.getRemoteAnalysisProjectType() instanceof GradleProjectType) {
            return ((GradleProjectType)this.getRemoteAnalysisProjectType()).getBuildFile();
        }
        if (this.getRemoteAnalysisProjectType() instanceof MavenProjectType) {
            return ((MavenProjectType)this.getRemoteAnalysisProjectType()).getBuildFile();
        }
        return "";
    }

    public boolean getIncludeTests() {
        if (this.getAnalysisRunType()) {
            if (this.getRemoteAnalysisProjectType() instanceof GradleProjectType) {
                return ((GradleProjectType)this.getRemoteAnalysisProjectType()).getIncludeTests();
            }
            if (this.getRemoteAnalysisProjectType() instanceof MavenProjectType) {
                return ((MavenProjectType)this.getRemoteAnalysisProjectType()).getIncludeTests();
            }
        }
        return false;
    }

    public boolean getSkipBuild() {
        if (this.getAnalysisRunType()) {
            if (this.getRemoteAnalysisProjectType() instanceof GradleProjectType) {
                return ((GradleProjectType)this.getRemoteAnalysisProjectType()).getSkipBuild();
            }
            if (this.getRemoteAnalysisProjectType() instanceof MavenProjectType) {
                return ((MavenProjectType)this.getRemoteAnalysisProjectType()).getSkipBuild();
            }
        }
        return false;
    }

    public String getTransArgs() {
        return this.getRemoteAnalysisProjectType() == null ? "" : this.analysisRunType.getTransArgs();
    }

    public String getScanArgs() {
        return this.getRemoteOptionalConfig() ? this.getScanOptions() : "";
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public Collection<? extends Action> getProjectActions(AbstractProject<?, ?> project) {
        return Collections.emptyList();
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        PrintStream log = listener.getLogger();
        log.println("Fortify Jenkins plugin v " + FortifyPlugin.getPluginVersion());
        if (this.isRemote()) {
            this.runRemote(build, launcher, listener);
        } else if (this.isMixed()) {
            this.runMixed(build, launcher, listener);
        } else if (this.isLocal()) {
            this.runLocal(build, launcher, listener);
        } else if (this.isUploadOnly()) {
            this.runUploadOnly(build, launcher, listener);
        }
        return true;
    }

    private void runRemote(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        PrintStream log = listener.getLogger();
        log.println("Running remote translation and scan.");
        RemoteAnalysisProjectType remoteAnalysisProjectType = this.getRemoteAnalysisProjectType();
        CloudScanStart csStart = new CloudScanStart(remoteAnalysisProjectType);
        CloudScanArguments csArguments = new CloudScanArguments();
        if (this.getRemoteOptionalConfig()) {
            csStart.setRemoteOptionalConfig(this.analysisRunType.getRemoteOptionalConfig());
            csArguments.setScanOptions(this.getScanArgs());
        }
        csArguments.setTransOptions(this.getTransArgs());
        if (StringUtils.isNotEmpty((String)csArguments.getTransOptions()) || StringUtils.isNotEmpty((String)csArguments.getScanOptions())) {
            csArguments.perform(build, launcher, listener);
        }
        if (this.getUploadSSC()) {
            csStart.setUploadSSC(this.analysisRunType.getUploadSSC());
        }
        csStart.perform(build, launcher, listener);
    }

    private void runMixed(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        PrintStream log = listener.getLogger();
        log.println("Running local translation and remote scan.");
        this.performLocalTranslation(build, launcher, listener);
        CloudScanMbs csMbs = new CloudScanMbs(this.getBuildId());
        if (this.getRemoteOptionalConfig()) {
            csMbs.setRemoteOptionalConfig(this.analysisRunType.getRemoteOptionalConfig());
        }
        if (this.getUploadSSC()) {
            csMbs.setUploadSSC(this.analysisRunType.getUploadSSC());
        }
        csMbs.perform(build, launcher, listener);
    }

    private void runLocal(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        PrintStream log = listener.getLogger();
        log.println("Running local translation and scan.");
        this.performLocalTranslation(build, launcher, listener);
        if (this.getRunScan()) {
            if (DESCRIPTOR.isDisableLocalScans()) {
                throw new AbortException(Messages.FortifyScan_Local_NotSupported());
            }
            FortifyScan fs = new FortifyScan(this.getBuildId());
            fs.setAddJVMOptions(this.getAddJVMOptions());
            fs.setMaxHeap(this.getMaxHeap());
            fs.setDebug(this.getScanDebug());
            fs.setVerbose(this.getScanVerbose());
            fs.setLogFile(this.getScanLogFile());
            fs.setResultsFile(this.getScanFile());
            fs.setCustomRulepacks(this.getScanCustomRulepacks());
            fs.setAddOptions(this.getScanAddOptions());
            fs.perform(build, launcher, listener);
        }
        if (this.getUploadSSC()) {
            FortifyUpload upload = new FortifyUpload(false, this.getAppName(), this.getAppVersion());
            upload.setFailureCriteria(this.getSearchCondition());
            upload.setFilterSet(this.getFilterSet());
            upload.setResultsFile(this.getScanFile());
            upload.setTimeout(this.getTimeout());
            upload.setPollingInterval(this.getPollingInterval());
            upload.perform(build, launcher, listener);
        }
    }

    private void runUploadOnly(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        PrintStream log = listener.getLogger();
        log.println("Running upload-only step.");
        FortifyUpload upload = new FortifyUpload(false, this.getAppName(), this.getAppVersion());
        upload.setFailureCriteria(this.getSearchCondition());
        upload.setFilterSet(this.getFilterSet());
        upload.setResultsFile(this.getScanFile());
        upload.setTimeout(this.getTimeout());
        upload.setPollingInterval(this.getPollingInterval());
        upload.perform(build, launcher, listener);
    }

    private void performLocalTranslation(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        if (this.getUpdateContent()) {
            FortifyUpdate fu = new FortifyUpdate.Builder().updateServerURL(this.getUpdateServerUrl()).locale(this.getLocale()).acceptKey(this.getAcceptKey()).build();
            fu.perform(build, launcher, listener);
        }
        FortifyClean fc = new FortifyClean(this.getBuildId());
        fc.perform(build, launcher, listener);
        ProjectScanType projectScanType = this.getProjectScanType();
        if (projectScanType != null) {
            FortifyTranslate ft = new FortifyTranslate(this.getBuildId(), projectScanType);
            ft.setMaxHeap(this.getMaxHeap());
            ft.setAddJVMOptions(this.getAddJVMOptions());
            ft.setDebug(this.isTranslationDebug());
            ft.setVerbose(this.isTranslationVerbose());
            ft.setLogFile(this.getTranslationLogFile());
            ft.setExcludeList(this.getTranslationExcludeList());
            if (projectScanType instanceof JavaScanType) {
                ft.setJavaVersion(((JavaScanType)projectScanType).getJavaVersion());
                ft.setJavaClasspath(((JavaScanType)projectScanType).getJavaClasspath());
                ft.setJavaSrcFiles(((JavaScanType)projectScanType).getJavaSrcFiles());
                ft.setJavaAddOptions(((JavaScanType)projectScanType).getJavaAddOptions());
            } else if (projectScanType instanceof DevenvScanType) {
                ft.setDotnetProject(((DevenvScanType)projectScanType).getDotnetProject());
                ft.setDotnetAddOptions(((DevenvScanType)projectScanType).getDotnetAddOptions());
            } else if (projectScanType instanceof MsbuildScanType) {
                ft.setDotnetProject(((MsbuildScanType)projectScanType).getDotnetProject());
                ft.setDotnetAddOptions(((MsbuildScanType)projectScanType).getDotnetAddOptions());
            } else if (projectScanType instanceof DotnetSourceScanType) {
                ft.setDotnetFrameworkVersion(((DotnetSourceScanType)projectScanType).getDotnetFrameworkVersion());
                ft.setDotnetLibdirs(((DotnetSourceScanType)projectScanType).getDotnetLibdirs());
                ft.setDotnetAddOptions(((DotnetSourceScanType)projectScanType).getDotnetAddOptions());
                ft.setDotnetSrcFiles(((DotnetSourceScanType)projectScanType).getDotnetSrcFiles());
            } else if (projectScanType instanceof MavenScanType) {
                ft.setMavenOptions(((MavenScanType)projectScanType).getMavenOptions());
                ft.setMavenName(((MavenScanType)projectScanType).getMavenInstallationName());
            } else if (projectScanType instanceof GradleScanType) {
                ft.setUseWrapper(((GradleScanType)projectScanType).getUseWrapper());
                ft.setGradleTasks(((GradleScanType)projectScanType).getGradleTasks());
                ft.setGradleOptions(((GradleScanType)projectScanType).getGradleOptions());
            } else if (projectScanType instanceof OtherScanType) {
                ft.setOtherIncludesList(((OtherScanType)projectScanType).getOtherIncludesList());
                ft.setOtherOptions(((OtherScanType)projectScanType).getOtherOptions());
            } else if (projectScanType instanceof AdvancedScanType) {
                ft.setAdvOptions(((AdvancedScanType)projectScanType).getAdvOptions());
            }
            ft.setCurrentNode(build.getBuiltOn());
            ft.perform(build, launcher, listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T runWithFortifyClient(String token, FortifyClient.Command<T> cmd) throws Exception {
        if (cmd != null) {
            Object object;
            block14: {
                String url = DESCRIPTOR.getUrl();
                ClassLoader contextClassLoader = null;
                try {
                    FortifyClient client = null;
                    object = syncObj;
                    synchronized (object) {
                        contextClassLoader = Thread.currentThread().getContextClassLoader();
                        Thread.currentThread().setContextClassLoader(FortifyPlugin.class.getClassLoader());
                        client = new FortifyClient();
                        ProxyConfig proxyConfig = DESCRIPTOR.getProxyConfig();
                        client.init(url, token, proxyConfig, DESCRIPTOR.getConnectTimeout(), DESCRIPTOR.getReadTimeout(), DESCRIPTOR.getWriteTimeout());
                    }
                    object = cmd.runWith(client);
                    if (contextClassLoader == null) break block14;
                    Thread.currentThread().setContextClassLoader(contextClassLoader);
                }
                catch (ApiException e) {
                    try {
                        String message = e.getMessage();
                        if (message == null || message.trim().length() == 0) {
                            message = e.getResponseBody();
                            try {
                                JSONObject obj = JSONObject.fromObject((Object)message);
                                String body = obj.getString("message");
                                if (body != null && body.trim().length() != 0) {
                                    message = body;
                                }
                            }
                            catch (JSONException jSONException) {
                                // empty catch block
                            }
                            if (message != null && message.contains("<body>") && message.contains("</body>")) {
                                message = message.substring(message.indexOf("<body>") + 6, message.indexOf("</body>"));
                            }
                        }
                        throw new ApiException(message, (Throwable)e, e.getCode(), e.getResponseHeaders());
                    }
                    catch (Throwable throwable) {
                        if (contextClassLoader != null) {
                            Thread.currentThread().setContextClassLoader(contextClassLoader);
                        }
                        throw throwable;
                    }
                }
            }
            return (T)object;
        }
        return null;
    }

    static {
        LOGGER = Logger.getLogger(FortifyPlugin.class.getName());
        syncObj = new Object();
        DESCRIPTOR = new DescriptorImpl();
    }

    public static class RemoteOptionalConfigBlock {
        private String sensorPoolUUID;
        private String notifyEmail;
        private String scanOptions;
        private String customRulepacks;
        private String filterFile;

        @DataBoundConstructor
        public RemoteOptionalConfigBlock() {
        }

        public String getSensorPoolUUID() {
            return this.sensorPoolUUID;
        }

        @DataBoundSetter
        public void setSensorPoolUUID(String sensorPoolUUID) {
            this.sensorPoolUUID = sensorPoolUUID;
        }

        public String getNotifyEmail() {
            return this.notifyEmail;
        }

        @DataBoundSetter
        public void setNotifyEmail(String notifyEmail) {
            this.notifyEmail = notifyEmail;
        }

        public String getScanOptions() {
            return this.scanOptions;
        }

        @DataBoundSetter
        public void setScanOptions(String scanOptions) {
            this.scanOptions = scanOptions;
        }

        public String getCustomRulepacks() {
            return this.customRulepacks;
        }

        @DataBoundSetter
        public void setCustomRulepacks(String customRulepacks) {
            this.customRulepacks = customRulepacks;
        }

        public String getFilterFile() {
            return this.filterFile;
        }

        @DataBoundSetter
        public void setFilterFile(String filterFile) {
            this.filterFile = filterFile;
        }
    }

    public static class AnalysisRunType {
        private String value;
        private RemoteAnalysisProjectType remoteAnalysisProjectType;
        private RemoteOptionalConfigBlock remoteOptionalConfig;
        private String transArgs;
        private ProjectScanType projectScanType;
        private UpdateContentBlock updateContent;
        private String buildId;
        private String scanFile;
        private String maxHeap;
        private String addJVMOptions;
        private String translationExcludeList;
        private boolean translationDebug;
        private boolean translationVerbose;
        private String translationLogFile;
        private RunScanBlock runScan;
        private UploadSSCBlock uploadSSC;

        @DataBoundConstructor
        public AnalysisRunType(String value) {
            this.value = value;
        }

        public RemoteAnalysisProjectType getRemoteAnalysisProjectType() {
            return this.remoteAnalysisProjectType;
        }

        @DataBoundSetter
        public void setRemoteAnalysisProjectType(RemoteAnalysisProjectType remoteAnalysisProjectType) {
            this.remoteAnalysisProjectType = remoteAnalysisProjectType;
        }

        public RemoteOptionalConfigBlock getRemoteOptionalConfig() {
            return this.remoteOptionalConfig;
        }

        @DataBoundSetter
        public void setRemoteOptionalConfig(RemoteOptionalConfigBlock remoteOptionalConfig) {
            this.remoteOptionalConfig = remoteOptionalConfig;
        }

        public String getTransArgs() {
            return this.transArgs;
        }

        @DataBoundSetter
        public void setTransArgs(String transArgs) {
            this.transArgs = transArgs;
        }

        public ProjectScanType getProjectScanType() {
            return this.projectScanType;
        }

        @DataBoundSetter
        public void setProjectScanType(ProjectScanType projectScanType) {
            this.projectScanType = projectScanType;
        }

        public UpdateContentBlock getUpdateContent() {
            return this.updateContent;
        }

        @DataBoundSetter
        public void setUpdateContent(UpdateContentBlock updateContent) {
            this.updateContent = updateContent;
        }

        public String getBuildId() {
            return this.buildId;
        }

        @DataBoundSetter
        public void setBuildId(String buildId) {
            this.buildId = buildId != null ? buildId.trim() : null;
        }

        public String getScanFile() {
            return this.scanFile;
        }

        @DataBoundSetter
        public void setScanFile(String scanFile) {
            this.scanFile = scanFile != null ? scanFile.trim() : "";
        }

        public String getMaxHeap() {
            return this.maxHeap;
        }

        @DataBoundSetter
        public void setMaxHeap(String maxHeap) {
            this.maxHeap = maxHeap;
        }

        public String getAddJVMOptions() {
            return this.addJVMOptions;
        }

        @DataBoundSetter
        public void setAddJVMOptions(String addJVMOptions) {
            this.addJVMOptions = addJVMOptions;
        }

        public String getTranslationExcludeList() {
            return this.translationExcludeList;
        }

        @DataBoundSetter
        public void setTranslationExcludeList(String translationExcludeList) {
            this.translationExcludeList = translationExcludeList;
        }

        public boolean isTranslationDebug() {
            return this.translationDebug;
        }

        @DataBoundSetter
        public void setTranslationDebug(boolean translationDebug) {
            this.translationDebug = translationDebug;
        }

        public boolean isTranslationVerbose() {
            return this.translationVerbose;
        }

        @DataBoundSetter
        public void setTranslationVerbose(boolean translationVerbose) {
            this.translationVerbose = translationVerbose;
        }

        public String getTranslationLogFile() {
            return this.translationLogFile;
        }

        @DataBoundSetter
        public void setTranslationLogFile(String translationLogFile) {
            this.translationLogFile = translationLogFile;
        }

        public RunScanBlock getRunScan() {
            return this.runScan;
        }

        @DataBoundSetter
        public void setRunScan(RunScanBlock runScan) {
            this.runScan = runScan;
        }

        public UploadSSCBlock getUploadSSC() {
            return this.uploadSSC;
        }

        @DataBoundSetter
        public void setUploadSSC(UploadSSCBlock uploadSSC) {
            this.uploadSSC = uploadSSC;
        }
    }

    @Deprecated
    public static class UseProxyBlock {
        private String proxyUrl;
        private Secret proxyUsername;
        private Secret proxyPassword;

        @DataBoundConstructor
        public UseProxyBlock(String updateProxyUrl, String updateProxyUsername, String updateProxyPassword) {
            this.proxyUrl = updateProxyUrl != null ? updateProxyUrl.trim() : "";
            this.proxyUsername = updateProxyUsername != null ? Secret.fromString((String)updateProxyUsername.trim()) : null;
            this.proxyPassword = updateProxyPassword != null ? Secret.fromString((String)updateProxyPassword.trim()) : null;
        }

        public String getProxyUrl() {
            return this.proxyUrl;
        }

        public String getProxyUsername() {
            return this.proxyUsername == null ? "" : this.proxyUsername.getPlainText();
        }

        public String getProxyPassword() {
            return this.proxyPassword == null ? "" : this.proxyPassword.getPlainText();
        }
    }

    public static class UpdateContentBlock {
        private String updateServerUrl;
        private String locale;
        private boolean acceptKey = Boolean.FALSE;
        private UseProxyBlock useProxy;

        @DataBoundConstructor
        public UpdateContentBlock() {
        }

        @Deprecated
        public UpdateContentBlock(String updateServerUrl, UseProxyBlock updateUseProxy) {
            this.updateServerUrl = updateServerUrl != null ? updateServerUrl.trim() : "";
            this.useProxy = updateUseProxy;
        }

        public String getUpdateServerUrl() {
            return this.updateServerUrl;
        }

        @DataBoundSetter
        public void setUpdateServerUrl(String updateServerUrl) {
            this.updateServerUrl = updateServerUrl;
        }

        public String getLocale() {
            return this.locale;
        }

        @DataBoundSetter
        public void setLocale(String locale) {
            this.locale = locale;
        }

        public boolean getAcceptKey() {
            return this.acceptKey;
        }

        @DataBoundSetter
        public void setAcceptKey(boolean acceptKey) {
            this.acceptKey = acceptKey;
        }

        @Deprecated
        public boolean getUpdateUseProxy() {
            return this.useProxy != null;
        }

        @Deprecated
        public String getUpdateProxyUrl() {
            return this.useProxy == null ? "" : this.useProxy.getProxyUrl();
        }

        @Deprecated
        public String getUpdateProxyUsername() {
            return this.useProxy == null ? "" : this.useProxy.getProxyUsername();
        }

        @Deprecated
        public String getUpdateProxyPassword() {
            return this.useProxy == null ? "" : this.useProxy.getProxyPassword();
        }
    }

    public static class RunScanBlock {
        private String customRulepacks;
        private String additionalOptions;
        private boolean debug;
        private boolean verbose;
        private String logFile;

        @DataBoundConstructor
        public RunScanBlock() {
        }

        @Deprecated
        public RunScanBlock(String scanCustomRulepacks, String scanAddOptions, boolean scanDebug, boolean scanVerbose, String scanLogFile) {
            this.customRulepacks = scanCustomRulepacks != null ? scanCustomRulepacks.trim() : "";
            this.additionalOptions = scanAddOptions != null ? scanAddOptions.trim() : "";
            this.debug = scanDebug;
            this.verbose = scanVerbose;
            this.logFile = scanLogFile != null ? scanLogFile.trim() : "";
        }

        public String getScanCustomRulepacks() {
            return this.customRulepacks;
        }

        @DataBoundSetter
        public void setScanCustomRulepacks(String scanCustomRulepacks) {
            this.customRulepacks = scanCustomRulepacks;
        }

        public String getScanAddOptions() {
            return this.additionalOptions;
        }

        @DataBoundSetter
        public void setScanAddOptions(String scanAddOptions) {
            this.additionalOptions = scanAddOptions;
        }

        public boolean getScanDebug() {
            return this.debug;
        }

        @DataBoundSetter
        public void setScanDebug(boolean scanDebug) {
            this.debug = scanDebug;
        }

        public boolean getScanVerbose() {
            return this.verbose;
        }

        @DataBoundSetter
        public void setScanVerbose(boolean scanVerbose) {
            this.verbose = scanVerbose;
        }

        public String getScanLogFile() {
            return this.logFile;
        }

        @DataBoundSetter
        public void setScanLogFile(String scanLogFile) {
            this.logFile = scanLogFile;
        }
    }

    @Deprecated
    public static class BasicOtherTranslationAppTypeBlock
    implements BasicTranslationAppTypeBlock {
        private String options;
        private String includesList;

        @DataBoundConstructor
        public BasicOtherTranslationAppTypeBlock(String otherOptions, String otherIncludesList) {
            this.options = otherOptions;
            this.includesList = otherIncludesList;
        }

        public String getOptions() {
            return this.options;
        }

        public String getIncludesList() {
            return this.includesList;
        }
    }

    @Deprecated
    public static class BasicGradleTranslationAppTypeBlock
    implements BasicTranslationAppTypeBlock {
        private boolean useWrapper;
        private boolean skipBuild;
        private String tasks;
        private String options;

        @DataBoundConstructor
        public BasicGradleTranslationAppTypeBlock(boolean gradleUseWrapper, boolean gradleSkipBuild, String gradleTasks, String gradleOptions) {
            this.useWrapper = gradleUseWrapper;
            this.skipBuild = gradleSkipBuild;
            this.tasks = gradleTasks;
            this.options = gradleOptions;
        }

        public boolean getSkipBuild() {
            return this.skipBuild;
        }

        public boolean getUseWrapper() {
            return this.useWrapper;
        }

        public String getTasks() {
            return this.tasks;
        }

        public String getOptions() {
            return this.options;
        }
    }

    @Deprecated
    public static class BasicMaven3TranslationAppTypeBlock
    implements BasicTranslationAppTypeBlock {
        private String options;
        private boolean skipBuild;
        private String mavenName;

        @DataBoundConstructor
        public BasicMaven3TranslationAppTypeBlock(String maven3Options, boolean skipBuild, String mavenName) {
            this.options = maven3Options;
            this.skipBuild = skipBuild;
            this.mavenName = mavenName;
        }

        public String getOptions() {
            return this.options;
        }

        public boolean getSkipBuild() {
            return this.skipBuild;
        }

        public String getMavenName() {
            return this.mavenName;
        }
    }

    @Deprecated
    public static class BasicDotNetMSBuildBuildTypeBlock
    implements BasicDotNetBuildTypeBlock {
        private String projects;
        private String addOptions;

        @DataBoundConstructor
        public BasicDotNetMSBuildBuildTypeBlock(String dotNetMSBuildProjects, String dotNetMSBuildAddOptions) {
            this.projects = dotNetMSBuildProjects;
            this.addOptions = dotNetMSBuildAddOptions;
        }

        public String getProjects() {
            return this.projects;
        }

        public String getAddOptions() {
            return this.addOptions;
        }
    }

    @Deprecated
    public static class BasicDotNetDevenvBuildTypeBlock
    implements BasicDotNetBuildTypeBlock {
        private String projects;
        private String addOptions;

        @DataBoundConstructor
        public BasicDotNetDevenvBuildTypeBlock(String dotNetDevenvProjects, String dotNetDevenvAddOptions) {
            this.projects = dotNetDevenvProjects;
            this.addOptions = dotNetDevenvAddOptions;
        }

        public String getProjects() {
            return this.projects;
        }

        public String getAddOptions() {
            return this.addOptions;
        }
    }

    @Deprecated
    public static interface BasicDotNetBuildTypeBlock {
    }

    @Deprecated
    public static class BasicDotNetSourceCodeScanTypeBlock
    implements BasicDotNetScanTypeBlock {
        private String dotNetVersion;
        private String libdirs;
        private String addOptions;
        private String dotNetSrcFiles;

        @DataBoundConstructor
        public BasicDotNetSourceCodeScanTypeBlock(String dotNetSourceCodeFrameworkVersion, String dotNetSourceCodeLibdirs, String dotNetSourceCodeAddOptions, String dotNetSourceCodeSrcFiles) {
            this.dotNetVersion = dotNetSourceCodeFrameworkVersion;
            this.libdirs = dotNetSourceCodeLibdirs;
            this.addOptions = dotNetSourceCodeAddOptions;
            this.dotNetSrcFiles = dotNetSourceCodeSrcFiles;
        }

        public String getDotNetVersion() {
            return this.dotNetVersion;
        }

        public String getLibdirs() {
            return this.libdirs;
        }

        public String getAddOptions() {
            return this.addOptions;
        }

        public String getDotNetSrcFiles() {
            return this.dotNetSrcFiles;
        }
    }

    @Deprecated
    public static class BasicDotNetProjectSolutionScanTypeBlock
    implements BasicDotNetScanTypeBlock {
        private BasicDotNetBuildTypeBlock buildType;

        @DataBoundConstructor
        public BasicDotNetProjectSolutionScanTypeBlock(BasicDotNetBuildTypeBlock dotNetBuildType) {
            this.buildType = dotNetBuildType;
        }

        public boolean isDevenvBuildType() {
            return this.buildType != null && this.buildType instanceof BasicDotNetDevenvBuildTypeBlock;
        }

        public boolean isMSBuildBuildType() {
            return this.buildType != null && this.buildType instanceof BasicDotNetMSBuildBuildTypeBlock;
        }

        public String getDevenvProjects() {
            return this.isDevenvBuildType() ? ((BasicDotNetDevenvBuildTypeBlock)this.buildType).getProjects() : "";
        }

        public String getDevenvAddOptions() {
            return this.isDevenvBuildType() ? ((BasicDotNetDevenvBuildTypeBlock)this.buildType).getAddOptions() : "";
        }

        public String getMSBuildProjects() {
            return this.isMSBuildBuildType() ? ((BasicDotNetMSBuildBuildTypeBlock)this.buildType).getProjects() : "";
        }

        public String getMSBuildAddOptions() {
            return this.isMSBuildBuildType() ? ((BasicDotNetMSBuildBuildTypeBlock)this.buildType).getAddOptions() : "";
        }
    }

    @Deprecated
    public static interface BasicDotNetScanTypeBlock {
    }

    @Deprecated
    public static class BasicDotNetTranslationAppTypeBlock
    implements BasicTranslationAppTypeBlock {
        private BasicDotNetScanTypeBlock scanType;

        @DataBoundConstructor
        public BasicDotNetTranslationAppTypeBlock(BasicDotNetScanTypeBlock dotNetScanType) {
            this.scanType = dotNetScanType;
        }

        public boolean isProjectSolutionScanType() {
            return this.scanType != null && this.scanType instanceof BasicDotNetProjectSolutionScanTypeBlock;
        }

        public boolean isSourceCodeScanType() {
            return this.scanType != null && this.scanType instanceof BasicDotNetSourceCodeScanTypeBlock;
        }

        public BasicDotNetScanTypeBlock getScanTypeBlock() {
            return this.scanType;
        }

        public boolean isDevenvBuildType() {
            return this.isProjectSolutionScanType() && ((BasicDotNetProjectSolutionScanTypeBlock)this.scanType).isDevenvBuildType();
        }

        public boolean isMSBuildBuildType() {
            return this.isProjectSolutionScanType() && ((BasicDotNetProjectSolutionScanTypeBlock)this.scanType).isMSBuildBuildType();
        }

        public String getDevenvProjects() {
            return this.isProjectSolutionScanType() ? ((BasicDotNetProjectSolutionScanTypeBlock)this.scanType).getDevenvProjects() : "";
        }

        public String getDevenvAddOptions() {
            return this.isProjectSolutionScanType() ? ((BasicDotNetProjectSolutionScanTypeBlock)this.scanType).getDevenvAddOptions() : "";
        }

        public String getMSBuildProjects() {
            return this.isProjectSolutionScanType() ? ((BasicDotNetProjectSolutionScanTypeBlock)this.scanType).getMSBuildProjects() : "";
        }

        public String getMSBuildAddOptions() {
            return this.isProjectSolutionScanType() ? ((BasicDotNetProjectSolutionScanTypeBlock)this.scanType).getMSBuildAddOptions() : "";
        }

        public String getSourceCodeFrameworkVersion() {
            return this.isSourceCodeScanType() ? ((BasicDotNetSourceCodeScanTypeBlock)this.scanType).getDotNetVersion() : "";
        }

        public String getSourceCodeLibdirs() {
            return this.isSourceCodeScanType() ? ((BasicDotNetSourceCodeScanTypeBlock)this.scanType).getLibdirs() : "";
        }

        public String getSourceCodeAddOptions() {
            return this.isSourceCodeScanType() ? ((BasicDotNetSourceCodeScanTypeBlock)this.scanType).getAddOptions() : "";
        }

        public String getSourceCodeSrcFiles() {
            return this.isSourceCodeScanType() ? ((BasicDotNetSourceCodeScanTypeBlock)this.scanType).getDotNetSrcFiles() : "";
        }
    }

    @Deprecated
    public static class BasicJavaTranslationAppTypeBlock
    implements BasicTranslationAppTypeBlock {
        private String javaVersion;
        private String classpath;
        private String sourceFiles;
        private String additionalOptions;

        @DataBoundConstructor
        public BasicJavaTranslationAppTypeBlock(String translationJavaVersion, String translationJavaClasspath, String translationJavaSourceFiles, String translationJavaAddOptions) {
            this.javaVersion = translationJavaVersion != null ? translationJavaVersion.trim() : "";
            this.classpath = translationJavaClasspath != null ? translationJavaClasspath.trim() : "";
            this.sourceFiles = translationJavaSourceFiles != null ? translationJavaSourceFiles.trim() : "";
            this.additionalOptions = translationJavaAddOptions != null ? translationJavaAddOptions.trim() : "";
        }

        public String getTranslationJavaVersion() {
            return this.javaVersion;
        }

        public String getTranslationClasspath() {
            return this.classpath;
        }

        public String getTranslationSourceFiles() {
            return this.sourceFiles;
        }

        public String getTranslationAddOptions() {
            return this.additionalOptions;
        }
    }

    @Deprecated
    public static interface BasicTranslationAppTypeBlock {
    }

    @Deprecated
    public static class AdvancedTranslationBlock
    implements TranslationTypeBlock {
        private String translationOptions;

        @DataBoundConstructor
        public AdvancedTranslationBlock(String translationOptions) {
            this.translationOptions = translationOptions != null ? translationOptions.trim() : "";
        }

        public String getTranslationOptions() {
            return this.translationOptions;
        }
    }

    @Deprecated
    public static class BasicTranslationBlock
    implements TranslationTypeBlock {
        private BasicTranslationAppTypeBlock appTypeBlock;
        private String excludeList;

        @DataBoundConstructor
        public BasicTranslationBlock(BasicTranslationAppTypeBlock translationAppType, String translationExcludeList) {
            this.appTypeBlock = translationAppType;
            this.excludeList = translationExcludeList != null ? translationExcludeList.trim() : "";
        }

        public BasicTranslationAppTypeBlock getTranslationApplicationTypeBlock() {
            return this.appTypeBlock;
        }

        public String getTranslationExcludeList() {
            return this.excludeList;
        }
    }

    @Deprecated
    public static interface TranslationTypeBlock {
    }

    @Deprecated
    public static class RunTranslationBlock {
        private TranslationTypeBlock translationType;
        private boolean debug;
        private boolean verbose;
        private String logFile;

        @DataBoundConstructor
        public RunTranslationBlock(TranslationTypeBlock translationType, boolean translationDebug, boolean translationVerbose, String translationLogFile) {
            this.translationType = translationType;
            this.debug = translationDebug;
            this.verbose = translationVerbose;
            this.logFile = translationLogFile != null ? translationLogFile.trim() : "";
        }

        public boolean isBasicTranslationType() {
            return this.translationType instanceof BasicTranslationBlock;
        }

        public boolean isAdvancedTranslationType() {
            return this.translationType instanceof AdvancedTranslationBlock;
        }

        public boolean isBasicJavaTranslationType() {
            return this.isBasicTranslationType() && ((BasicTranslationBlock)this.translationType).getTranslationApplicationTypeBlock() instanceof BasicJavaTranslationAppTypeBlock;
        }

        public boolean isBasicDotNetTranslationType() {
            return this.isBasicTranslationType() && ((BasicTranslationBlock)this.translationType).getTranslationApplicationTypeBlock() instanceof BasicDotNetTranslationAppTypeBlock;
        }

        public boolean isBasicMaven3TranslationType() {
            return this.isBasicTranslationType() && ((BasicTranslationBlock)this.translationType).getTranslationApplicationTypeBlock() instanceof BasicMaven3TranslationAppTypeBlock;
        }

        public boolean isBasicGradleTranslationType() {
            return this.isBasicTranslationType() && ((BasicTranslationBlock)this.translationType).getTranslationApplicationTypeBlock() instanceof BasicGradleTranslationAppTypeBlock;
        }

        public boolean isBasicOtherTranslationType() {
            return this.isBasicTranslationType() && ((BasicTranslationBlock)this.translationType).getTranslationApplicationTypeBlock() instanceof BasicOtherTranslationAppTypeBlock;
        }

        public boolean isBasicDotNetProjectSolutionScanType() {
            return this.isBasicDotNetTranslationType() && this.getBasicDotNetTranslationAppTypeBlock().isProjectSolutionScanType();
        }

        public boolean isBasicDotNetSourceCodeScanType() {
            return this.isBasicDotNetTranslationType() && this.getBasicDotNetTranslationAppTypeBlock().isSourceCodeScanType();
        }

        public boolean isBasicDotNetDevenvBuildType() {
            return this.isBasicDotNetProjectSolutionScanType() && this.getBasicDotNetTranslationAppTypeBlock().isDevenvBuildType();
        }

        public boolean isBasicDotNetMSBuildBuildType() {
            return this.isBasicDotNetProjectSolutionScanType() && this.getBasicDotNetTranslationAppTypeBlock().isMSBuildBuildType();
        }

        private BasicJavaTranslationAppTypeBlock getBasicJavaTranslationAppTypeBlock() {
            return this.isBasicJavaTranslationType() ? (BasicJavaTranslationAppTypeBlock)((BasicTranslationBlock)this.translationType).getTranslationApplicationTypeBlock() : null;
        }

        private BasicDotNetTranslationAppTypeBlock getBasicDotNetTranslationAppTypeBlock() {
            return this.isBasicDotNetTranslationType() ? (BasicDotNetTranslationAppTypeBlock)((BasicTranslationBlock)this.translationType).getTranslationApplicationTypeBlock() : null;
        }

        private BasicMaven3TranslationAppTypeBlock getBasicMaven3TranslationAppTypeBlock() {
            return this.isBasicMaven3TranslationType() ? (BasicMaven3TranslationAppTypeBlock)((BasicTranslationBlock)this.translationType).getTranslationApplicationTypeBlock() : null;
        }

        private BasicGradleTranslationAppTypeBlock getBasicGradleTranslationAppTypeBlock() {
            return this.isBasicGradleTranslationType() ? (BasicGradleTranslationAppTypeBlock)((BasicTranslationBlock)this.translationType).getTranslationApplicationTypeBlock() : null;
        }

        private BasicOtherTranslationAppTypeBlock getBasicOtherTranslationAppTypeBlock() {
            return this.isBasicOtherTranslationType() ? (BasicOtherTranslationAppTypeBlock)((BasicTranslationBlock)this.translationType).getTranslationApplicationTypeBlock() : null;
        }

        public String getTranslationType() {
            return this.isBasicTranslationType() ? "translationBasic" : "translationAdvanced";
        }

        public String getTranslationOptions() {
            return this.isAdvancedTranslationType() ? ((AdvancedTranslationBlock)this.translationType).getTranslationOptions() : "";
        }

        public String getTranslationExcludeList() {
            return this.isBasicTranslationType() ? ((BasicTranslationBlock)this.translationType).getTranslationExcludeList() : "";
        }

        public String getTranslationJavaVersion() {
            return this.isBasicJavaTranslationType() ? this.getBasicJavaTranslationAppTypeBlock().getTranslationJavaVersion() : "";
        }

        public String getTranslationClasspath() {
            return this.isBasicJavaTranslationType() ? this.getBasicJavaTranslationAppTypeBlock().getTranslationClasspath() : "";
        }

        public String getTranslationSourceFiles() {
            return this.isBasicJavaTranslationType() ? this.getBasicJavaTranslationAppTypeBlock().getTranslationSourceFiles() : "";
        }

        public String getTranslationAddOptions() {
            return this.isBasicJavaTranslationType() ? this.getBasicJavaTranslationAppTypeBlock().getTranslationAddOptions() : "";
        }

        public String getDotNetDevenvProjects() {
            return this.isBasicDotNetTranslationType() ? this.getBasicDotNetTranslationAppTypeBlock().getDevenvProjects() : "";
        }

        public String getDotNetDevenvAddOptions() {
            return this.isBasicDotNetTranslationType() ? this.getBasicDotNetTranslationAppTypeBlock().getDevenvAddOptions() : "";
        }

        public String getDotNetMSBuildProjects() {
            return this.isBasicDotNetTranslationType() ? this.getBasicDotNetTranslationAppTypeBlock().getMSBuildProjects() : "";
        }

        public String getDotNetMSBuildAddOptions() {
            return this.isBasicDotNetTranslationType() ? this.getBasicDotNetTranslationAppTypeBlock().getMSBuildAddOptions() : "";
        }

        public String getDotNetSourceCodeFrameworkVersion() {
            return this.isBasicDotNetTranslationType() ? this.getBasicDotNetTranslationAppTypeBlock().getSourceCodeFrameworkVersion() : "";
        }

        public String getDotNetSourceCodeLibdirs() {
            return this.isBasicDotNetTranslationType() ? this.getBasicDotNetTranslationAppTypeBlock().getSourceCodeLibdirs() : "";
        }

        public String getDotNetSourceCodeAddOptions() {
            return this.isBasicDotNetTranslationType() ? this.getBasicDotNetTranslationAppTypeBlock().getSourceCodeAddOptions() : "";
        }

        public String getDotNetSourceCodeSrcFiles() {
            return this.isBasicDotNetTranslationType() ? this.getBasicDotNetTranslationAppTypeBlock().getSourceCodeSrcFiles() : "";
        }

        public String getMaven3Options() {
            return this.isBasicMaven3TranslationType() ? this.getBasicMaven3TranslationAppTypeBlock().getOptions() : "";
        }

        public boolean getMaven3SkipBuild() {
            return this.isBasicMaven3TranslationType() && this.getBasicMaven3TranslationAppTypeBlock().getSkipBuild();
        }

        public String getMaven3Name() {
            return this.isBasicMaven3TranslationType() ? this.getBasicMaven3TranslationAppTypeBlock().getMavenName() : null;
        }

        public boolean getGradleSkipBuild() {
            return this.isBasicGradleTranslationType() && this.getBasicGradleTranslationAppTypeBlock().getSkipBuild();
        }

        public boolean getGradleUseWrapper() {
            return this.isBasicGradleTranslationType() && this.getBasicGradleTranslationAppTypeBlock().getUseWrapper();
        }

        public String getGradleTasks() {
            return this.isBasicGradleTranslationType() ? this.getBasicGradleTranslationAppTypeBlock().getTasks() : "";
        }

        public String getGradleOptions() {
            return this.isBasicGradleTranslationType() ? this.getBasicGradleTranslationAppTypeBlock().getOptions() : "";
        }

        public String getOtherOptions() {
            return this.isBasicOtherTranslationType() ? this.getBasicOtherTranslationAppTypeBlock().getOptions() : "";
        }

        public String getOtherIncludesList() {
            return this.isBasicOtherTranslationType() ? this.getBasicOtherTranslationAppTypeBlock().getIncludesList() : "";
        }

        public boolean getTranslationDebug() {
            return this.debug;
        }

        public boolean getTranslationVerbose() {
            return this.verbose;
        }

        public String getTranslationLogFile() {
            return this.logFile;
        }
    }

    public static class UploadSSCBlock {
        private transient String projectName;
        private transient String projectVersion;
        private String appName;
        private String appVersion;
        private String filterSet;
        private String searchCondition;
        private String timeout;
        private String pollingInterval;

        @DataBoundConstructor
        public UploadSSCBlock(String appName, String appVersion) {
            this.appName = appName != null ? appName.trim() : "";
            this.appVersion = appVersion != null ? appVersion.trim() : "";
        }

        @Deprecated
        public UploadSSCBlock(String projectName, String projectVersion, String filterSet, String searchCondition, String timeout, String pollingInterval) {
            this.projectName = projectName != null ? projectName.trim() : "";
            this.projectVersion = projectName != null ? projectVersion.trim() : "";
            this.filterSet = filterSet != null ? filterSet.trim() : "";
            this.searchCondition = searchCondition != null ? searchCondition.trim() : "";
            this.timeout = timeout != null ? timeout.trim() : "";
            this.pollingInterval = pollingInterval != null ? pollingInterval.trim() : "";
        }

        protected Object readResolve() {
            if (this.projectName != null) {
                this.appName = this.projectName;
            }
            if (this.projectVersion != null) {
                this.appVersion = this.projectVersion;
            }
            return this;
        }

        @Deprecated
        public String getProjectName() {
            return this.projectName;
        }

        @Deprecated
        public String getProjectVersion() {
            return this.projectVersion;
        }

        public String getAppName() {
            return this.appName;
        }

        public String getAppVersion() {
            return this.appVersion;
        }

        public String getFilterSet() {
            return this.filterSet;
        }

        @DataBoundSetter
        public void setFilterSet(String filterSet) {
            this.filterSet = filterSet;
        }

        public String getSearchCondition() {
            return this.searchCondition;
        }

        @DataBoundSetter
        public void setSearchCondition(String searchCondition) {
            this.searchCondition = searchCondition;
        }

        public String getTimeout() {
            return this.timeout;
        }

        @DataBoundSetter
        public void setTimeout(String timeout) {
            this.timeout = timeout;
        }

        public String getPollingInterval() {
            return this.pollingInterval;
        }

        @DataBoundSetter
        public void setPollingInterval(String pollingInterval) {
            this.pollingInterval = pollingInterval;
        }
    }

    @Symbol(value={"fortifyPlugin"})
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        private String url;
        private transient boolean useProxy = false;
        private transient String proxyUrl;
        private transient Secret proxyUsername;
        private transient Secret proxyPassword;
        private boolean isProxy;
        @CheckForNull
        private ProxyConfig proxyConfig;
        private transient Secret token;
        private String sscTokenCredentialsId;
        private String projectTemplate;
        private Integer breakdownPageSize;
        private Integer appVersionListLimit;
        private Integer connectTimeout;
        private Integer readTimeout;
        private Integer writeTimeout;
        private List<ProjectTemplateBean> projTemplateList = Collections.emptyList();
        private Map<String, Long> allProjects = Collections.emptyMap();
        private Map<String, Map<String, Long>> allVersions = Collections.emptyMap();
        private List<SensorPoolBean> sensorPoolList = Collections.emptyList();
        private String ctrlUrl;
        private transient Secret ctrlToken;
        private String ctrlTokenCredentialsId;
        private boolean disableLocalScans;
        private boolean isSettingUpdated = false;

        public DescriptorImpl() {
            super(FortifyPlugin.class);
            this.load();
        }

        private Object readResolve() {
            if (this.token != null) {
                this.setToken(Secret.toString((Secret)this.token));
                this.token = null;
            }
            if (this.ctrlToken != null) {
                this.setCtrlToken(Secret.toString((Secret)this.ctrlToken));
                this.ctrlToken = null;
            }
            if (this.useProxy) {
                this.proxyConfig = new ProxyConfig(this.proxyUrl, this.proxyUsername, this.proxyPassword);
                this.proxyUrl = null;
                this.proxyUsername = null;
                this.proxyPassword = null;
                this.useProxy = false;
            }
            if (this.proxyConfig != null) {
                this.isProxy = true;
            }
            return this;
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public String getDisplayName() {
            return "Fortify Assessment";
        }

        public String getUrl() {
            return this.url;
        }

        @DataBoundSetter
        public void setUrl(String url) {
            try {
                this.url = url == null ? null : url.trim();
                this.checkUrlValue(this.url);
            }
            catch (FortifyException e) {
                LOGGER.log(Level.WARNING, "Fortify SSC URL configuration error: " + e.getMessage());
                this.url = null;
            }
        }

        public boolean getUseProxy() {
            return this.proxyConfig != null && this.proxyConfig.getProxyUrlFor(null) != null;
        }

        public String getProxyUrl() {
            return this.proxyConfig != null ? this.proxyConfig.getProxyUrlFor(null) : null;
        }

        public String getProxyUsername() {
            return this.proxyConfig != null ? Secret.toString((Secret)this.proxyConfig.getProxyUsername()) : null;
        }

        public String getProxyPassword() {
            return this.proxyConfig != null ? Secret.toString((Secret)this.proxyConfig.getProxyPassword()) : null;
        }

        public ProxyConfig getProxyConfig() {
            return this.proxyConfig;
        }

        @DataBoundSetter
        public void setIsProxy(boolean isProxy) {
            this.isProxy = isProxy;
            this.proxyConfig = this.isProxy ? ProxyConfig.getJenkinsProxyConfig() : null;
        }

        public boolean getIsProxy() {
            return this.isProxy;
        }

        @DataBoundSetter
        public void setProxyConfig(ProxyConfig proxyConfig) {
            this.proxyConfig = proxyConfig;
            this.isProxy = proxyConfig != null;
        }

        public String getToken() {
            FortifyApiToken sc = this.getTokenFrom(this.getSscTokenCredentialsId(), this.getUrl());
            Secret userToken = null;
            try {
                userToken = sc != null ? sc.getToken() : null;
            }
            catch (IOException | InterruptedException exception) {
                // empty catch block
            }
            return userToken == null ? "" : userToken.getPlainText();
        }

        public String getSscTokenCredentialsId() {
            return this.sscTokenCredentialsId;
        }

        @DataBoundSetter
        public void setToken(String token) {
            String defaultMigratedTokenId = "fortify_api_token";
            StandardFortifyApiToken fortifyToken = new StandardFortifyApiToken(CredentialsScope.GLOBAL, defaultMigratedTokenId, StringUtils.isBlank((String)token) ? "" : token.trim(), "fortify plugin migration generated ssc token credentials");
            try {
                ((CredentialsStore)CredentialsProvider.lookupStores((ModelObject)Jenkins.get()).iterator().next()).addCredentials(Domain.global(), (Credentials)fortifyToken);
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Fortify SSC token credential registration error: " + e.getMessage());
            }
            this.sscTokenCredentialsId = defaultMigratedTokenId;
        }

        @DataBoundSetter
        public void setSscTokenCredentialsId(String sscTokenCredentialsId) {
            this.sscTokenCredentialsId = sscTokenCredentialsId;
        }

        public boolean canUploadToSsc() {
            return StringUtils.isNotBlank((String)this.getUrl()) && StringUtils.isNotBlank((String)this.getToken());
        }

        public String getProjectTemplate() {
            return this.projectTemplate;
        }

        @DataBoundSetter
        public void setProjectTemplate(String projectTemplate) {
            this.projectTemplate = projectTemplate == null ? null : projectTemplate.trim();
        }

        public Integer getBreakdownPageSize() {
            return this.breakdownPageSize;
        }

        @DataBoundSetter
        public void setBreakdownPageSize(Integer breakdownPageSize) {
            if (breakdownPageSize == null || breakdownPageSize < 1) {
                this.breakdownPageSize = 50;
                LOGGER.log(Level.INFO, "Cannot restore 'Issue breakdown page size' property. Will use default (50) value.");
            } else {
                this.breakdownPageSize = breakdownPageSize;
            }
        }

        public Integer getAppVersionListLimit() {
            return this.appVersionListLimit;
        }

        @DataBoundSetter
        public void setAppVersionListLimit(Integer appVersionListLimit) {
            if (appVersionListLimit == null || appVersionListLimit < 1) {
                this.appVersionListLimit = 100;
                LOGGER.log(Level.INFO, "Cannot restore 'Application version list limit' property. Will use default (100) value.");
            } else {
                this.appVersionListLimit = appVersionListLimit;
            }
        }

        public Integer getConnectTimeout() {
            return this.connectTimeout;
        }

        @DataBoundSetter
        public void setConnectTimeout(Integer connectTimeout) {
            this.connectTimeout = connectTimeout;
        }

        public Integer getReadTimeout() {
            return this.readTimeout;
        }

        @DataBoundSetter
        public void setReadTimeout(Integer readTimeout) {
            this.readTimeout = readTimeout;
        }

        public Integer getWriteTimeout() {
            return this.writeTimeout;
        }

        @DataBoundSetter
        public void setWriteTimeout(Integer writeTimeout) {
            this.writeTimeout = writeTimeout;
        }

        public String getCtrlUrl() {
            return this.ctrlUrl;
        }

        @DataBoundSetter
        public void setCtrlUrl(String ctrlUrl) {
            try {
                this.ctrlUrl = ctrlUrl == null ? null : ctrlUrl.trim();
                this.checkCtrlUrlValue(this.ctrlUrl);
            }
            catch (FortifyException e) {
                LOGGER.log(Level.WARNING, "Fortify ScanCentral Controller URL configuration error: " + e.getMessage());
                this.ctrlUrl = null;
            }
        }

        public String getCtrlToken() {
            FortifyApiToken sc = this.getTokenFrom(this.getCtrlTokenCredentialsId(), this.getCtrlUrl());
            Secret ctrlUserToken = null;
            try {
                ctrlUserToken = sc != null ? sc.getToken() : null;
            }
            catch (IOException | InterruptedException exception) {
                // empty catch block
            }
            return ctrlUserToken == null ? "" : ctrlUserToken.getPlainText();
        }

        @DataBoundSetter
        public void setCtrlToken(String ctrlToken) {
            String defaultMigratedCtrlTokenId = "fortify_ctrl_token";
            StandardFortifyApiToken fortifyCtrlToken = new StandardFortifyApiToken(CredentialsScope.GLOBAL, defaultMigratedCtrlTokenId, StringUtils.isBlank((String)ctrlToken) ? "" : ctrlToken.trim(), "fortify plugin migration generated ctrl token credentials");
            try {
                ((CredentialsStore)CredentialsProvider.lookupStores((ModelObject)Jenkins.get()).iterator().next()).addCredentials(Domain.global(), (Credentials)fortifyCtrlToken);
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Fortify Ctrl token credential registration error: " + e.getMessage());
            }
            this.ctrlTokenCredentialsId = defaultMigratedCtrlTokenId;
        }

        public String getCtrlTokenCredentialsId() {
            return this.ctrlTokenCredentialsId;
        }

        @DataBoundSetter
        public void setCtrlTokenCredentialsId(String ctrlTokenCredentialsId) {
            this.ctrlTokenCredentialsId = ctrlTokenCredentialsId;
        }

        public boolean isDisableLocalScans() {
            return this.disableLocalScans;
        }

        @DataBoundSetter
        public void setDisableLocalScans(boolean disableLocalScans) {
            this.disableLocalScans = disableLocalScans;
        }

        public FormValidation doCheckBreakdownPageSize(@QueryParameter String value) {
            if (StringUtils.isBlank((String)value)) {
                return FormValidation.ok();
            }
            int pageSize = 0;
            try {
                pageSize = Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                return FormValidation.warning((String)"Expected an integer value greater than zero.");
            }
            if (pageSize < 1) {
                return FormValidation.warning((String)"Expected an integer value greater than zero.");
            }
            return FormValidation.ok();
        }

        @POST
        public FormValidation doCheckUrl(@QueryParameter String value) {
            try {
                this.checkUrlValue(value == null ? null : value.trim());
            }
            catch (FortifyException e) {
                return FormValidation.warning((String)e.getMessage());
            }
            return FormValidation.ok();
        }

        @POST
        public FormValidation doCheckSscTokenCredentialsId(@QueryParameter String value, @QueryParameter String url) {
            if (StringUtils.isBlank((String)value) && StringUtils.isNotBlank((String)url) && this.doCheckUrl(url) == FormValidation.ok()) {
                return FormValidation.warning((String)"Authentication token cannot be empty");
            }
            return FormValidation.ok();
        }

        @POST
        public FormValidation doCheckCtrlTokenCredentialsId(@QueryParameter String value, @QueryParameter String ctrlUrl) {
            if (StringUtils.isBlank((String)value) && StringUtils.isNotBlank((String)ctrlUrl)) {
                return FormValidation.warning((String)"Controller token cannot be empty");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckFpr(@QueryParameter String value) {
            if (StringUtils.isBlank((String)value) || value.charAt(0) == '$') {
                return FormValidation.ok();
            }
            if (value.contains("/") || value.contains("\\") || !FilenameUtils.isExtension((String)value.toLowerCase(), (String[])new String[]{"fpr", "zip"})) {
                return FormValidation.error((String)"The filename should be in basename *ONLY*, with extension FPR or ZIP");
            }
            return FormValidation.ok();
        }

        @POST
        public FormValidation doCheckProjectTemplate(@QueryParameter String value) {
            DescriptorImpl.checkAdministerPermission();
            try {
                this.checkProjectTemplateName(value.trim());
            }
            catch (FortifyException e) {
                return FormValidation.error((String)e.getMessage());
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckProjectName(@QueryParameter String value) {
            return FormValidation.ok();
        }

        public FormValidation doCheckProjectVersion(@QueryParameter String value) {
            return FormValidation.ok();
        }

        public FormValidation doCheckTimeout(@QueryParameter String value) {
            if (StringUtils.isBlank((String)value)) {
                return FormValidation.ok();
            }
            try {
                int x = Integer.parseInt(value);
                if (x >= 0 && x <= 10080) {
                    return FormValidation.ok();
                }
                return FormValidation.error((String)"Timeout must be in the range of 0 to 10080");
            }
            catch (NumberFormatException e) {
                return FormValidation.error((String)"Timeout is invalid");
            }
        }

        public FormValidation doCheckPollingInterval(@QueryParameter String value) {
            if (StringUtils.isBlank((String)value) || value.charAt(0) == '$') {
                return FormValidation.ok();
            }
            int x = -1;
            try {
                x = Integer.parseInt(value);
                if (x >= 0 && x <= 60) {
                    return FormValidation.ok();
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return FormValidation.error((String)"The unit is in minutes, and in the range of 0 to 60");
        }

        @POST
        public FormValidation doCheckCtrlUrl(@QueryParameter String value, @QueryParameter String url) {
            if (StringUtils.isBlank((String)value)) {
                if (StringUtils.isNotBlank((String)url) && this.doCheckUrl(url) == FormValidation.ok()) {
                    return FormValidation.okWithMarkup((String)"<font color=\"blue\">Will use the SSC URL to determine the Controller location</font>");
                }
                return FormValidation.error((String)"Controller URL and SSC URL cannot both be empty");
            }
            try {
                this.checkCtrlUrlValue(value == null ? null : value.trim());
            }
            catch (FortifyException e) {
                return FormValidation.warning((String)e.getMessage());
            }
            return FormValidation.ok();
        }

        @POST
        public ListBoxModel doFillSscTokenCredentialsIdItems(@AncestorInPath Item item, @QueryParameter String sscTokenCredentialsId, @QueryParameter String url) {
            StandardListBoxModel result = new StandardListBoxModel();
            if (item == null ? !Jenkins.get().hasPermission(Jenkins.ADMINISTER) : !item.hasPermission(Item.EXTENDED_READ) && !item.hasPermission(CredentialsProvider.USE_ITEM)) {
                return result.includeCurrentValue(sscTokenCredentialsId);
            }
            return result.includeCurrentValue(sscTokenCredentialsId).includeMatchingAs(ACL.SYSTEM, item, FortifyApiToken.class, URIRequirementBuilder.fromUri((String)url).build(), CredentialsMatchers.instanceOf(FortifyApiToken.class));
        }

        @POST
        public FormValidation doTestConnection(@QueryParameter String url, @QueryParameter String sscTokenCredentialsId, @QueryParameter Boolean isProxy, @QueryParameter Integer connectTimeout, @QueryParameter Integer readTimeout, @QueryParameter Integer writeTimeout) {
            DescriptorImpl.checkAdministerPermission();
            return this.testSscConnection(url, sscTokenCredentialsId, isProxy, connectTimeout, readTimeout, writeTimeout);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private FormValidation testSscConnection(String url, String sscTokenCredentialsId, Boolean isProxy, Integer connectTimeout, Integer readTimeout, Integer writeTimeout) {
            Secret userToken;
            String sscUrl = url == null ? "" : url.trim();
            try {
                this.checkUrlValue(sscUrl);
            }
            catch (FortifyException e) {
                return FormValidation.error((String)e.getMessage());
            }
            String tokenId = sscTokenCredentialsId == null ? "" : sscTokenCredentialsId.trim();
            try {
                this.checkTokenId(tokenId);
            }
            catch (FortifyException e) {
                return FormValidation.error((String)e.getMessage());
            }
            FortifyApiToken sc = this.getTokenFrom(tokenId, sscUrl);
            try {
                userToken = sc != null ? sc.getToken() : null;
            }
            catch (IOException | InterruptedException e) {
                return FormValidation.error((String)("Error getting a token from credential id: " + e.getMessage()));
            }
            if (StringUtils.isEmpty((String)Secret.toString((Secret)userToken))) {
                return FormValidation.error((String)"Authentication token cannot be empty");
            }
            String orig_url = this.url;
            Integer orig_connectTimeout = this.connectTimeout;
            Integer orig_readTimeout = this.readTimeout;
            Integer orig_writeTimeout = this.writeTimeout;
            Boolean orig_isProxy = this.isProxy;
            ProxyConfig orig_proxyConfig = this.proxyConfig;
            this.setIsProxy(isProxy);
            this.url = sscUrl;
            this.connectTimeout = connectTimeout;
            this.readTimeout = readTimeout;
            this.writeTimeout = writeTimeout;
            try {
                FortifyPlugin.runWithFortifyClient(Secret.toString((Secret)userToken), new FortifyClient.Command<FortifyClient.NoReturn>(){

                    @Override
                    public FortifyClient.NoReturn runWith(FortifyClient client) throws Exception {
                        client.getProjectList(null, 1);
                        return FortifyClient.NoReturn.INSTANCE;
                    }
                });
                FormValidation formValidation = FormValidation.okWithMarkup((String)"<font color=\"blue\">Connection successful!</font>");
                return formValidation;
            }
            catch (Throwable t) {
                String message = t.getMessage();
                if (message != null && message.contains("Access Denied")) {
                    FormValidation formValidation = FormValidation.error((String)("Invalid token. (" + this.removeHtmlFormatting(message) + ")"));
                    return formValidation;
                }
                FormValidation formValidation = FormValidation.error((String)("Cannot connect to SSC server. " + this.removeHtmlFormatting(message)));
                return formValidation;
            }
            finally {
                this.url = orig_url;
                this.setIsProxy(orig_isProxy);
                this.proxyConfig = orig_proxyConfig;
                this.connectTimeout = orig_connectTimeout;
                this.readTimeout = orig_readTimeout;
                this.writeTimeout = orig_writeTimeout;
            }
        }

        private String removeHtmlFormatting(String html) {
            if (html != null) {
                return html.replaceAll("<[^>]*>", "");
            }
            return "";
        }

        private FortifyApiToken getTokenFrom(String tokenId, String url) throws FortifyException {
            FortifyApiToken c = tokenId == null ? null : (FortifyApiToken)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(FortifyApiToken.class, (ItemGroup)Jenkins.get(), (Authentication)ACL.SYSTEM, StringUtils.isBlank((String)url) ? Collections.emptyList() : URIRequirementBuilder.fromUri((String)url).build()), (CredentialsMatcher)CredentialsMatchers.withId((String)tokenId));
            return c;
        }

        @POST
        public ListBoxModel doFillCtrlTokenCredentialsIdItems(@AncestorInPath Item item, @QueryParameter String ctrlTokenCredentialsId, @QueryParameter String ctrlUrl) {
            StandardListBoxModel result = new StandardListBoxModel();
            if (item == null ? !Jenkins.get().hasPermission(Jenkins.ADMINISTER) : !item.hasPermission(Item.EXTENDED_READ) && !item.hasPermission(CredentialsProvider.USE_ITEM)) {
                return result.includeCurrentValue(ctrlTokenCredentialsId);
            }
            return result.includeEmptyValue().includeCurrentValue(ctrlTokenCredentialsId).includeMatchingAs(ACL.SYSTEM, item, FortifyApiToken.class, StringUtils.isBlank((String)ctrlUrl) ? Collections.emptyList() : URIRequirementBuilder.fromUri((String)ctrlUrl).build(), CredentialsMatchers.instanceOf(FortifyApiToken.class));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @POST
        public FormValidation doTestCtrlConnection(@QueryParameter String ctrlUrl, @QueryParameter String ctrlTokenCredentialsId, @QueryParameter Boolean isProxy) throws IOException {
            DescriptorImpl.checkAdministerPermission();
            String controllerUrl = ctrlUrl == null ? "" : ctrlUrl.trim();
            try {
                this.checkCtrlUrlValue(controllerUrl);
            }
            catch (FortifyException e) {
                return FormValidation.error((String)e.getMessage());
            }
            String orig_url = this.ctrlUrl;
            this.ctrlUrl = controllerUrl;
            OkHttpClient client = new OkHttpClient();
            Request request = new Request.Builder().url(controllerUrl).build();
            Response response = null;
            ResponseBody body = null;
            try {
                response = client.newCall(request).execute();
                if (response != null) {
                    body = response.body();
                    if (response.isSuccessful() && body != null && (body.string().contains("Fortify ScanCentral Controller") || body.string().contains("Fortify CloudScan Controller"))) {
                        FormValidation formValidation = FormValidation.okWithMarkup((String)"<font color=\"blue\">Connection successful!</font>");
                        return formValidation;
                    }
                }
                FormValidation formValidation = FormValidation.error((String)"Connection failed. Check the Controller URL.");
                return formValidation;
            }
            catch (Throwable t) {
                FormValidation formValidation = FormValidation.error((Throwable)t, (String)"Cannot connect to Controller");
                return formValidation;
            }
            finally {
                this.ctrlUrl = orig_url;
                if (body != null) {
                    body.close();
                }
            }
        }

        private void checkUrlValue(String sscUrl) throws FortifyException {
            if (StringUtils.isNotBlank((String)sscUrl)) {
                if (StringUtils.startsWith((String)sscUrl, (String)"http://") || StringUtils.startsWith((String)sscUrl, (String)"https://")) {
                    if (sscUrl.trim().equalsIgnoreCase("http://") || sscUrl.trim().equalsIgnoreCase("https://")) {
                        throw new FortifyException(new Message(4, "URL host is required"));
                    }
                } else {
                    throw new FortifyException(new Message(4, "Invalid protocol"));
                }
                if (sscUrl.indexOf(32) != -1) {
                    throw new FortifyException(new Message(4, "URL cannot have spaces"));
                }
            }
        }

        private void checkTokenId(String tokenId) throws FortifyException {
            if (StringUtils.isBlank((String)tokenId)) {
                throw new FortifyException(new Message(4, "Token id can't be blank, please Add it through the Jenkins credentials UI"));
            }
        }

        private void checkProjectTemplateName(String projectTemplateName) throws FortifyException {
            if (StringUtils.isNotBlank((String)projectTemplateName)) {
                boolean valid = false;
                List<ProjectTemplateBean> projectTemplateList = this.getProjTemplateListList();
                if (projectTemplateList != null) {
                    for (ProjectTemplateBean projectTemplateBean : projectTemplateList) {
                        if (!projectTemplateBean.getName().equals(projectTemplateName)) continue;
                        valid = true;
                    }
                    if (!valid) {
                        throw new FortifyException(new Message(4, "Invalid Issue Template \"" + projectTemplateName + "\"."));
                    }
                }
            }
        }

        private void checkCtrlUrlValue(String ctrlUrl) throws FortifyException {
            if (StringUtils.isNotBlank((String)ctrlUrl)) {
                if (StringUtils.startsWith((String)ctrlUrl, (String)"http://") || StringUtils.startsWith((String)ctrlUrl, (String)"https://")) {
                    int hash;
                    if (ctrlUrl.trim().equalsIgnoreCase("http://") || ctrlUrl.trim().equalsIgnoreCase("https://")) {
                        throw new FortifyException(new Message(4, "URL host is required"));
                    }
                    if (ctrlUrl.endsWith("/")) {
                        ctrlUrl = ctrlUrl.substring(0, ctrlUrl.length() - 1);
                    }
                    if ((hash = ctrlUrl.indexOf("%23")) > 0) {
                        ctrlUrl = ctrlUrl.substring(0, hash);
                    }
                    if (!StringUtils.endsWith((String)ctrlUrl, (String)"/scancentral-ctrl") && !StringUtils.endsWith((String)ctrlUrl, (String)"/cloud-ctrl")) {
                        throw new FortifyException(new Message(4, "Invalid context"));
                    }
                } else {
                    throw new FortifyException(new Message(4, "Invalid protocol"));
                }
                if (ctrlUrl.indexOf(32) != -1) {
                    throw new FortifyException(new Message(4, "URL cannot have spaces"));
                }
            }
        }

        @POST
        public void doRefreshProjects(StaplerRequest req, StaplerResponse rsp, @QueryParameter String value, @AncestorInPath Item item) throws Exception {
            if (item != null) {
                item.checkPermission(Item.CONFIGURE);
            } else {
                Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            }
            try {
                String typedText = this.sanitizeUnicodeControls(req.getParameter("typedText"));
                this.allProjects = this.refreshAllProjects(typedText);
                StringBuilder buf = new StringBuilder();
                ArrayList<String> projects = new ArrayList<String>(this.allProjects.keySet());
                Collections.sort(projects, String.CASE_INSENSITIVE_ORDER);
                for (String prjName : projects) {
                    if (buf.length() > 0) {
                        buf.append(",");
                    }
                    buf.append("{ \"name\": \"" + this.escapeJsonValue(prjName) + "\" }\n");
                }
                buf.insert(0, "{ \"list\" : [\n");
                buf.append("]}");
                rsp.setContentType("application/json;charset=utf-8");
                rsp.getWriter().print(buf.toString());
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
        }

        @POST
        public void doRefreshVersions(StaplerRequest req, StaplerResponse rsp, @QueryParameter String value, @AncestorInPath Item item) throws Exception {
            if (item != null) {
                item.checkPermission(Item.CONFIGURE);
            } else {
                Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            }
            try {
                String selectedApp = this.sanitizeUnicodeControls(req.getParameter("selectedPrj"));
                String typedText = this.sanitizeUnicodeControls(req.getParameter("typedText"));
                StringBuilder buf = new StringBuilder();
                Long appId = this.getAllProjects(null).get(selectedApp);
                Map<String, Long> appVersions = this.refreshVersionsFor(appId, typedText);
                buf.append((CharSequence)this.appVersionToJson(selectedApp, appVersions));
                buf.insert(0, "{ \"list\" : [\n");
                buf.append("]}");
                rsp.setContentType("application/json;charset=utf-8");
                rsp.getWriter().print(buf.toString());
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
        }

        private String sanitizeUnicodeControls(String unsafeInput) {
            if (unsafeInput == null) {
                return "";
            }
            String trimmed = unsafeInput.trim();
            String withoutUnicodeControls = trimmed.replaceAll("[\\p{C}&&\\p{Cntrl}]", "?");
            return withoutUnicodeControls;
        }

        private StringBuilder appVersionToJson(String appName, Map<String, Long> appVersions) {
            StringBuilder buf = new StringBuilder();
            ArrayList<String> sortedVersions = new ArrayList<String>(appVersions.keySet());
            Collections.sort(sortedVersions, String.CASE_INSENSITIVE_ORDER);
            for (String nextVersion : sortedVersions) {
                if (buf.length() > 0) {
                    buf.append(",");
                }
                buf.append("{ \"name\": \"" + this.escapeJsonValue(nextVersion) + "\", \"prj\": \"" + this.escapeJsonValue(appName) + "\" }\n");
            }
            return buf;
        }

        private String escapeJsonValue(String stringValue) {
            return stringValue.replace("\"", "\\\"");
        }

        @POST
        public void doRefreshProjectTemplates(StaplerRequest req, StaplerResponse rsp, @QueryParameter String value) throws Exception {
            DescriptorImpl.checkAdministerPermission();
            String orig_url = this.url;
            ProxyConfig orig_proxyConfig = this.proxyConfig;
            Boolean orig_isProxy = this.isProxy;
            String orig_tokenId = this.sscTokenCredentialsId;
            String url = req.getParameter("url");
            String proxyEnabled = req.getParameter("isProxy");
            if (proxyEnabled == null) {
                proxyEnabled = req.getParameter("_.isProxy");
            }
            Boolean useProxyParam = "true".equalsIgnoreCase(proxyEnabled);
            this.setIsProxy(useProxyParam);
            Integer connectTimeout = Integer.getInteger(req.getParameter("connectTimeout"));
            Integer readTimeout = Integer.getInteger(req.getParameter("readTimeout"));
            Integer writeTimeout = Integer.getInteger(req.getParameter("writeTimeout"));
            String tokenId = req.getParameter("sscTokenCredentialsId");
            this.url = url != null ? url.trim() : "";
            this.sscTokenCredentialsId = tokenId;
            try {
                FormValidation testConnectionResult = this.testSscConnection(this.url, this.getSscTokenCredentialsId(), useProxyParam, connectTimeout, readTimeout, writeTimeout);
                if (!testConnectionResult.kind.equals((Object)FormValidation.Kind.OK)) {
                    LOGGER.log(Level.WARNING, "Can't retrieve Fortify Issue Template list because of SSC server connection problem: " + testConnectionResult.getLocalizedMessage());
                    return;
                }
                this.projTemplateList = this.getProjTemplateListNoCache();
                StringBuilder buf = new StringBuilder();
                buf.append("{ \"list\" : [\n");
                for (int i = 0; i < this.projTemplateList.size(); ++i) {
                    ProjectTemplateBean b = this.projTemplateList.get(i);
                    buf.append("{ \"name\": \"" + this.escapeJsonValue(b.getName()) + "\", \"id\": \"" + this.escapeJsonValue(b.getId()) + "\" }");
                    if (i != this.projTemplateList.size() - 1) {
                        buf.append(",\n");
                        continue;
                    }
                    buf.append("\n");
                }
                buf.append("]}");
                rsp.setContentType("text/html;charset=UTF-8");
                rsp.getWriter().print(buf.toString());
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
            finally {
                this.url = orig_url;
                this.setIsProxy(orig_isProxy);
                this.proxyConfig = orig_proxyConfig;
                this.sscTokenCredentialsId = orig_tokenId;
            }
        }

        private static void checkAdministerPermission() {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        }

        @POST
        public void doRefreshSensorPools(StaplerRequest req, StaplerResponse rsp, @QueryParameter String value) throws Exception {
            DescriptorImpl.checkAdministerPermission();
            String orig_url = this.url;
            String url = req.getParameter("url");
            this.url = url != null ? url.trim() : "";
            try {
                FormValidation testConnectionResult = this.testSscConnection(this.url, this.getSscTokenCredentialsId(), this.getIsProxy(), this.connectTimeout, this.readTimeout, this.writeTimeout);
                if (!testConnectionResult.kind.equals((Object)FormValidation.Kind.OK)) {
                    throw new Exception(testConnectionResult.getLocalizedMessage());
                }
                this.sensorPoolList = this.getSensorPoolListNoCache();
                StringBuilder buf = new StringBuilder();
                buf.append("{ \"list\" : [\n");
                for (int i = 0; i < this.sensorPoolList.size(); ++i) {
                    SensorPoolBean b = this.sensorPoolList.get(i);
                    buf.append("{ \"name\": \"" + this.escapeJsonValue(b.getName()) + "\", \"uuid\": \"" + this.escapeJsonValue(b.getUuid()) + "\" }");
                    if (i != this.sensorPoolList.size() - 1) {
                        buf.append(",\n");
                        continue;
                    }
                    buf.append("\n");
                }
                buf.append("]}");
                rsp.setContentType("text/html;charset=UTF-8");
                rsp.getWriter().print(buf.toString());
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
            finally {
                this.url = orig_url;
            }
        }

        @POST
        public void doCreateNewProject(final StaplerRequest req, StaplerResponse rsp, @QueryParameter String value, @AncestorInPath Item item) throws Exception {
            if (item != null) {
                item.checkPermission(Item.CONFIGURE);
            } else {
                Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            }
            try {
                FortifyPlugin.runWithFortifyClient(this.getToken(), new FortifyClient.Command<FortifyClient.NoReturn>(){

                    @Override
                    public FortifyClient.NoReturn runWith(FortifyClient client) throws Exception {
                        OutputStreamWriter w = new OutputStreamWriter((OutputStream)System.out, "UTF-8");
                        client.createProject(req.getParameter("newprojName"), req.getParameter("newprojVersion"), req.getParameter("newprojTemplate"), Collections.emptyMap(), new PrintWriter(w));
                        return FortifyClient.NoReturn.INSTANCE;
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.doRefreshProjects(req, rsp, value, item);
        }

        public boolean configure(StaplerRequest req, JSONObject jsonObject) throws Descriptor.FormException {
            try (BulkChange b = new BulkChange((Saveable)this);){
                this.proxyConfig = null;
                this.url = null;
                this.isProxy = false;
                this.sscTokenCredentialsId = null;
                this.projectTemplate = null;
                this.breakdownPageSize = 50;
                this.appVersionListLimit = 100;
                this.readTimeout = null;
                this.writeTimeout = null;
                this.connectTimeout = null;
                this.ctrlUrl = null;
                this.ctrlTokenCredentialsId = null;
                this.disableLocalScans = false;
                req.bindJSON((Object)this, jsonObject);
                b.commit();
            }
            this.save();
            this.isSettingUpdated = true;
            return super.configure(req, jsonObject);
        }

        public boolean isSettingUpdated() {
            try {
                boolean bl = this.isSettingUpdated;
                return bl;
            }
            finally {
                this.isSettingUpdated = false;
            }
        }

        @POST
        public ComboBoxModel doFillAppNameItems(@AncestorInPath Item item) {
            Map<Object, Object> allPrj;
            if (item != null) {
                item.checkPermission(Item.CONFIGURE);
                allPrj = this.getAllProjects(null);
            } else {
                allPrj = Collections.emptyMap();
            }
            return new ComboBoxModel(allPrj.keySet());
        }

        @POST
        public ComboBoxModel getAppNameItems(@AncestorInPath Item item) {
            return this.doFillAppNameItems(item);
        }

        @POST
        public ComboBoxModel doFillAppVersionItems(@QueryParameter String appName, @AncestorInPath Item item) {
            Map<Object, Object> allPrjVersions;
            if (item != null) {
                item.checkPermission(Item.CONFIGURE);
                allPrjVersions = this.getVersionsFor(appName);
                if (null == allPrjVersions) {
                    return new ComboBoxModel(Collections.emptyList());
                }
            } else {
                allPrjVersions = Collections.emptyMap();
            }
            return new ComboBoxModel(allPrjVersions.keySet());
        }

        @POST
        public ComboBoxModel getAppVersionItems(@QueryParameter String appName, @AncestorInPath Item item) {
            return this.doFillAppVersionItems(appName, item);
        }

        private Map<String, Long> getAllProjects(String query) {
            if (this.allProjects.isEmpty()) {
                this.allProjects = this.refreshAllProjects(query);
            }
            return this.allProjects;
        }

        private Map<String, Long> refreshAllProjects(final String query) {
            if (this.canUploadToSsc()) {
                try {
                    Map<String, Long> map = FortifyPlugin.runWithFortifyClient(this.getToken(), new FortifyClient.Command<Map<String, Long>>(){

                        @Override
                        public Map<String, Long> runWith(FortifyClient client) throws Exception {
                            return client.getProjectList(query, this.getAppVersionListLimit());
                        }
                    });
                    return map;
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    return Collections.emptyMap();
                }
            }
            return Collections.emptyMap();
        }

        private Map<String, Long> getVersionsFor(String appName) {
            Map<String, Long> versions = this.allVersions.get(appName);
            if (versions == null || versions.isEmpty()) {
                Long appId = this.getAllProjects(null).get(appName);
                versions = this.refreshVersionsFor(appId, null);
                this.allVersions.put(appName, versions);
            }
            return versions;
        }

        private Map<String, Long> refreshVersionsFor(final Long appId, final String query) {
            if (this.canUploadToSsc()) {
                try {
                    Map<String, Long> map = FortifyPlugin.runWithFortifyClient(this.getToken(), new FortifyClient.Command<Map<String, Long>>(){

                        @Override
                        public Map<String, Long> runWith(FortifyClient client) throws Exception {
                            return client.getVersionListEx(appId, query, this.getAppVersionListLimit());
                        }
                    });
                    return map;
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    return Collections.emptyMap();
                }
            }
            return Collections.emptyMap();
        }

        @POST
        public AutoCompletionCandidates doAutoCompleteAppName(@QueryParameter String value, @AncestorInPath Item item) {
            AutoCompletionCandidates c = new AutoCompletionCandidates();
            if (item != null) {
                item.checkPermission(Item.CONFIGURE);
                for (String nextApp : this.getAllProjects(value).keySet()) {
                    if (!nextApp.toLowerCase(Locale.ENGLISH).startsWith(value.toLowerCase(Locale.ENGLISH))) continue;
                    c.add(nextApp);
                }
            }
            return c;
        }

        @POST
        public ComboBoxModel doFillProjectTemplateItems(@AncestorInPath Item item) {
            List names;
            if (item != null) {
                item.checkPermission(Item.CONFIGURE);
                if (this.projTemplateList.isEmpty()) {
                    this.projTemplateList = this.getProjTemplateListNoCache();
                }
                names = new ArrayList(this.projTemplateList.size());
                for (ProjectTemplateBean b : this.projTemplateList) {
                    names.add(b.getName());
                }
            } else {
                names = Collections.emptyList();
            }
            return new ComboBoxModel(names);
        }

        @POST
        public ComboBoxModel getProjectTemplateItems(@AncestorInPath Item item) {
            return this.doFillProjectTemplateItems(item);
        }

        public List<ProjectTemplateBean> getProjTemplateListList() {
            if (this.projTemplateList.isEmpty()) {
                this.projTemplateList = this.getProjTemplateListNoCache();
            }
            return this.projTemplateList;
        }

        private List<ProjectTemplateBean> getProjTemplateListNoCache() {
            if (this.canUploadToSsc()) {
                try {
                    Map<String, String> map = FortifyPlugin.runWithFortifyClient(this.getToken(), new FortifyClient.Command<Map<String, String>>(){

                        @Override
                        public Map<String, String> runWith(FortifyClient client) throws Exception {
                            return client.getProjectTemplateList();
                        }
                    });
                    ArrayList<ProjectTemplateBean> list = new ArrayList<ProjectTemplateBean>(map.size());
                    for (Map.Entry<String, String> entry : map.entrySet()) {
                        ProjectTemplateBean proj = new ProjectTemplateBean(entry.getKey(), entry.getValue());
                        list.add(proj);
                    }
                    Collections.sort(list, new Comparator<ProjectTemplateBean>(){

                        @Override
                        public int compare(ProjectTemplateBean o1, ProjectTemplateBean o2) {
                            if (o1 != null && o2 != null) {
                                return o1.getName().compareTo(o2.getName());
                            }
                            return 0;
                        }
                    });
                    return list;
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
            return Collections.emptyList();
        }

        @POST
        public ListBoxModel doFillFilterSetItems(@QueryParameter String appName, @QueryParameter String appVersion, @AncestorInPath Item item) {
            ListBoxModel standardListBoxModel = new ListBoxModel();
            if (item != null) {
                item.checkPermission(Item.CONFIGURE);
                standardListBoxModel.add("");
                Map<String, String> allFilterSets = this.refreshFilterSetsFor(appName, appVersion);
                if (allFilterSets != null) {
                    for (Map.Entry<String, String> nextFilterSet : allFilterSets.entrySet()) {
                        standardListBoxModel.add(nextFilterSet.getKey(), nextFilterSet.getValue());
                    }
                }
            }
            return standardListBoxModel;
        }

        private Map<String, String> refreshFilterSetsFor(final String appName, final String appVersion) {
            if (!StringUtils.isBlank((String)appName) && !StringUtils.isBlank((String)appVersion) && this.canUploadToSsc()) {
                try {
                    Map<String, String> map = FortifyPlugin.runWithFortifyClient(this.getToken(), new FortifyClient.Command<Map<String, String>>(){

                        @Override
                        public Map<String, String> runWith(FortifyClient client) throws Exception {
                            Map<String, Long> appList = client.getProjectList(appName, 1);
                            if (appList != null && appList.size() == 1) {
                                for (Map.Entry<String, Long> nextApp : appList.entrySet()) {
                                    Map<String, Long> versionList;
                                    if (!nextApp.getKey().equals(appName) || (versionList = client.getVersionListEx(nextApp.getValue(), appVersion, 1)) == null || versionList.size() != 1) continue;
                                    for (Map.Entry<String, Long> nextVer : versionList.entrySet()) {
                                        if (!nextVer.getKey().equals(appVersion)) continue;
                                        return client.getFilterSetListEx(nextVer.getValue());
                                    }
                                }
                            }
                            return Collections.emptyMap();
                        }
                    });
                    return map;
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
            return Collections.emptyMap();
        }

        @POST
        public ListBoxModel doFillSensorPoolUUIDItems(@AncestorInPath Item item) {
            ArrayList<ListBoxModel.Option> optionList = new ArrayList<ListBoxModel.Option>();
            if (item != null) {
                item.checkPermission(Item.CONFIGURE);
                this.sensorPoolList = this.getSensorPoolListNoCache();
                for (SensorPoolBean sensorPoolBean : this.sensorPoolList) {
                    ListBoxModel.Option option = new ListBoxModel.Option(sensorPoolBean.getName(), sensorPoolBean.getUuid());
                    optionList.add(option);
                }
            }
            return new ListBoxModel(optionList);
        }

        public List<SensorPoolBean> getSensorPoolList() {
            if (this.sensorPoolList.isEmpty()) {
                this.sensorPoolList = this.getSensorPoolListNoCache();
            }
            return this.sensorPoolList;
        }

        private List<SensorPoolBean> getSensorPoolListNoCache() {
            if (DESCRIPTOR.getUrl() == null) {
                return Collections.emptyList();
            }
            try {
                Map<String, String> map = FortifyPlugin.runWithFortifyClient(this.getToken(), new FortifyClient.Command<Map<String, String>>(){

                    @Override
                    public Map<String, String> runWith(FortifyClient client) throws Exception {
                        return client.getCloudScanPoolList();
                    }
                });
                ArrayList<SensorPoolBean> list = new ArrayList<SensorPoolBean>(map.size());
                for (Map.Entry<String, String> entry : map.entrySet()) {
                    SensorPoolBean proj = new SensorPoolBean(entry.getKey(), entry.getValue());
                    list.add(proj);
                }
                Collections.sort(list, new Comparator<SensorPoolBean>(){

                    @Override
                    public int compare(SensorPoolBean o1, SensorPoolBean o2) {
                        if (o1 != null && o2 != null) {
                            return o1.getName().compareTo(o2.getName());
                        }
                        return 0;
                    }
                });
                return list;
            }
            catch (Throwable e) {
                e.printStackTrace();
                return Collections.emptyList();
            }
        }

        public ListBoxModel doFillLocaleItems(@QueryParameter String locale) {
            ListBoxModel items = new ListBoxModel();
            items.add("English", "en");
            items.add("Chinese Simplified", "zh_CN");
            items.add("Chinese Traditional", "zh_TW");
            items.add("Japanese", "ja");
            items.add("Korean", "ko");
            items.add("Portuguese (Brazil)", "pt_BR");
            items.add("Spanish", "es");
            if (StringUtils.isBlank((String)locale)) {
                ((ListBoxModel.Option)items.get((int)0)).selected = true;
            }
            return items;
        }
    }
}

